/* Analyse für DAB: Survey Response in 2018 and 2020 or Is there any Corona Effect? */
version 16
set more off, perm
clear all
macro drop _all
set linesize 132
capture log close

* Survival analysis
use "w78-surv.dta", clear
sort newid welle

stset partdur, failure(partcen) id(newid)

* Exponential
streg  corona , distribution(exp) nohr vce(robust)
stcurve, survival at1(corona=0) at2(corona=1)

streg  , distribution(exp) nohr strata(corona)
stcurve, survival at1(corona=0) at2(corona=1)

* Kaplan-Meier
sts graph, fail by(welle) ci
sts list if welle == 7
sts list if welle == 8
* Median
stdescribe if welle==7
stdescribe if welle==8
stsum, by(welle)

sts graph, cumhaz by(welle)

sts list, by(welle) enter
sts list, by(welle) compare

sts test corona
sts test corona, wilcoxon
sts test corona, tware
sts test corona, peto

* Cox Regression
stcox  ib7.welle, nohr efron vce(robust)
stcurve, survival at1(welle=7) at2(welle=8)


/* Append mit Wetter-Daten: taken from 
Becker, Rolf, 2021: Have you ever seen the rain? The causal impact of the weather situation and the season on survey participation in a multi-wave panel study. Sociological Research Methods 15: 27-41.

use "w7-spweather.dta", clear
append using "w8-spweather.dta", nolabel 

sort id newid

* Politik: Lockdown in Welle 8
gen Lockdown = 0
replace Lockdown = 1 if welle==8 & wdate < 132
fre Lockdown
* Counterfactual: Simulation of pseudo shutdown in Wave 7, in order to controll for time dependency 
gen CLockdown = 1
replace CLockdown = 0 if wdate >= 132
fre CLockdown

recode sektyp9 (. = 4)(.m = 4), gen(sektyp9_mv)

order newid partcen partdur welle corona tstart tend cen ts tf dur wdate tre200d0 tre200n0 ure200d0 rka150d0 sremaxdv su2000d0 pp0qffd0 weather ///
	  gender sektyp9 sektyp9_mv demark9 zdemark9 hh_egp_kat hh_egp_mv ztre200d0 ztre200n0 zure200d0 zrka150d0 zsremaxdv zsu2000d0 zpp0qffd0 Lockdown CLockdown 
sort newid welle wdate

save "w78-spweather.dta", replace
*/

* Ereignisanalyse für Table 1
use "C:\Users\Rolf Becker\Eigene Daten\DAB\Corona\W8\w78-spweather.dta", clear
sort teilnehmercode id wdate

stset tf if weather != . & gender != . , failure(cen) id(newid)

streg ib7.welle  , distribution(exp) nohr 

streg ib7.welle ib7.hh_egp_mv ib4.sektyp9_mv zdemark9 ib1.gender  , distribution(exp) nohr 

streg weather Lockdown , distribution(exp) nohr 

streg weather Lockdown ib7.hh_egp_mv ib4.sektyp9_mv zdemark9 ib1.gender  , distribution(exp) nohr 



streg Lockdown ztre200d0 zure200d0 zrka150d0 zsu2000d0 zpp0qffd0   , distribution(exp) nohr 


* Pseudo-shutdown
use "w78-spweather.dta", clear
sort newid wdate
stset tf if weather != . & gender != . , failure(cen) id(newid)

streg  CLockdown if welle==7 , distribution(exp) nohr 
estimate store W7
streg  Lockdown if welle==8 , distribution(exp) nohr 
estimate store W8

coefplot W8 W7 , drop(_cons) 


/* Wave 8 only - Corona effects */
use "w8-covid.dta", clear
sort newid wdate

/* Remaining time until the end of the shutdown
gen sdend = .
replace sdend = 132-wdate if wdate < 132
replace sdend = 0 if wdate >= 132
fre sdend */

/* Reminder
gen remind1 = 0
replace remind1 = 1 if tf == 2
gen remind2 = 0
replace remind2 = 1 if tf == 4
gen remind3 = 0
replace remind3 = 1 if tf == 7
gen remind4 = 0
replace remind4 = 1 if tf == 11
gen remind5 = 0
replace remind5 = 1 if tf == 14
*/

/* Digital Reminder

gen dremind1 = 0
replace dremind1 = 1 if tf == 4
gen dremind2 = 0
replace dremind2 = 1 if tf == 7
gen dremind3 = 0
replace dremind3 = 1 if tf == 11

*/
* Table 2

stset tf if weather != . & gender != . , failure(cen) id(newid)

streg Lockdown fallzahlenprotag hospitalisationenprotag TodesfälleproTag weather  , distribution(exp) nohr 

streg Lockdown fallzahlenprotag hospitalisationenprotag TodesfälleproTag weather ib7.hh_egp_mv ib4.sektyp9_mv zdemark9 ib1.gender , distribution(exp) nohr 


streg dremind1-dremind3 , distribution(exp) nohr 

streg Lockdown fallzahlenprotag hospitalisationenprotag TodesfälleproTag weather ib7.hh_egp_mv ib4.sektyp9_mv zdemark9 ib1.gender dremind1-dremind3 , distribution(exp) nohr 

* Interaction: Shutdown and education
gen int1=0
replace int1=1 if Lockdown==1 & sektyp9_mv==1
gen int2=0
replace int2=1 if Lockdown==1 & sektyp9_mv==2
gen int3=0
replace int3=1 if Lockdown==1 & sektyp9_mv==3

streg Lockdown fallzahlenprotag hospitalisationenprotag TodesfälleproTag weather ib7.hh_egp_mv ib4.sektyp9_mv zdemark9 ib1.gender int1-int3, distribution(exp) nohr 



/* End of File */
