################################################################################
# RRT-plus projekt ##
# Datamanagement
################################################################################
# devtools::dev_mode(on = T)
# devtools::install_github("jeffreyhanson/tibble")
# devtools::install_github("prioritizr/prioritizr@tibbles4")
################################
## packete
################################
  if (!require("pacman"))
    install.packages("pacman")
  pacman::p_load(
    # memisc,
    eRm,
    psych,
    devtools,
    lavaan,
    ggplot2,
    #ggmosaic,
    MplusAutomation,
    plyr,
    relimp,
    xtable,
    dplyr,
    stringr,
    readr,
    data.table,
    margins,
    tidyr,
    ztable,
    lazyeval,
    scales,
    # memisc,
    haven,
    tibble,
    inspectdf,
    # simsalapar,
    stargazer,
    summarytools,
    DataExplorer,
    Hmisc,
    RRreg, # auswertung rrt
    vtable, # variablen ansehen koennen
    gtsummary, # summarytablene
    gt # tables
  )
################################
# Dropboxpfadfinden
################################
  if (Sys.info()['sysname'] == 'Darwin') {
    info <- RJSONIO::fromJSON(file.path(path.expand("~"), '.dropbox',
                                        'info.json'))
  }
  if (Sys.info()['sysname'] == 'Windows') {
    info <- RJSONIO::fromJSON(if (file.exists(file.path(
      Sys.getenv('APPDATA'), 'Dropbox', 'info.json'
    ))) {
      file.path(Sys.getenv('APPDATA'), 'Dropbox', 'info.json')
    } else {
      file.path(Sys.getenv('LOCALAPPDATA'), 'Dropbox', 'info.json')
    })
  }
  
  dropbox_base <- info$personal$path
################################
# Ergebnispfade werden definiert

  results_path <-
    paste0(dropbox_base,
           "\\aktenkoffer\\4_projekte\\rrt_plus\\analyse\\")

# funktion zur indexerstellung
# funktion bildet spss sum.1() ab
  spss.row.sum <- function(vars, not.na=0) {
    apply(vars, 1, function(x) ifelse(sum(!is.na(x)) >= not.na, 
                                      sum(x, na.rm=TRUE), NA))
  }
#funktion zur indexerstellung

# funktion zur indexerstellung
# funktion bildet spss mean.1() ab
  spss.row.mean <- function(vars, not.na=0) {
    apply(vars, 1, function(x) ifelse(sum(!is.na(x)) >= not.na, 
                                      mean(x, na.rm=TRUE), NA))
  }
#funktion zur indexerstellung

# Datensatzort bestimmen
# path1 <- choose.dir()
  path  <-paste0(dropbox_base,"\\aktenkoffer\\4_projekte\\rrt_plus\\analyse\\")
  setwd(paste0(dropbox_base,"\\aktenkoffer\\4_projekte\\rrt_plus\\analyse\\"))

### pfade der Datensaetze-------->
  db_rrt = paste0(path,"Datensatz_aufbereitet_V1.0.sav")# Dateiname Angeben

# Datensaetze einlesen
  df.rrt <- read_spss(db_rrt)

## Section:Id variable erstellen
###############################################################################
  df.rrt <- df.rrt %>% mutate(id = row_number())
  colnames(df.rrt)

# Datensatz?bersicht
  # view(dfSummary(df.rrt))
  vtable(df.rrt)

# missingverteilung
  plot_intro(df.rrt)
  plot_missing(df.rrt)


# Zusammenfassung
  # create_report(df.rrt)

################################################################################
### Arbeits-Datensatz ########
################################################################################
  df.w <- select(df.rrt, c(c_0001,  # fragebogenversion
                              v29,  # aktuelle wohnform (inkl wg)
                              v31,  # wohnen in wg (jemals)
                              v131, # Konzentration
                              v132, # ehrlichkeit
                              v133, # interesse an themen
                              v135, # vertrauen in anony
                              v136, # korrekte befolgung
                              v90,  # Es ist schon mal vorgekommen, dass ich jemanden ausgenutzt habe.
                              v91,  # Auch wenn ich selbst gestresst bin, behandle ich andere immer freundlich und zuvorkommend.
                              v92,  # Manchmal helfe ich jemandem nur, wenn ich eine Gegenleistung erwarten kann.
                              v93,  # Im Streit bleibe ich stets sachlich und objektiv.
                              v94,  # Ich habe schon mal M?ll einfach in die Landschaft oder auf die Stra?e geworfen.
                              v95,   # Wenn ich mich mit jemandem unterhalte, h?re ich ihm immer aufmerksam zu.
                              id    # id
                           )
               )
  colnames(df.w)
  
  df.w <- df.w %>% rename(quest_version = c_0001,     # fragebogenversion
                          living_style = v29,         # aktuelle wohnform (inkl wg)
                          shared_appartment_q = v31,  # wohnen in wg (jemals)
                          concentration = v131,       # Konzentration
                          honest_answ = v132,         # ehrlichkeit
                          intrestin_q = v133,         # interesse an themen
                          trustin_ano = v135,         # vertrauen in anony
                          compliance_q = v136,         # korrekte befolgung
                          sd1 = v90,# Es ist schon mal vorgekommen, dass ich jemanden ausgenutzt habe.
                          sd2 = v91,# Auch wenn ich selbst gestresst bin, behandle ich andere immer freundlich und zuvorkommend.
                          sd3 = v92,# Manchmal helfe ich jemandem nur, wenn ich eine Gegenleistung erwarten kann.
                          sd4 = v93,# Im Streit bleibe ich stets sachlich und objektiv.
                          sd5 = v94,# Ich habe schon mal M?ll einfach in die Landschaft oder auf die Stra?e geworfen.
                          sd6 = v95, # Wenn ich mich mit jemandem unterhalte, h?re ich ihm immer aufmerksam zu.
                          id  = id  # id
                          )
  
################################################################################
## Verteilungen #####
################################################################################
  df.w$quest_version # zufallsauswahl
  df.w$living_style
  df.w$shared_appartment_q
  df.w$id
  
  # plot(df.w$living_style)
  # table(df.w$living_style)
  
  # plot(df.w$shared_appartment_q)
  # table(df.w$shared_appartment_q)
    
    # missingverteilung
    plot_intro(df.w)
    plot_missing(df.w)
    
    # table(df.w$quest_version)

# nach normaler momentanen normale frage
  # Datebsatz mit personen die aktuell in einer WG Wohnen
  df.livinginshared <-df.w %>% 
                filter(living_style == 2) # hier der Filter 
    
# nach fragetechniken
  df.livinginshared %>%
    group_by(quest_version) %>%
    summarise(mean = mean(shared_appartment_q, na.rm = TRUE), n = n())


  table(df.livinginshared$shared_appartment_q)
  plot_missing(df.livinginshared)
  
# Zusammenfassung ueber living aktuell in shared ###############################
    nrow(df.livinginshared) # Anzahl Personen, welche auf jeden Fall 
                            # einmal in einer WG gelebt haben: 381
  
  # Summary
    library(vtable) # variablen ansehen koennen
    vtable(df.livinginshared)
    
    # ansicht der analysegruppe
    df.stargater<-as.data.frame(na.omit(df.livinginshared))
    stargazer(df.stargater ~ as.factor(quest_version), type="text")
    stargazer(as.data.frame(na.omit(df.w)), type="text")
    
    # table(df.livinginshared$compliance_q)
    # table(df.livinginshared$trustin_ano)
    # table(df.livinginshared$honest_answ)
    # table(df.livinginshared$concentration)
    
    # mytable <- table(df.livinginshared$compliance_q,
    #                  df.livinginshared$honest_answ,
    #                  df.livinginshared$concentration)
    # ftable(mytable) 
    # 
    
# Summary 1 alle
    summaryset <- sapply(na.omit(df.w), as.numeric)
    summaryset <- as.data.frame(summaryset)
    summaryset %>%
      tbl_summary(by = quest_version) %>%
      #add_p() %>%
      add_overall() %>% 
      bold_labels()
    
# Summary 2 wg sicher
    # library(gtsummary)
    summaryset <- sapply(na.omit(df.livinginshared), as.numeric)
    summaryset <- as.data.frame(summaryset)
    summaryset %>%
              tbl_summary(by = quest_version) %>%
                #add_p() %>%
                add_overall() %>% 
                bold_labels()%>% 
                    as_gt() %>% gt::as_latex()
    

    
################################################################################
## Auswertung fuer Personen, welche auf jeden Fall 
##  einmal in einer WG gelebt haben: 381
################################################################################

# Auswertung: directe Frage Auswertung DQ
  df.w %>%
    filter(living_style == 2 & quest_version==3) %>%
    summarise(count_of_ja   =sum(shared_appartment_q==1, na.rm=TRUE), 
              count_of_nein =sum(shared_appartment_q==2, na.rm=TRUE),
              n = n())
    
# Auswertung: der Triangulation
  df.w %>%
    filter(living_style == 2 & quest_version==1) %>%
    summarise(count_of_A   =sum(shared_appartment_q==1, na.rm=TRUE), 
              count_of_B =sum(shared_appartment_q==2, na.rm=TRUE),
              n = n())

# Auswertung: RRT
  df.w %>%
    filter(living_style == 2 & quest_version==2) %>%
    summarise(count_of_ja   =sum(shared_appartment_q==1, na.rm=TRUE), 
              count_of_nein =sum(shared_appartment_q==2, na.rm=TRUE),
              n = n())
  
# Auswertung: des crosswise model
  df.w %>%
    filter(living_style == 2 & quest_version==4) %>%
    summarise(count_of_ja   =sum(shared_appartment_q==1, na.rm=TRUE), 
              count_of_nein =sum(shared_appartment_q==2, na.rm=TRUE),
              n = n())
  
################################################################################
## Auswertung fuer alle Personen im Datensatz #####
################################################################################
  
  # Auswertung: directe Frage Auswertung DQ
  df.w %>%
    filter(quest_version==3) %>%
    summarise(count_of_ja   =sum(shared_appartment_q==1, na.rm=TRUE), 
              count_of_nein =sum(shared_appartment_q==2, na.rm=TRUE),
              n = n())
  
  # Auswertung: der Triangulation
  df.w %>%
    filter(quest_version==1) %>%
    summarise(count_of_A   =sum(shared_appartment_q==1, na.rm=TRUE), 
              count_of_B =sum(shared_appartment_q==2, na.rm=TRUE),
              n = n())
  
  # Auswertung: RRT
  df.w %>%
      filter(quest_version==2) %>%
      summarise(count_of_ja   =sum(shared_appartment_q==1, na.rm=TRUE), 
                count_of_nein =sum(shared_appartment_q==2, na.rm=TRUE),
                n = n())
    
  # Auswertung: des crosswise model
  df.w %>%
    filter(quest_version==4) %>%
    summarise(count_of_ja   =sum(shared_appartment_q==1, na.rm=TRUE), 
              count_of_nein =sum(shared_appartment_q==2, na.rm=TRUE),
              n = n())


## Section: Summary for all
###############################################################################   

  
  
  
# ##############################################################################
# ##############################################################################
# ##############################################################################
# ##############################################################################
# ##############################################################################

# ##############################################################################
# ##############################################################################
# ##############################################################################
# ##############################################################################
# ##############################################################################
# ##############################################################################
  
## Section: Sample-Verteilungen für Paper
###############################################################################
library(estimatr)
library(modelsummary)
library(tidyr)

## Section: Desc with skimmer aus 
###############################################################################
  
  df.desc_all <- data.frame(lapply(na.omit(df.w),
                                   function(x) as.numeric(as.character(x))))
  
  # Zusatzvariablen zuspielen mit ID Matching
  df.zuspiel<-select(df.rrt, c(  # fragebogenversion
                     v1,  # sex
                     v2,  # geburtsjahr
                     # v15, # Abschluss
                     v17, # Fachsemster
                     id ))
  # sex recode
    df.zuspiel <- df.zuspiel %>% mutate(sexratio = ifelse(v1==-77, NA, # missings 
                                                    ifelse(v1==3, NA, #divers
                                                      ifelse(v1==2,1,0))))# m=1 
    
  # alter redoce
    df.zuspiel <- df.zuspiel %>% mutate(age = ifelse(v2==-77, NA, v2))
    df.zuspiel <- df.zuspiel %>% mutate(age = ifelse(v2==25, NA, v2))                                                   
    df.zuspiel <- df.zuspiel %>% mutate(age = 2019-(1980+v2)) # alter berechnen
  
  # fachsemester recode
    df.zuspiel <- df.zuspiel %>% mutate(semester = ifelse(v17==-77, NA, v17))
  
  # drop unnoetig vars
    df.zuspiel<-df.zuspiel %>% select (-c(v1, v2, v17))

  # # 
  # sex = v1, 
  # geburtsjahr = v2, 
  # Abschluss= v15, 
  # Fachsemster= v17,
  # Dauer_Studium = v18,  
  # Erwerb= v19,
  
  # verbinde zuspiel mit reduzierten
  df.desc_all<-merge(df.desc_all, df.zuspiel, by = "id")
  nrow(df.desc_all)
  
  df.desc_all <- data.frame(lapply(df.desc_all,
                                   function(x) as.numeric(as.character(x))))
  
  # reordering
  col_order <- c("age", "sexratio", "semester", "concentration","honest_answ",
                 "intrestin_q", "trustin_ano", "compliance_q", "sd1","sd2",
                 "sd3", "sd4", "sd5", "sd6","living_style",
                 "shared_appartment_q", "id", "quest_version"
                 )
  df.desc_all <- df.desc_all[, col_order]
  
  # recode quest_version for table
  df.desc_all <- df.desc_all %>% mutate(quest_version = 
                           recode_factor(quest_version,
                                         `3` = "DQ",
                                         `2` = "RRT",
                                         `4` = "CM",
                                         `1` = "TM"))
  
  
  # 
  # n1      <- sum(df.temp$quest_version == 3) # fallzahl fuer DQ
  # n_rrt   <- sum(df.temp$quest_version == 2) # fallzahl fuer rrt
  # n_cross <- sum(df.temp$quest_version == 4) # fallzahl fuer Crosswise
  # n_tria  <- sum(df.temp$quest_version == 1) # fallzahl fuer tria
  
  # Ausgabe
  caption <- 'Descriptive Statistics for Aggregate Level Validation (N=1043)'
  reference <- ''
  datasummary_balance(~quest_version,
                      data=df.desc_all,
                      # output = "default",
                      output = "desc_all_table.tex",
                      title = caption,
                      align = "lcccccccc",
                      fmt = 2,
                      dinm=FALSE
  )
  ############################################################################
  caption <- 'Descriptive Statistics for Individual Level Validation (N=335)'
  reference <- ''
  
  
  df.desc_wg <- data.frame(lapply(na.omit(df.livinginshared),
                                  function(x) as.numeric(as.character(x))))
  
  # verbinde zuspiel mit reduzierten
  df.desc_wg<-merge(df.desc_wg, df.zuspiel, by = "id")
  nrow(df.desc_wg)
  
  df.desc_wg <- data.frame(lapply(df.desc_wg,
                                  function(x) as.numeric(as.character(x))))
  # reordering
  col_order <- c("age", "sexratio", "semester", "concentration","honest_answ",
                 "intrestin_q", "trustin_ano", "compliance_q", "sd1","sd2",
                 "sd3", "sd4", "sd5", "sd6","living_style",
                 "shared_appartment_q", "id", "quest_version"
  )
  df.desc_wg <- df.desc_wg[, col_order]
  
  # recode quest_version for table
  df.desc_wg <- df.desc_wg %>% mutate(quest_version = 
                                          recode_factor(quest_version,
                                                        `3` = "DQ",
                                                        `2` = "RRT",
                                                        `4` = "CM",
                                                        `1` = "TM"))
  datasummary_balance(~quest_version,
                      data=df.desc_wg,
                      # output = "default",
                      output = "desc_wg_table.tex",
                      title = caption,
                      align = "lcccccccc",
                      fmt = 2,
                      dinm=FALSE
  )  
  

# ##############################################################################
# ##############################################################################
# ##############################################################################
# ##############################################################################
# ##############################################################################
# ##############################################################################
# ##############################################################################
# ##############################################################################
# ##############################################################################
# ##############################################################################
# ##############################################################################
# # alles aus speicher loeschen
# ##############################################################################
# ##############################################################################
# # gc()
# rm(list = ls())
# gc(TRUE)
# ##############################################################################
# ##############################################################################
# # alles aus speicher loeschen
# ##############################################################################
# ##############################################################################