################################################################################
## RRT Plus Projekt #####################
# Syntax fuer plausibilittschecks etc.
# Erstellt: 2020-10-29
################################################################################

# Point biserial correlation coefficient with the items of sd scala
# Auswertung: directe Frage Auswertung DQ
df.plausible<-df.w %>%
  filter(quest_version==3)

# df.plausible<-df.w
  
ds_cor <- df.plausible %>%
  select(shared_appartment_q, sd1, sd2, sd3, sd4, sd5 ,sd6) %>% 
  as.matrix() %>%
  rcorr(type = "pearson")

ds_cor # output

# Matrix fuer Ergebnis
ds_cor$r[,1] # erste spalte korrelationen shared appartment und SD items
ds_cor$P[,1] # erste spalte p werte shared appartment und SD items
mymatrix_Point_biserial<-cbind(ds_cor$r[,1],ds_cor$P[,1], ds_cor$n[,1])
mymatrix_Point_biserial=mymatrix_Point_biserial[-1,]
colnames(mymatrix_Point_biserial)<-c("point biserial corr", "p-value", "N")
mymatrix_Point_biserial

write.table(mymatrix_Point_biserial, 'clipboard', sep='\t') # matrix to clipboard

# analysis with pca with sd scala
  df.plausible<-df.w %>%
    select(sd1, sd2, sd3, sd4, sd5 ,sd6)
  
  # df.plausible<-na.omit(df.plausible) # missings raus
  
  # Principal component analysis
  pca1 <- princomp(df.plausible, scores=TRUE, cor=TRUE)
  summary(pca1)
  
  # Loadings of principal components
  loadings(pca1)
  #pca1$loadings
  
  # Scree plot of eigenvalues
  plot(pca1)
  screeplot(pca1, type="line", main="Scree Plot")
  
  # Biplot of score variables
  biplot(pca1)
  
  # Scores of the components
  pca1$scores[1:10,]
  
  # Rotation
  # varimax(pca1$rotation)
  # promax(pca1$rotation)
  
  require("stats")
  # Factor analysis - different results from other softwares and no rotation
  fa1 <- factanal(df.plausible, factor=2, rotation = "promax")
  fa1
  
  fa2 <- factanal(df.plausible, factor=3, rotation="varimax")
  fa2
  
  fa3 <- factanal(df.plausible, factors=3, rotation="varimax", scores="regression")
  fa3
  
# # we need library(psych)
  require(psych)