################################################################################
# RRT-plus projekt ##
# Auswertung fuer alle Befragten
################################################################################

### Aggregate Level Validierung ########

################################################################################
## Auswertung der Schaetzer der indirekten Fragetechniken #####
################################################################################
library(RRreg) # packet fuer indirekte Fragetechniken

###########################
# Hier Stichprobe festlegen
###########################
  df.temp <- df.w # ohne einschr?nkung stichprobe
  # df.temp <- df.w %>% filter(living_style == 2)# nur personen mit 1 in data
  
  # Umcodierung der Variablen zu 0 = merkmal nicht vorhanden oder 
  # unterschiedlich antwort SOWI 1= merkmal vorhanden oder gleiche Antwort
  df.temp <- df.temp %>% 
    mutate(response=as.numeric(!(shared_appartment_q>1)))# dummycodierung
  # durch invertierung der gr??erabfrage fuer DQ, Crosswise und RRT
  # sum(is.na(df.temp$response))
  # Conditional Recode
  df.temp <- df.temp %>% 
    mutate(response = ifelse(quest_version==1 & response==1, 0, 
                             ifelse(quest_version==1 & response==0, 1,
                                    response)))
  # sum(is.na(df.temp$response))
  # # f?r triangual wird 1=B und 0=A
  
  
  df.temp$shared_appartment_q
  # sum(is.na(df.temp$shared_appartment_q))
  df.temp$response
  
  # Missings in response raus
  df.temp<- na.omit(df.temp, cols="response") # Missings raus
  # df.temp<-df.temp %>% drop_na(response)
  
  mean(df.temp$response)
  nrow(df.temp)
  # sum(is.na(df.temp$response))
  #  DQ Auswertung
  df.w_auswertung <- 
    df.temp %>% filter(quest_version==3) # Filter DQ
  dq_mean<-mean(df.w_auswertung$response, na.rm=TRUE)
  dq_mean
  print("N=")
  nrow(df.w_auswertung)
  
  p.est <- mean(df.w_auswertung$response)
  variance <- (p.est*(1-p.est))/nrow(df.w_auswertung)
  dq_std.dev <- sqrt(variance)
  print("Std.Error=")
  dq_std.dev
  
  # RRT Auswertung
  p_whs<-0.166
  # Benfordverteilung 1 bis 4
  p_hausnr<-0.301 + 0.1666 + 0.125 + 0.097
  # Einschr?nkung der Stichprobe
  df.w_auswertung <- 
    df.temp %>% filter(quest_version==2) # Filter RRT
  model_rrt_all <- RRuni(response=response, data=df.w_auswertung, 
                     model="UQTknown", p=c(p_hausnr, 0.166), MLest=T)
  summary(model_rrt_all)

# Crosswise Auswertung
  # Einschr?nkung der Stichprobe
  df.w_auswertung <- 
    df.temp %>% filter(quest_version==4) # Filter crosswise
  model_cross_all <- RRuni(response=response, data=df.w_auswertung, 
                       model="Crosswise", p=0.166, MLest=T)
  summary(model_cross_all)
  
  # triangular Auswertung
  # Einschr?nkung der Stichprobe
  df.w_auswertung <- 
    df.temp %>% filter(quest_version==1) # Filter triang
  model_triangular_all <- RRuni(response=response, data=df.w_auswertung, 
                            model="Triangular", p=0.166, MLest=T)
  summary(model_triangular_all)


# Summary 3
# library(gtsummary)
summaryset <- sapply(df.temp, as.numeric)
summaryset <-as.data.frame(summaryset)

summaryset %>%
  tbl_summary(by = quest_version) %>%
  # add_p() %>%
  add_overall() %>% 
  bold_labels() 

############################################################################
### Mittelwertvergleich #####
############################################################################
  n1      <- sum(df.temp$quest_version == 3) # fallzahl fuer DQ
  n_rrt   <- sum(df.temp$quest_version == 2) # fallzahl fuer rrt
  n_cross <- sum(df.temp$quest_version == 4) # fallzahl fuer Crosswise
  n_tria  <- sum(df.temp$quest_version == 1) # fallzahl fuer tria
  
  #  Welch t test (noch nicht fertig)
  library(PASWR)
  # rrt test
  tsum.test(mean.x=dq_mean, s.x = dq_std.dev, n.x = n1,
            mean.y = model_rrt_all$pi, s.y = model_rrt_all$piSE,n.y = n_rrt,
            alternative = "two.sided", mu = 0, var.equal = FALSE,
            conf.level = 0.95)
  
  # crosswise test
  tsum.test(mean.x=dq_mean, s.x = dq_std.dev, n.x = n1,
            mean.y = model_cross_all$pi, s.y = model_cross_all$piSE,n.y = n_cross,
            alternative = "two.sided", mu = 0, var.equal = FALSE,
            conf.level = 0.95)
  
  # trian test
  tsum.test(mean.x=dq_mean, s.x = dq_std.dev, n.x = n1,
            mean.y = model_triangular_all$pi, s.y = model_triangular_all$piSE,n.y = n_tria,
            alternative = "two.sided", mu = 0, var.equal = FALSE,
            conf.level = 0.95)

# (dq_mean - model_rrt_all$pi)/sqrt(((dq_std.dev^2)/n1)+((model_rrt_all$piSE^2)/n_rrt))
# (dq_mean - model_cross_all$pi)/sqrt(((dq_std.dev^2)/n1)+((model_cross_all$piSE^2)/n_cross))
# (dq_mean - model_triangular_all$pi)/sqrt(((dq_std.dev^2)/n1)+((model_triangular_all$piSE^2)/n_tria))
#   
#   # DF berechnung
# (dq_std.dev^2)/n1)+((model_rrt_all$piSE^2)/n_rrt)^2/

# Cohen's d formula: Cohen's d for Welch t-test

(dq_mean - model_rrt_all$pi)/sqrt((dq_std.dev^2 + model_rrt_all$piSE^2)/2)

# log modell (unklar ob dies geht) RRTuq
  df.temp$not_DQ <- 
    ifelse(df.temp$quest_version==3,0,1)# zeigt an ob DQ oder
  df.temp$not_DQ
  
  
  table(df.temp$not_DQ)
  
  # RRT, Cross, tria ####
  
  # Faelle filtern
  df.w_auswertung <- 
    df.temp %>% filter(quest_version==2 | quest_version==3) # Filter RRT+DQ
  fit_rrtuq_all <- RRlog(response ~ not_DQ,
                     data=df.w_auswertung,
                     model="UQTknown",
                     p=c(p_hausnr, 0.166), 
                     group=not_DQ,
                     LR.test=TRUE,
                     fit.n = 5)
  summary(fit_rrtuq_all)
  
  
  # log modell (geht nicht) Crosswise
  # Faelle filtern
  df.w_auswertung <- 
    df.temp %>% filter(quest_version==4 | quest_version==3) # Filter cross+DQ
  fit_cross_all <- RRlog(df.w_auswertung$response ~ not_DQ,
                     data=df.w_auswertung,
                     model="Crosswise",
                     p=0.166, 
                     group=not_DQ,
                     LR.test=TRUE,
                     fit.n = 5)
  summary(fit_cross_all)
  
  # log modell (geht nicht) trian
  # Faelle filtern
  df.w_auswertung <- 
    df.temp %>% filter(quest_version==1 | quest_version==3) # Filter tria+DQ
  fit_tria_all <- RRlog(response ~ not_DQ,
                    data=df.w_auswertung,
                    model="Triangular",
                    p=0.166, 
                    group=not_DQ,
                    LR.test=TRUE,
                    fit.n = 5)
  summary(fit_tria_all)


##### Grafik ##################################
# Datensatz aus Ergebnissen erstellen ######
Modeltyp<-c('DQ',
            'RRT_uq',
            'Crosswise',
            'Triangular')                                                                                
estimation_preval<- c(dq_mean,
                      model_rrt_all$pi,
                      model_cross_all$pi,
                      model_triangular_all$pi)
SE<- c(dq_std.dev,
       model_rrt_all$piSE,
       model_cross_all$piSE,
       model_triangular_all$piSE)

df.meandata <- data.frame(Modeltyp, estimation_preval, SE)# datensatz 
df.meandata$ci<-df.meandata$SE*1.96# CI erstellen

head(df.meandata)
###########################################

library(ggplot2)

# sortierung von modeltyp sicherstellen ing Grafik
df.meandata$Modeltyp <- factor(df.meandata$Modeltyp,
                               levels = c("DQ",
                                          "RRT_uq",
                                          "Crosswise",
                                          "Triangular"))

# Make the graph with the 95% confidence interval

ggplot_all<-ggplot(df.meandata, aes(x=Modeltyp, y=estimation_preval)) +
  geom_errorbar(width=.1, 
                aes(ymin=estimation_preval-ci,
                    ymax=estimation_preval+ci)) +
  geom_point(shape=21, size=4, fill="black") +
  geom_text(label=round(estimation_preval,3), nudge_x = 0.3, size=6) +
  ylab("Est. Prop.: Shared apartment")+
  xlab("")+
  #ylim(0.0,1) +
  scale_y_continuous(breaks=seq(0,1,0.1), limits=c(0, 1.0), oob = rescale_none)+
  coord_flip(expand = TRUE) +
  theme_bw(base_size = 20)
ggplot_all


library("ggpubr")

# ggexport(ggplot_all, filename = "aggregat_analysis_size.pdf")

ggsave(filename="aggregat_analysis_size.pdf", 
       plot = ggplot_all, 
       device = cairo_pdf, 
       width = 297, 
       height = 210, 
       units = "mm")
###############################################################################



################################################################################
# log modell RRlog mit Erklaerungvariablen ###########
################################################################################
df.temp$not_DQ <- 
  ifelse(df.temp$quest_version==3,0,1)# zeigt an ob DQ oder
df.temp$not_DQ


table(df.temp$not_DQ)

# RRT, Cross, tria ####
formula_rrt_plus<-response ~ not_DQ + compliance_q + concentration + honest_answ + trustin_ano
# formula_rrt_plus<-response ~ not_DQ + compliance_q
# formula_rrt_plus<-response ~ not_DQ + concentration
# formula_rrt_plus<-response ~ not_DQ + trustin_ano
# formula_rrt_plus<-response ~ not_DQ + honest_answ

# # mit interaktion
# formula_rrt_plus<-response ~ not_DQ * compliance_q
# formula_rrt_plus<-response ~ not_DQ * concentration
# formula_rrt_plus<-response ~ not_DQ * trustin_ano
# formula_rrt_plus<-response ~ not_DQ * honest_answ



# Faelle filtern
df.w_auswertung <- 
  df.temp %>% filter(quest_version==2 | quest_version==3) # Filter RRT+DQ
fit_rrtuq_all_full <- RRlog(formula_rrt_plus,
                   data=df.w_auswertung,
                   model="UQTknown",
                   p=c(p_hausnr, 0.166), 
                   group=not_DQ,
                   LR.test=TRUE,
                   fit.n = 50)
summary(fit_rrtuq_all_full)


# log modell (geht nicht) Crosswise
# Faelle filtern
df.w_auswertung <- 
  df.temp %>% filter(quest_version==4 | quest_version==3) # Filter cross+DQ
fit_cross_all_full <- RRlog(formula_rrt_plus,
                   data=df.w_auswertung,
                   model="Crosswise",
                   p=0.166, 
                   group=not_DQ,
                   LR.test=TRUE,
                   fit.n = 50)
summary(fit_cross_all_full)

# log modell (geht nicht) trian
# Faelle filtern
df.w_auswertung <- 
  df.temp %>% filter(quest_version==1 | quest_version==3) # Filter tria+DQ
fit_tria_all_full <- RRlog(formula_rrt_plus,
                  data=df.w_auswertung,
                  model="Triangular",
                  p=0.166, 
                  group=not_DQ,
                  LR.test=TRUE,
                  fit.n = 50)
summary(fit_tria_all_full)

################################################################################
### Building a table of results ####
################################################################################
# library(matlib) # intervertierung matrix
  # rrt model
  a<-fit_rrtuq_all_full$param #  name
  b<-fit_rrtuq_all_full$coefficients # of LRT
  
  diag_matrix<-diag((fit_rrtuq_all_full$vcov)) #covmatrix
  c<-sqrt(diag_matrix) # SEs
  d<-fit_rrtuq_all_full$prob # of LRT
  
  e<-fit_rrtuq_all_full$logLik # LL
  f<-fit_rrtuq_all_full$n # N
  
  mymatrix_rrtuq<-cbind(b,c,d)
  mymatrix_rrtuq<-rbind(mymatrix_rrtuq,e,f)
  colnames(mymatrix_rrtuq)<-c("Esti.", "StdErr", "p-Value from LRT")
  mymatrix_rrtuq
  
  write.table(mymatrix_rrtuq, 'clipboard', sep='\t') # matrix zu clipboard
  # cross model
  a<-fit_cross_all_full$param #  name
  b<-fit_cross_all_full$coefficients # of LRT
  
  diag_matrix<-diag((fit_cross_all_full$vcov)) #covmatrix
  c<-sqrt(diag_matrix) # SEs
  d<-fit_cross_all_full$prob # of LRT
  
  e<-fit_cross_all_full$logLik # LL
  f<-fit_cross_all_full$n # N
  
  mymatrix_cross<-cbind(b,c,d)
  mymatrix_cross<-rbind(mymatrix_cross,e,f)
  colnames(mymatrix_cross)<-c("Esti.", "StdErr", "p-Value from LRT")
  mymatrix_cross
  
  write.table(mymatrix_cross, 'clipboard', sep='\t') # matrix zu clipboard
  # tria model
  a<-fit_tria_all_full$param #  name
  b<-fit_tria_all_full$coefficients # of LRT
  
  diag_matrix<-diag((fit_tria_all_full$vcov)) #covmatrix
  c<-sqrt(diag_matrix) # SEs
  d<-fit_tria_all_full$prob # of LRT
  
  e<-fit_tria_all_full$logLik # LL
  f<-fit_tria_all_full$n # N
  
  mymatrix_tria<-cbind(b,c,d)
  mymatrix_tria<-rbind(mymatrix_tria,e,f)
  colnames(mymatrix_tria)<-c("Esti.", "StdErr", "p-Value from LRT")
  mymatrix_tria

write.table(mymatrix_tria, 'clipboard', sep='\t') # matrix zu clipboard


mymatrix_rrtuq
mymatrix_cross
mymatrix_tria
mymatrix_gesamt<-cbind(mymatrix_rrtuq, mymatrix_cross,mymatrix_tria)
mymatrix_gesamt

write.table(mymatrix_gesamt, 'clipboard', sep='\t') # matrix zu clipboard
################################################################################
source("test_der_berechnungsformeln_rrtplus.R", echo = TRUE, print.eval = TRUE)
