################################################################################
## Test der Berechnungsformeln #######
################################################################################

# RRTu ###############################################
# Faelle filtern
df.w_auswertung <- 
  df.temp %>% filter(quest_version==2) # Filter RRT

# pi_rrt    <-
# var_pi_rrt
p_a       <- 0.301 + 0.1666 + 0.125 + 0.097   
pi_b      <- 0.166
lamda_est <- mean(df.w_auswertung$response)
n         <- nrow(df.w_auswertung)

# Schaetzer nach rrt_un
pi_rrt <- (lamda_est-(1-p_a)*pi_b)/p_a
pi_rrt

# Varianz und std.error
var_pi_rrt<-(lamda_est*(1-lamda_est))/(n*p_a^2)
var_pi_rrt # Varianz
sqrt(var_pi_rrt) # SE

# bis auf rundungsfehler ist dieses ergebnis in ordnung fuer rrt_U

# Crosswise ###############################################    
df.w_auswertung <- 
  df.temp %>% filter(quest_version==4) # Filter crosswise

n         <- nrow(df.w_auswertung)
p_c       <- 0.166
lamda_est <- 1-mean(df.w_auswertung$response) # da anteil option A 
# invers of anteil
# von option B

# Schaetzer nach cross
pi_cross <- 1-((lamda_est+p_c-1)/(2*p_c-1))
pi_cross

# Varianz und std.error
var_pi_cross <- ((pi_cross*(1-pi_cross))/(n-1))+
  ((p_c*(1-p_c))/((n-1)*(2*p_c-1)^2))
var_pi_cross # Varianz
sqrt(var_pi_cross) # SE

# bis auf rundungsfehler ist dieses ergebnis in ordnung fuer crosswise


# triang ############################################### 
# Einschrnkung der Stichprobe
df.w_auswertung <- 
  df.temp %>% filter(quest_version==1) # Filter triang

n         <- nrow(df.w_auswertung)
p_t       <- 0.166
lamda_est <- 1-mean(df.w_auswertung$response) # da anteil option A 
# invers of anteil
# von option B
# Schaetzer nach triang
pi_triang <- 1-((lamda_est)/(1-p_t))
pi_triang

# Varianz und std.error
var_pi_triang <- ((pi_triang*(1-pi_triang))/(n-1))+
  ((p_t*(1-pi_triang))/((n-1)*(1-p_t)))
var_pi_triang # Varianz
sqrt(var_pi_triang) # SE  

################################################################################