# RRT-plus projekt
# Datamanagement

################################
## packete
################################
  if (!require("pacman"))
    install.packages("pacman")
  pacman::p_load(
    memisc,
    eRm,
    psych,
    devtools,
    lavaan,
    ggplot2,
    ggmosaic,
    MplusAutomation,
    plyr,
    relimp,
    xtable,
    dplyr,
    stringr,
    readr,
    data.table,
    margins,
    tidyr,
    ztable,
    lazyeval,
    scales,
    memisc,
    haven,
    tibble,
    inspectdf,
    simsalapar,
    stargazer,
    summarytools,
    DataExplorer,
    vtable, # variablen ansehen koennen
    gt # tables
  )
################################
# Dropboxpfadfinden
################################
  if (Sys.info()['sysname'] == 'Darwin') {
    info <- RJSONIO::fromJSON(file.path(path.expand("~"), '.dropbox',
                                        'info.json'))
  }
  if (Sys.info()['sysname'] == 'Windows') {
    info <- RJSONIO::fromJSON(if (file.exists(file.path(
      Sys.getenv('APPDATA'), 'Dropbox', 'info.json'
    ))) {
      file.path(Sys.getenv('APPDATA'), 'Dropbox', 'info.json')
    } else {
      file.path(Sys.getenv('LOCALAPPDATA'), 'Dropbox', 'info.json')
    })
  }
  
  dropbox_base <- info$personal$path
################################
# Ergebnispfade werden definiert
#results_path <- paste0(dropbox_base,"/aktenkoffer/4_projekte/monte_carlo_simulation/mixture_models/simulation/auswertung_thirdrun/")
#results_path <- paste0(dropbox_base,"/aktenkoffer/4_projekte/monte_carlo_simulation/mixture_models/simulation/auswertung_labelrun/")
  results_path <-
    paste0(dropbox_base,
           "\\aktenkoffer\\4_projekte\\rrt_plus\\analyse\\")

# funktion zur indexerstellung
# funktion bildet spss sum.1() ab
  spss.row.sum <- function(vars, not.na=0) {
    apply(vars, 1, function(x) ifelse(sum(!is.na(x)) >= not.na, sum(x, na.rm=TRUE), NA))
  }
#funktion zur indexerstellung

# funktion zur indexerstellung
# funktion bildet spss mean.1() ab
  spss.row.mean <- function(vars, not.na=0) {
    apply(vars, 1, function(x) ifelse(sum(!is.na(x)) >= not.na, mean(x, na.rm=TRUE), NA))
  }
#funktion zur indexerstellung

# Datensatzort bestimmen
# path1 <- choose.dir()
  path  <-paste0(dropbox_base,"\\aktenkoffer\\4_projekte\\rrt_plus\\analyse\\")
  setwd(paste0(dropbox_base,"\\aktenkoffer\\4_projekte\\rrt_plus\\analyse\\"))

### pfade der Datensaetze-------->
  db_rrt = paste0(path,"Datensatz_aufbereitet_V1.0.sav")# Dateiname Angeben

# Datensaetze einlesen
  df.rrt <- read_spss(db_rrt)


view(dfSummary(df.rrt))
vtable(df.rrt)

# missingverteilung
  plot_intro(df.rrt)
  plot_missing(df.rrt)

# korrelationen
  df.rrt %>% 
    inspect_cor() %>%
    show_plot()
  
  behaelter<-df.rrt %>% 
    inspect_cor()
  
  
  behaelter_sub <- subset(behaelter, abs(corr) >= 0.2)
  plot(behaelter_sub$corr)
            
  df.rrt %>% 
    inspect_cor() %>%
      select_if(abs(.corr)>0.5)

# Zusammenfassung
  # create_report(df.rrt)

# ausspeichern der merged files
  write_sav(df.rrt, paste0(path, "\\df.rrt_plus.sav"))
# rm(merged_data_child_all)# loeschen um speicher zu entlassten
  
  
# Variablenbetrachtung zur Selbstangabe zum Verhalten
  # hist(df.rrt$v131) # Konzentration
  # hist(df.rrt$v132) # ehrlichkeit
  # hist(df.rrt$v133) # interesse an themen
  # hist(df.rrt$v135) # vertrauen in anony
  # hist(df.rrt$v136) # korrekte befolgung
  # 
  # boxplot(df.rrt$v131, df.rrt$v132,df.rrt$v133, df.rrt$v135,df.rrt$v136)
  # summary(df.rrt$v131, na.rm=TRUE)
  # 
################################################################################
## Arbeits-Datensatz
################################################################################
  df.w <- select(df.rrt, c(c_0001,  # fragebogenversion
                              v29,  # aktuelle wohnform (inkl wg)
                              v31,  # wohnen in wg (jemals)
                              v131, # Konzentration
                              v132, # ehrlichkeit
                              v133, # interesse an themen
                              v135, # vertrauen in anony
                              v136, # korrekte befolgung
                             )
               )
  colnames(df.w)
  
  df.w <- df.w %>% rename(quest_version = c_0001,     # fragebogenversion
                          living_style = v29,         # aktuelle wohnform (inkl wg)
                          shared_appartment_q = v31,  # wohnen in wg (jemals)
                          concentration = v131,       # Konzentration
                          honest_answ = v132,         # ehrlichkeit
                          intrestin_q = v133,         # interesse an themen
                          trustin_ano = v135,         # vertrauen in anony
                          compliance_q = v136         # korrekte befolgung
                          )
  
################################################################################
## Verteilungen
################################################################################
  df.w$quest_version
  df.w$living_style
  df.w$shared_appartment_q
  
  plot(df.w$living_style)
  table(df.w$quest_version)

# nach normaler momentanen normale frage
  # Datebsatz mit personen die aktuell in einer WG Wohnen
  df.livinginshared <-df.w %>% 
                filter(living_style == 2) # hier der Filter 
    
# nach fragetechniken
  df.livinginshared %>%
    group_by(quest_version) %>%
    summarise(mean = mean(shared_appartment_q, na.rm = TRUE), n = n())


  table(df.livinginshared$shared_appartment_q)

  df.w %>%
    filter(living_style == 2 & quest_version==3) %>%
    summarise(mean = mean(shared_appartment_q, na.rm = TRUE), n = n())

# Zusammenfassung ueber living aktuell in shared
  nrow(df.livinginshared) # Anzahl Personen, welche auf jeden Fall 
                          # einmal in einer WG gelebt haben: 381
  
  # Summary
  library(vtable) # variablen ansehen koennen
  vtable(df.livinginshared)
  stargazer(as.data.frame(df.livinginshared), type="text")
  
  table(df.livinginshared$compliance_q)
  table(df.livinginshared$trustin_ano)
  table(df.livinginshared$honest_answ)
  table(df.livinginshared$concentration)
  
  mytable <- table(df.livinginshared$compliance_q,
                   df.livinginshared$honest_answ,
                   df.livinginshared$concentration)
  ftable(mytable) 
  
  
################################################################################
## Likert visual ##
################################################################################

  library(sjPlot)
  library(sjmisc)


  
  plot_likert(df.w, show.n = TRUE)

  plot_likert(
    df.livinginshared,
    grid.range = c(1.2, 1.4),
    catcount = 4,
    cat.neutral = 3,
    expand.grid = FALSE,
    values = "sum.outside",
    show.legend = FALSE,
    show.n = TRUE,
    show.prc.sign = TRUE
  )


# ##############################################################################
# ##############################################################################
# ##############################################################################
# ##############################################################################
# ##############################################################################
# ##############################################################################
# ##############################################################################
# ##############################################################################
# ##############################################################################

# 
# #######################################################################################################
# #######################################################################################################
# # alles aus speicher loeschen
# #######################################################################################################
# #######################################################################################################
# # gc()
# rm(list = ls())
# gc(TRUE)
# #######################################################################################################
# #######################################################################################################
# # alles aus speicher loeschen
# #######################################################################################################
# #######################################################################################################