################################################################################
# RRT-plus projekt ##
# Auswertung fuer WG-sicher Befragten
################################################################################

### Individual Level Validierung ########


################################################################################
## Auswertung der Schaetzer der indirekten Fragetechniken #####
################################################################################
library(RRreg) # packet fuer indirekte Fragetechniken

###########################
# Hier Stichprobe festlegen
###########################
  # df.temp <- df.w # ohne einschr?nkung stichprobe
  df.temp <- df.w %>% filter(living_style == 2)# nur personen mit 1 in data
  
  # Umcodierung der Variablen zu 0 = merkmal nicht vorhanden oder 
  # unterschiedlich antwort SOWI 1= merkmal vorhanden oder gleiche Antwort
  df.temp <- df.temp %>% 
    mutate(response=as.numeric(!(shared_appartment_q>1)))# dummycodierung
  # durch invertierung der gr??erabfrage fuer DQ, Crosswise und RRT
  
  # Conditional Recode
  df.temp <- df.temp %>% 
    mutate(response = ifelse(quest_version==1 & response==1, 0, 
                             ifelse(quest_version==1 & response==0, 1,
                                    response)))
  df.temp$response
  # # f?r triangual wird 1=B und 0=A
  
  
  df.temp$shared_appartment_q
  df.temp$response
  sum(is.na(df.temp$response))
  
  # Missings raus
  df.temp<- na.omit(df.temp, cols="response") # Missings raus
  # df.temp<-df.temp %>% drop_na(response)
  
  mean(df.temp$response)
  nrow(df.temp)
  
  #  DQ Auswertung
  df.w_auswertung <- 
    df.temp %>% filter(quest_version==3) # Filter DQ
  dq_mean<-mean(df.w_auswertung$response, na.rm=TRUE)
  dq_mean
  print("N=")
  nrow(df.w_auswertung)
  
  p.est <- mean(df.w_auswertung$response)
  variance <- (p.est*(1-p.est))/nrow(df.w_auswertung)
  dq_std.dev <- sqrt(variance)
  print("Std.Error=")
  dq_std.dev
  
  # RRT Auswertung
  p_whs<-0.166
  # Benfordverteilung 1 bis 4
  p_hausnr<-0.301 + 0.1666 + 0.125 + 0.097
  # Einschr?nkung der Stichprobe
  df.w_auswertung <- 
    df.temp %>% filter(quest_version==2) # Filter RRT
  model_rrt_wg <- RRuni(response=response, data=df.w_auswertung, 
                     model="UQTknown", p=c(p_hausnr, .166), MLest=T)
  summary(model_rrt_wg)
  
  # Crosswise Auswertung
  # Einschr?nkung der Stichprobe
  df.w_auswertung <- 
    df.temp %>% filter(quest_version==4) # Filter crosswise
  model_cross_wg <- RRuni(response=response, data=df.w_auswertung, 
                       model="Crosswise", p=0.166, MLest=T)
  summary(model_cross_wg)
  
  # triangular Auswertung
  # Einschr?nkung der Stichprobe
  df.w_auswertung <- 
    df.temp %>% filter(quest_version==1) # Filter triang
  model_triangular_wg <- RRuni(response=response, data=df.w_auswertung, 
                            model="Triangular", p=.166, MLest=T)
  summary(model_triangular_wg)
  
  
  # Summary 3
  # library(gtsummary)
  summaryset <- sapply(df.temp, as.numeric)
  summaryset <- as.data.frame(summaryset)
  
  summaryset %>%
    tbl_summary(by = quest_version) %>%
    # add_p() %>%
    add_overall() %>% 
    bold_labels() 

############################################################################
### Mittelwertvergleich #####
############################################################################
n1      <- sum(df.temp$quest_version == 3) # fallzahl fuer DQ
n_rrt   <- sum(df.temp$quest_version == 2) # fallzahl fuer rrt
n_cross <- sum(df.temp$quest_version == 4) # fallzahl fuer Crosswise
n_tria  <- sum(df.temp$quest_version == 1) # fallzahl fuer tria


# # (dq_mean - model_rrt_wg$pi)/sqrt(((dq_std.dev^2)/n1)+((model_rrt_wg$piSE^2)/n_rrt))
# # (dq_mean - model_cross_wg$pi)/sqrt(((dq_std.dev^2)/n1)+((model_cross_wg$piSE^2)/n_cross))
# # (dq_mean - model_triangular_wg$pi)/sqrt(((dq_std.dev^2)/n1)+((model_triangular_wg$piSE^2)/n_tria))
# #   
# #   # DF berechnung
# # (dq_std.dev^2)/n1)+((model_rrt_wg$piSE^2)/n_rrt)^2/
# 
# # Cohen's d formula: Cohen's d for Welch t-test
# 
# (dq_mean - model_rrt_wg$pi)/sqrt((dq_std.dev^2 + model_rrt_wg$piSE^2)/2)

# log modell (unklar ob dies geht) RRTuq
df.temp$not_DQ <- 
  ifelse(df.temp$quest_version==3,0,1)# zeigt an ob DQ oder
df.temp$not_DQ


table(df.temp$not_DQ)

# RRT, Cross, tria ####

# Faelle filtern
df.w_auswertung <- 
  df.temp %>% filter(quest_version==2 | quest_version==3) # Filter RRT+DQ
fit_rrtuq_wg <- RRlog(response ~ not_DQ,
                   data=df.w_auswertung,
                   model="UQTknown",
                   p=c(p_hausnr, .166), 
                   group=not_DQ,
                   LR.test=TRUE,
                   fit.n = 5)
summary(fit_rrtuq_wg)


# log modell (geht nicht) Crosswise
# Faelle filtern
df.w_auswertung <- 
  df.temp %>% filter(quest_version==4 | quest_version==3) # Filter cross+DQ
fit_cross_wg <- RRlog(df.w_auswertung$response ~ not_DQ,
                   data=df.w_auswertung,
                   model="Crosswise",
                   p=.166, 
                   group=not_DQ,
                   LR.test=TRUE,
                   fit.n = 5)
summary(fit_cross_wg)

# log modell (geht nicht) trian
# Faelle filtern
df.w_auswertung <- 
  df.temp %>% filter(quest_version==1 | quest_version==3) # Filter tria+DQ
fit_tria_wg <- RRlog(response ~ not_DQ,
                  data=df.w_auswertung,
                  model="Triangular",
                  p=.166, 
                  group=not_DQ,
                  LR.test=TRUE,
                  fit.n = 5)
summary(fit_tria_wg)


##### Grafik ##################################
# Datensatz aus Ergebnissen erstellen ######
  Modeltyp<-c('DQ',
              'RRT_uq',
              'Crosswise',
              'Triangular')                                                                                
  estimation_preval<- c(dq_mean,
                        model_rrt_wg$pi,
                        model_cross_wg$pi,
                        model_triangular_wg$pi)
  SE<- c(dq_std.dev,
         model_rrt_wg$piSE,
         model_cross_wg$piSE,
         model_triangular_wg$piSE)
  
  df.meandata <- data.frame(Modeltyp, estimation_preval, SE) # datensatz 
  df.meandata$ci<-df.meandata$SE*1.96 # CI erstellen
  df.meandata$ci90<-df.meandata$SE*1.645 # CI erstellen
  
  head(df.meandata)
  df.meandata$Modeltyp
  df.meandata$estimation_preval
  df.meandata$estimation_preval+(df.meandata$SE*1.645)
###########################################

library(ggplot2)

# sortierung von modeltyp sicherstellen ing Grafik
df.meandata$Modeltyp <- factor(df.meandata$Modeltyp,
                               levels = c("DQ",
                                          "RRT_uq",
                                          "Crosswise",
                                          "Triangular"))
# without DQ
  #df.meandata_w<-df.meandata[-1,]
  #df.meandata_w$Modeltyp
  
  
## Section: Conf Inter 95 % (two side)
###############################################################################
# Make the graph with the 95% confidence interval

ggplot_95<-ggplot(df.meandata, aes(x=Modeltyp, y=estimation_preval)) +
  geom_errorbar(width=.1, 
                aes(ymin=estimation_preval-ci,
                    ymax=estimation_preval+ci)) +
  geom_point(shape=21, size=4, fill="black") +
  geom_text(label=round(estimation_preval,3), nudge_x = 0.3, size=6) +
  ylab("Est. Prop.: Shared apartment (95% CI)")+
  xlab("")+
  #ylim(0.0,1) +
  scale_y_continuous(breaks=seq(0,1,0.1), limits=c(0, 1.0), oob = rescale_none)+
  geom_hline(yintercept=1, linetype="dashed", 
             color = "red", size=1) +
  coord_flip(expand = TRUE) +
  theme_bw(base_size = 20)
ggplot_95



## Section: Conf Inter 90 % (two side)
###############################################################################
# sortierung von modeltyp sicherstellen ing Grafik
df.meandata$Modeltyp <- factor(df.meandata$Modeltyp,
                               levels = c("DQ",
                                          "RRT_uq",
                                          "Crosswise",
                                          "Triangular"))

# Make the graph with the 95% confidence interval

ggplot_90<-ggplot(df.meandata, aes(x=Modeltyp, y=estimation_preval)) +
  geom_errorbar(width=.1, 
                aes(ymin=estimation_preval-ci90,
                    ymax=estimation_preval+ci90)) +
  geom_point(shape=21, size=4, fill="black") +
  geom_text(label=round(estimation_preval,3), nudge_x = 0.3, size=6) +
  ylab("Est. Prop.: Shared apartment (90% CI)")+
  xlab("")+
  #ylim(0.0,1) +
  scale_y_continuous(breaks=seq(0,1,0.1), limits=c(0, 1.0), oob = rescale_none)+
  geom_hline(yintercept=1, linetype="dashed", 
             color = "red", size=1) +
  coord_flip(expand = TRUE) +
  theme_bw(base_size = 20)
ggplot_90

###############################################################################

## Section: save combined plot
###############################################################################
library("ggpubr")

figure <- ggarrange(ggplot_95, ggplot_90,
                    labels = c("1", "2"),
                    ncol = 1, nrow = 2)
figure

ggexport(figure, filename = "individual_analysis_size2.pdf")

## Section: Post Hoc Power Analysis (two side)
###############################################################################
library(pwr)

# RRT
pwr_rrt_95<-pwr.t.test(d=(df.meandata[2,2]-1.00)/(df.meandata[2,3]*sqrt(n_rrt)), # SE to SD
           n=n_rrt,
           sig.level=0.05, # 95 %
           type="one.sample",
           alternative="two.sided")
pwr_rrt_95

pwr_rrt_90<-pwr.t.test(d=(df.meandata[2,2]-1.00)/(df.meandata[2,3]*sqrt(n_rrt)), # SE to SD
           n=n_rrt,
           sig.level=0.1, # 90 %
           type="one.sample",
           alternative="two.sided")
pwr_rrt_90

# Cross
pwr_cross_95<-pwr.t.test(d=(df.meandata[3,2]-1.00)/(df.meandata[3,3]*sqrt(n_cross)), # SE to SD
           n=n_cross,
           sig.level=0.05, # 95 %
           type="one.sample",
           alternative="two.sided")
pwr_cross_95

pwr_cross_90<-pwr.t.test(d=(df.meandata[3,2]-1.00)/(df.meandata[3,3]*sqrt(n_cross)), # SE to SD
           n=n_cross,
           sig.level=0.1, # 95 %
           type="one.sample",
           alternative="two.sided")
pwr_cross_90

# tria
pwr_tria_95<-pwr.t.test(d=(df.meandata[4,2]-1.00)/(df.meandata[4,3]*sqrt(n_tria)), # SE to SD
           n=n_tria,
           sig.level=0.05, # 95 %
           type="one.sample",
           alternative="two.sided")
pwr_tria_95

pwr_tria_90<-pwr.t.test(d=(df.meandata[4,2]-1.00)/(df.meandata[4,3]*sqrt(n_tria)), # SE to SD
           n=n_tria,
           sig.level=0.1, # 90 %
           type="one.sample",
           alternative="two.sided")
pwr_tria_90

## Section: One side T-Test
###############################################################################
#  Welch t test 
library(PASWR)
df.meandata[2,2]
# RRT
tsum.test(df.meandata[2,2],
          (df.meandata[2,3]*sqrt(61)),
          n.x=61,
          alternative = "less",
          mu=1.0,
          conf.level = 0.90)
# cross
tsum.test(df.meandata[3,2],
          (df.meandata[3,3]*sqrt(104)),
          n.x=104,
          alternative = "less",
          mu=1.0,
          conf.level = 0.90)
# tria
tsum.test(df.meandata[4,2],
          (df.meandata[4,3]*sqrt(87)),
          n.x=87,
          alternative = "less",
          mu=1.0,
          conf.level = 0.90)

## Section: Power Analysis for One side T-Test
###############################################################################
library(pwr)

# RRT
pwr_rrt_95_oneside<-pwr.t.test(d=(df.meandata[2,2]-1.00)/(df.meandata[2,3]*sqrt(n_rrt)), # SE to SD
                       n=n_rrt,
                       sig.level=0.05, # 95 %
                       type="one.sample",
                       alternative="less")
pwr_rrt_95_oneside

pwr_rrt_90_oneside<-pwr.t.test(d=(df.meandata[2,2]-1.00)/(df.meandata[2,3]*sqrt(n_rrt)), # SE to SD
                       n=n_rrt,
                       sig.level=0.1, # 90 %
                       type="one.sample",
                       alternative="less")
pwr_rrt_90_oneside

# Cross
pwr_cross_95_oneside<-pwr.t.test(d=(df.meandata[3,2]-1.00)/(df.meandata[3,3]*sqrt(n_cross)), # SE to SD
                         n=n_cross,
                         sig.level=0.05, # 95 %
                         type="one.sample",
                         alternative="less")
pwr_cross_95_oneside

pwr_cross_90_oneside<-pwr.t.test(d=(df.meandata[3,2]-1.00)/(df.meandata[3,3]*sqrt(n_cross)), # SE to SD
                         n=n_cross,
                         sig.level=0.1, # 90 %
                         type="one.sample",
                         alternative="less")
pwr_cross_90_oneside

# tria
pwr_tria_95_oneside<-pwr.t.test(d=(df.meandata[4,2]-1.00)/(df.meandata[4,3]*sqrt(n_tria)), # SE to SD
                        n=n_tria,
                        sig.level=0.05, # 95 %
                        type="one.sample",
                        alternative="less")
pwr_tria_95_oneside

pwr_tria_90_oneside<-pwr.t.test(d=(df.meandata[4,2]-1.00)/(df.meandata[4,3]*sqrt(n_tria)), # SE to SD
                        n=n_tria,
                        sig.level=0.1, # 90 %
                        type="one.sample",
                        alternative="less")
pwr_tria_90_oneside


## Section: Poweranalysis document
###############################################################################




################################################################################
# log modell RRlog mit Erklaerungvariablen ###########
################################################################################
  df.temp$not_DQ <- 
    ifelse(df.temp$quest_version==3,0,1)# zeigt an ob DQ oder
  df.temp$not_DQ
  
  
  table(df.temp$not_DQ)

# RRT, Cross, tria ####
# formula_rrt_plus<-response ~ not_DQ + compliance_q + concentration + honest_answ + trustin_ano
formula_rrt_plus<-response ~ not_DQ + compliance_q
formula_rrt_plus<-response ~ not_DQ + concentration
formula_rrt_plus<-response ~ not_DQ + trustin_ano
formula_rrt_plus<-response ~ not_DQ + honest_answ

# Faelle filtern
df.w_auswertung <- 
  df.temp %>% filter(quest_version==2 | quest_version==3) # Filter RRT+DQ
fit_rrtuq_wg_full <- RRlog(formula_rrt_plus,
                   data=df.w_auswertung,
                   model="UQTknown",
                   p=c(p_hausnr, .166), 
                   group=not_DQ,
                   LR.test=TRUE,
                   fit.n = 50)
summary(fit_rrtuq_wg_full)


# log modell Crosswise
# Faelle filtern
df.w_auswertung <- 
  df.temp %>% filter(quest_version==4 | quest_version==3) # Filter cross+DQ
fit_cross_wg_full <- RRlog(formula_rrt_plus,
                   data=df.w_auswertung,
                   model="Crosswise",
                   p=.166, 
                   group=not_DQ,
                   LR.test=TRUE,
                   fit.n = 50)
summary(fit_cross_wg_full)

# log modell (geht nicht) trian
# Faelle filtern
df.w_auswertung <- 
  df.temp %>% filter(quest_version==1 | quest_version==3) # Filter tria+DQ
fit_tria_wg_full <- RRlog(formula_rrt_plus,
                  data=df.w_auswertung,
                  model="Triangular",
                  p=.166, 
                  group=not_DQ,
                  LR.test=TRUE,
                  fit.n = 50)
summary(fit_tria_wg_full)

################################################################################
source("test_der_berechnungsformeln_rrtplus.R", echo = TRUE, print.eval = TRUE)
