/* manuscript  "Have you ever seen the rain? It looks like it’s going to rain! The causal impact of the weather situation and the season on survey participation in a multi-wave panel study" to Survey Research Methods
weather situations and participations in each of the waves since Wave 4*/

version 16
set more off
set scheme s1mono
clear all
macro drop _all
set linesize 132
capture log close
local stout .  // C:\Users\Rolf Becker\Documents\ -> .

capture which outreg
if _rc ssc install outreg

* Event history analysis
use "w45678-spweather.dta", clear
sort id newid wdate ts tf

stset tf  , failure(cen) id(newid)

streg  weather oppstructure , distribution(exp) 

streg  weather oppstructure , distribution(exp) nohr 
outreg using "`stout'/tabelle1", replace se starlevel(5 1 .1) varlabels ///
title(Tabelle 1: Weather)

streg  zrka150d0 zsu2000d0 ztre200d0 zure200d0 zpp0qffd0 oppstructure ib4.welle , distribution(exp) nohr 
outreg using "`stout'/tabelle1", replace se starlevel(5 1 .1) varlabels ///
title(Tabelle 1: Weather)
streg  zrka150d0 zsu2000d0 ztre200d0 zure200d0 zpp0qffd0 oppstructure ib4.welle ib7.hh_egp_mv ib4.sektyp9_mv zdemark9 ib1.gender , distribution(exp) nohr 
outreg using "`stout'/tabelle1", merge replace se starlevel(5 1 .1) varlabels ///
title(Tabelle 1: Weather)

streg  zrka150d0 zsu2000d0 ztre200d0 zure200d0 zpp0qffd0 ib2.season oppstructure  , distribution(exp) nohr 
outreg using "`stout'/tabelle1", replace se starlevel(5 1 .1) varlabels ///
title(Tabelle 1: Weather)
streg  zrka150d0 zsu2000d0 ztre200d0 zure200d0 zpp0qffd0 ib2.season oppstructure ib7.hh_egp_mv ib4.sektyp9_mv zdemark9 ib1.gender , distribution(exp) nohr 
outreg using "`stout'/tabelle1", merge replace se starlevel(5 1 .1) varlabels ///
title(Tabelle 1: Weather)


streg  weather oppstructure ib4.welle , distribution(exp) nohr 
outreg using "`stout'/tabelle1", merge replace se starlevel(5 1 .1) varlabels ///
title(Tabelle 1: Weather)

streg weather oppstructure ib4.welle ts ib7.hh_egp_mv ib4.sektyp9_mv zdemark9 ib1.gender , distribution(exp) nohr 
outreg using "`stout'/tabelle1", merge replace se starlevel(5 1 .1) varlabels ///
title(Tabelle 1: Weather)

* Jahreszeiten: 
streg weather ib2.season oppstructure ts ib7.hh_egp_mv ib4.sektyp9_mv zdemark9 ib1.gender , distribution(exp) nohr 
outreg using "`stout'/tabelle1", replace se starlevel(5 1 .1) varlabels ///
title(Tabelle 1: Weather)

* Ohne Corona:
streg weather ib2.season oppstructure ts ib7.hh_egp_mv ib4.sektyp9_mv zdemark9 ib1.gender if welle != 8, distribution(exp) nohr 
outreg using "`stout'/tabelle1", replace se starlevel(5 1 .1) varlabels ///
title(Tabelle 1: Weather)

capture drop rainspring rainaut
gen rainspring = zrka150d0 * spring
gen rainaut = zrka150d0 * autumn
label variable rainspring "Rainfall in spring"
label variable rainaut "Rainfall in Autumn"

streg  zrka150d0 spring autumn  , distribution(exp) nohr 
estimates store weathsea1

streg  zrka150d0 spring autumn rainspring rainaut , distribution(exp) nohr 
estimates store weathsea2

coefplot  ///
  weathsea1, bylabel("Main effects") drop(_cons) xline(0)  ///
  || weathsea2, bylabel(Plus interaction effects) drop(_cons) xline(0)

graph export 7782_fig7a.pdf, replace

* Interaction effects: rain & latency
capture drop raints
gen raints = zrka150d0 * ts
label variable raints "Rainfall & Duration"

streg  zrka150d0 ts , distribution(exp) nohr 
estimates store raints1

streg  zrka150d0 ts raints, distribution(exp) nohr 
estimates store raints2

coefplot raints1, bylabel(Main effects) drop(_cons) xline(0)  ///
  || raints2, bylabel(Plus interaction effects) drop(_cons) xline(0)

graph export 7782_fig7b.pdf, replace


* nur einzelne Wellen
stset tf , failure(cen) id(newid)
streg weather oppstructure  if welle==4 , distribution(exp) nohr 
outreg using "`stout'/tabelle1", replace se starlevel(5 1 .1) varlabels ///
title(Tabelle 1: Weather)
streg weather oppstructure  if welle==5 , distribution(exp) nohr 
outreg using "`stout'/tabelle1", merge replace se starlevel(5 1 .1) varlabels ///
title(Tabelle 1: Weather)
streg weather oppstructure  if welle==6 , distribution(exp) nohr 
outreg using "`stout'/tabelle1", merge replace se starlevel(5 1 .1) varlabels ///
title(Tabelle 1: Weather)
streg weather oppstructure  if welle==7 , distribution(exp) nohr 
outreg using "`stout'/tabelle1", merge replace se starlevel(5 1 .1) varlabels ///
title(Tabelle 1: Weather)
streg weather  oppstructure if welle==8 , distribution(exp) nohr 
outreg using "`stout'/tabelle1", merge replace se starlevel(5 1 .1) varlabels ///
title(Tabelle 1: Weather)


streg weather oppstructure ib7.hh_egp_mv ib4.sektyp9_mv zdemark9 ib1.gender if welle==4 , distribution(exp) nohr 
outreg using "`stout'/tabelle1", replace se starlevel(5 1 .1) varlabels ///
title(Tabelle 1: Weather)
streg weather oppstructure ib7.hh_egp_mv ib4.sektyp9_mv zdemark9 ib1.gender if welle==5 , distribution(exp) nohr 
outreg using "`stout'/tabelle1", merge replace se starlevel(5 1 .1) varlabels ///
title(Tabelle 1: Weather)
streg weather oppstructure ib7.hh_egp_mv ib4.sektyp9_mv zdemark9 ib1.gender if welle==6 , distribution(exp) nohr 
outreg using "`stout'/tabelle1", merge replace se starlevel(5 1 .1) varlabels ///
title(Tabelle 1: Weather)
streg weather oppstructure ib7.hh_egp_mv ib4.sektyp9_mv zdemark9 ib1.gender if welle==7 , distribution(exp) nohr 
outreg using "`stout'/tabelle1", merge replace se starlevel(5 1 .1) varlabels ///
title(Tabelle 1: Weather)
streg weather  oppstructure ib7.hh_egp_mv ib4.sektyp9_mv zdemark9 ib1.gender if welle==8 , distribution(exp) nohr 
outreg using "`stout'/tabelle1", merge replace se starlevel(5 1 .1) varlabels ///
title(Tabelle 1: Weather)

* KM
sts graph, by(welle) 

sts list if welle==4
sts list if welle==5
sts list if welle==6
sts list if welle==7
sts list if welle==8

* Median
stdescribe if welle==4
stdescribe if welle==5
stdescribe if welle==6
stdescribe if welle==7
stdescribe if welle==8

sts graph, cumhaz by(welle) scheme(s1color)  ///
  legend(order(1 "Wave 4" 2 "Wave 5" 3 "Wave 6" 4 "Wave 7" 5 "Wave 8") ///
  rows(1) span symxsize(*.8) )  ///
  xtitle(Days) xlab(1(1)28)  ///
  ytitle(Hazard rate) title("") ylabel(, angle(0) format(%2.1f))  ///

graph export 7782_fig3.eps, replace
!epstopdf 7782_fig3.eps

* Test
streg ib2.season , distribution(gom) nohr
stcurve, survival at1(season=1) at2(season=2) at3(season=3)  ///
  legend(order(1 "Spring" 2 "Summer" 3 "Autumn") ///
  rows(1) span symxsize(*.8) )  ///
  xtitle(Days) xlab(1(1)28)  ///
  ytitle(Survival) title("") ylabel(.4(.1)1, angle(0) format(%2.1f) grid)  ///
  xline(11, lcolor(red) lpattern(dot))  ///
  yline(0.5, lcolor(red) lpattern(dot))  ///
  lcolor(black..) lpattern(solid longdash dash)  


graph export 7782_fig4.eps, replace
!epstopdf 7782_fig4.eps


stdescribe if season==1
stdescribe if season==2
stdescribe if season==3

sts list, by(season) enter
sts list, by(season) compare

sts test season 
sts test season , wilcoxon
sts test season , tware
sts test season , peto

/* Graphics on interaction terms: 
gen wints1 = weather
replace wints1 = 0 if season != 1
gen wints3 = weather
replace wints3 = 0 if season != 3
recode season (1=1)(2 3=0), gen(spring)
recode season (3=1)(1 2=0), gen(autumn)
gen oppweather = oppstructure * weather
 */

use "w45678-spweather.dta", clear
sort id newid wdate ts tf

stset tf  , failure(cen) id(newid)

streg  weather oppstructure  , distribution(exp) nohr 
outreg using "`stout'/tabelle1", replace se starlevel(5 1 .1) varlabels ///
title(Tabelle 1: Weather)
estimates store weathopp

streg  weather oppstructure oppweather , distribution(exp) nohr 
outreg using "`stout'/tabelle1", replace se starlevel(5 1 .1) varlabels ///
title(Tabelle 1: Weather)
estimates store weathopint

coefplot weathopp, bylabel(Main effects) drop(_cons) xline(0)  ///
  || weathopint, bylabel(Plus interaction effects) drop(_cons) xline(0)

graph export 7782_fig5a.pdf, replace

streg  weather spring autumn , distribution(exp) nohr 
outreg using "`stout'/tabelle1", replace se starlevel(5 1 .1) varlabels ///
title(Tabelle 1: Weather)
estimates store weathseason

streg  weather spring autumn wints1 wints3  , distribution(exp) nohr 
outreg using "`stout'/tabelle1", replace se starlevel(5 1 .1) varlabels ///
title(Tabelle 1: Weather)
estimates store weathints 

coefplot weathseason, bylabel(Main effects) drop(_cons) xline(0)  ///
  || weathints, bylabel(Plus interaction effects) drop(_cons) xline(0)

graph export 7782_fig5b.pdf, replace

* Figure 1

import excel day w2014 w2016 w2017 w2018 w2020  ///
  using "Wetter_2014_2020.xlsx", clear cellrange(A2:F29)

reshape long w, i(day) j(year)

graph twoway  ///
  || line w day, sort lcolor(black) ///
  || , by(year, cols(1) note(""))  ///
  xlab(1(1)28, labsize(small) )  ///
  xtick(5(5)25, grid) xtitle(Field period on a daily base) ///
  ylabel(-2(1)3, grid angle(0)) ytitle(Factor scores) ///
  ysize(8) 
graph export 7782_fig1.pdf, replace

* Figure 6

import excel day w2014 w2016 w2017 w2018 w2020  ///
  using "Wetter_2014_2020.xlsx", clear cellrange(A3) sheet("Rain fall")

gen w = .
gen year = .

foreach var of varlist w2014-w2020 {
	replace w = `var' if w==.
	replace year = `=substr("`var'",2,5)' if !mi(`var')
}
  
graph twoway  ///
  || bar w day, barwidth(.75) ///
  || , by(year, cols(1) note("") legend(off))  ///
  xlab(1(1)28, labsize(small) )  ///
  xtick(5(5)25, grid) xtitle(Field period on a daily base) ///
  ylabel(0(5)45, grid angle(0) labsize(small)) ytitle(Rain fall (in mm)) ///
  ysize(8) 

graph export 7782_fig6.pdf, replace 




* End of file
