#--- 7751_functions.R --- [R] code for reproducing results of Investigating
# selection bias of online surveys on coronavirus-related behavioral outcomes
# 
# Title: 
# Filename: 7751_functions.R
# Description: 
# Author: 
# Maintainer: 
# DOI: 
# Created: Fr Mai 29 09:46:42 2020 (+0200)
# Last-Updated: Fr Mai 29 11:27:17 2020 (+0200)
#           By: weissbd
#     Update #: 4
# Version: 
# Dependencies: [Software (Version), Software (Version)...)
# Depends on: [File1, file2, ...] 
# Data source: [name of dataset] (DOI) 
# URL: 
# Keywords: 
# Licence: Attribution 4.0 International (CC BY 4.0) 
# Licence-URL: https://creativecommons.org/licenses/by/4.0/ 
# Compatibility: 
# 
################################################################################
# 
## Commentary: 
# 
# This is [R|Stata|...] code can give insights into statistical analyses 
# conducted in the following paper :
# 
# Investigating selection bias of online surveys on coronavirus-related
# behavioral outcomes.
# 
# Other code files may need to be executed first or this code file will be 
# called by another code file that hopefully is listed under "Depends on:".
# 
# Due to [German|...] data protection laws we may be unable to provide the 
# data. In that case you may be unable to reproduce our statistical analyses
# yourself. However, you might be able to obtain the data from [http://].
# 
################################################################################
# 
# 
# 
################################################################################
# 
## Change Log:
# 
# 
################################################################################
# 
## Code:


##' Based on y, l, z variable names, this function returns a regression formula,
##' which then can be fed into a purrr::map() function to be applied to all
##' combinations of y, l, z variables.
##'
##' @title Create a custom regression call
##' @param y A character string
##' @param l A character string
##' @param z A character string
##' @param mfamily Character string describing the glm family to be fit
##' @return Formula object to be fed in a glm() call
##' @author Bernd Weiss
create_ylz_formula <- function(y, l, z, mfamily) {
    lz <- paste0(c(l, z)) %>% str_flatten(collapse = " + ")
    fml <- glue("{y} ~ {lz}") %>% as.formula
    glm(fml, family = mfamily, data = dfx)
}


##' @title Get variable labels for a vector x of variable names x of data
##'     "data"
##' @param data A data.frame that contains x
##' @param x A vector 
##' @return A string
##' @author Bernd Weiss
get_varlabels <- function(data, x) {
    return(labelled::var_label(data[x], unlist = TRUE))
}


##' Dichotomize a numeric vector
##'
##' Dichotomize a numeric vector and assigns specifics attributes 
##' @param x A numeric vector
##' @return A logical vector 
##' @author Bernd Weiss
dichotomiz_variable <- function(x){
    x_mean <- mean(x, na.rm = TRUE)
    x_dichotom <- x > x_mean
    attr(x_dichotom, "label") <- attributes(x)$label
    attr(x_dichotom, "dichotomized") <- TRUE
    return(x_dichotom)
}


##' Helper function for extracting CIs from prop.test(). 
##' 
##' @param x
##' @param print
##' @return a list which -- among other stuff -- also includes the difference in
##'     proportions between online participation and risk minimizing measures,
##'     respectively.
##' @author Bernd Weiß
calc_ci_prop <- function(x, print = FALSE){

    ##   0 1 
    ## 0 a b
    ## 1 c d

    ## Calculate column-wise proportions.
    prop <- prop.table(x, 2)[2,]
    ncol <- margin.table(x, 2)

    ptest <- prop.test(x = x[2, ], n = ncol, conf.level = 0.99)

    if(print){
        print(list(diff = diff(prop),
                   ci = ptest$conf.int,
                   pt = ptest,
                   table = x,
                   ptable = prop.table(x, 2)))
        }
              
    res <- c(delta = diff(prop) * 100,
             ll = -1 * ptest$conf.int[2] * 100,
             ul = -1 * ptest$conf.int[1] * 100)
    
    return(res)
}



################################################################################
#--- 7751_functions.R ends here
