*	Replication File
*	"The relationship between response propensities and data quality in grid questions"
*
*	Code for merging and appending the data adapted from:
*	GESIS Panel Team (2018). GESIS panel - standard edition. GESIS Data Archive, Cologne. 
*	ZA5665 Data File Version 24.0.0 (2018), doi:10.4232/1.13001.
*
*
***************************************************************************
***																		***
***		Preliminaries (changes required!)								***
***																		***
***************************************************************************

clear
clear mata
clear matrix
set more off
set matsize 10000
set maxvar 32000

* Define a macro with entering the file path where the GESIS Panel data are located
* global filepath `"[enter the file path where the GESIS Panel data are located]"'

global filepath `"FILEPATH"'

***************************************************************************
***																		***
***		Merging and appending the data (no changes required)			***
***																		***
***************************************************************************

global path = subinstr("${filepath}",char(92),char(47),.) //slash replace
global dataDta: dir `"${path}"' files "*.dta" //get all Stata data files from filpath
global dataDta = lower(`"${dataDta}"') //set string to lower case

//get recruitment and wave datasets
foreach x of global dataDta {
	if regexm(`"`x'"', "^za566[45]_[a-z][1-9]_[a-z][1-9][0-9]-[a-z][1-9][0-9]_v[1-9][0-9]-[0-9]-[0-9]") {
		local recruitment = strtrim("`recruitment'"+" `x'")
	}
	if regexm(`"`x'"', "^za566[45]_[a-z][1-9]_[a-z][a-z]-[a-z][a-z]_v[1-9][0-9]-[0-9]-[0-9]") {
		local waves = strtrim("`waves'"+" `x'")
	}
}

//get cohorts
local r = wordcount(`"`recruitment'"')
tokenize `"`recruitment'"'
forval i=1(1)`r' {
	if regexm("``i''", "_[a-z][1-9]_") {
		local c = subinstr(regexs(0), "_","",.)
	}
	local cohort_`c' = `"${path}/``i''"'
	local cohorts = strtrim("`cohorts'"+" `c'")
}

//get cohort specific datasets
foreach c of local cohorts {
	tempfile dta_`c'
	use `"`cohort_`c''"', clear
	tokenize `"`waves'"'
	local j = wordcount(`"`waves'"') 
	forval i=1(1)`j' {
		if regexm("``i''", "_[a-z][1-9]_") { 
			if regexs(0)==`"_`c'_"' {
				merge 1:1 z000001a using `"${path}/``i''"', nogen
			}
		}
	}
	save `dta_`c''
}

//mvencode cohort specific datasets . --> -22 "Not in panel"
foreach c of local cohorts {
	use `dta_`c'', clear
	qui ds, has(type numeric)
	qui mvencode `r(varlist)', mv(.=-22) override
	qui ds, has(type string)
	foreach v in `r(varlist)' {
		qui replace `v' ="-22" if `v'==""
	}
	save `dta_`c'', replace
}

//append cohorts
local l = wordcount(`"`cohorts'"')
tokenize `"`cohorts'"'
forval i=1(1)`l' {
	di "`dta_``i'''"
	if `i' == 1 use `dta_``i''', clear
	else append using `dta_``i'''
}

********************* Data Prep for RP estimation********************************

**** Recoding fromALLBUS initial sample to start cohort
	// Civic duty 
	replace  a12c006a = d12c012a if a12c006a==. 
	replace  a12c007a = d12c013a if a12c007a==. 
	replace  a11c022a = d12c050a if a11c022a==. 
	replace  a11d080a = d11d080a if a11d080a==. 
	replace  a12c023a = d12c027a if a12c023a==. 
	replace  a11c034a = d12c068a if a11c034a==. 
	replace  a11c035a = d12c069a if a11c035a==. 
	replace  a11c036a = d12c070a if a11c036a==. 
	replace  a11c038a = d12c071a if a11c038a==. 
	replace  a11c050a = d12c081a if a11c050a==. 
	replace  a11c051a = d12c082a if a11c051a==. 
	replace  a11c052a = d12c083a if a11c052a==. 
	replace  a11c053a = d12c084a if a11c053a==. 
	replace  a11d056b = d11d056b if a11d056b==. 
	replace  a11d075d = d11d075d if a11d075d==. 
	replace  a11d081a = d11d081a if a11d081a==. 
	replace  a11d082b = d12d091b if a11d082b==. 
	replace  a11d086b = d11d086b if a11d086b==. 
	replace  a11d095b = d11d094b if a11d095b==. 
	replace  a12q012a = d12q012a if a12q012a==. 
	replace  a12c001a = d12c001a if a12c001a==. 
	replace  a12c038a = d12c054a if a12c038a==. 
	replace  a12c002a = d12c002a if a12c002a==. 
	replace  a12c003a = d12c003a if a12c003a==. 
	replace  a12c004a = d12c004a if a12c004a==. 
	replace  a12c005a = d12c005a if a12c005a==. 
	replace  a12c009a = d12c010a if a12c009a==. 
	replace  a12c015a = d12c018a if a12c015a==. 
	replace  a12c017a = d12c020a if a12c017a==. 
	replace  a12c070a = d12c048a if a12c070a==. 
	replace  a12c010a = d12c011a if a12c010a==. 
	replace  a12c011a = d12c014a if a12c011a==. 
	replace  a12c012a = d12c015a if a12c012a==. 
	replace  a12c013a = d12c016a if a12c013a==. 
	replace  a12c014a = d12c017a if a12c014a==. 
	replace  a12c015a = d12c018a if a12c015a==. 
	replace  a12c016a = d12c019a if a12c016a==. 
	replace  a12c017a = d12c020a if a12c017a==. 
	replace  a12c018a = d12c021a if a12c018a==. 
	replace  a12c019a = d12c022a if a12c019a==. 
	replace  a12c020a = d12c023a if a12c020a==. 
	replace  a12c049a = d12c065a if a12c049a==. 
	replace  a12c025a = d12c029a if a12c025a==. 
	replace  a12c026a = d12c030a if a12c026a==. 
	replace  a12c027a = d12c031a if a12c027a==. 
	replace  a12c028a = d12c032a if a12c028a==. 
	replace  a12c029a = d12c033a if a12c029a==. 
	replace  a12c035a = d12c051a if a12c035a==. 
	replace  a12c036a = d12c052a if a12c036a==. 
	replace  a12c037a = d12c053a if a12c037a==. 
	replace  a12c038a = d12c054a if a12c038a==. 
	replace  a12c039a = d12c055a if a12c039a==. 
	replace  a12c040a = d12c056a if a12c040a==. 
	replace  a12c041a = d12c057a if a12c041a==. 
	replace  a12c042a = d12c058a if a12c042a==. 
	replace  a12c043a = d12c059a if a12c043a==. 
	replace  a12c044a = d12c060a if a12c044a==. 
	replace  a12c045a = d12c061a if a12c045a==. 
	replace  a12c046a = d12c062a if a12c046a==. 
	replace  a12c047a = d12c063a if a12c047a==. 
	replace  a12c048a = d12c064a if a12c048a==. 
	replace  a12c049a = d12c065a if a12c049a==. 
	replace  a12c051a = d12c067a if a12c051a==. 
	replace  a12c063a = d12c041a if a12c063a==. 
	replace  a12c064a = d12c042a if a12c064a==. 
	replace  a12c065a = d12c043a if a12c065a==. 
	replace  a12c066a = d12c044a if a12c066a==. 
	replace  a12c067a = d12c045a if a12c067a==. 
	replace  a12c068a = d12c046a if a12c068a==. 
	replace  a12c069a = d12c047a if a12c069a==. 
	replace  a12c070a = d12c048a if a12c070a==. 
	replace  a12c071a = d12c049a if a12c071a==. 
	replace  a12a001a = d12a001a if a12a001a==. 
	replace  a12a002a = d12a002a if a12a002a==. 
	replace  a12a010a = d12a010a if a12a010a==. 
	replace  a12a003b = d12a003a if a12a003b==. 
	replace  a12a006a = d12a006a if a12a006a==. 
	replace  a12q001a = d12q001a if a12q001a==. 
	replace  a12q002a = d12q002a if a12q002a==. 
	replace  a12q003a = d12q003a if a12q003a==. 
	replace  a12q004a = d12q004a if a12q004a==. 
	replace  a12q005a = d12q005a if a12q005a==. 
	replace  a12q006a = d12q006a if a12q006a==. 
	replace  a12q010a = d12q010a if a12q010a==. 
	replace  a12q013a = d12q013a if a12q013a==. 
	replace  a12q014a = d12q014a if a12q014a==. 
	replace  a12q009a = d12q009a if a12q009a==. 
	replace  a11d079b = d11d079b if a11d079b==. 
	replace  a11d054a = dfzh037a if a11d054a==. 
	replace  bfzh070c = d11d056b if bfzh070c==. 
	replace  a11d089c = dezh060a if a11d089c==. 

	// Income household
	replace a11d097c=13 if a11d097c==14
	label define a11d097c 14 "", modify
	label define a11d097c 13 "5000 � und mehr", modify

	replace a11d097c=11 if a11d097c==12
	label define a11d097c 12 "", modify
	label define a11d097c 11 "3200 bis unter 5000", modify

	gen eink1 = d11d097b
	replace eink1=1 if d11d097b==1
	replace eink1=1 if d11d097b==2
	replace eink1=1 if d11d097b==3
	replace eink1=2 if d11d097b==4
	replace eink1=4 if d11d097b==5
	replace eink1=5 if d11d097b==6
	replace eink1=7 if d11d097b==7
	replace eink1=8 if d11d097b==8
	replace eink1=10 if d11d097b==9
	replace eink1=11 if d11d097b==10
	replace eink1=13 if d11d097b==11
	 
	replace  a11d097c = eink1 if a11d097c==.  

	// Income
	replace a11d096b=13 if a11d096b==15
	label define a11d096b 15 "", modify
	label define a11d096b 13 "5000 � und mehr", modify

	replace a11d096b=11 if a11d096b==12
	label define a11d096b 12 "", modify
	label define a11d096b 11 "3200 bis unter 5000", modify

	gen eink2 = d11d096b
	replace eink2=1 if d11d096b==1
	replace eink2=1 if d11d096b==2
	replace eink2=1 if d11d096b==3
	replace eink2=2 if d11d096b==4
	replace eink2=4 if d11d096b==5
	replace eink2=5 if d11d096b==6
	replace eink2=7 if d11d096b==7
	replace eink2=8 if d11d096b==8
	replace eink2=10 if d11d096b==9
	replace eink2=11 if d11d096b==10
	replace eink2=13 if d11d096b==11
	 
	replace  a11d096b = eink2 if a11d096b==.  

drop if edza006a == -22 // drops panel all respondents which have dropped out

** Create dummy if subject particpated in wave ed 
tab z000006a
gen participate=0
replace participate =1 if edza006a== 11
tab participate, m 
drop edza006a 
drop a12a004a a12a005a a12q015a a12a011a a11d056b  


** Create additional vars (recruitment cohort, mode, response behavior) 
** participation mode 
replace a12a001a = d12a001a if a12a001a==. 
tab a12a001a,m 
** Response behavior 
** Counting response in the previous waves  
egen resp_behaviour = anycount(a12a006a aaza006a abza006a acza006a baza006a ///
bbza006a bcza006a bdza006a beza006a bfza006a caza006a cbza006a ccza006a cdza006a ceza006a ///
cfza006a daza006a dbza006a dcza006a ddza006a deza006a dfza006a eaza006a ebza006a ///
ecza006a ), values(11)
tab resp_behaviour ,m 
replace resp_behaviour = resp_behaviour/25 if z000006a ==1
replace resp_behaviour = resp_behaviour/8 if z000006a ==2
tab resp_behaviour ,m 

// Keep everything which is useful for rp model  (and only keep vars which have also values for ALLBUS) 
keep  participate z000001a resp_behaviour  z000006a  a12c006a a12c007a a11c022a a11d080a a12c023a a11c034a ///
a11c035a a11c036a a11c038a a11c050a a11c051a a11c052a a11c053a a11d075d a11d081a a11d082b a11d086b ///
a11d095b a12q012a a12c001a a12c038a a12c002a a12c003a a12c004a a12c005a a12c009a a12c015a a12c017a a12c070a a12c010a ///
 a12c015a  a12c017a  a12c020a a12c049a a12c025a a12c026a a11d054a ///
 a12c027a a12c028a a12c029a a12c035a a12c036a a12c037a a12c038a a12c039a a12c040a a12c041a a12c042a a12c043a a12c044a ///
 a12c045a a12c046a a12c047a a12c048a a12c049a a12c051a a12c063a a12c064a a12c065a a12c066a a12c067a a12c068a a12c069a ///
 a12c070a a12c071a a12a001a a12a002a a12a010a a12a003b a12a006a a12q001a a12q002a a12q003a a12q004a a12q005a a12q006a ///
 a12q009a a12q010a a12q013a a12q014a a11d079b a11d097c a11d096b a11d089c bfzh070c 
 
mvencode _all, mv(999)
// save data file 
saveold "FILEPATH\data_readyforRP.dta", replace version(12)
 


