*	Replication File
*	"The relationship between response propensities and data quality in grid questions"
*
*	Head
clear
clear mata
clear matrix
set more off
set matsize 10000
set maxvar 15000
set scheme s1mono
graph set window fontface "Times New Roman"
graph set eps fontface "Times New Roman"
cd "PATH"
*
*	Content
*	(1) Load data
*	(2) Data preparation
*	(3) Analyses
*	(4) Output
*
*	(1) Load data
* 	Get survey data
use "Data/ZA5665_v24.dta"
*	Merge response propensities
gen long id = z000001a
merge 1:1 id using "Data/pscores.dta"
gen ps = PREDALL
drop PREDALL _merge
*	Get case counts
tab edza006a z000006a
tab edzq014a if edza006a == 11 & edzq014a >= -44
tab edzq014a z000006a if edza006a == 11 & edzq014a >= -44, col
tab edzq014a if edza006a == 11 & edzq014a > 0, nol
*	Keep complete cases only
keep if edza006a == 11
*
*	(2) Data preparation
*	Calculate data quality indicators
*	
*	q1:
local g_items = 10
local g_scale = 5
egen q_miss_1 = anycount(edze001a - edze010a), values(-111 -99 -66)
egen q_missing_1 = anycount(edze001a - edze010a), values(-99)
*	q_inr_1: Rate of item nonresponse (answer refusals) in the grid - range [0,1]
gen q_inr_1 = q_missing_1 / `g_items'
*	q_ext_1: Rate of extreme responses in the grid - range [0,1]
egen q_extreme_1 = anycount(edze001a - edze010a), values(1 5)
gen q_ext_1 = q_extreme_1 / `g_items'
*	q_lef_1: Rate of left aligned respones in the grid - range [0,1]
egen q_left_1 = anycount(edze001a - edze010a), values(1)
gen q_lef_1 = q_left_1 / `g_items'
* 	q_str_1: Dummy variable indicating straightlining in the grid (0,1)
egen q_sd_1 = rowsd(edze001a - edze010a) if q_miss_1 == 0
egen q_mean_1 = rowmean(edze001a - edze010a) if q_miss_1 == 0
gen q_str_1 = q_sd_1 == 0
*	q_rho_1: Indicator for number of response options used with respect to the number of scale points - range [0,1]
gen q_rhosum_1 = 0
mvdecode edze001a - edze010a, mv(-111=.a\-99=.b\-66=.c)
forvalues i = 1 / `g_scale' {
	egen temp_`i'=anycount(edze001a - edze010a), v(`i') 
	replace temp_`i'=temp_`i'/`g_items'
	replace q_rhosum_1=q_rhosum_1+(temp_`i'^2)
	drop temp_`i'
}
mvencode edze001a - edze010a, mv(.a=-111\.b=-99\.c=-66)
gen q_rho_1 = 1 - q_rhosum_1
replace q_rho_1 = . if q_miss_1 != 0
* 	q_cov_1: Indicator for response differentiation in the grid - range [0, +infinite]
gen q_cov_1 = q_sd_1 / q_mean_1
* 	q_atc_1: Dummy variable for failing the attention check in the experiment (0,1)
gen q_atc_1 = .
*	
sum q_inr_1 q_ext_1 q_lef_1 q_str_1 q_rho_1 q_cov_1 q_atc_1
*	
*	q2:
local g_items = 6
local g_scale = 6
egen q_miss_2 = anycount(edze011a-edze016a), values(-111 -99 -66)
egen q_missing_2 = anycount(edze011a-edze016a), values(-99)
*	q_inr_2:
gen q_inr_2 = q_missing_2 / `g_items'
*	q_ext_2:
egen q_extreme_2 = anycount(edze011a-edze016a), values(1 6)
gen q_ext_2 = q_extreme_2 / `g_items'
*	q_lef_2:
egen q_left_2 = anycount(edze011a-edze016a), values(1)
gen q_lef_2 = q_left_2 / `g_items'
* 	q_str_2:
egen q_sd_2 = rowsd(edze011a-edze016a) if q_miss_2 == 0
egen q_mean_2 = rowmean(edze011a-edze016a) if q_miss_2 == 0
gen q_str_2 = q_sd_2 == 0
*	q_rho_2
gen q_rhosum_2 = 0
mvdecode edze011a-edze016a, mv(-111=.a\-99=.b\-66=.c)
forvalues i = 1 / `g_scale' {
	egen temp_`i'=anycount(edze011a-edze016a), v(`i') 
	replace temp_`i'=temp_`i'/`g_items'
	replace q_rhosum_2=q_rhosum_2+(temp_`i'^2)
	drop temp_`i'
}
mvencode edze011a-edze016a, mv(.a=-111\.b=-99\.c=-66)
gen q_rho_2 = 1 - q_rhosum_2
replace q_rho_2 = . if q_miss_2 != 0
* 	q_cov_2
gen q_cov_2 = q_sd_2 / q_mean_2
* 	q_atc_2
gen q_atc_2 = .
*	
sum q_inr_2 q_ext_2 q_lef_2 q_str_2 q_rho_2 q_cov_2 q_atc_2
*
*	q3:
local g_items = 6
local g_scale = 6
egen q_miss_3 = anycount(edze017a- edze022a), values(-111 -99 -66)
egen q_missing_3 = anycount(edze017a- edze022a), values(-99)
*	q_inr_3:
gen q_inr_3 = q_missing_3 / `g_items'
*	q_ext_3:
egen q_extreme_3 = anycount(edze017a- edze022a), values(1 6)
gen q_ext_3 = q_extreme_3 / `g_items'
*	q_lef_3:
egen q_left_3 = anycount(edze017a- edze022a), values(1)
gen q_lef_3 = q_left_3 / `g_items'
* 	q_str_3:
egen q_sd_3 = rowsd(edze017a- edze022a) if q_miss_3 == 0
egen q_mean_3 = rowmean(edze017a- edze022a) if q_miss_3 == 0
gen q_str_3 = q_sd_3 == 0
*	q_rho_3
gen q_rhosum_3 = 0
mvdecode edze017a- edze022a, mv(-111=.a\-99=.b\-66=.c)
forvalues i = 1 / `g_scale' {
	egen temp_`i'=anycount(edze017a- edze022a), v(`i') 
	replace temp_`i'=temp_`i'/`g_items'
	replace q_rhosum_3=q_rhosum_3+(temp_`i'^2)
	drop temp_`i'
}
mvencode edze017a- edze022a, mv(.a=-111\.b=-99\.c=-66)
gen q_rho_3 = 1 - q_rhosum_3
replace q_rho_3 = . if q_miss_3 != 0
* 	q_cov_3
gen q_cov_3 = q_sd_3 / q_mean_3
* 	q_atc_3
gen q_atc_3 = .
*	
sum q_inr_3 q_ext_3 q_lef_3 q_str_3 q_rho_3 q_cov_3 q_atc_3
*
*	q4:
local g_items = 5
local g_scale = 6
egen q_miss_4 = anycount(edze023a- edze027a), values(-111 -99 -66)
egen q_missing_4 = anycount(edze023a- edze027a), values(-99)
*	q_inr_4:
gen q_inr_4 = q_missing_4 / `g_items'
*	q_ext_4:
egen q_extreme_4 = anycount(edze023a- edze027a), values(1 6)
gen q_ext_4 = q_extreme_4 / `g_items'
*	q_lef_4:
egen q_left_4 = anycount(edze023a- edze027a), values(1)
gen q_lef_4 = q_left_4 / `g_items'
* 	q_str_4:
egen q_sd_4 = rowsd(edze023a- edze027a) if q_miss_4 == 0
egen q_mean_4 = rowmean(edze023a- edze027a) if q_miss_4 == 0
gen q_str_4 = q_sd_4 == 0
*	q_rho_4
gen q_rhosum_4 = 0
mvdecode edze023a- edze027a, mv(-111=.a\-99=.b\-66=.c)
forvalues i = 1 / `g_scale' {
	egen temp_`i'=anycount(edze023a- edze027a), v(`i') 
	replace temp_`i'=temp_`i'/`g_items'
	replace q_rhosum_4=q_rhosum_4+(temp_`i'^2)
	drop temp_`i'
}
mvencode edze023a- edze027a, mv(.a=-111\.b=-99\.c=-66)
gen q_rho_4 = 1 - q_rhosum_4
replace q_rho_4 = . if q_miss_4 != 0
* 	q_cov_4
gen q_cov_4 = q_sd_4 / q_mean_4
* 	q_atc_4
gen q_atc_4 = .
*	
sum q_inr_4 q_ext_4 q_lef_4 q_str_4 q_rho_4 q_cov_4 q_atc_4
*
*	q5:
local g_items = 6
local g_scale = 5
egen q_miss_5 = anycount(edbt034a- edbt039a), values(-111 -99 -66)
egen q_missing_5 = anycount(edbt034a- edbt039a), values(-99)
*	q_inr_5:
gen q_inr_5 = q_missing_5 / `g_items'
*	q_ext_5:
egen q_extreme_5 = anycount(edbt034a- edbt039a), values(1 5)
gen q_ext_5 = q_extreme_5 / `g_items'
*	q_lef_5:
egen q_left_5 = anycount(edbt034a- edbt039a), values(1)
gen q_lef_5 = q_left_5 / `g_items'
* 	q_str_5:
egen q_sd_5 = rowsd(edbt034a- edbt039a) if q_miss_5 == 0
egen q_mean_5 = rowmean(edbt034a- edbt039a) if q_miss_5 == 0
gen q_str_5 = q_sd_5 == 0
*	q_rho_5
gen q_rhosum_5 = 0
mvdecode edbt034a- edbt039a, mv(-111=.a\-99=.b\-66=.c)
forvalues i = 1 / `g_scale' {
	egen temp_`i'=anycount(edbt034a- edbt039a), v(`i') 
	replace temp_`i'=temp_`i'/`g_items'
	replace q_rhosum_5=q_rhosum_5+(temp_`i'^2)
	drop temp_`i'
}
mvencode edbt034a- edbt039a, mv(.a=-111\.b=-99\.c=-66)
gen q_rho_5 = 1 - q_rhosum_5
replace q_rho_5 = . if q_miss_5 != 0
* 	q_cov_5
gen q_cov_5 = q_sd_5 / q_mean_5
* 	q_atc_5
gen q_atc_5 = .
*	
sum q_inr_5 q_ext_5 q_lef_5 q_str_5 q_rho_5 q_cov_5 q_atc_5
*
*	q6:
local g_items = 7
local g_scale = 5
egen q_miss_6 = anycount(edbt040a- edbt046a), values(-111 -99 -66)
egen q_missing_6 = anycount(edbt040a- edbt046a), values(-99)
*	q_inr_6:
gen q_inr_6 = q_missing_6 / `g_items'
*	q_ext_6:
egen q_extreme_6 = anycount(edbt040a- edbt046a), values(1 5)
gen q_ext_6 = q_extreme_6 / `g_items'
*	q_lef_6:
egen q_left_6 = anycount(edbt040a- edbt046a), values(1)
gen q_lef_6 = q_left_6 / `g_items'
* 	q_str_6:
egen q_sd_6 = rowsd(edbt040a- edbt046a) if q_miss_6 == 0
egen q_mean_6 = rowmean(edbt040a- edbt046a) if q_miss_6 == 0
gen q_str_6 = q_sd_6 == 0
*	q_rho_6
gen q_rhosum_6 = 0
mvdecode edbt040a- edbt046a, mv(-111=.a\-99=.b\-66=.c)
forvalues i = 1 / `g_scale' {
	egen temp_`i'=anycount(edbt040a- edbt046a), v(`i') 
	replace temp_`i'=temp_`i'/`g_items'
	replace q_rhosum_6=q_rhosum_6+(temp_`i'^2)
	drop temp_`i'
}
mvencode edbt040a- edbt046a, mv(.a=-111\.b=-99\.c=-66)
gen q_rho_6 = 1 - q_rhosum_6
replace q_rho_6 = . if q_miss_6 != 0
* 	q_cov_6
gen q_cov_6 = q_sd_6 / q_mean_6
* 	q_atc_6
gen q_atc_6 = .
*	
sum q_inr_6 q_ext_6 q_lef_6 q_str_6 q_rho_6 q_cov_6 q_atc_6
*
*	q7:
local g_items = 6
local g_scale = 5
egen q_miss_7 = anycount(edbt047a- edbt052a), values(-111 -99 -66)
egen q_missing_7 = anycount(edbt047a- edbt052a), values(-99)
*	q_inr_7:
gen q_inr_7 = q_missing_7 / `g_items'
*	q_ext_7:
egen q_extreme_7 = anycount(edbt047a- edbt052a), values(1 5)
gen q_ext_7 = q_extreme_7 / `g_items'
*	q_lef_7:
egen q_left_7 = anycount(edbt047a- edbt052a), values(1)
gen q_lef_7 = q_left_7 / `g_items'
* 	q_str_7:
egen q_sd_7 = rowsd(edbt047a- edbt052a) if q_miss_7 == 0
egen q_mean_7 = rowmean(edbt047a- edbt052a) if q_miss_7 == 0
gen q_str_7 = q_sd_7 == 0
*	q_rho_7
gen q_rhosum_7 = 0
mvdecode edbt047a- edbt052a, mv(-111=.a\-99=.b\-66=.c)
forvalues i = 1 / `g_scale' {
	egen temp_`i'=anycount(edbt047a- edbt052a), v(`i') 
	replace temp_`i'=temp_`i'/`g_items'
	replace q_rhosum_7=q_rhosum_7+(temp_`i'^2)
	drop temp_`i'
}
mvencode edbt047a- edbt052a, mv(.a=-111\.b=-99\.c=-66)
gen q_rho_7 = 1 - q_rhosum_7
replace q_rho_7 = . if q_miss_7 != 0
* 	q_cov_7
gen q_cov_7 = q_sd_7 / q_mean_7
* 	q_atc_7
gen q_atc_7 = .
*	
sum q_inr_7 q_ext_7 q_lef_7 q_str_7 q_rho_7 q_cov_7 q_atc_7
*
*	q8
gen g_items = 10 if edbs153a == 1 
replace g_items = 9 if edbs153a == 2
local g_scale = 5
egen q_miss_8 = anycount(edbs131a-edbs140a), values(-111 -99 -66)
egen q_miss_tmp_8 = anycount(edbs141a-edbs149a), values(-111 -99 -66)
replace q_miss_8 = q_miss_tmp_8 if edbs153a == 2
egen q_missing_8 = anycount(edbs131a-edbs140a), values(-99)
egen q_missing_tmp_8 = anycount(edbs141a-edbs149a), values(-99)
replace q_missing_8 = q_missing_tmp_8 if edbs153a == 2
*	q_inr_8:
gen q_inr_8 = q_missing_8 / g_items
*	q_ext_8:
egen q_extreme_8 = anycount(edbs131a-edbs140a), values(1 5) 
egen q_extreme_tmp_8 = anycount(edbs141a-edbs149a), values(1 5) 
replace q_extreme_8 = q_extreme_tmp_8 if edbs153a == 2
gen q_ext_8 = q_extreme_8 / g_items
*	q_lef_8:
egen q_left_8 = anycount(edbs131a-edbs140a), values(1)
egen q_left_tmp_8 = anycount(edbs141a-edbs149a), values(1)
replace q_left_8 = q_left_tmp_8 if edbs153a == 2
gen q_lef_8 = q_left_8 / g_items
* 	q_str_8:
egen q_sd_8 = rowsd(edbs131a-edbs140a) if q_miss_8 == 0
egen q_sd_tmp_8 = rowsd(edbs141a-edbs149a) if q_miss_8 == 0
replace q_sd_8 = q_sd_tmp_8 if edbs153a == 2
egen q_mean_8 = rowmean(edbs131a-edbs140a) if q_miss_8 == 0
egen q_mean_tmp_8 = rowmean(edbs141a-edbs149a) if q_miss_8 == 0
replace q_mean_8 = q_mean_tmp_8 if edbs153a == 2
gen q_str_8 = q_sd_8 == 0
*	q_rho_8
gen q_rhosum_8 = 0
mvdecode edbs131a-edbs140a, mv(-111=.a\-99=.b\-66=.c)
mvdecode edbs141a-edbs149a, mv(-111=.a\-99=.b\-66=.c)
forvalues i = 1 / `g_scale' {
	egen temp_`i'=anycount(edbs131a-edbs140a), v(`i') 
	egen temp_tmp_`i'=anycount(edbs141a-edbs149a), v(`i') 
	replace temp_`i' = temp_tmp_`i' if edbs153a == 2
	replace temp_`i'=temp_`i'/ g_items
	replace q_rhosum_8=q_rhosum_8+(temp_`i'^2)
	drop temp_`i' temp_tmp_`i'
}
mvencode edbs131a-edbs140a, mv(.a=-111\.b=-99\.c=-66)
mvencode edbs141a-edbs149a, mv(.a=-111\.b=-99\.c=-66)
gen q_rho_8 = 1 - q_rhosum_8 
replace q_rho_8 = . if q_miss_8 != 0
* 	q_cov_8
gen q_cov_8 = q_sd_8 / q_mean_8
* 	q_atc_8
gen q_atc_8 = 1 if edbs136a > 0
replace q_atc_8 = 0 if edbs136a == 2
*	
drop g_items
*
sum q_inr_8 q_ext_8 q_lef_8 q_str_8 q_rho_8 q_cov_8 q_atc_8
*
*	q9:
local g_items = 6
local g_scale = 5
egen q_miss_9 = anycount(edzq001a- edzq006a), values(-111 -99 -66)
egen q_missing_9 = anycount(edzq001a- edzq006a), values(-99)
*	q_inr_9:
gen q_inr_9 = q_missing_9 / `g_items'
*	q_ext_9:
egen q_extreme_9 = anycount(edzq001a- edzq006a), values(1 5)
gen q_ext_9 = q_extreme_9 / `g_items'
*	q_lef_9:
egen q_left_9 = anycount(edzq001a- edzq006a), values(1)
gen q_lef_9 = q_left_9 / `g_items'
* 	q_str_9:
egen q_sd_9 = rowsd(edzq001a- edzq006a) if q_miss_9 == 0
egen q_mean_9 = rowmean(edzq001a- edzq006a) if q_miss_9 == 0
gen q_str_9 = q_sd_9 == 0
*	q_rho_9
gen q_rhosum_9 = 0
mvdecode edzq001a- edzq006a, mv(-111=.a\-99=.b\-66=.c)
forvalues i = 1 / `g_scale' {
	egen temp_`i'=anycount(edzq001a- edzq006a), v(`i') 
	replace temp_`i'=temp_`i'/`g_items'
	replace q_rhosum_9=q_rhosum_9+(temp_`i'^2)
	drop temp_`i'
}
mvencode edzq001a- edzq006a, mv(.a=-111\.b=-99\.c=-66)
gen q_rho_9 = 1 - q_rhosum_9
replace q_rho_9 = . if q_miss_9 != 0
* 	q_cov_9
gen q_cov_9 = q_sd_9 / q_mean_9
* 	q_atc_9
gen q_atc_9 = .
*	
sum q_inr_9 q_ext_9 q_lef_9 q_str_9 q_rho_9 q_cov_9 q_atc_9
*
*	Rescale data quality indicators to 0 = bad data quality, 1 = good data quality
*	In addition, standardize CV to [0;1]
forvalues i=1/9 {
	foreach var in q_inr_`i' q_ext_`i' q_lef_`i' q_str_`i' q_atc_`i' {
		replace `var' = 1 - `var'
	}
	quietly: sum q_cov_`i'
	replace q_cov_`i' = (q_cov_`i' - `r(min)') / (`r(max)'-`r(min)')
}
*	Additonal variables
*	Sample
gen refresh = z000006a == 2
lab def refresh 0 "initial" 1 "refreshment"
lab val refresh refresh
*
gen educ = .
replace educ = 0 if d12d091b >= 1 & d12d091b <= 3
replace educ = 1 if d12d091b >= 4 & d12d091b <= 5
replace educ = 2 if d12d091b >= 6 & d12d091b <= 7
replace educ = 0 if (a11d082b >= 1 & a11d082b <= 3) | a11d082b == 5 | a11d082b == 9
replace educ = 1 if a11d082b == 4 | (a11d082b >= 6 & a11d082b <= 7)
replace educ = 2 if a11d082b == 8
*
*	Mode
gen paper = edza002a == 1 if edza002a > 0
*
*	Describe all data quality indicators
sum q_inr_* 
sum q_ext_* 
sum q_lef_* 
sum q_str_* 
sum q_rho_* 
sum q_cov_* 
sum q_atc_*
*
* Describe response propensities
twoway kdensity ps if refresh==0 || ///
  kdensity ps if refresh==1
*
*	Reshape data to long format
keep id ps* q_inr_* q_ext_* q_lef_* q_str_* q_rho_* q_cov_* q_atc_* refresh paper educ
reshape long q_inr_ q_ext_ q_lef_ q_str_ q_rho_ q_cov_ q_atc_, i(id) j(q_id)
lab var q_inr "Item Nonresp."
lab var q_ext_ "Extreme R."
lab var q_lef_ "Left-aligned R."
lab var q_str_ "Straightlining"
lab var q_rho_ "Rho"
lab var q_cov_  "CV"
lab var q_atc_ "Attention Check"

*
*	Question characteristics
*
*	# of items in grid
gen q_items=.
replace q_items = 10 if q_id == 1
replace q_items = 6 if q_id == 2
replace q_items = 6 if q_id == 3
replace q_items = 5 if q_id == 4
replace q_items = 6 if q_id == 5
replace q_items = 7 if q_id == 6
replace q_items = 6 if q_id == 7
replace q_items = 10 if q_id == 8
replace q_items = 6 if q_id == 9
*	# of response options
gen q_scale=.
replace q_scale = 5 if q_id == 1
replace q_scale = 6 if q_id == 2
replace q_scale = 6 if q_id == 3
replace q_scale = 6 if q_id == 4
replace q_scale = 5 if q_id == 5
replace q_scale = 5 if q_id == 6
replace q_scale = 5 if q_id == 7
replace q_scale = 5 if q_id == 8
replace q_scale = 5 if q_id == 9
*
*	(3) Analyses
*	Response propensities
sum ps
bysort refresh: sum ps
*	DQ correlation matrix
pwcorr q_inr_ q_ext_ q_lef_ q_str_ q_rho_ q_cov_ q_atc_, sig
*
*	Mixed models
xtmixed q_inr c.ps##refresh i.q_id || id:
est sto reg_inr_1
lincom _b[ps] + _b[1.refresh#c.ps]
test _b[ps] == _b[ps] + _b[1.refresh#c.ps]
margins, at(c.ps=(0(.025)1)) over(refresh)
marginsplot, title("") ///
	recast(line) recastci(rarea) ciopts(color(%30)) ///
	ytitle("item nonresponse") ///
	xtitle("response propensity") ///
	legend(title("sample") col(1)) name("fig_inr", replace)
graph export "Results\fig_inr.emf", as(emf) replace
graph export "Results\fig_inr.eps", as(eps) replace
*
xtmixed q_ext c.ps##refresh i.q_id || id: 
est sto reg_ext_1
lincom _b[ps] + _b[1.refresh#c.ps]
test _b[ps] == _b[ps] + _b[1.refresh#c.ps]
margins, at(c.ps=(0(.025)1)) over(refresh)
marginsplot, title("") ///
	recast(line) recastci(rarea) ciopts(color(%30)) ///
	ytitle("% of extreme responses") ///
	xtitle("response propensity") ///
	legend(title("sample"))
graph export "Results\fig_ext.emf", as(emf) replace
graph export "Results\fig_ext.eps", as(eps) replace
*
xtmixed q_lef c.ps##refresh i.q_id || id:
est sto reg_lef_1
lincom _b[ps] + _b[1.refresh#c.ps]
test _b[ps] == _b[ps] + _b[1.refresh#c.ps]
margins, at(c.ps=(0(.025)1)) over(refresh)
marginsplot, title("") ///
	recast(line) recastci(rarea) ciopts(color(%30)) ///
	ytitle("% of left-aligned responses") ///
	xtitle("response propensity") ///
	legend(title("sample"))
graph export "Results\fig_lef.emf", as(emf) replace
graph export "Results\fig_lef.eps", as(eps) replace
*
melogit q_str c.ps##refresh i.q_id || id:
est sto reg_str_1
lincom _b[ps] + _b[1.refresh#c.ps]
test _b[ps] == _b[ps] + _b[1.refresh#c.ps]
margins, at(c.ps=(0(.025)1)) over(refresh)
marginsplot, title("") ///
	recast(line) recastci(rarea) ciopts(color(%30)) ///
	ytitle("Pr(straightlining)") ///
	xtitle("response propensity") ///
	legend(title("sample"))
graph export "Results\fig_str.emf", as(emf) replace
graph export "Results\fig_str.eps", as(eps) replace
*
xtmixed q_rho c.ps##refresh i.q_id || id:
est sto reg_rho_1
lincom _b[ps] + _b[1.refresh#c.ps]
test _b[ps] == _b[ps] + _b[1.refresh#c.ps]
margins, at(c.ps=(0(.025)1)) over(refresh)
marginsplot, title("") ///
	recast(line) recastci(rarea) ciopts(color(%30)) ///
	ytitle("Rho") ///
	xtitle("response propensity") ///
	legend(title("sample")) name("fig_rho")
graph export "Results\fig_rho.emf", as(emf) replace
graph export "Results\fig_rho.eps", as(eps) replace
*
xtmixed q_cov c.ps##refresh i.q_id || id:
est sto reg_cov_1
lincom _b[ps] + _b[1.refresh#c.ps]
test _b[ps] == _b[ps] + _b[1.refresh#c.ps]
margins, at(c.ps=(0(.025)1)) over(refresh)
marginsplot, title("") ///
	recast(line) recastci(rarea) ciopts(color(%30)) ///
	ytitle("coefficient of variation") ///
	xtitle("response propensity") ///
	legend(title("sample")) name("fig_cv")
graph export "Results\fig_cov.emf", as(emf) replace
graph export "Results\fig_cov.eps", as(eps) replace
*
logit q_atc c.ps##refresh
est sto reg_atc_1
lincom _b[ps] + _b[1.refresh#c.ps]
test _b[ps] == _b[ps] + _b[1.refresh#c.ps]
margins, at(c.ps=(0(.025)1)) over(refresh)
marginsplot, title("") ///
	recast(line) recastci(rarea) ciopts(color(%30)) ///
	ytitle("Pr(failing attention check)") ///
	xtitle("response propensity") ///
	legend(title("sample"))
graph export "Results\fig_atc.emf", as(emf) replace
graph export "Results\fig_atc.eps", as(eps) replace
*
*
*
*	(4) Output
*	Table 1
tabstat q_lef q_ext q_inr q_str q_rho q_cov q_atc, stat(mean min max n) c(stats)
*	Table 2, column 2
esttab reg_lef_1 reg_ext_1 reg_inr_1 reg_str_1 reg_rho_1 reg_cov_1 reg_atc_1  ///
	using "Results\tab_reg.rtf", replace cells(b(star fmt(%9.3f)) se(par fmt(%9.3f))) ///
	keep(ps 1.refresh#*)
*	Table A.2
esttab reg_lef_1 reg_ext_1 reg_inr_1 reg_str_1 reg_rho_1 reg_cov_1 reg_atc_1 ///
	using "Results\tab_reg_A1.rtf", replace cells(b(star fmt(%9.3f)) se(par fmt(%9.3f)))stats(N ll) legend ///
	keep(ps *refresh*)
esttab reg_lef_1 reg_ext_1 reg_inr_1 reg_str_1 reg_rho_1 reg_cov_1 reg_atc_1 ///
	using "Results\tab_reg_A1.tex", replace cells(b(star fmt(%9.3f)) se(par fmt(%9.3f)))stats(N ll) legend ///
	keep(ps *refresh*)
*	Figure 1
grc1leg fig_inr fig_rho fig_cv,  col(2) legendfrom(fig_inr) ring(0) position(5)
gr_edit legend.xoffset = -10
gr_edit legend.yoffset = 15
graph export "Results\Fig_1.emf", as(emf) replace
graph export "Results\Fig_1.eps", as(eps) replace
*	Figure 2
graph matrix q_lef q_ext q_inr q_str q_rho q_cov q_atc
corrtable q_lef q_ext q_inr q_str q_rho q_cov q_atc, half listwise
graph export "Results\Fig_2.emf", as(emf) replace
graph export "Results\Fig_2.eps", as(eps) replace
