********************************************************************************
********************************************************************************
************* Syntax to produce outputs contained in Manuscript ****************
** "Studying the context effect of family norms on gender role attitudes: 	  **
**					an experimental design"								      **
********	Authors: Angelica Maineri, Vera Lomazzi, Ruud Luijx			********
********		Date current version: 28-1-2020						************
********************************************************************************
********************************************************************************

*** Set folders ***
global folder "C:\Users\u1277277\surfdrive\Documents\Order effects - gender roles\Data"
global folder_save "C:\Users\u1277277\Dropbox\art. cronos_test priming effect\manuscript\Submission SRM\Revision - final accepted version"


*** Install ados (apply only once) ***
* ssc install blindschemes    // color scheme for graphs
* ssc install g538schemes  // color scheme for graphs
* ssc install coefplot // to make coefficients plots
* ssc install grc1leg  // to combine graphs including only one legend
* ssc install catplot  // to make catplots

*** Load dataset ***
use "$folder\CRONOS_ESS8_e01_2", clear
set more off

* Run syntax provided by ESS
* This do-file assigns missing value definitions to the dataset
mvdecode _all, mv(-66=.a \ -77=.b \ -88=.c \ -99=.d \ -98=.d \ -97=.d \ -55=.d \ -33=.e \ -22=.f \ -11=.f)
quietly label dir
foreach var in `r(names)' {
  capture confirm variable `var'
  if !_rc {
    label define `var' ///
    .a "Not applicable" ///
    .b "Prefer not to answer" ///
    .c "Don't know" ///
    .d "Not available" ///
    .e "Not asked: Survey break-off" ///
    .f "Wave 5: Never too young / Should not live with unmarried..", modify
  }
}
*

* We are interested in wave 5 hence we select respondents that filled in the 
* wave 5 survey
keep if w5exp1!=. & w5exp1!=.e
tab w5exp1, m

******************************
save data.dta, replace
u data.dta, clear
******************************

*****************************************************************************
* ++++++++++			SECTION I: Data preparation				++++++++++++*
*****************************************************************************

* Experimental condition 
fre w5exp1
gen expcon=w5exp1
lab def expcon 1 "A. FN-GRA" 2 "B. GRA-FN", modify
lab val expcon expcon
lab var expcon "Question order"
fre expcon //check
tab expcon w5exp1 // check

* Country
tab cntry
encode cntry, gen(country)
numlabel country, add
tab country
lab def country 1 "EE" 2 "GB" 3 "SI", modify
lab val country country
numlabel country, remove
tab country

* Group (country by expcon)
gen group=. 
replace group=1 if country==1 & expcon==1 // EE FN
replace group=2 if country==1 & expcon==2 // EE GRA
replace group=3 if country==2 & expcon==1 // GB FN
replace group=4 if country==2 & expcon==2 // GB GRA
replace group=5 if country==3 & expcon==1 // SI FN
replace group=6 if country==3 & expcon==2 // SI GRA
lab def group ///
	1 "EE A. FN-GRA" ///
	2 "EE B. GRA-FN" ///
	3 "GB A. FN-GRA" ///
	4 "GB B. GRA-FN" ///
	5 "SI A. FN-GRA" ///
	6 "SI B. GRA-FN" 
lab val group group
lab var group "Country by Experimental condition"
tab group

* Gender
fre gndr // 1 Male 2 Female
gen female=gndr==2
lab def female 0 "Male" 1 "Female"
lab val female female
fre female

* Age
sum agea
recode agea (18/34= 1 "18-34") (35/59 = 2 "35-59") ///
 (60/max=3 "60+"), gen(agecat)
lab var agecat "Age categories"
fre agecat

foreach n of numlist 1 2 3 {
gen agecat`n'=agecat==`n'
}
fre agecat*


* Educational attainment
fre eisced
recode eisced (1 2=1 "Lower") (3 4 = 2 "Middle") (5 6 7 = 3 "Higher") ///
	(55 = .d), gen(educat)
lab var educat "Educational level respondent"
fre educat
foreach n of numlist 1 2 3 {
gen educat`n'=educat==`n'
}
fre educat*

recode eisced (55 = .d) // recode other to missing?

* Place of residence 
tab w5q74

* Marital status
fre maritalb // marital status
fre rshpsts // relationship status

fre maritalb rshpsts

gen maritalr=.
lab def maritalr ///
	1 "Married/Civil union" ///
	2 "Previously married" ///
	3 "Living with partner" ///
	4 "Single and never married"
lab val maritalr maritalr	
lab var maritalr "Marital status: current"

replace maritalr=1 if maritalb==1 | maritalb==2
replace maritalr=2 if maritalb==4 | maritalb==5 
replace maritalr=3 if rshpsts==3
replace maritalr=3 if rshpsts==4
replace maritalr=3 if rshpsts==6
replace maritalr=4 if rshpsts==. & maritalb==6
tab maritalr  // check
tab maritalr maritalb // check
fre maritalr rshpsts // check

gen married = maritalr==1
gen wasmarried = maritalr==2
gen cohabiting = maritalr==3
gen single = maritalr==4

* When jobs are scarce
fre mnrgtjb // egalitarian = high values

* Church attendance
tab1 rlgatnd // turn
codebook rlgatnd
recode rlgatnd (7=1 "Never") (6=2 "Less often") ///
	(5 = 3 "Only on special holy days") (4= 4 "At least once a month") ///
	(3=5 "Once a week") (2=6 "More than once a week") ///
	(1 = 7 "Every day") , gen(churchatt)
lab var churchatt "Church attendance"
tab churchatt rlgatnd 
	* gen dummy 
gen nochurch=. 
replace nochurch=1 if churchatt==1
replace nochurch=0 if churchatt>=2
lab def nochurch 0 "Church attendance" 1 "No church attendance"
lab val nochurch nochurch
tab nochurch rlgatnd // check

lab var female "Female"
lab var agea "Age"
lab var eisced "Educational level"
lab var wasmarried "Previously married"
lab var cohabiting "Living with partner"
lab var single "Single"
lab var nochurch "No church attendance"



*** GRA **
global varlistgra w5q8 w5q9 w5q10 w5q11 w5q12 w5q13 w5q14 w5q15


				***************************************
				*** 			TAB. 2				***
				***************************************
sum $varlistgra
fre $varlistgra


* Turn items so that high values indicate egalitarianism
* Hence we need to turn some of the items:
gen q8=5-w5q8 // turned
gen q9=w5q9 
gen q10=w5q10
gen q11=w5q11
gen q12=5-w5q12 // turned
gen q13=5-w5q13 // turned
gen q14=5-w5q14 // turned
gen q15=5-w5q15 // turned

alpha q8-q15, c d i 

global varlistgrar q8 q9 q10 q11 q12 q13 q14 q15
corr q8 q14 q15 q9 q10 q11 q12 q13




**** APPENDIX *********
* Family norms
global varlistfn w5q1-w5q7
sum $varlistfn
tab1 $varlistfn, m
egen missfn=rowmiss($varlistfn)
tab missfn

alpha $varlistfn, c d i // 0.74

** Confirmatory factor analysis
// With turned variables

*factor $varlistfn, pcf factors(2)
factor $varlistfn, pf altdivisor mineigen(0) factors(2) 

				*******************************************
				*** 			TAB. 14 				***
				*******************************************
rotate, varimax norm //blank(.40) //orthogonal rotation
estat common


** RANDOMIZATION CHECK +++++++++++++++++++++++++++++++++++++++++++++++++++++++++
sum gndr agecat3 educat w5q74

				*******************************************************
				*** 						TAB. 13   		 		***
				*******************************************************
tab gndr expcon, col chi
tab agecat expcon, col chi
tab educat expcon, col chi
tab w5q74 expcon, col chi

				*******************************************************
				*** 					Fig 6						***
				*******************************************************
sum q8-q15
fre q8-q15

gen workmother=q8
gen childsuffer=q9
gen jobalright=q10
gen housewife=q11
gen independent=q12
gen hhincome=q13
gen fathersuit=q14
gen menrespons=q15

gen group2 = group
fre group2
lab def group2  1 "EE-A" 2 "EE-B" 3 "GB-A" 4 "GB-B" 5 "SI-A" 6"SI-B" 
lab val group2 group2

set scheme s1mono
foreach var of varlist workmother-menrespons {
graph bar `var', over(group2, label(angle(vertical) labsize(small))) ylab(1(1)4) ytitle(mean) ///
	title(`var') exclude0 name(g_`var', replace) nodraw
}
graph dir
graph combine  g_workmother g_childsuffer g_jobalright g_housewife ///
 g_independent g_hhincome g_fathersuit g_menrespons   ///
			, rows(2)
graph export "$folder_save/FigureA1.pdf", replace



** efa

***************************** TABLE 3 ****************************************
factor $varlistgrar, pf altdivisor mineigen(0) 
rotate, varimax norm //blank(.40) //orthogonal rotation
*********************************************************************************


** efa by countries
foreach g of numlist 1 2 3 {
factor $varlistgrar if country==`g', pf altdivisor mineigen(0) 
rotate, varimax norm blank(.40) //orthogonal rotation
estat common
}

bys group: corr q8 q14 q15 q9 q10 q11 q12 q13

bys group: corr q8 q14 q15
bys group: corr q9 q10 q11
bys group: corr q12 q13


*************************************************************************
* ++++++++++			SECTION II: Analyses				++++++++++++*
*************************************************************************


************************
***** RELIABILITY ******
************************
alpha q8-q15, c d i 
bys expcon: alpha q8-q15, c d i 
bys country: alpha q8-q15, c d i 
bys group: alpha q8-q15, c d i 



				*******************************************************
				*** 						TAB. 5		 		***
				*******************************************************


bootstrap alpha = r(alpha), reps(400) nodots nowarn: ///
	alpha q8-q15, c d i 

	
* by expcon
bootstrap alpha = r(alpha), reps(400) nodots nowarn: ///
	alpha q8-q15 if expcon==1, c d i 
bootstrap alpha = r(alpha), reps(400) nodots nowarn: ///
	alpha q8-q15 if expcon==2, c d i 

* by country
bootstrap alpha = r(alpha), reps(400) nodots nowarn: ///
	alpha q8-q15 if country==1, c d
bootstrap alpha = r(alpha), reps(400) nodots nowarn: ///
	alpha q8-q15 if country==2, c d
bootstrap alpha = r(alpha), reps(400) nodots nowarn: ///
	alpha q8-q15 if country==3, c d

* by group	
bootstrap alpha = r(alpha), reps(400) nodots nowarn: ///
	alpha q8-q15 if group==1, c d i
bootstrap alpha = r(alpha), reps(400) nodots nowarn: ///
	alpha q8-q15 if group==2, c d i
bootstrap alpha = r(alpha), reps(400) nodots nowarn: ///
	alpha q8-q15 if group==3, c d i
bootstrap alpha = r(alpha), reps(400) nodots nowarn: ///
	alpha q8-q15 if group==4, c d i
bootstrap alpha = r(alpha), reps(400) nodots nowarn: ///
	alpha q8-q15 if group==5, c d i
bootstrap alpha = r(alpha), reps(400) nodots nowarn: ///
	alpha q8-q15 if group==6, c d i	

* generate variables with meaningful names for plots *
*clonevar workmother=q8
*clonevar childsuffer=q9
*clonevar jobalright=q10
*clonevar housewife=q11
*clonevar independent=q12
*clonevar hhincome=q13
*clonevar fathersuit=q14
*clonevar menresponsible=q15 

**********************************************
************* MEASUREMENT MODEL **************
**********************************************

*save data_analysis.dta, replace
*u data_analysis.dta, clear

// drop missing listwise from validity variables
global varlistreg female agea eisced ///
 expcon country nochurch maritalr 
sum $varlistreg
egen misstot=rowmiss($varlistreg)
tab misstot // "net" sample = 1815
keep if misstot==0

save data_analysis.dta, replace
u data_analysis.dta, clear


******************************** TABLE 4 **************************************
sum q8-q15
sum mnrgtjb agea i.agecat eisced female i.maritalr nochurch i.country


/*
Structure suggested by EFA:
Gra1 -> q8 q14 q15
Gra2 -> q9 q10 q11
Gra3 -> q12 q13
*/

* cfa model 1 -- ml

******************************** TABLE 6**************************************
*bys group: /// 
*bys country: ///
sem (Gra1 -> q8 q14 q15) (Gra2 -> q9 q10 q11)(Gra3 -> q12 q13),  ///
	nocapslatent latent(Gra1 Gra2 Gra3) method(ml) difficult ///
	standardized 
estat gof, stats(all)
// by country: GB and SI do not converge
** + sem builder (sem_8items.stsem)

foreach n of numlist 1 2 3 4 5 6 {
sem (Gra1 -> q8 q14 q15) (Gra2 -> q9 q10 q11)(Gra3 -> q12 q13) if group==`n',  ///
	nocapslatent latent(Gra1 Gra2 Gra3) method(ml) difficult ///
	standardized iterate(100)
estat gof, stats(all)
}
estat mindices

// by group: group 4 and group 6 do not converge

// comments
// poor fit
// poor convergent validity: standardized factor loading <.7 for 6 items out of 8; 
//		std. factor loading <.5 for 4/8 items
// q11 has a std. residual variance of .9; 
// correlation Gra1-Gra2 is .66 >> low discriminant validity?


**********  single dimension *****************
* Single factor model 
sem (Gra -> q8 q14 q15),  ///
	nocapslatent latent(Gra) method(ml) standardized
estat gof, stats(all)
// model saturated. 
** + sem builder (sem_3items.stsem)


bys expcon: ///
sem (Gra -> q8 q14 q15),  ///
	nocapslatent latent(Gra) method(ml) standardized

bys country: ///
sem (Gra -> q8 q14 q15),  ///
	nocapslatent latent(Gra) method(ml) standardized

bys group: ///
sem (Gra -> q8 q14 q15),  ///
	nocapslatent latent(Gra) method(ml) standardized

	
** MI **	

** across countries, within experimental condition
**************** TABLE 8 **************
//configural
*sem (Gra -> q8 q14 q15) (q8 <- Gra _cons@0),  ///
*	ginvariant(none) group(country) mean(Gra) ///
*	nocapslatent latent(Gra) method(ml) difficult
*matrix b = e(b)

sem (Gra -> q8 q14 q15) (q8 <- Gra _cons@0) if expcon==1,  ///
	ginvariant(none) group(country) mean(Gra) ///
	nocapslatent latent(Gra) method(ml) difficult from(b)
estat gof, stats(all)

//metric
sem (Gra -> q8 q14 q15) (q8 <- Gra _cons@0) if expcon==1,  ///
	ginvariant(mcoef) group(country) mean(Gra) ///
	nocapslatent latent(Gra) method(ml) difficult
estat gof, stats(all)

//scalar
sem (Gra -> q8 q14 q15) (q8 <- Gra _cons@0) if expcon==1,  ///
	ginvariant(mcoef mcons) group(country) mean(Gra) ///
	nocapslatent latent(Gra) method(ml) difficult
estat gof, stats(all)

//strict
sem (Gra -> q8 q14 q15) (q8 <- Gra _cons@0) if expcon==1,  ///
	ginvariant(mcoef mcons merrvar) group(country) mean(Gra) ///
	nocapslatent latent(Gra) method(ml) //difficult
estat gof, stats(all)



//configural
sem (Gra -> q8 q14 q15) (q8 <- Gra _cons@0) if expcon==2,  ///
	ginvariant(none) group(country) mean(Gra) ///
	nocapslatent latent(Gra) method(ml) difficult
matrix b = e(b)
estat gof, stats(all)
// saturated

//metric
sem (Gra -> q8 q14 q15) (q8 <- Gra _cons@0) if expcon==2,  ///
	ginvariant(mcoef) group(country) mean(Gra) ///
	nocapslatent latent(Gra) method(ml) difficult from(b)
estat gof, stats(all)

//scalar
sem (Gra -> q8 q14 q15) (q8 <- Gra _cons@0) if expcon==2,  ///
	ginvariant(mcoef mcons) group(country) mean(Gra) ///
	nocapslatent latent(Gra) method(ml) difficult 
estat gof, stats(all)


//strict
sem (Gra -> q8 q14 q15) (q8 <- Gra _cons@0) if expcon==2,  ///
	ginvariant(mcoef mcons merrvar) group(country) mean(Gra) ///
	nocapslatent latent(Gra) method(ml) difficult 
estat gof, stats(all)


*** across conditions, by country
************* TABLE 7 **********************

* EE
//configural
sem (Gra -> q8 q14 q15) (q8 <- Gra _cons@0) if country==1,  ///
	ginvariant(none) group(expcon) mean(Gra) ///
	nocapslatent latent(Gra) method(ml) difficult
estat gof, stats(all)
*
//metric
sem (Gra -> q8 q14 q15) (q8 <- Gra _cons@0) if country==1,  ///
	ginvariant(mcoef) group(expcon) mean(Gra) ///
	nocapslatent latent(Gra) method(ml) difficult
estat gof, stats(all)

//scalar
sem (Gra -> q8 q14 q15) (q8 <- Gra _cons@0) if country==1, ///
	ginvariant(mcoef mcons) group(expcon) mean(Gra) ///
	nocapslatent latent(Gra) method(ml) difficult
estat gof, stats(all)
*
// strict
sem (Gra -> q8 q14 q15) (q8 <- Gra _cons@0) if country==1,  ///
	ginvariant(mcoef mcons merrvar) group(expcon) mean(Gra) ///
	nocapslatent latent(Gra) method(ml) difficult
estat gof, stats(all)
*

* GB
//configural
sem (Gra -> q8 q14 q15) (q8 <- Gra _cons@0) if country==2,  ///
	ginvariant(none) group(expcon) mean(Gra) ///
	nocapslatent latent(Gra) method(ml) //difficult 
estat gof, stats(all)

*
//metric
sem (Gra -> q8 q14 q15) (q8 <- Gra _cons@0) if country==2,  ///
	ginvariant(mcoef) group(expcon) mean(Gra) ///
	nocapslatent latent(Gra) method(ml) difficult
estat gof, stats(all)

//scalar
sem (Gra -> q8 q14 q15) (q8 <- Gra _cons@0) if country==2, ///
	ginvariant(mcoef mcons) group(expcon) mean(Gra) ///
	nocapslatent latent(Gra) method(ml) difficult
estat gof, stats(all)
*
// strict
sem (Gra -> q8 q14 q15) (q8 <- Gra _cons@0) if country==2,  ///
	ginvariant(mcoef mcons merrvar) group(expcon) mean(Gra) ///
	nocapslatent latent(Gra) method(ml) difficult
estat gof, stats(all)
*

* SI
//configural
sem (Gra -> q8 q14 q15) (q8 <- Gra _cons@0) if country==3,  ///
	ginvariant(none) group(expcon) mean(Gra) ///
	nocapslatent latent(Gra) method(ml) difficult
estat gof, stats(all)
*
//metric
sem (Gra -> q8 q14 q15) (q8 <- Gra _cons@0) if country==3,  ///
	ginvariant(mcoef) group(expcon) mean(Gra) ///
	nocapslatent latent(Gra) method(ml) difficult
estat gof, stats(all)

/*MODEL 4 VS 3*/
*Compute difference of chi2 and pvalue
local Y 1.225-0.646 /*chi2 difference= X*/
local X 4-2  /*df difference= Y*/
*pvalue
display chi2tail(Y, X) // = Z



//scalar
sem (Gra -> q8 q14 q15) (q8 <- Gra _cons@0) if country==3, ///
	ginvariant(mcoef mcons) group(expcon) mean(Gra) ///
	nocapslatent latent(Gra) method(ml) difficult
matrix a = e(b)
estat gof, stats(all)
*
// strict
sem (Gra -> q8 q14 q15) (q8 <- Gra _cons@0) if country==3,  ///
	ginvariant(mcoef mcons merrvar) group(expcon) mean(Gra) ///
	nocapslatent latent(Gra) method(ml) difficult from(a)
estat gof, stats(all)
*
	
	
	

	
****** criterion validity *********


* add explanatory model 
// corr agea

sem (Gra -> q8 q14 q15)(agea),  ///
	cov(Gra*agea) ///
	nocapslatent latent(Gra) method(ml) standardized
	
bys expcon: ///
sem (Gra -> q8 q14 q15)(agea),  ///
	cov(Gra*agea) ///
	nocapslatent latent(Gra) method(ml) standardized

bys group: ///
sem (Gra -> q8 q14 q15)(agea),  ///
	cov(Gra*agea) ///
	nocapslatent latent(Gra) method(ml) standardized
estat gof, stats(all)


************* TABLE 9 **********************
// men have more right to a job
sem (Gra -> q8 q14 q15)(mnrgtjb),  ///
	cov(Gra*mnrgtjb) ///
	nocapslatent latent(Gra) method(ml) standardized
	
bys expcon: ///
sem (Gra -> q8 q14 q15)(mnrgtjb),  ///
	cov(Gra*mnrgtjb) ///
	nocapslatent latent(Gra) method(ml) standardized

bys group: ///
sem (Gra -> q8 q14 q15)(mnrgtjb),  ///
	cov(Gra*mnrgtjb) ///
	nocapslatent latent(Gra) method(ml) standardized
estat gof, stats(all)


// men have more right to a job by age groups
************* TABLE 10 **********************
bys agecat: ///
sem (Gra -> q8 q14 q15)(mnrgtjb),  ///
	cov(Gra*mnrgtjb) ///
	nocapslatent latent(Gra) method(ml) standardized

bys agecat expcon: ///
sem (Gra -> q8 q14 q15)(mnrgtjb),  ///
	cov(Gra*mnrgtjb) ///
	nocapslatent latent(Gra) method(ml) difficult standardized


bys agecat group: ///
sem (Gra -> q8 q14 q15)(mnrgtjb),  ///
	cov(Gra*mnrgtjb) ///
	nocapslatent latent(Gra) method(ml) standardized difficult
* no convergence: small sample size?


**** construct validity *******

** i.gndr i.agecat3 i.edur ib4.maritalr i.nochurch

********* !!!! lower sample size because of 7 cases "other" in eisced were dropped
// no standardized? 
*bys group: ///
sem (Gra -> q8 q14 q15) ///
	(agea nochurch gndr eisced wasmarried cohabiting single -> Gra), ///
	nocapslatent latent(Gra) method(adf) 
estat gof, stats(all)



set scheme s1mono

sem (Gra -> q8 q14 q15) ///
	(agea  -> Gra), ///
	nocapslatent latent(Gra) method(adf) 


***
egen miss = rowmiss(q8 q14 q15)
fre miss	
keep if miss==0
	
*** baseline
set scheme s1mono
sem (Gra -> q8 q14 q15) ///
	(female eisced agecat2 agecat3 wasmarried cohabiting single nochurch -> Gra), ///
	nocapslatent latent(Gra) method(ml) 
est sto baseline
estat gof, stats(all)
*

sum group 
global nobs `r(N)'

lab var agecat2 "35-59"
lab var agecat3 "60+"  

************* FIGURE 4 **********************
coefplot ///
	(baseline, ms(circle)) ///
	, drop(_cons) ///
	xline(0) byopts(xrescale) ///
	headings(agecat2="{it: Age categories(ref: 18-34)}" ///
	wasmarried="{it:Marital status (ref: Married)}" nochurch=" ", ///
	labsize(vsmall*1.5)) ///
	ylab(, labsize(vsmall*1.5)) ///
	name (val_all, replace)
graph export "$folder_save/Proof/review_baseline.emf", replace
graph export "$folder_save/Proof/7656_fig4.pdf", replace

*** by group
foreach n of numlist 1 2 3 4 5 6 {
sem (Gra -> q8 q14 q15) ///
	(female eisced agecat2 agecat3 wasmarried cohabiting single nochurch -> Gra) ///
	if group==`n', ///
	nocapslatent latent(Gra) method(ml) 
est sto group`n'
estat gof, stats(all)
}
*
sum group if group==1
global nobsg1 `r(N)'

sum group if group==2
global nobsg2 `r(N)'

sum group if group==3
global nobsg3 `r(N)'

sum group if group==4
global nobsg4 `r(N)'

sum group if group==5
global nobsg5 `r(N)'

sum group if group==6
global nobsg6 `r(N)'


* EE
coefplot ///
	(group1, ms(circle)) ///
	(group2, ms(t)) ///
	, drop(_cons) ///
	xline(0) byopts(xrescale) ///
	title("EE") fxsize(100) ///
	headings(agecat2="{it: Age categories(ref: 18-34)}" ///
	wasmarried="{it:Marital status (ref: Married)}" nochurch=" ", ///
	labsize(small*1.5)) ///
	ylab(, labsize(small*1.5)) ///
	subtitle("N{subscript:A}=$nobsg1 | N{subscript:B}=$nobsg2", size(small)) ///
	legend(label(2 "A (FN-GRA)") label(4 "B (GRA-FN)") cols(2) size(small) title("Experimental setting", size(small))) ///
	name (val_EE, replace)

* GB 

coefplot ///
	(group3, ms(circle)) ///
	(group4, ms(t) ) ///
	, drop(_cons) ///
	xline(0) byopts(xrescale) ///
	fxsize(40) ///
	headings(agecat2="{it: Age categories(ref: 18-34)}" ///
	wasmarried="{it:Marital status (ref: Married)}" nochurch=" ", ///
	labsize(small)) ///
	ylab(, labsize(small)) ///
	title("GB") yscale(off) ///
	subtitle("N{subscript:A}=$nobsg3 | N{subscript:B}=$nobsg4", size(small)) ///
	legend(label(2 "A (FN-GRA)") label(4 "B (GRA-FN)") cols(2)) ///
	name (val_GB, replace)

* SI
coefplot ///
	(group5, ms(circle)) ///
	(group6, ms(t)) ///
	, drop(_cons) ///
	xline(0) byopts(xrescale) fxsize(40) ///
	headings(agecat2="{it: Age categories(ref: 18-34)}" ///
	wasmarried="{it:Marital status (ref: Married)}" nochurch=" ", ///
	labsize(small)) ///
	ylab(, labsize(small)) ///
	title("SI")  yscale(off) ///
	subtitle("N{subscript:A}=$nobsg5 | N{subscript:B}=$nobsg6", size(small)) ///
	legend(label(2 "A (FN-GRA)") label(4 "B (GRA-FN)") cols(2)) ///
	name (val_SI, replace)

						***********************************
						*** 		FIG.	5	***
						***********************************
grc1leg val_EE val_GB val_SI , xcommon  r(1) ///
	legendfrom(val_EE) ///
	note("Source: CRONOS (2018)", pos(5) size(vsmall)) 

	
**********************************************
graph export "$folder_save/Figure5.emf", replace
graph export "$folder_save/Proof/7656_fig5.pdf", replace
*graph export "$folder_save/Fig3.tif", replace
**********************************************

window manage close graph _all
	
	


******** SUPPLEMENTARY MATERIAL *******************

* Single factor model 
sem (Gra -> q8 q14 q15 q9 q10 q11 q12 q13),  ///
	nocapslatent latent(Gra) method(ml) standardized
estat gof, stats(all)
// poor fit. 


** 3-factors model
sem (Gra1 -> q8 q14 q15) (Gra2 -> q9 q10 q11)(Gra3 -> q12 q13),  ///
	nocapslatent latent(Gra1 Gra2 Gra3) method(ml) difficult ///
	standardized 
estat gof, stats(all)
estat mindices



* Potential explanations looking at modification indices:
// q8 would have high loading on gra2 as well, and q9 on gra1 >> add error covariance
// high error covariance q9-q10 (but, spoiler, the model won't converge if I specify it)




sem (Gra1 -> q8 q14 q15) (Gra2 -> q9 q10 q11)(Gra3 -> q12 q13),  ///
	cov(e.q9*e.q10) ///
	nocapslatent latent(Gra1 Gra2 Gra3) method(ml) standardized
estat gof, stats(all) 
estat mindices


*Adding an error covariance between q8 and q9 seems to be theoretically motivated, 
*	as they both refer to working mothers and could thus share something in common
 // add q8-q9 (working mother )
sem (Gra1 -> q8 q14 q15) (Gra2 -> q9 q10 q11)(Gra3 -> q12 q13),  ///
	cov(e.q8*e.q9) ///
	nocapslatent latent(Gra1 Gra2 Gra3) method(ml) standardized
estat gof, stats(all) 
estat mindices
// comments:
// still poor fit (high RMSEA, low CFI and TLI; acceptable SRMR)
// 7/10 items have std. factor loading <.7
// all std. residual variance >.1

* Potential problems looking at modification indices:
// q13 now would have high loadin on Gra1
// high error covariance q9-q10 (but, spoiler, the model won't converge if I specify it)


* add error covariance to q14-q15 (they refer to men roles)
sem (Gra1 -> q8 q14 q15) (Gra2 -> q9 q10 q11)(Gra3 -> q12 q13),  ///
	cov(e.q8*e.q9 e.q14*e.q15) ///
	nocapslatent latent(Gra1 Gra2 Gra3) method(ml) standardized
estat gof, stats(all) 
estat mindices
// comments:
// still poor fit (high RMSEA, low CFI and TLI; acceptable SRMR)
// 7/10 items have std. factor loading <.7
// all std. residual variance >.1
 
 
* add error covariance to q10-q13 (they refer to household)
sem (Gra1 -> q8 q14 q15) (Gra2 -> q9 q10 q11)(Gra3 -> q12 q13),  ///
	cov(e.q8*e.q9 e.q14*e.q15 e.q13*e.q10) ///
	nocapslatent latent(Gra1 Gra2 Gra3) method(ml) standardized
estat gof, stats(all) 
estat mindices
// comments:
// poor fit etc

 * add error covariance to q10-q11 (they refer to women's aspirations)
sem (Gra1 -> q8 q14 q15) (Gra2 -> q9 q10 q11)(Gra3 -> q12 q13),  ///
	cov(e.q8*e.q9 e.q14*e.q15 e.q13*e.q10 e.q10*e.q11) ///
	nocapslatent latent(Gra1 Gra2 Gra3) method(ml) standardized
estat gof, stats(all) 
estat mindices
// comments:
// decent fit etc

 
// convergence by country? NO
foreach n of numlist 1 2 3 {
sem (Gra1 -> q8 q14 q15) (Gra2 -> q9 q10 q11)(Gra3 -> q12 q13) if country==`n',  ///
	cov(e.q8*e.q9 e.q14*e.q15 e.q13*e.q10 e.q10*e.q11) ///
	nocapslatent latent(Gra1 Gra2 Gra3) method(ml) standardized //iterate(50)
estat gof, stats(all)
}
*

fre country
	
	
// convergence by experimental group? YES
bys expcon: sem (Gra1 -> q8 q14 q15) (Gra2 -> q9 q10 q11)(Gra3 -> q12 q13),  ///
	cov(e.q8*e.q9 e.q14*e.q15 e.q13*e.q10 e.q10*e.q11) ///
	nocapslatent latent(Gra1 Gra2 Gra3) method(ml) standardized 
// convergence by group? NO
bys group: sem (Gra1 -> q8 q14 q15) (Gra2 -> q9 q10 q11)(Gra3 -> q12 q13),  ///
	cov(e.q8*e.q9 e.q14*e.q15 e.q13*e.q10 e.q10*e.q11) ///
	nocapslatent latent(Gra1 Gra2 Gra3) method(ml) standardized //iterate(50)

foreach n of numlist 1 2 3 4 5 6 {
sem (Gra1 -> q8 q14 q15) (Gra2 -> q9 q10 q11)(Gra3 -> q12 q13) if group==`n',  ///
	cov(e.q8*e.q9 e.q14*e.q15 e.q13*e.q10 e.q10*e.q11) ///
	nocapslatent latent(Gra1 Gra2 Gra3) method(ml) standardized //iterate(50)
estat gof, stats(all)
}
*
 
 
 
***** Other options? ***** 

// q11 has a quite low factor loading, and indeed fit improves when kicking it outputs
sem (Gra1 -> q8 q14 q15) (Gra2 -> q9 q10)(Gra3 -> q12 q13),  ///
	nocapslatent latent(Gra1 Gra2 Gra3) method(ml) standardized
estat gof, stats(all)
estat mindices

** Kicking out q11? 
factor q8 q9 q10 q12 q13 q14 q15, pf mineigen(0) altdivisor
rotate, varimax norm blank(.4)

sem (Gra1 -> q8 q9 q10) (Gra2 -> q14 q15)(Gra3 -> q12 q13),  ///
	nocapslatent latent(Gra1 Gra2 Gra3) method(ml) standardized
estat gof, stats(all)
// decent fit without covariances

bys country: sem (Gra1 -> q8 q9 q10) (Gra2 -> q14 q15)(Gra3 -> q12 q13),  ///
	nocapslatent latent(Gra1 Gra2 Gra3) method(ml) standardized iterate(50)
// doesn't converge in gb and si (residual variance q13 = 0)
bys group: sem (Gra1 -> q8 q9 q10) (Gra2 -> q14 q15)(Gra3 -> q12 q13),  ///
	nocapslatent latent(Gra1 Gra2 Gra3) method(ml) standardized
// doesn't converge in si-B and gb-a


// add error covariances for theoretical reasons: q8-q9: refer to working mothers, 
// and the efa shows high cross-factor loading
// q10-q11 share reference to womens' aspirations
// q11 and q12 share reference to jobs
// q14 and q15 share reference to fathers
bys group: sem (Gra1 -> q8 q14 q15) (Gra2 -> q9 q10 q11)(Gra3 -> q12 q13),  ///
	cov(e.q8*e.q9 e.q11*e.q12 e.q10*e.q11 e.q14*e.q15) ///
	nocapslatent latent(Gra1 Gra2 Gra3) method(ml) standardized iterate(50)
estat gof, stats(all) 
estat mindices
// no convergence by group


// from previous version of manuscript
sem (Gra1 -> q8 q14 q15) (Gra2 -> q9 q10 q11)(Gra3 -> q12 q13),  ///
	cov(e.q8*e.q9 e.q10*e.q13 e.q10*e.q11 e.q9*e.q11) ///
	nocapslatent latent(Gra1 Gra2 Gra3) method(ml) standardized
estat gof, stats(all)
// the factor loading of Q11 turns negative

bys country: sem (Gra1 -> q8 q14 q15) (Gra2 -> q9 q10 q11)(Gra3 -> q12 q13),  ///
	cov(e.q8*e.q9 e.q10*e.q13 e.q10*e.q11 e.q9*e.q11) ///
	nocapslatent latent(Gra1 Gra2 Gra3) method(ml) standardized iterate(50)
// does not converge in GB and SI

bys group: sem (Gra1 -> q8 q14 q15) (Gra2 -> q9 q10 q11)(Gra3 -> q12 q13),  ///
	cov(e.q8*e.q9 e.q10*e.q13 e.q10*e.q11 e.q9*e.q11) ///
	nocapslatent latent(Gra1 Gra2 Gra3) method(ml) iterate(50)
// does not converge in many groups


// CFA by groups; 
* cfa model 1 FN-GRA
sem (Gra1 -> q8 q14 q15) (Gra2 -> q9 q10 q11)(Gra3 -> q12 q13) if expcon==1,  ///
	nocapslatent latent(Gra1 Gra2 Gra3) method(adf)
estat gof, stats(all)
estat mindices

* cfa model 1 GRA-FN
sem (Gra1 -> q8 q14 q15) (Gra2 -> q9 q10 q11)(Gra3 -> q12 q13) if expcon==2,  ///
	nocapslatent latent(Gra1 Gra2 Gra3) method(adf)
estat gof, stats(all)
estat mindices


**** THE END *****










