# Need SURVEY to be loaded

builddates_X<-function (D, na2zero = TRUE){
  Y=sort(unique(D$year))
  n=paste('visit',c('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'),sep='.')
  datesi=which(grepl('visit.',colnames(D),fixed=TRUE))
  subD=data.frame(pnr=D$pnr,as.data.frame(D)[,datesi])
  out=fastmerge(subD[D$year==Y[1],],subD[D$year==Y[2],],by='pnr')
  colnames(out)=c('pnr',paste(n,Y[1],sep='.'),paste(n,Y[2],sep='.'))
  if(length(Y)>=3) for (k in 3:length(Y)){
    cc=colnames(out)
    out=fastmerge(out,subD[D$year==Y[k],],by='pnr')
    colnames(out)=c(cc,paste(n,Y[k],sep='.'))
  }
  if (na2zero) out[is.na(out)]=0
  out=data.frame(out)
  attr(out,'Y')=Y
  out
}

buildtimeseriesO<-function(G, breaks10, Month=NULL,Year=NULL, before=12, after=24, direct.only=FALSE){
  D=builddates_X(G)
  
  dim(SURVEY)
  has.wave1 = length(which((SURVEY$Wave==1) & (SURVEY$pnr %in% D$pnr)))>0
  
  Da1 = as.data.frame(SURVEY)[which((SURVEY$Wave==1) & (SURVEY$pnr %in% D$pnr)),]
  Da2 = as.data.frame(SURVEY)[which((SURVEY$Wave==2) & (SURVEY$pnr %in% D$pnr)),]
  
  if (has.wave1) {
    table(Da1$pnr %in% Da2$pnr)
    table(Da2$pnr %in% Da1$pnr) 
    table(D$pnr %in% Da1$pnr)
    table(Da1$pnr %in% D$pnr)
    # if (direct.only) Da1 = Da1[which(Da1$directpnr),]
    table(D$pnr %in% Da1$pnr)
    table(Da1$pnr %in% D$pnr)
  }
  
  if (has.wave1) {
    if (direct.only) {
      Da1 = Da1[which(Da1$directpnr),]
      Da2 = Da2[Da2$pnr %in% Da1$pnr,] #must have W1 as has.wave1
    }
    D=as.data.frame(D)[which(D$pnr %in% Da1$pnr),]
    D2=as.data.frame(fastmerge(D,data.frame(pnr=Da1$pnr,
                                            dead.year=Da1$dead.year, 
                                            dead.month=Da1$dead.month,
                                            hhid=Da1$hhid,
                                            surv.year.w1=Da1$year, 
                                            surv.month.w1=Da1$month,
                                            directpnr=Da1$directpnr,
                                            surv.w=Da1$weight_i,
                                            surv.psu=Da1$psu),
                               by='pnr'))
    D2=as.data.frame(fastmerge(D2,data.frame(pnr=Da2$pnr,
                                             surv.year.w2=Da2$year, 
                                             surv.month.w2=Da2$month,
                                             directpnr.w2=Da2$directpnr
    ),by='pnr'))
  } else {
    if (direct.only) Da2 = Da2[which(Da2$directpnr),]
    D=as.data.frame(D)[which(D$pnr %in% Da2$pnr),]
    D2=as.data.frame(fastmerge(D,data.frame(pnr=Da2$pnr,
                                            dead.year=Da2$dead.year, 
                                            dead.month=Da2$dead.month,
                                            hhid=Da2$hhid,
                                            surv.year.w2=Da2$year, 
                                            surv.month.w2=Da2$month,
                                            directpnr=Da2$directpnr,
                                            surv.w=Da2$weight_i,
                                            surv.psu=Da2$psu),
                               by='pnr'))
    D2$surv.month.w1=NA
    D2$surv.year.w1=NA
  }
  
  if (has.wave1 && (length(Month) !=0 || length(Year)!=0)) 
    stop ('Data has wave 1, Month or Year cannot be set.') 
  
  if (!has.wave1){
    if (length(Month) !=0 && length(Year)!=0) {
      D2$surv.year.w1=Year
      D2$surv.month.w1=Month
    } else stop('Data does not have wave 1, Month and Year must be delivered.')
  }
  
  #select from register Wave1 and all pnr asselected  in D2
  regind=(G$year==2004)&(G$pnr%in%D2$pnr)
  table(regind)
  
  D2=fastmerge(D2,G[regind,c('pnr','birth.raw')],by='pnr')
  D2=as.data.frame(D2)
  Yr=range(attributes(D)$Y)
  
  # mark dead as NA
  where_<-function(year, month) (year-Yr[1])*12+month
  maxY=where_(Yr[2],12)
  where_dead<-where_(D2$dead.year,D2$dead.month)
  if (sum(is.na(where_dead))) stop('Problem with deaths, mistake in the code')
  for (g in seq_len(dim(D2)[1])){
    if(where_dead[g]<maxY) D2[g,1+(where_dead[g]:maxY)]=NA
  }
  
  #read 1+4 years
  where_surv_w1=where_(D2$surv.year.w1,D2$surv.month.w1)
  where_surv_w2=where_(D2$surv.year.w2,D2$surv.month.w2)
  
  Age.w1=as.Date(paste(D2$surv.year.w1,'-',D2$surv.month.w1,'-15',sep=''))-as.Date(D2$birth.raw)
  D2$Age2004=as.numeric(Age.w1/365.25)
  D2$ageclass2004=cut(as.numeric(D2$Age2004), breaks=breaks10,
                      include.lowest=TRUE, right = FALSE, labels=breaks10str)
 
  Age.w2=as.Date(paste(D2$surv.year.w2,'-',D2$surv.month.w2,'-15',sep=''))-as.Date(D2$birth.raw)
  D2$Age2006=as.numeric(Age.w2/365.25)
  D2$ageclass2006=cut(as.numeric(D2$Age2006), breaks=breaks10,
                      include.lowest=TRUE, right = FALSE, labels=breaks10str)
 
  D3=matrix(NA,dim(D2)[1],length((-before):after))
  for (g in seq_len(dim(D2)[1])) D3[g,]=unlist(D2[g, 1+((where_surv_w1[g]-before):(where_surv_w1[g]+after))])
  
  #censored at second survey
  D2o=D2
  for (g in seq_len(dim(D2o)[1])){
    if (!is.na(where_surv_w2[g])) D2o[g,1+(where_surv_w2[g]:maxY)]<-NA
  }
  D3o=matrix(NA,dim(D2o)[1],length((-before):after))
  for (g in seq_len(dim(D2o)[1])) D3o[g,]=unlist(D2o[g, 1+((where_surv_w1[g]-before):(where_surv_w1[g]+after))])
  
  return(list(
    notcensored=data.frame(pnr=D2$pnr,
                           hhid=D2$hhid,
                           ageclass2004=D2$ageclass2004,
                           ageclass2006=D2$ageclass2006,
                           directpnr=D2$directpnr,
                           Age2004=D2$Age2004,
                           Age2006=D2$Age2006,
                           weight=D2$surv.w,
                           psu=D2$surv.psu,
                           dead.year=D2$dead.year, 
                           dead.month=D2$dead.month,
                           D3), 
    censored=data.frame(pnr=D2o$pnr,
                        hhid=D2$hhid,
                        ageclass2004=D2o$ageclass2004,
                        ageclass2006=D2o$ageclass2006,
                        directpnr=D2o$directpnr,
                        Age2004=D2o$Age2004,
                        Age2006=D2o$Age2006,
                        weight=D2o$surv.w,
                        psu=D2o$surv.psu,
                        dead.year=D2$dead.year, 
                        dead.month=D2$dead.month,
                        D3o)))
}





