##################################################################################################################
# Function used to generate descriptive statistics
##################################################################################################################

comparegr<-function(group='gender',
                    data = NULL,
                    param='vis',
                    type=c('real','cat'),
                    rtest=c('npar','par'),
                    use.fisher=TRUE,
                    dig=2){
  
  if(!length(data)) stop('No or empty data.')
  type=type[1]
  rtest=rtest[1]
  N=c(Total=length(unlist(data[param])),table(interaction(data[group])))
  data[group]=as.factor(unlist(data[group]))
  if (type=='cat') {
    data[param]=as.factor(unlist(data[param]))
    Z.t = table(data[param])
    Z.p = table(data[group])
    Z.g = table(cbind(data[param],data[group]))
    
    fr=(100*Z.g / t(matrix(rep(Z.p,length(Z.t)),length(Z.p),length(Z.t)))) 
    dimnames(fr)=list()
    colnames(fr)=names(Z.p)
    rownames(fr)=names(Z.t)
    #colSums(fr)
    
    print(Z.g)
    
    build.table<-function(mat,gr) {
      mat=as.matrix(mat)
      if (dim(mat)[1]==2 && dim(mat)[2]==2)
        tmp=rbind(gr=as.matrix(mat)[gr,], alternative=t(as.matrix(mat[-gr,])))
      else
        tmp=rbind(gr=as.matrix(mat)[gr,], alternative=colSums(as.matrix(mat[-gr,])))
      print(tmp)
    }
    
    if (use.fisher) {
      test=lapply(seq_len(NROW(Z.g)),function(k) fisher.test(build.table(Z.g,k)))
      testr=t(sapply(test,function (k) c(Statistic=NA, p=base::format.pval(round(k$p.value,4),digits=4,eps=0.0001,scientific=FALSE))))
      Tfr=data.frame(round(cbind(Total=100*Z.t/sum(Z.t),fr),2),testr,Test='Fisher Exact')
    } else {
      test=lapply(seq_len(NROW(Z.g)),function(k) chisq.test(build.table(Z.g,k)))
      testr=t(sapply(test,function (k) c(Statistic=unname(round(k$statistic,2)), p=base::format.pval(round(k$p.value,4),digits=4,eps=0.0001,scientific=FALSE))))
      Tfr=data.frame(round(cbind(Total=100*Z.t/sum(Z.t),fr),2),testr,Test='Chisq')
    }
    if (dim(Z.g)[1]==dim(Z.g)[2] && dim(Z.g)[1] == 2 && use.fisher) {
      btest=fisher.test(Z.g) 
      btest=c(Statistic=NA,p=base::format.pval(btest$p.value,digits=4,eps=0.0001,scientific=FALSE),Test='Fisher Exact')
    } else {
      btest=chisq.test(Z.g)
      btest=c(Statistic=unname(round(btest$statistic,2)),p=base::format.pval(btest$p.value,digits=4,eps=0.0001,scientific=FALSE),Test='Chisq')
    }
  } else if (type=='real'){
    btest=rep(NA,3)
    val=tn(data[param])
    Mean=c(Total=mean(val,na.rm=TRUE),tapply(val,(interaction(data[group])),mean,na.rm=TRUE))
    Std=c(Total=sd(val,na.rm=TRUE),tapply(val,(interaction(data[group])),sd,na.rm=TRUE))
    ndat=data.frame(dep=val,gr=unlist(data[group]))
    if (rtest=='par'){
      test=t.test(dep~gr,data=ndat)
      testr=c(Statistic=unname(round(test$statistic,2)),p=base::format.pval(test$p.value,digits=4,eps=0.0001,scientific=FALSE),Test='t-test')
    } else if (rtest=='npar') {
      test=wilcox_test(dep~gr,data=ndat) #test=wilcoxsign_test(dep~gr,data=ndat, zero.method="Pratt",distribution="asympt", paired = FALSE)
      testr=c(Statistic=unname(round(test@statistic@teststatistic,2)),p=base::format.pval(pvalue(test),digits=4,eps=0.0001,scientific=FALSE),Test='Wilcoxon-Mann-Whitney')
    } else stop ('Unknown rtest parameter.')
    
    Tfr=data.frame(rbind(round(Mean,dig),round(Std,dig)),(rbind(testr,rep(NA,3))))
    rownames(Tfr)<-c(paste('mean',sep='.'),paste('sd',sep='.'))
  } else stop('Unknown type parameter.')
  Tfr=data.frame(par=param,'  '=rownames(Tfr),Tfr,check.names =FALSE, stringsAsFactors=FALSE)
  rownames(Tfr)=NULL
  list(tab=Tfr,glob=btest)
}

make.table<-function(group='coh',data){
  N=table(data[group])
  data$ageclass2004=droplevels(data$ageclass2004)
  data$ageclass2006=droplevels(data$ageclass2006)
  
  tmp=rbind(
    comparegr(group,data , param='reportedvisits', type=c('real'), rtest=c('npar'), use.fisher=TRUE, dig=2)$tab,
    comparegr(group,data , param='zeroreportedvisits', type=c('cat'), rtest=c('npar'), use.fisher=TRUE, dig=2)$tab,
    comparegr(group,data , param='sex', type=c('cat'), rtest=c('npar'), use.fisher=TRUE, dig=2)$tab,
    comparegr(group,data[data$exposures==max(data$exposures),] , param='visits', type=c('real'), rtest=c('npar'), use.fisher=TRUE, dig=2)$tab,
    comparegr(group,data , param='mvisits', type=c('real'), rtest=c('par'), use.fisher=TRUE, dig=2)$tab,
    comparegr(group,data , param='zerovisits', type=c('cat'), rtest=c('par'), use.fisher=TRUE, dig=2)$tab,
    comparegr(group,data , param='hospvisits', type=c('real'), rtest=c('npar'), use.fisher=TRUE, dig=2)$tab,
    comparegr(group,data , param='Age2004', type=c('real'), rtest=c('par'), use.fisher=TRUE, dig=2)$tab,
    comparegr(group,data , param='ageclass2004', type=c('cat'), use.fisher=TRUE, dig=2)$tab,
    comparegr(group,data , param='has.children', type=c('cat'), use.fisher=TRUE, dig=2)$tab,
    comparegr(group,data , param='nchild', type=c('real'), rtest='npar', use.fisher=TRUE, dig=2)$tab,
    comparegr(group,data , param='edusurv3lv', type=c('cat'), use.fisher=TRUE, dig=2)$tab,
    comparegr(group,data , param='employ', type=c('cat'), use.fisher=TRUE, dig=2)$tab,
    comparegr(group,data , param='income3yB.cat', type=c('cat'), use.fisher=TRUE, dig=2)$tab,
    comparegr(group,data , param='civstat', type=c('cat'), use.fisher=TRUE, dig=2)$tab,
    comparegr(group,data , param='foreigner', type=c('cat'), use.fisher=TRUE, dig=2)$tab)
  rbind(c('Observations','sum',sum(N),N,rep(NA,3)),tmp)
}

mysummary2<-function(model){
  s=summary(model)$coef
  v=rms:::vif(model)
  coefi=cbind('Est.'=s[,1], VIF=c(NA,v), s[,-1])
  coefi=printCoefmat2(coefi, digits = 2, dig.tst=3,
                      signif.stars = TRUE, na.print = "NA", cs.ind=1:3, tst.ind=4, P.values=TRUE, eps.Pvalue=0.0001)
  invisible(coefi)
}

HTMLmod2<-function(model){
  HTML(as.title(form2str(formula(model))))
  HTML(mysummary2(model),Border=0,align='left')
  HTML(paste('<b><font color="red">AIC:',round(AIC(model),2),'</b></font>'))
  HTMLhr()
}

# Modification of the code of printCoefmat {stats package} 
printCoefmat2 <- function (x, digits = max(3L, getOption("digits") - 2L), signif.stars = getOption("show.signif.stars"), 
                           signif.legend = signif.stars, dig.tst = max(1L, min(5L, digits - 
                                                                                 1L)), cs.ind = 1:k, tst.ind = k + 1, zap.ind = integer(), 
                           P.values = NULL, has.Pvalue = nc >= 4L && length(cn <- colnames(x)) && 
                             substr(cn[nc], 1L, 3L) %in% c("Pr(", "p-v"), eps.Pvalue = .Machine$double.eps, 
                           na.print = "NA", ...) 
{
  if (is.null(d <- dim(x)) || length(d) != 2L) 
    stop("'x' must be coefficient matrix/data frame")
  nc <- d[2L]
  if (is.null(P.values)) {
    scp <- getOption("show.coef.Pvalues")
    if (!is.logical(scp) || is.na(scp)) {
      warning("option \"show.coef.Pvalues\" is invalid: assuming TRUE")
      scp <- TRUE
    }
    P.values <- has.Pvalue && scp
  }
  else if (P.values && !has.Pvalue) 
    stop("'P.values' is TRUE, but 'has.Pvalue' is not")
  if (has.Pvalue && !P.values) {
    d <- dim(xm <- data.matrix(x[, -nc, drop = FALSE]))
    nc <- nc - 1
    has.Pvalue <- FALSE
  }
  else xm <- data.matrix(x)
  k <- nc - has.Pvalue - (if (missing(tst.ind)) 
    1
    else length(tst.ind))
  if (!missing(cs.ind) && length(cs.ind) > k) 
    stop("wrong k / cs.ind")
  Cf <- array("", dim = d, dimnames = dimnames(xm))
  ok <- !(ina <- is.na(xm))
  for (i in zap.ind) xm[, i] <- zapsmall(xm[, i], digits)
  if (length(cs.ind)) {
    acs <- abs(coef.se <- xm[, cs.ind, drop = FALSE])
    if (any(ia <- is.finite(acs))) {
      digmin <- 1 + if (length(acs <- acs[ia & acs != 0])) 
        floor(log10(range(acs[acs != 0], finite = TRUE)))
      else 0
      Cf[, cs.ind] <- format(round(coef.se, max(1L, digits - 
                                                  digmin)), digits = digits)
    }
  }
  if (length(tst.ind)) 
    Cf[, tst.ind] <- format(round(xm[, tst.ind], digits = dig.tst), 
                            digits = digits)
  if (any(r.ind <- !((1L:nc) %in% c(cs.ind, tst.ind, if (has.Pvalue) nc)))) 
    for (i in which(r.ind)) Cf[, i] <- format(xm[, i], digits = digits)
  ok[, tst.ind] <- FALSE
  okP <- if (has.Pvalue) 
    ok[, -nc]
  else ok
  x1 <- Cf[okP]
  dec <- getOption("OutDec")
  if (dec != ".") 
    x1 <- chartr(dec, ".", x1)
  x0 <- (xm[okP] == 0) != (as.numeric(x1) == 0)
  if (length(not.both.0 <- which(x0 & !is.na(x0)))) {
    Cf[okP][not.both.0] <- format(xm[okP][not.both.0], digits = max(1L, 
                                                                    digits - 1L))
  }
  if (any(ina)) 
    Cf[ina] <- na.print
  if (P.values) {
    if (!is.logical(signif.stars) || is.na(signif.stars)) {
      warning("option \"show.signif.stars\" is invalid: assuming TRUE")
      signif.stars <- TRUE
    }
    if (any(okP <- ok[, nc])) {
      pv <- as.vector(xm[, nc])
      Cf[okP, nc] <- format.pval(pv[okP], digits = dig.tst, 
                                 eps = eps.Pvalue)
      signif.stars <- signif.stars && any(pv[okP] < 0.1)
      if (signif.stars) {
        Signif <- symnum(pv, corr = FALSE, na = FALSE, 
                         cutpoints = c(0, 0.001, 0.01, 0.05, 0.1, 1), 
                         symbols = c("***", "**", "*", ".", " "))
        Cf <- cbind(Cf, format(Signif))
      }
    }
    else signif.stars <- FALSE
  }
  else signif.stars <- FALSE
  print.default(Cf, quote = FALSE, right = TRUE, na.print = na.print, 
                ...)
  if (signif.stars && signif.legend) {
    if ((w <- getOption("width")) < nchar(sleg <- attr(Signif, 
                                                       "legend"))) 
      sleg <- strwrap(sleg, width = w - 2, prefix = "  ")
    cat("---\nSignif. codes:  ", sleg, sep = "", fill = w + 
          4 + max(nchar(sleg, "bytes") - nchar(sleg)))
  }
  invisible(Cf)
}

mysummary<-function(model){
  s=summary(model)$coef
  v=rms:::vif(model)
  coefi=cbind('Est.'=s[,1], 'exp(Est.)'=exp(s[,1]), VIF=c(NA,v), s[,-1])
  coefi=printCoefmat2(coefi, digits = 2, dig.tst=3,
                      signif.stars = TRUE, na.print = "NA", cs.ind=1:4, tst.ind=5, P.values=TRUE, eps.Pvalue=0.0001)
  invisible(coefi)
}

mysummary_rnd_coef<-function(model){
  s=summary(model)$coef
  coefi=cbind('Est.'=s[,1], 'exp(Est.)'=exp(s[,1]), s[,-1])
  coefi=printCoefmat2(round(coefi,4), digits = 4, dig.tst=4,
                      signif.stars = TRUE, na.print = "NA", cs.ind=1:3, tst.ind=4, P.values=TRUE, eps.Pvalue=0.0001)
  invisible(coefi)
}

mysummary_rnd_coef_TMB<-function(model){
  s=summary(model)$coefficients[[1]]
  coefi=cbind('Est.'=s[,1], 'exp(Est.)'=exp(s[,1]), s[,-1])
  coefi=printCoefmat2(round(coefi,4), digits = 4, dig.tst=4,
                      signif.stars = TRUE, na.print = "NA", cs.ind=1:3, tst.ind=4, P.values=TRUE, eps.Pvalue=0.0001)
  invisible(coefi)
}

form2str<-function (x) 
{
  e <- environment(.x <- x)
  attr(x, ".Environment") <- NULL
  paste(as.character(unclass(x))[c(2,1,3)],collapse = ' ')
}

HTMLmod<-function(model){
  HTML(as.title(form2str(formula(model))))
  HTML(mysummary(model),Border=0,align='left')
  HTML(paste('<b><font color="red">AIC:',round(AIC(model),2),'</b></font>'))
  HTMLhr()
}

HTMLmod_rnd<-function(model){
  HTML(as.title(form2str(formula(model))))
  HTML(mysummary_rnd_coef(model),Border=0,align='left')
  HTML(paste('<b><font color="red">AIC:',round(AIC(model),2),'</b></font>'))
  HTMLhr()
}

HTMLmod_rnd_TMB<-function(model){
  HTML(as.title(form2str(formula(model))))
  HTML(mysummary_rnd_coef_TMB(model),Border=0,align='left')
  HTML(paste('<b><font color="red">AIC:',round(AIC(model),2),'</b></font>'))
  HTMLhr()
}
