# Need SURVEY to be loaded

load(file=paste(SAVE_DIR,'hospU.dat',sep=''))
hospital=HOSPITAL[(HOSPITAL$pnr %in% ind.w1) | (HOSPITAL$pnr %in% ind.w2),]

# wave - only pnr for specified wave
hospitalsurvey<-function(Wave, mspan=24,Year=NULL,Month=NULL){
  hosp=hospital[hospital$pnr %in% as.character(SURVEY$pnr)[SURVEY$Wave %in% Wave],]
  DAT=data.frame(pnr=SURVEY$pnr, year=SURVEY$year, month=SURVEY$month) # don't care about deaths as always interested in pre
  DAT=DAT[SURVEY$Wave %in% Wave,]
  hosp=fastmerge(DAT,hosp,by='pnr')
  if (length(Year) && length(Month)) { #no info for Wave 1 in SURVEY
    hosp$year=Year
    hosp$month=Month
  }
  hosp[is.na(hosp)]=0
  hosp=as.data.frame(hosp)
  y0=2001
  d2p<-function(y,m) sort((y-y0)*12+m - (1:mspan)-1)
  d2p(2004,1)
  (d2p(2002,9) %% 12)+1
  hospv=matrix(0,NROW(hosp),mspan)
  for (u in seq_len(NROW(hosp))) {
    hospv[u,1:mspan]=unlist(hosp[u,3+d2p(hosp$year[u],hosp$month[u])])# +3 -> pnr, year, month
  }
  data.frame(pnr=hosp$pnr, hospvisits=rowSums(hospv), hv=hospv, syear=hosp$year, smonth=hosp$month)
}

H1=hospitalsurvey(Wave=1) # measured before wave 1 surv dates, pnr present in wave 1
H2=hospitalsurvey(Wave=2) # measured before wave 2 surv dates, pnr present in wave 2

