# Some usefull functions

# Merging to data frames
fastmerge<-function(DF1, DF2, by, all.x = TRUE, all.y = TRUE) {
  DT1 = data.table(DF1, key=by)
  DT2 = data.table(DF2, key=by)
  data.table:::merge.data.table(DT1,DT2, all.x = all.x, all.y = all.y)
}

# Fisher test
fishtest<-function(param,group,data){
  data[param]=as.factor(unlist(data[param]))
  Z.t = table(data[param])
  Z.p = table(data[group])
  Z.g = table(cbind(data[param],data[group]))
  fr=(100*Z.g / t(matrix(rep(Z.p,length(Z.t)),length(Z.p),length(Z.t)))) 
  list(test=fisher.test(Z.g),Z.t=100*Z.t/sum(Z.t),fr=fr)
}

# Data format and data tools
ti<-function(x) as.numeric(as.character(x))
tn<-function(x) as.numeric(as.character(unlist(x)))
'%!in%' <- function(a,b) (!(a%in%b))
absna<-function(x) {x[x<0]=NA; x}
emptyna<-function(x) if (length(x)) x else NA
empty2NA <- function (x) if (length(x)==0) NA else x[1]
NA2FALSE<-function(x) {x[is.na(x)]=FALSE; x}
nchr<- function(x) nchar(as.character(x))
