################################################################################
# plots used in the manuscript
# see data_plots.R for data pre-processing
# data loaded here already is the pre-processed data
################################################################################

################################################################################
library(ggplot2)

load("Data/allData.RData")

source("functions.R")
################################################################################
###

txt.scale = .8

################################################################################
###England
                                                                                
axis_size = 30
facet_size = 38*txt.scale
label_size = 42*txt.scale
space_facet = 2
point_size = 4
legend_text = 18
max_lim = 0.75

# note: Green is only used in the code as pseude-placeholder, it is "others"
levels(eng_data_scat$party)[5] = "OTHERS"

pdf("Figures/fig1.pdf", width = 1.5*14, height = 1.5*7)                                            
  ggplot(eng_data_scat, aes(share_aggr, share_indi)) + 
    geom_point(size = point_size) + geom_point(aes(colour = factor(party))) +
    facet_grid(election_name ~ party) +
    xlab("\n aggregate data") + ylab("individual data \n") +
    xlim(0, max_lim) + ylim(0, max_lim) +
    scale_colour_manual(values = c("blue", "red", "orange", "purple", "gray80", "dimgrey"),
                        guide = FALSE) +
    geom_abline(intercept = 0, slope = 1, linetype = "dashed", size = 1.5) +
    theme(axis.text.x = element_text(size = axis_size, angle = -90, vjust = 0.2),
          axis.text.y = element_text(size = axis_size),
          axis.title.x = element_text(size = label_size),
          axis.title.y = element_text(size = label_size),
          strip.text.y = element_text(size = facet_size),
          strip.text.x = element_text(size = facet_size),
          panel.spacing = unit(space_facet, "lines")) 
dev.off()


################################################################################
###Scotland

axis_size = 30
facet_size = 38*txt.scale
label_size = 42*txt.scale
space_facet = 2
point_size = 5
legend_text = 18
max_lim = 0.75

levels(sco_data_scat$party)[4] = "OTHERS"

pdf("Figures/figa1a.pdf", width = 1.5*14, height = 1.5*7)
  ggplot(sco_data_scat, aes(share_aggr, share_indi)) + 
    geom_point(size = point_size) + geom_point(aes(colour = factor(party))) +
    facet_grid(election_name ~ party) +
    xlab("\n aggregate data") + ylab("individual data \n") +
    xlim(0, max_lim) + ylim(0, max_lim) +
    scale_colour_manual(values = c("blue", "red", "yellow", "gray80", "dimgrey"),
                        guide = FALSE) +
    geom_abline(intercept = 0, slope = 1, linetype = "dashed", size = 1.5) +
    theme(axis.text.x = element_text(size = axis_size, angle = -90, vjust = 0.2),
          axis.text.y = element_text(size = axis_size),
          axis.title.x = element_text(size = label_size),
          axis.title.y = element_text(size = label_size),
          strip.text.y = element_text(size = facet_size),
          strip.text.x = element_text(size = facet_size),
          panel.spacing = unit(space_facet, "lines")) 
dev.off()

################################################################################
###Wales

axis_size = 30
facet_size = 38*txt.scale
label_size = 42*txt.scale
space_facet = 2
point_size = 5
legend_text = 18
max_lim = 0.75

levels(wal_data_scat$party)[4] = "OTHERS"

pdf("Figures/figa1b.pdf", width = 1.5*14, height = 1.5*7)
  ggplot(wal_data_scat, aes(share_aggr, share_indi)) + 
    geom_point(size = point_size) + geom_point(aes(colour = factor(party))) +
    facet_grid(election_name ~ party) +
    xlab("\n aggregate data") + ylab("individual data \n") +
    xlim(0, max_lim) + ylim(0, max_lim) +
    scale_colour_manual(values = c("blue", "red", "deepskyblue", "gray80", "dimgrey"),
                        guide = FALSE) +
    geom_abline(intercept = 0, slope = 1, linetype = "dashed", size = 1.5) +
    theme(axis.text.x = element_text(size = axis_size, angle = -90, vjust = 0.2),
          axis.text.y = element_text(size = axis_size),
          axis.title.x = element_text(size = label_size),
          axis.title.y = element_text(size = label_size),
          strip.text.y = element_text(size = facet_size),
          strip.text.x = element_text(size = facet_size),
          panel.spacing = unit(space_facet, "lines")) 
dev.off()


################################################################################
#### Transition Flows

### England
rownames(sum_abs_mod_eng_hyb_6part_1)[5] = "OTHERS_1"
colnames(sum_abs_mod_eng_hyb_6part_1)[5] = "OTHERS_2"

pdf("Figures/fig2a.pdf", width = 1.5*14, height = 1.5*7)
  coll = c("white", rep("black", 4), "white")
  colv <- c("blue", "red", "orange", "purple", "gray80", "dimgrey")
  plot.sald.grid(sum_abs_mod_eng_hyb_6part_1, colv1 = colv,
                 colv2 = colv, coll1 = coll, coll2 = coll, 
                 cex.axis = 2.5, cex.text = 3)
dev.off()

### Scotland
rownames(sum_abs_mod_sco_hyb_5part_1)[5] = "OTHERS_1"
colnames(sum_abs_mod_sco_hyb_5part_1)[5] = "OTHERS_2"

pdf("Figures/fig2b.pdf", width = 1.5*14, height = 1.5*7)
  coll_sco = c("white", rep("black", 2), "white", "black")
  colv_sco <- c("blue", "red", "yellow", "dimgrey", "gray80")
  plot.sald.grid(sum_abs_mod_sco_hyb_5part_1, colv1 = colv_sco, 
                 colv2 = colv_sco, coll1 = coll_sco, coll2 = coll_sco, 
                 cex.axis = 2.5, cex.text = 3, min.txt = 0.5)
dev.off()

###Wales
rownames(sum_abs_mod_wal_hyb_5part_1)[5] = "OTHERS_1"
colnames(sum_abs_mod_wal_hyb_5part_1)[5] = "OTHERS_2"

pdf("Figures/fig2c.pdf", width = 1.5*14, height = 1.5*7)
  coll_wal = c("white", rep("black", 2), "white", "black")
  colv_wal <- c("blue", "red", "deepskyblue", "dimgrey", "gray80")
  plot.sald.grid(sum_abs_mod_wal_hyb_5part_1, colv1 = colv_wal, 
                 colv2 = colv_wal, coll1 = coll_wal, coll2 = coll_wal, 
                 cex.axis = 2.5, cex.text = 3)
dev.off()


################################################################################
#### Convergence Diagnostics
                                                                                
### England
## HHMD
pdf("Figures/figa2a.pdf", width = 1.5*14, height = 1.5*7)
  lwd = 2.5
  cex.main = 4
  cex.axis = 3
  alpha.f = 0.7
  col_trans <- adjustcolor("green", alpha.f = alpha.f) 
  layout(matrix(c(1, 2, 3, 4), ncol = 1, byrow = TRUE), heights = c(1, 1, 1, 1))
  par(mar = c(3.5, 11, 4.1, 2.1))
  plot(1:1000, as.numeric(mod_eng_hyb_6part_1$draws$cellCounts[, 1]), 
       type = "l", col = "black", ylab = "", xlab = "",
       main = "CON - CON", lwd = lwd, cex.main = cex.main, 
       cex.axis = cex.axis, xaxt = "n", yaxt = "n")
  axis(1, las = 0, cex.axis = cex.axis, tck = -0.04)
  axis(2, las = 2, cex.axis = cex.axis)
  lines(1:1000, as.numeric(mod_eng_hyb_6part_2$draws$cellCounts[, 1]), 
        type = "l", col = col_trans, lwd = lwd, cex.main = cex.main, 
        cex.axis = cex.axis)
  plot(1:1000, as.numeric(mod_eng_hyb_6part_1$draws$cellCounts[, 2]), 
       type = "l", col = "black", ylab = "", xlab = "",
       main = "LAB - CON", lwd = lwd, cex.main = cex.main, 
       cex.axis = cex.axis, xaxt = "n", yaxt = "n")
  axis(1, las = 0, cex.axis = cex.axis)
  axis(2, las = 2, cex.axis = cex.axis)
  lines(1:1000, as.numeric(mod_eng_hyb_6part_2$draws$cellCounts[, 2]), 
        type = "l", col = col_trans, lwd = lwd, cex.main = cex.main, 
        cex.axis = cex.axis)
  plot(1:1000, as.numeric(mod_eng_hyb_6part_1$draws$cellCounts[, 16]), 
       type = "l", col = "black", ylab = "", xlab = "",
       main = "UKIP - LD", lwd = lwd, cex.main = cex.main, 
       cex.axis = cex.axis, xaxt = "n", yaxt = "n")
  axis(1, las = 0, cex.axis = cex.axis)
  axis(2, las = 2, cex.axis = cex.axis)
  lines(1:1000, as.numeric(mod_eng_hyb_6part_2$draws$cellCounts[, 16]), 
        type = "l", col = col_trans, lwd = lwd, cex.main = cex.main, 
        cex.axis = cex.axis)
  plot(1:1000, as.numeric(mod_eng_hyb_6part_1$draws$cellCounts[, 23]), 
       type = "l", col = "black", ylab = "", xlab = "",
       main = "OTHERS - UKIP", lwd = lwd, cex.main = cex.main,
       cex.axis = cex.axis, xaxt = "n", yaxt = "n")
  axis(1, las = 0, cex.axis = cex.axis)
  axis(2, las = 2, cex.axis = cex.axis)
  lines(1:1000, as.numeric(mod_eng_hyb_6part_2$draws$cellCounts[, 23]), 
        type = "l", col = col_trans, lwd = lwd, cex.main = cex.main, 
        cex.axis = cex.axis)
dev.off()

## EI
pdf("Figures/figa3a.pdf", width = 1.5*14, height = 1.5*7)
  lwd = 2.5
  cex.main = 4
  cex.axis = 3
  alpha.f = 0.7
  col_trans <- adjustcolor("green", alpha.f = alpha.f) 
  layout(matrix(c(1, 2, 3, 4), ncol = 1, byrow = TRUE), heights = c(1, 1, 1, 1))
  par(mar = c(3.5, 11, 4.1, 2.1))
  plot(1:1000, as.numeric(mod_eng_eco_6part_1$draws$cellCounts[, 1]), 
       type = "l", col = "black", ylab = "", xlab = "",
       main = "CON - CON", lwd = lwd, cex.main = cex.main, 
       cex.axis = cex.axis, xaxt = "n", yaxt = "n")
  axis(1, las = 0, cex.axis = cex.axis, tck = -0.04)
  axis(2, las = 2, cex.axis = cex.axis)
  lines(1:1000, as.numeric(mod_eng_eco_6part_2$draws$cellCounts[, 1]), 
        type = "l", col = col_trans, lwd = lwd, cex.main = cex.main, 
        cex.axis = cex.axis)
  plot(1:1000, as.numeric(mod_eng_eco_6part_1$draws$cellCounts[, 2]), 
       type = "l", col = "black", ylab = "", xlab = "",
       main = "LAB - CON", lwd = lwd, cex.main = cex.main, 
       cex.axis = cex.axis, xaxt = "n", yaxt = "n")
  axis(1, las = 0, cex.axis = cex.axis)
  axis(2, las = 2, cex.axis = cex.axis)
  lines(1:1000, as.numeric(mod_eng_eco_6part_2$draws$cellCounts[, 2]), 
        type = "l", col = col_trans, lwd = lwd, cex.main = cex.main, 
        cex.axis = cex.axis)
  plot(1:1000, as.numeric(mod_eng_eco_6part_1$draws$cellCounts[, 16]), 
       type = "l", col = "black", ylab = "", xlab = "",
       main = "UKIP - LD", lwd = lwd, cex.main = cex.main, 
       cex.axis = cex.axis, xaxt = "n", yaxt = "n")
  axis(1, las = 0, cex.axis = cex.axis)
  axis(2, las = 2, cex.axis = cex.axis)
  lines(1:1000, as.numeric(mod_eng_eco_6part_2$draws$cellCounts[, 16]), 
        type = "l", col = col_trans, lwd = lwd, cex.main = cex.main, 
        cex.axis = cex.axis)
  plot(1:1000, as.numeric(mod_eng_eco_6part_1$draws$cellCounts[, 23]), 
       type = "l", col = "black", ylab = "", xlab = "",
       main = "OTHERS - UKIP", lwd = lwd, cex.main = cex.main,
       cex.axis = cex.axis, xaxt = "n", yaxt = "n")
  axis(1, las = 0, cex.axis = cex.axis)
  axis(2, las = 2, cex.axis = cex.axis)
  lines(1:1000, as.numeric(mod_eng_eco_6part_2$draws$cellCounts[, 23]), 
        type = "l", col = col_trans, lwd = lwd, cex.main = cex.main, 
        cex.axis = cex.axis)
dev.off()


###Scotland
## HHMD
pdf("Figures/figa2b.pdf", width = 1.5*14, height = 1.5*7)
  lwd = 2.5
  cex.main = 4
  cex.axis = 3
  alpha.f = 0.7
  col_trans <- adjustcolor("green", alpha.f = alpha.f) 
  layout(matrix(c(1, 2, 3, 4), ncol = 1, byrow = TRUE), heights = c(1, 1, 1, 1))
  par(mar = c(3.5, 11, 4.1, 2.1))
  plot(1:1000, as.numeric(mod_sco_hyb_5part_1$draws$cellCounts[, 1]), 
       type = "l", col = "black", ylab = "", xlab = "",
       main = "CON - CON", lwd = lwd, cex.main = cex.main,
       cex.axis = cex.axis, xaxt = "n", yaxt = "n")
  axis(1, las = 0, cex.axis = cex.axis, tck = -0.04)
  axis(2, las = 2, cex.axis = cex.axis)
  lines(1:1000, as.numeric(mod_sco_hyb_5part_2$draws$cellCounts[, 1]), 
        type = "l", col = col_trans, lwd = lwd, cex.main = cex.main, 
        cex.axis = cex.axis)
  plot(1:1000, as.numeric(mod_sco_hyb_5part_1$draws$cellCounts[, 2]), 
       type = "l", col = "black", ylab = "", xlab = "",
       main = "LAB - CON", lwd = lwd, cex.main = cex.main,
       cex.axis = cex.axis, xaxt = "n", yaxt = "n")
  axis(1, las = 0, cex.axis = cex.axis)
  axis(2, las = 2, cex.axis = cex.axis)
  lines(1:1000, as.numeric(mod_sco_hyb_5part_2$draws$cellCounts[, 2]), 
        type = "l", col = col_trans, lwd = lwd, cex.main = cex.main, 
        cex.axis = cex.axis)
  plot(1:1000, as.numeric(mod_sco_hyb_5part_1$draws$cellCounts[, 8]), 
       type = "l", col = "black", ylab = "", xlab = "",
       main = "SNP - LAB", lwd = lwd, cex.main = cex.main,
       cex.axis = cex.axis, xaxt = "n", yaxt = "n")
  axis(1, las = 0, cex.axis = cex.axis)
  axis(2, las = 2, cex.axis = cex.axis)
  lines(1:1000, as.numeric(mod_sco_hyb_5part_2$draws$cellCounts[, 8]), 
        type = "l", col = col_trans, lwd = lwd, cex.main = cex.main, 
        cex.axis = cex.axis)
  plot(1:1000, as.numeric(mod_sco_hyb_5part_1$draws$cellCounts[, 20]), 
       type = "l", col = "black", ylab = "", xlab = "",
       main = "OTHER - ABSTAIN", lwd = lwd, cex.main = cex.main,
       cex.axis = cex.axis, xaxt = "n", yaxt = "n")
  axis(1, las = 0, cex.axis = cex.axis)
  axis(2, las = 2, cex.axis = cex.axis)
  lines(1:1000, as.numeric(mod_sco_hyb_5part_2$draws$cellCounts[, 20]), 
        type = "l", col = col_trans, lwd = lwd, cex.main = cex.main, 
        cex.axis = cex.axis)
dev.off()

## EI
pdf("Figures/figa3b.pdf", width = 1.5*14, height = 1.5*7)
  lwd = 2.5
  cex.main = 4
  cex.axis = 3
  alpha.f = 0.7
  col_trans <- adjustcolor("green", alpha.f = alpha.f) 
  layout(matrix(c(1, 2, 3, 4), ncol = 1, byrow = TRUE), heights = c(1, 1, 1, 1))
  par(mar = c(3.5, 11, 4.1, 2.1))
  plot(1:1000, as.numeric(mod_sco_eco_5part_1$draws$cellCounts[, 1]), 
       type = "l", col = "black", ylab = "", xlab = "",
       main = "CON - CON", lwd = lwd, cex.main = cex.main,
       cex.axis = cex.axis, xaxt = "n", yaxt = "n")
  axis(1, las = 0, cex.axis = cex.axis, tck = -0.04)
  axis(2, las = 2, cex.axis = cex.axis)
  lines(1:1000, as.numeric(mod_sco_eco_5part_2$draws$cellCounts[, 1]), 
        type = "l", col = col_trans, lwd = lwd, cex.main = cex.main, 
        cex.axis = cex.axis)
  plot(1:1000, as.numeric(mod_sco_eco_5part_1$draws$cellCounts[, 2]), 
       type = "l", col = "black", ylab = "", xlab = "",
       main = "LAB - CON", lwd = lwd, cex.main = cex.main,
       cex.axis = cex.axis, xaxt = "n", yaxt = "n")
  axis(1, las = 0, cex.axis = cex.axis)
  axis(2, las = 2, cex.axis = cex.axis)
  lines(1:1000, as.numeric(mod_sco_eco_5part_2$draws$cellCounts[, 2]), 
        type = "l", col = col_trans, lwd = lwd, cex.main = cex.main, 
        cex.axis = cex.axis)
  plot(1:1000, as.numeric(mod_sco_eco_5part_1$draws$cellCounts[, 8]), 
       type = "l", col = "black", ylab = "", xlab = "",
       main = "SNP - LAB", lwd = lwd, cex.main = cex.main,
       cex.axis = cex.axis, xaxt = "n", yaxt = "n")
  axis(1, las = 0, cex.axis = cex.axis)
  axis(2, las = 2, cex.axis = cex.axis)
  lines(1:1000, as.numeric(mod_sco_eco_5part_2$draws$cellCounts[, 8]), 
        type = "l", col = col_trans, lwd = lwd, cex.main = cex.main, 
        cex.axis = cex.axis)
  plot(1:1000, as.numeric(mod_sco_eco_5part_1$draws$cellCounts[, 20]), 
       type = "l", col = "black", ylab = "", xlab = "",
       main = "OTHER - ABSTAIN", lwd = lwd, cex.main = cex.main,
       cex.axis = cex.axis, xaxt = "n", yaxt = "n")
  axis(1, las = 0, cex.axis = cex.axis)
  axis(2, las = 2, cex.axis = cex.axis)
  lines(1:1000, as.numeric(mod_sco_eco_5part_2$draws$cellCounts[, 20]), 
        type = "l", col = col_trans, lwd = lwd, cex.main = cex.main, 
        cex.axis = cex.axis)
dev.off()

###Wales
## HHMD
pdf("Figures/figa2c.pdf", width = 1.5*14, height = 1.5*7)
  lwd = 2.5
  cex.main = 4
  cex.axis = 3
  alpha.f = 0.7
  col_trans <- adjustcolor("green", alpha.f = alpha.f) 
  layout(matrix(c(1, 2, 3, 4), ncol = 1, byrow = TRUE), heights = c(1, 1, 1, 1))
  par(mar = c(3.5, 11, 4.1, 2.1))
  plot(1:1000, as.numeric(mod_wal_hyb_5part_1$draws$cellCounts[, 1]), 
       type = "l", col = "black", ylab = "", xlab = "",
       main = "CON - CON", lwd = lwd, cex.main = cex.main,
       cex.axis = cex.axis, xaxt = "n", yaxt = "n")
  axis(1, las = 0, cex.axis = cex.axis, tck = -0.04)
  axis(2, las = 2, cex.axis = cex.axis)
  lines(1:1000, as.numeric(mod_wal_hyb_5part_2$draws$cellCounts[, 1]), 
        type = "l", col = col_trans, lwd = lwd, cex.main = cex.main, 
        cex.axis = cex.axis)
  plot(1:1000, as.numeric(mod_wal_hyb_5part_1$draws$cellCounts[, 2]), 
       type = "l", col = "black", ylab = "", xlab = "",
       main = "LAB - CON", lwd = lwd, cex.main = cex.main,
       cex.axis = cex.axis, xaxt = "n", yaxt = "n")
  axis(1, las = 0, cex.axis = cex.axis)
  axis(2, las = 2, cex.axis = cex.axis)
  lines(1:1000, as.numeric(mod_wal_hyb_5part_2$draws$cellCounts[, 2]), 
        type = "l", col = col_trans, lwd = lwd, cex.main = cex.main, 
        cex.axis = cex.axis)
  plot(1:1000, as.numeric(mod_wal_hyb_5part_1$draws$cellCounts[, 8]), 
       type = "l", col = "black", ylab = "", xlab = "",
       main = "PC - LAB", lwd = lwd, cex.main = cex.main,
       cex.axis = cex.axis, xaxt = "n", yaxt = "n")
  axis(1, las = 0, cex.axis = cex.axis)
  axis(2, las = 2, cex.axis = cex.axis)
  lines(1:1000, as.numeric(mod_wal_hyb_5part_2$draws$cellCounts[, 8]), 
        type = "l", col = col_trans, lwd = lwd, cex.main = cex.main, 
        cex.axis = cex.axis)
  plot(1:1000, as.numeric(mod_wal_hyb_5part_1$draws$cellCounts[, 14]), 
       type = "l", col = "black", ylab = "", xlab = "",
       main = "ABSTAIN - PC", lwd = lwd, cex.main = cex.main,
       cex.axis = cex.axis, xaxt = "n", yaxt = "n")
  axis(1, las = 0, cex.axis = cex.axis)
  axis(2, las = 2, cex.axis = cex.axis)
  lines(1:1000, as.numeric(mod_wal_hyb_5part_2$draws$cellCounts[, 14]), 
        type = "l", col = col_trans, lwd = lwd, cex.main = cex.main, 
        cex.axis = cex.axis)
dev.off()

## EI
pdf("Figures/figa3c.pdf", width = 1.5*14, height = 1.5*7)
  lwd = 2.5
  cex.main = 4
  cex.axis = 3
  alpha.f = 0.7
  col_trans <- adjustcolor("green", alpha.f = alpha.f) 
  layout(matrix(c(1, 2, 3, 4), ncol = 1, byrow = TRUE), heights = c(1, 1, 1, 1))
  par(mar = c(3.5, 11, 4.1, 2.1))
  plot(1:1000, as.numeric(mod_wal_eco_5part_1$draws$cellCounts[, 1]), 
       type = "l", col = "black", ylab = "", xlab = "",
       main = "CON - CON", lwd = lwd, cex.main = cex.main,
       cex.axis = cex.axis, xaxt = "n", yaxt = "n")
  axis(1, las = 0, cex.axis = cex.axis, tck = -0.04)
  axis(2, las = 2, cex.axis = cex.axis)
  lines(1:1000, as.numeric(mod_wal_eco_5part_2$draws$cellCounts[, 1]), 
        type = "l", col = col_trans, lwd = lwd, cex.main = cex.main, 
        cex.axis = cex.axis)
  plot(1:1000, as.numeric(mod_wal_eco_5part_1$draws$cellCounts[, 2]), 
       type = "l", col = "black", ylab = "", xlab = "",
       main = "LAB - CON", lwd = lwd, cex.main = cex.main,
       cex.axis = cex.axis, xaxt = "n", yaxt = "n")
  axis(1, las = 0, cex.axis = cex.axis)
  axis(2, las = 2, cex.axis = cex.axis)
  lines(1:1000, as.numeric(mod_wal_eco_5part_2$draws$cellCounts[, 2]), 
        type = "l", col = col_trans, lwd = lwd, cex.main = cex.main, 
        cex.axis = cex.axis)
  plot(1:1000, as.numeric(mod_wal_eco_5part_1$draws$cellCounts[, 8]), 
       type = "l", col = "black", ylab = "", xlab = "",
       main = "PC - LAB", lwd = lwd, cex.main = cex.main,
       cex.axis = cex.axis, xaxt = "n", yaxt = "n")
  axis(1, las = 0, cex.axis = cex.axis)
  axis(2, las = 2, cex.axis = cex.axis)
  lines(1:1000, as.numeric(mod_wal_eco_5part_2$draws$cellCounts[, 8]), 
        type = "l", col = col_trans, lwd = lwd, cex.main = cex.main, 
        cex.axis = cex.axis)
  plot(1:1000, as.numeric(mod_wal_eco_5part_1$draws$cellCounts[, 14]), 
       type = "l", col = "black", ylab = "", xlab = "",
       main = "ABSTAIN - PC", lwd = lwd, cex.main = cex.main,
       cex.axis = cex.axis, xaxt = "n", yaxt = "n")
  axis(1, las = 0, cex.axis = cex.axis)
  axis(2, las = 2, cex.axis = cex.axis)
  lines(1:1000, as.numeric(mod_wal_eco_5part_2$draws$cellCounts[, 14]), 
        type = "l", col = col_trans, lwd = lwd, cex.main = cex.main, 
        cex.axis = cex.axis)
dev.off()
