################################################################################
#
# calculating the HHMD models
#
# all calculated models available in: models_results.RData
#
################################################################################

################################################################################
source("functions.R")

load("Data/besip.RData")

library(readstata13)
library(eiwild)

#################### model parameters ####################
election_names <- c("10", "15")
sample <- 1000
maxiter = 35
verbose = 10

################################################################################
#################### England ####################

# note: Green is only used in the code as pseude-placeholder, it is "others"
# parties
parties_all   <- c("CON", "LAB", "LD", "UKIP", "GREEN", "PC", "SNP") 
parties_eng_6 <- c("CON", "LAB", "LD", "UKIP", "GREEN") 
burnin_eng    <- 500000
thinning_eng  <- 2000

# subset data
besip_15_eng  <- besip_15[besip_15$eng == 1, ]

# 1.) ecological, 6 parties, with tuneVars, no individual prio
list_eng_eco_6part_1 <- besip_model(besip_15_eng, country = "eng", 
                                    election_names = election_names, 
                                    individual = FALSE, parties = parties_eng_6,
                                    sample = sample, thinning = thinning_eng,
                                    tune_vars = TRUE, maxiter = maxiter, 
                                    burnin = burnin_eng, verbose = verbose)
mod_eng_eco_6part_1 <- list_eng_eco_6part_1$model
sum_abs_mod_eng_eco_6part_1 = summary(mod_eng_eco_6part_1)$absolut
sum_rel_mod_eng_eco_6part_1 = summary(mod_eng_eco_6part_1)$relative
alphaVars_eng_eco_6part <- list_eng_eco_6part_1$alphaVars
betaVars_eng_eco_6part <- list_eng_eco_6part_1$betaVars
plot(mod_eng_eco_6part_1, whichPlot = 1, whichCell = c(1:9))
plot(mod_eng_eco_6part_1, whichPlot = 1, whichCell = c(10:18))
plot(mod_eng_eco_6part_1, whichPlot = 1, whichCell = c(19:25))
plot(mod_eng_eco_6part_1, whichPlot = 1, whichCell = c(26:31))
plot(mod_eng_eco_6part_1, whichPlot = 1, whichCell = c(32:36))


list_eng_eco_6part_2 <- besip_model(besip_15_eng, country = "eng", 
                                    election_names = election_names, 
                                    individual = FALSE, parties = parties_eng_6,
                                    sample = sample, thinning = thinning_eng,
                                    tune_vars = FALSE, 
                                    alphaVars = alphaVars_eng_eco_6part, 
                                    betaVars = betaVars_eng_eco_6part,
                                    burnin = burnin_eng, verbose = verbose)
mod_eng_eco_6part_2 <- list_eng_eco_6part_2$model
sum_abs_mod_eng_eco_6part_2 = summary(mod_eng_eco_6part_2)$absolut
sum_rel_mod_eng_eco_6part_2 = summary(mod_eng_eco_6part_2)$relative
plot(mod_eng_eco_6part_2, whichPlot = 1, whichCell = c(1:9))
plot(mod_eng_eco_6part_2, whichPlot = 1, whichCell = c(10:18))
plot(mod_eng_eco_6part_2, whichPlot = 1, whichCell = c(19:25))
plot(mod_eng_eco_6part_2, whichPlot = 1, whichCell = c(26:31))
plot(mod_eng_eco_6part_2, whichPlot = 1, whichCell = c(32:36))


# 2.) hybrid, 6 parties, with tuneVars, no individual prio
list_eng_hyb_6part_1 <- besip_model(besip_15_eng, country = "eng", 
                                    election_names = election_names, 
                                    individual = TRUE, parties = parties_eng_6,
                                    sample = sample, thinning = thinning_eng,
                                    tune_vars = TRUE, maxiter = maxiter, 
                                    burnin = burnin_eng, verbose = verbose)
mod_eng_hyb_6part_1  <- list_eng_hyb_6part_1$model
alphaVars_eng_hyb_6part <- list_eng_hyb_6part_1$alphaVars
betaVars_eng_hyb_6part <- list_eng_hyb_6part_1$betaVars
sum_abs_mod_eng_hyb_6part_1 = summary(mod_eng_hyb_6part_1)$absolut
sum_rel_mod_eng_hyb_6part_1 = summary(mod_eng_hyb_6part_1)$relative
plot(mod_eng_hyb_6part_1, whichPlot = 1, whichCell = c(1:9))
plot(mod_eng_hyb_6part_1, whichPlot = 1, whichCell = c(10:18))
plot(mod_eng_hyb_6part_1, whichPlot = 1, whichCell = c(19:25))
plot(mod_eng_hyb_6part_1, whichPlot = 1, whichCell = c(26:31))
plot(mod_eng_hyb_6part_1, whichPlot = 1, whichCell = c(32:36))


list_eng_hyb_6part_2 <- besip_model(besip_15_eng, country = "eng", 
                                    election_names = election_names, 
                                    individual = TRUE, parties = parties_eng_6,
                                    sample = sample, thinning = thinning_eng,
                                    tune_vars = FALSE, 
                                    alphaVars = alphaVars_eng_hyb_6part, 
                                    betaVars = betaVars_eng_hyb_6part, 
                                    burnin = burnin_eng, verbose = verbose)
mod_eng_hyb_6part_2  <- list_eng_hyb_6part_2$model
sum_abs_mod_eng_hyb_6part_2 = summary(mod_eng_hyb_6part_2)$absolut
sum_rel_mod_eng_hyb_6part_2 = summary(mod_eng_hyb_6part_2)$relative
plot(mod_eng_hyb_6part_2, whichPlot = 1, whichCell = c(1:9))
plot(mod_eng_hyb_6part_2, whichPlot = 1, whichCell = c(10:18))
plot(mod_eng_hyb_6part_2, whichPlot = 1, whichCell = c(19:25))
plot(mod_eng_hyb_6part_2, whichPlot = 1, whichCell = c(26:31))
plot(mod_eng_hyb_6part_2, whichPlot = 1, whichCell = c(32:36))



# 3.) ecological, 6 parties, with tuneVars, individual prio
shape_matrix_6part_eng <- matrix(c(30, 4, 4, 4, 4,4, 
                                   4, 30, 4, 4, 4, 4, 
                                   4, 4, 4, 4, 4, 4,
                                   4, 4, 4, 30, 4, 4,
                                   4, 4, 4, 4, 30, 4,
                                   4, 4, 4, 4, 4, 30), 
                                 nrow = 6, ncol = 6, byrow = TRUE)

rate_matrix_6part_eng <-  matrix(c(1, 2, 2, 2, 2, 2, 
                                   2, 1, 2, 2, 2, 2, 
                                   2, 2, 2, 2, 2, 2,
                                   2, 2, 2, 1, 2, 2,
                                   2, 2, 2, 2, 1, 2,
                                   2, 2, 2, 2, 2, 1), 
                                 nrow = 6, ncol = 6, byrow = TRUE)
prioriPars_6part_eng = list(shape = shape_matrix_6part_eng, rate = rate_matrix_6part_eng)
list_eng_eco_6part_cellspec_1 <- besip_model(besip_15_eng, country = "eng", 
                                             election_names = election_names, 
                                             individual = FALSE, parties = parties_eng_6,
                                             sample = sample, thinning = thinning_eng,
                                             tune_vars = TRUE, maxiter = maxiter, 
                                             prioriPars = prioriPars_6part_eng,
                                             burnin = burnin_eng, verbose = verbose)
mod_eng_eco_6part_cellspec_1  <- list_eng_eco_6part_cellspec_1$model
sum_abs_mod_eng_eco_6part_cellspec_1 <- summary(mod_eng_eco_6part_cellspec_1)$absolut
sum_rel_mod_eng_eco_6part_cellspec_1 <- summary(mod_eng_eco_6part_cellspec_1)$relative
alphaVars_eng_eco_6part_cellspec <- list_eng_eco_6part_cellspec_1$alphaVars
betaVars_eng_eco_6part_cellspec <- list_eng_eco_6part_cellspec_1$betaVars


list_eng_eco_6part_cellspec_2 <- besip_model(besip_15_eng, country = "eng", 
                                             election_names = election_names, 
                                             individual = FALSE, 
                                             parties = parties_eng_6,
                                             sample = sample, thinning = thinning_eng,
                                             tune_vars = FALSE, 
                                             alphaVars = alphaVars_eng_eco_6part_cellspec, 
                                             betaVars = betaVars_eng_eco_6part_cellspec, 
                                             maxiter = maxiter, 
                                             prioriPars = prioriPars_6part_eng,
                                             burnin = burnin_eng, verbose = verbose)
mod_eng_eco_6part_cellspec_2  <- list_eng_eco_6part_cellspec_2$model
sum_abs_mod_eng_eco_6part_cellspec_2 <- summary(mod_eng_eco_6part_cellspec_2)$absolut
sum_rel_mod_eng_eco_6part_cellspec_2 <- summary(mod_eng_eco_6part_cellspec_2)$relative


# 4.) hybrid, 6 parties, with tuneVars, individual prio

list_eng_hyb_6part_cellspec_1 <- besip_model(besip_15_eng, country = "eng", 
                                             election_names = election_names, 
                                             individual = TRUE, parties = parties_eng_6,
                                             sample = sample, thinning = thinning_eng,
                                             tune_vars = TRUE, maxiter = maxiter, 
                                             prioriPars = prioriPars_6part_eng,
                                             burnin = burnin_eng, verbose = verbose)
mod_eng_hyb_6part_cellspec_1  <- list_eng_hyb_6part_cellspec_1$model
sum_abs_mod_eng_hyb_6part_cellspec_1 <- summary(mod_eng_hyb_6part_cellspec_1)$absolut
sum_rel_mod_eng_hyb_6part_cellspec_1 <- summary(mod_eng_hyb_6part_cellspec_1)$relative
alphaVars_eng_hyb_6part_cellspec <- list_eng_hyb_6part_cellspec_1$alphaVars
betaVars_eng_hyb_6part_cellspec <- list_eng_hyb_6part_cellspec_1$betaVars



list_eng_hyb_6part_cellspec_2 <- besip_model(besip_15_eng, country = "eng", 
                                             election_names = election_names, 
                                             individual = TRUE, 
                                             parties = parties_eng_6,
                                             sample = sample, thinning = thinning_eng,
                                             tune_vars = FALSE, 
                                             alphaVars = alphaVars_eng_hyb_6part_cellspec, 
                                             betaVars = betaVars_eng_hyb_6part_cellspec, 
                                             maxiter = maxiter, 
                                             prioriPars = prioriPars_6part_eng,
                                             burnin = burnin_eng, verbose = verbose)
mod_eng_hyb_6part_cellspec_2  <- list_eng_hyb_6part_cellspec_2$model
sum_abs_mod_eng_hyb_6part_cellspec_2 <- summary(mod_eng_hyb_6part_cellspec_2)$absolut
sum_rel_mod_eng_hyb_6part_cellspec_2 <- summary(mod_eng_hyb_6part_cellspec_2)$relative


################################################################################
#################### Scotland ####################

parties_sco_5 <- c("CON", "LAB", "SNP") 
#parties_sco_4 <- c("LAB", "SNP") 

# subset data
burnin_sco <- 3000000
thinning_sco <- 2000
besip_15_sco <- besip_15[besip_15$scot == 1, ]


# 5.) ecological, 5 parties, with tuneVars, no individual prio
list_sco_eco_5part_1 <- besip_model(besip_15_sco, country = "sco", 
                                    election_names = election_names, 
                                    individual = FALSE, parties = parties_sco_5,
                                    sample = sample, thinning = 5000,
                                    tune_vars = TRUE, maxiter = maxiter, 
                                    burnin = 5000000, verbose = verbose)
mod_sco_eco_5part_1 <- list_sco_eco_5part_1$model
sum_abs_mod_sco_eco_5part_1 <- summary(mod_sco_eco_5part_1)$absolut
sum_rel_mod_sco_eco_5part_1 <- summary(mod_sco_eco_5part_1)$relative
alphaVars_sco_eco <- list_sco_eco_5part_1$alphaVars
betaVars_sco_eco <- list_sco_eco_5part_1$betaVars
plot(mod_sco_eco_5part_1, whichPlot = 1, whichCell = c(1:9))
plot(mod_sco_eco_5part_1, whichPlot = 1, whichCell = c(10:18))
plot(mod_sco_eco_5part_1, whichPlot = 1, whichCell = c(19:25))


list_sco_eco_5part_2 <- besip_model(besip_15_sco, country = "sco", 
                                    election_names = election_names, 
                                    individual = FALSE, parties = parties_sco_5,
                                    sample = sample, thinning = 5000,
                                    tune_vars = FALSE, alphaVars = alphaVars_sco_eco, 
                                    betaVars = betaVars_sco_eco, maxiter = maxiter, 
                                    burnin = 5000000, verbose = verbose)
mod_sco_eco_5part_2 <- list_sco_eco_5part_2$model
sum_abs_mod_sco_eco_5part_2 <- summary(mod_sco_eco_5part_2)$absolut
sum_rel_mod_sco_eco_5part_2 <- summary(mod_sco_eco_5part_2)$relative
plot(mod_sco_eco_5part_2, whichPlot = 1, whichCell = c(1:9))
plot(mod_sco_eco_5part_2, whichPlot = 1, whichCell = c(10:18))
plot(mod_sco_eco_5part_2, whichPlot = 1, whichCell = c(19:25))


# 6.) hybrid, 5 parties, with tuneVars, no individual prio
list_sco_hyb_5part_1 <- besip_model(besip_15_sco, country = "sco", 
                                    election_names = election_names, 
                                    individual = TRUE, parties = parties_sco_5,
                                    sample = sample, thinning = thinning_sco,
                                    tune_vars = TRUE, maxiter = maxiter, 
                                    burnin = burnin_sco, verbose = verbose)
mod_sco_hyb_5part_1 <- list_sco_hyb_5part_1$model
sum_abs_mod_sco_hyb_5part_1 <- summary(mod_sco_hyb_5part_1)$absolut
sum_rel_mod_sco_hyb_5part_1 <- summary(mod_sco_hyb_5part_1)$relative
alphaVars_sco_hyb <- list_sco_hyb_5part_1$alphaVars
betaVars_sco_hyb <- list_sco_hyb_5part_1$betaVars
plot(mod_sco_hyb_5part_1, whichPlot = 1, whichCell = c(1:9))
plot(mod_sco_hyb_5part_1, whichPlot = 1, whichCell = c(10:18))
plot(mod_sco_hyb_5part_1, whichPlot = 1, whichCell = c(19:25))


list_sco_hyb_5part_2 <- besip_model(besip_15_sco, country = "sco", 
                                    election_names = election_names, 
                                    individual = TRUE, parties = parties_sco_5,
                                    sample = sample, thinning = thinning_sco,
                                    tune_vars = FALSE, alphaVars = alphaVars_sco_hyb, 
                                    betaVars = betaVars_sco_hyb, maxiter = maxiter, 
                                    burnin = burnin_sco, verbose = verbose)
mod_sco_hyb_5part_2 <- list_sco_hyb_5part_2$model
sum_abs_mod_sco_hyb_5part_2 <- summary(mod_sco_hyb_5part_2)$absolut
sum_rel_mod_sco_hyb_5part_2 <- summary(mod_sco_hyb_5part_2)$relative
plot(mod_sco_hyb_5part_2, whichPlot = 1, whichCell = c(1:9))
plot(mod_sco_hyb_5part_2, whichPlot = 1, whichCell = c(10:18))
plot(mod_sco_hyb_5part_2, whichPlot = 1, whichCell = c(19:25))


# 7.) ecological, 5 parties, with tuneVars, individual prio
shape_matrix_5part_sco <- matrix(c(30, 4, 4, 4, 4, 
                                   4, 30, 4, 4, 4, 
                                   4, 4, 30, 4, 4,
                                   4, 4, 4, 30, 4,
                                   4, 4, 4, 4, 4), 
                                 nrow = 5, ncol = 5, byrow = TRUE)

rate_matrix_5part_sco <-  matrix(c(1, 2, 2, 2, 2, 
                                   2, 1, 2, 2, 2, 
                                   2, 2, 1, 2, 2,
                                   2, 2, 2, 1, 2,
                                   2, 2, 2, 2, 2), 
                                 nrow = 5, ncol = 5, byrow = TRUE)
prioriPars_5part_sco = list(shape = shape_matrix_5part_sco, 
                            rate = rate_matrix_5part_sco)

list_sco_eco_5part_cellspec_1 <- besip_model(besip_15_sco, country = "sco", 
                                             election_names = election_names, 
                                             individual = FALSE, parties = parties_sco_5,
                                             sample = sample, thinning = thinning_sco,
                                             tune_vars = TRUE, maxiter = maxiter, 
                                             prioriPars = prioriPars_5part_sco, 
                                             burnin = burnin_sco, verbose = verbose)
mod_sco_eco_5part_cellspec_1 <- list_sco_eco_5part_cellspec_1$model
sum_abs_mod_sco_eco_5part_cellspec_1 <- summary(mod_sco_eco_5part_cellspec_1)$absolut
sum_rel_mod_sco_eco_5part_cellspec_1 <- summary(mod_sco_eco_5part_cellspec_1)$relative
alphaVars_sco_eco_cellspec <- list_sco_eco_5part_cellspec_1$alphaVars
betaVars_sco_eco_cellspec <- list_sco_eco_5part_cellspec_1$betaVars
plot(mod_sco_eco_5part_cellspec_1, whichPlot = 1, whichCell = c(1:9))
plot(mod_sco_eco_5part_cellspec_1, whichPlot = 1, whichCell = c(10:18))
plot(mod_sco_eco_5part_cellspec_1, whichPlot = 1, whichCell = c(19:25))


list_sco_eco_5part_cellspec_2 <- besip_model(besip_15_sco, country = "sco", 
                                             election_names = election_names, 
                                             individual = FALSE, parties = parties_sco_5,
                                             sample = sample, thinning = thinning_sco,
                                             tune_vars = FALSE, alphaVars = alphaVars_sco_eco_cellspec, 
                                             betaVars = betaVars_sco_eco_cellspec, maxiter = maxiter, 
                                             prioriPars = prioriPars_5part_sco, 
                                             burnin = burnin_sco, verbose = verbose)
mod_sco_eco_5part_cellspec_2 <- list_sco_eco_5part_cellspec_2$model
sum_abs_mod_sco_eco_5part_cellspec_2 <- summary(mod_sco_eco_5part_cellspec_2)$absolut
sum_rel_mod_sco_eco_5part_cellspec_2 <- summary(mod_sco_eco_5part_cellspec_2)$relative
plot(mod_sco_eco_5part_cellspec_2, whichPlot = 1, whichCell = c(1:9))
plot(mod_sco_eco_5part_cellspec_2, whichPlot = 1, whichCell = c(10:18))
plot(mod_sco_eco_5part_cellspec_2, whichPlot = 1, whichCell = c(19:25))



# 8.) hybrid, 5 parties, with tuneVars, individual prio
list_sco_hyb_5part_cellspec_1 <- besip_model(besip_15_sco, country = "sco", 
                                             election_names = election_names, 
                                             individual = TRUE, parties = parties_sco_5,
                                             sample = sample, thinning = thinning_sco,
                                             tune_vars = TRUE, maxiter = maxiter, 
                                             prioriPars = prioriPars_5part_sco, 
                                             burnin = burnin_sco, verbose = verbose)
mod_sco_hyb_5part_cellspec_1 <- list_sco_hyb_5part_cellspec_1$model
sum_abs_mod_sco_hyb_5part_cellspec_1 <- summary(mod_sco_hyb_5part_cellspec_1)$absolut
sum_rel_mod_sco_hyb_5part_cellspec_1 <- summary(mod_sco_hyb_5part_cellspec_1)$relative
alphaVars_sco_hyb_cellspec <- list_sco_hyb_5part_cellspec_1$alphaVars
betaVars_sco_hyb_cellspec <- list_sco_hyb_5part_cellspec_1$betaVars
plot(mod_sco_hyb_5part_cellspec_1, whichPlot = 1, whichCell = c(1:9))
plot(mod_sco_hyb_5part_cellspec_1, whichPlot = 1, whichCell = c(10:18))
plot(mod_sco_hyb_5part_cellspec_1, whichPlot = 1, whichCell = c(19:25))



list_sco_hyb_5part_cellspec_2 <- besip_model(besip_15_sco, country = "sco", 
                                             election_names = election_names, 
                                             individual = TRUE, parties = parties_sco_5,
                                             sample = sample, thinning = thinning_sco,
                                             tune_vars = FALSE, alphaVars = alphaVars_sco_hyb_cellspec, 
                                             betaVars = betaVars_sco_hyb_cellspec, maxiter = maxiter, 
                                             prioriPars = prioriPars_5part_sco, 
                                             burnin = burnin_sco, verbose = verbose)
mod_sco_hyb_5part_cellspec_2 <- list_sco_hyb_5part_cellspec_2$model
sum_abs_mod_sco_hyb_5part_cellspec_2 <- summary(mod_sco_hyb_5part_cellspec_2)$absolut
sum_rel_mod_sco_hyb_5part_cellspec_2 <- summary(mod_sco_hyb_5part_cellspec_2)$relative
plot(mod_sco_hyb_5part_cellspec_2, whichPlot = 1, whichCell = c(1:9))
plot(mod_sco_hyb_5part_cellspec_2, whichPlot = 1, whichCell = c(10:18))
plot(mod_sco_hyb_5part_cellspec_2, whichPlot = 1, whichCell = c(19:25))



################################################################################
#################### Wales ####################

# parties
parties_wal_5 <- c("CON", "LAB", "PC") 
#parties_wal_4 <- c("CON", "LAB") 

# subset data
besip_15_wal <- besip_15[besip_15$wal == 1, ]
burnin_wal <- 1500000
thinning_wal <- 2000

# 9.) ecological, 5 parties, with tuneVars, no individual prio
list_wal_eco_5part_1 <- besip_model(besip_15_wal, country = "wal", 
                                    election_names = election_names, 
                                    individual = FALSE, parties = parties_wal_5,
                                    sample = sample, thinning = 4000,
                                    tune_vars = TRUE, maxiter = maxiter, 
                                    burnin = 2000000, verbose = verbose)
mod_wal_eco_5part_1 <- list_wal_eco_5part_1$model
sum_abs_mod_wal_eco_5part_1 = summary(mod_wal_eco_5part_1)$absolut
sum_rel_mod_wal_eco_5part_1 = summary(mod_wal_eco_5part_1)$relative
alphaVars_wal_eco_5part <- list_wal_eco_5part_1$alphaVars
betaVars_wal_eco_5part <- list_wal_eco_5part_1$betaVars
plot(mod_wal_eco_5part_1, whichPlot = 1, whichCell = c(1:9))
plot(mod_wal_eco_5part_1, whichPlot = 1, whichCell = c(10:18))
plot(mod_wal_eco_5part_1, whichPlot = 1, whichCell = c(19:25))


list_wal_eco_5part_2 <- besip_model(besip_15_wal, country = "wal", 
                                    election_names = election_names, 
                                    individual = FALSE, parties = parties_wal_5,
                                    sample = sample, thinning = 4000,
                                    tune_vars = FALSE, 
                                    alphaVars = alphaVars_wal_eco_5part, 
                                    betaVars = betaVars_wal_eco_5part, 
                                    burnin = 2000000, verbose = verbose)
mod_wal_eco_5part_2 <- list_wal_eco_5part_2$model
sum_abs_mod_wal_eco_5part_2 = summary(mod_wal_eco_5part_2)$absolut
sum_rel_mod_wal_eco_5part_2 = summary(mod_wal_eco_5part_2)$relative
plot(mod_wal_eco_5part_2, whichPlot = 1, whichCell = c(1:9))
plot(mod_wal_eco_5part_2, whichPlot = 1, whichCell = c(10:18))
plot(mod_wal_eco_5part_2, whichPlot = 1, whichCell = c(19:25))


# 10) hybrid, 5 parties, with tuneVars, no individual prio
list_wal_hyb_5part_1 <- besip_model(besip_15_wal, country = "wal", 
                                    election_names = election_names, 
                                    individual = TRUE, parties = parties_wal_5,
                                    sample = sample, thinning = thinning_wal,
                                    tune_vars = TRUE, maxiter = maxiter, 
                                    burnin = burnin_wal, verbose = verbose)
mod_wal_hyb_5part_1 <- list_wal_hyb_5part_1$model
sum_abs_mod_wal_hyb_5part_1 = summary(mod_wal_hyb_5part_1)$absolut
sum_rel_mod_wal_hyb_5part_1 = summary(mod_wal_hyb_5part_1)$relative
alphaVars_wal_hyb_5part <- list_wal_hyb_5part_1$alphaVars
betaVars_wal_hyb_5part <- list_wal_hyb_5part_1$betaVars
plot(mod_wal_hyb_5part_1, whichPlot = 1, whichCell = c(1:9))
plot(mod_wal_hyb_5part_1, whichPlot = 1, whichCell = c(10:18))
plot(mod_wal_hyb_5part_1, whichPlot = 1, whichCell = c(19:25))


list_wal_hyb_5part_2 <- besip_model(besip_15_wal, country = "wal", 
                                    election_names = election_names, 
                                    individual = TRUE, parties = parties_wal_5,
                                    sample = sample, thinning = thinning_wal,
                                    tune_vars = FALSE, 
                                    alphaVars = alphaVars_wal_eco_5part, 
                                    betaVars = betaVars_wal_eco_5part, 
                                    burnin = burnin_wal, verbose = verbose)
mod_wal_hyb_5part_2 <- list_wal_hyb_5part_2$model
sum_abs_mod_wal_hyb_5part_2 = summary(mod_wal_hyb_5part_2)$absolut
sum_rel_mod_wal_hyb_5part_2 = summary(mod_wal_hyb_5part_2)$relative
plot(mod_wal_hyb_5part_2, whichPlot = 1, whichCell = c(1:9))
plot(mod_wal_hyb_5part_2, whichPlot = 1, whichCell = c(10:18))
plot(mod_wal_hyb_5part_2, whichPlot = 1, whichCell = c(19:25))


# 11.) ecological, 5 parties, with tuneVars, individual prio
shape_matrix_5part_wal <- matrix(c(6, 4, 4, 4, 4, 
                                   4, 6, 4, 4, 4, 
                                   4, 4, 6, 4, 4,
                                   4, 4, 4, 6, 4,
                                   4, 4, 4, 4, 4), 
                                 nrow = 5, ncol = 5, byrow = TRUE)

rate_matrix_5part_wal <-  matrix(c(1.8, 2, 2, 2, 2, 
                                   2, 1.8, 2, 2, 2, 
                                   2, 2, 1.8, 2, 2,
                                   2, 2, 2, 1.8, 2,
                                   2, 2, 2, 2, 2), 
                                 nrow = 5, ncol = 5, byrow = TRUE)
prioriPars_5part_wal = list(shape = shape_matrix_5part_wal, 
                            rate = rate_matrix_5part_wal)

list_wal_eco_5part_cellspec_1 <- besip_model(besip_15_wal, country = "wal", 
                                             election_names = election_names, 
                                             individual = FALSE, parties = parties_wal_5,
                                             sample = sample, thinning = 4000,
                                             tune_vars = TRUE, maxiter = maxiter, 
                                             prioriPars = prioriPars_5part_wal, 
                                             burnin = 2000000, verbose = verbose)
mod_wal_eco_5part_cellspec_1 <- list_wal_eco_5part_cellspec_1$model
sum_abs_mod_wal_eco_5part_cellspec_1 <- summary(mod_wal_eco_5part_cellspec_1)$absolut
sum_rel_mod_wal_eco_5part_cellspec_1 <- summary(mod_wal_eco_5part_cellspec_1)$relative
alphaVars_wal_eco_5part_cellspec <- list_wal_eco_5part_cellspec_1$alphaVars
betaVars_wal_eco_5part_cellspec <- list_wal_eco_5part_cellspec_1$betaVars
plot(mod_wal_eco_5part_cellspec_1, whichPlot = 1, whichCell = c(1:9))
plot(mod_wal_eco_5part_cellspec_1, whichPlot = 1, whichCell = c(10:18))
plot(mod_wal_eco_5part_cellspec_1, whichPlot = 1, whichCell = c(19:25))


list_wal_eco_5part_cellspec_2 <- besip_model(besip_15_wal, country = "wal", 
                                             election_names = election_names, 
                                             individual = FALSE, parties = parties_wal_5,
                                             sample = sample, thinning = 4000,
                                             tune_vars = FALSE, 
                                             alphaVars = alphaVars_wal_eco_6part_cellspec, 
                                             betaVars = betaVars_wal_eco_6part_cellspec, 
                                             burnin = 2000000, verbose = verbose)
mod_wal_eco_5part_cellspec_2 <- list_wal_eco_5part_cellspec_2$model
sum_abs_mod_wal_eco_5part_cellspec_2 <- summary(mod_wal_eco_5part_cellspec_2)$absolut
sum_rel_mod_wal_eco_5part_cellspec_2 <- summary(mod_wal_eco_5part_cellspec_2)$relative



# 12.) hybrid, 5 parties, with tuneVars, individual prio
list_wal_hyb_5part_cellspec_1 <- besip_model(besip_15_wal, country = "wal", 
                                             election_names = election_names, 
                                             individual = TRUE, parties = parties_wal_5,
                                             sample = sample, thinning = thinning_wal,
                                             tune_vars = TRUE, maxiter = maxiter, 
                                             prioriPars = prioriPars_5part_wal, 
                                             burnin = burnin_wal, verbose = verbose)
mod_wal_hyb_5part_cellspec_1 <- list_wal_hyb_5part_cellspec_1$model
sum_abs_mod_wal_hyb_5part_cellspec_1 <- summary(mod_wal_hyb_5part_cellspec_1)$absolut
sum_rel_mod_wal_hyb_5part_cellspec_1 <- summary(mod_wal_hyb_5part_cellspec_1)$relative
alphaVars_wal_hyb_5part_cellspec <- list_wal_hyb_5part_cellspec_1$alphaVars
betaVars_wal_hyb_5part_cellspec <- list_wal_hyb_5part_cellspec_1$betaVars


list_wal_hyb_5part_cellspec_2 <- besip_model(besip_15_wal, country = "wal", 
                                             election_names = election_names, 
                                             individual = TRUE, parties = parties_wal_5,
                                             sample = sample, thinning = thinning_wal,
                                             tune_vars = FALSE, 
                                             alphaVars = alphaVars_wal_hyb_6part_cellspec, 
                                             betaVars = betaVars_wal_hyb_6part_cellspec, 
                                             burnin = burnin_wal, verbose = verbose)
mod_wal_hyb_5part_cellspec_2 <- list_wal_hyb_5part_cellspec_2$model
sum_abs_mod_wal_hyb_5part_cellspec_2 <- summary(mod_wal_hyb_5part_cellspec_2)$absolut
sum_rel_mod_wal_hyb_5part_cellspec_2 <- summary(mod_wal_hyb_5part_cellspec_2)$relative

