################################################################################
#
# preparing data for plots
#
################################################################################

################################################################################
source("functions.R")

load("Data/models_results.RData")
################################################################################
#### Scatterplots

eng_data_scat <- data_scatter_plot(data_aggr = list_eng_hyb_6part_1$aggr, 
                                   data_indi = list_eng_hyb_6part_1$indi_like_aggr)
sco_data_scat <- data_scatter_plot(data_aggr = list_sco_hyb_5part_1$aggr, 
                                   data_indi = list_sco_hyb_5part_1$indi_like_aggr)
wal_data_scat <- data_scatter_plot(data_aggr = list_wal_hyb_5part_1$aggr, 
                                   data_indi = list_wal_hyb_5part_1$indi_like_aggr)

eng_data_scat$party = factor(eng_data_scat$party, 
                             levels = c("CON", "LAB", "LD", "UKIP", "GREEN", "ABSTAIN"))
eng_data_scat$election_name[eng_data_scat$election_name == "10"] <- "2010"
eng_data_scat$election_name[eng_data_scat$election_name == "15"] <- "2015"

sco_data_scat$party = factor(sco_data_scat$party, 
                             levels = c("CON", "LAB", "SNP", "OTHER", "ABSTAIN"))
sco_data_scat$election_name[sco_data_scat$election_name == "10"] <- "2010"
sco_data_scat$election_name[sco_data_scat$election_name == "15"] <- "2015"

wal_data_scat$party = factor(wal_data_scat$party, 
                             levels = c("CON", "LAB", "PC", "OTHER", "ABSTAIN"))
wal_data_scat$election_name[wal_data_scat$election_name == "10"] <- "2010"
wal_data_scat$election_name[wal_data_scat$election_name == "15"] <- "2015"


################################################################################
#### transition flows

#data transition flows
colnames(sum_abs_mod_eng_hyb_6part_1) <- 
  gsub("15", "_2", colnames(sum_abs_mod_eng_hyb_6part_1))
row.names(sum_abs_mod_eng_hyb_6part_1) <- 
  gsub("10", "_1", row.names(sum_abs_mod_eng_hyb_6part_1))

colnames(sum_abs_mod_sco_hyb_5part_1) <- 
  gsub("15", "_2", colnames(sum_abs_mod_sco_hyb_5part_1))
row.names(sum_abs_mod_sco_hyb_5part_1) <- 
  gsub("10", "_1", row.names(sum_abs_mod_sco_hyb_5part_1))

colnames(sum_abs_mod_wal_hyb_5part_1) <- 
  gsub("15", "_2", colnames(sum_abs_mod_wal_hyb_5part_1))
row.names(sum_abs_mod_wal_hyb_5part_1) <- 
  gsub("10", "_1", row.names(sum_abs_mod_wal_hyb_5part_1))


