################################################################################
#
# preparing data for tables, etc
#  
# results stored in allData.RData
#
################################################################################

load("Data/models_results.RData")

source("functions.R")

#########################################
# create table
stats_indi <- data.frame(matrix(nrow = 3, ncol = 5))
names(stats_indi) <- c("country", "numb_district", "numb_indi", 
                       "min_numb_voter_dist", "max_numb_voter_dist")
stats_indi[1, ] <- c("Eng", besip_indi_stats(besip_15_eng))
stats_indi[2, ] <- c("Sco", besip_indi_stats(besip_15_sco))
stats_indi[3, ] <- c("Wal", besip_indi_stats(besip_15_wal))


##############################
###Vote shares in the 2010 and 2015 British general elections: Aggregate and individual data compared

#England 
eng_margins_aggr <- calc_marg_prob(aggr_data = list_eng_hyb_6part_1$aggr, 
                                   election_names = c("10", "15"))
eng_margins_indi <- calc_marg_prob(aggr_data = list_eng_hyb_6part_1$indi_like_aggr, 
                                   election_names = c("10", "15"))
#Scotland
sco_margins_aggr <- calc_marg_prob(aggr_data = list_sco_hyb_5part_1$aggr, 
                                   election_names = c("10", "15"))
sco_margins_indi <- calc_marg_prob(aggr_data = list_sco_hyb_5part_1$indi_like_aggr, 
                                   election_names = c("10", "15"))
#Wales
wal_margins_aggr <- calc_marg_prob(aggr_data = list_wal_hyb_5part_1$aggr, 
                                   election_names = c("10", "15"))
wal_margins_indi <- calc_marg_prob(aggr_data = list_wal_hyb_5part_1$indi_like_aggr, 
                                   election_names = c("10", "15"))

###############################################
####Comparison of models and chains based on the AD (Absolute Distance) index

# England
besip_eng_indi_list = besip_ipfp(besip_15_eng, aggr_data = list_eng_hyb_6part_1$aggr, 
                                 indi_data = list_eng_hyb_6part_1$indi, 
                                 country = "eng", election_names = c("10", "15"))
eng_indi_ipfp_rel <- besip_eng_indi_list$trans_matrix_ipfp_rel
eng_indi_ipfp_abs <- besip_eng_indi_list$trans_matrix_ipfp_abs
eng_indi_rel <- besip_eng_indi_list$trans_matrix_indi_rel
eng_indi_abs <- besip_eng_indi_list$trans_matrix_indi_abs

eng_mod_abs_6part <- list(eng_indi_abs = eng_indi_abs,
                          eng_indi_ipfp_abs = eng_indi_ipfp_abs,
                          sum_abs_mod_eng_eco_6part_1 = sum_abs_mod_eng_eco_6part_1, 
                          sum_abs_mod_eng_eco_6part_2 = sum_abs_mod_eng_eco_6part_2,
                          sum_abs_mod_eng_hyb_6part_1 = sum_abs_mod_eng_hyb_6part_1, 
                          sum_abs_mod_eng_hyb_6part_2 = sum_abs_mod_eng_hyb_6part_2,
                          sum_abs_mod_eng_eco_6part_cellspec_1 = sum_abs_mod_eng_eco_6part_cellspec_1,
                          sum_abs_mod_eng_eco_6part_cellspec_2 = sum_abs_mod_eng_eco_6part_cellspec_2,
                          sum_abs_mod_eng_hyb_6part_cellspec_1 = sum_abs_mod_eng_hyb_6part_cellspec_1,
                          sum_abs_mod_eng_hyb_6part_cellspec_2 = sum_abs_mod_eng_hyb_6part_cellspec_2)

eng_mod_rel_6part <- list(eng_indi_rel = eng_indi_rel,
                          eng_indi_ipfp_rel = eng_indi_ipfp_rel,
                          sum_rel_mod_eng_eco_6part_1 = sum_rel_mod_eng_eco_6part_1, 
                          sum_rel_mod_eng_eco_6part_2 = sum_rel_mod_eng_eco_6part_2,
                          sum_rel_mod_eng_hyb_6part_1 = sum_rel_mod_eng_hyb_6part_1, 
                          sum_rel_mod_eng_hyb_6part_2 = sum_rel_mod_eng_hyb_6part_2,
                          sum_rel_mod_eng_eco_6part_cellspec_1 = sum_rel_mod_eng_eco_6part_cellspec_1,
                          sum_rel_mod_eng_eco_6part_cellspec_2 = sum_rel_mod_eng_eco_6part_cellspec_2,
                          sum_rel_mod_eng_hyb_6part_cellspec_1 = sum_rel_mod_eng_hyb_6part_cellspec_1,
                          sum_rel_mod_eng_hyb_6part_cellspec_2 = sum_rel_mod_eng_hyb_6part_cellspec_2)

tab_eng_mod_ad_6part  <- create_comp_tab(eng_mod_abs_6part, method = "ad")
tab_eng_mod_mae_6part  <- create_comp_tab(eng_mod_rel_6part, method = "mae")



# Scotland
besip_sco_indi_list = besip_ipfp(besip_15_sco, aggr_data = list_sco_hyb_5part_1$aggr, 
                                 indi_data = list_sco_hyb_5part_1$indi, 
                                 country = "sco", election_names = c("10", "15"))
sco_indi_ipfp_rel <- besip_sco_indi_list$trans_matrix_ipfp_rel
sco_indi_ipfp_abs <- besip_sco_indi_list$trans_matrix_ipfp_abs
sco_indi_rel <- besip_sco_indi_list$trans_matrix_indi_rel
sco_indi_abs <- besip_sco_indi_list$trans_matrix_indi_abs


sco_indi_abs = sco_indi_abs[c(1, 2, 3, 5, 4), c(1, 2, 3, 5, 4)]
sco_indi_ipfp_abs = sco_indi_ipfp_abs[c(1, 2, 3, 5, 4), c(1, 2, 3, 5, 4)]
sco_indi_rel = sco_indi_rel[c(1, 2, 3, 5, 4), c(1, 2, 3, 5, 4)]
sco_indi_ipfp_rel = sco_indi_ipfp_rel[c(1, 2, 3, 5, 4), c(1, 2, 3, 5, 4)]

sco_mod_abs_5part <- list(sco_indi_abs = sco_indi_abs,
                          sco_indi_ipfp_abs = sco_indi_ipfp_abs,
                          sum_abs_mod_sco_eco_5part_1 = sum_abs_mod_sco_eco_5part_1, 
                          sum_abs_mod_sco_eco_5part_2 = sum_abs_mod_sco_eco_5part_2,
                          sum_abs_mod_sco_hyb_5part_1 = sum_abs_mod_sco_hyb_5part_1, 
                          sum_abs_mod_sco_hyb_5part_2 = sum_abs_mod_sco_hyb_5part_2,
                          sum_abs_mod_sco_eco_5part_cellspec_1 = sum_abs_mod_sco_eco_5part_cellspec_1,
                          sum_abs_mod_sco_eco_5part_cellspec_2 = sum_abs_mod_sco_eco_5part_cellspec_2,
                          sum_abs_mod_sco_hyb_5part_cellspec_1 = sum_abs_mod_sco_hyb_5part_cellspec_1,
                          sum_abs_mod_sco_hyb_5part_cellspec_2 = sum_abs_mod_sco_hyb_5part_cellspec_2)

sco_mod_rel_5part <- list(sco_indi_rel = sco_indi_rel,
                          sco_indi_ipfp_rel = sco_indi_ipfp_rel,
                          sum_rel_mod_sco_eco_5part_1 = sum_rel_mod_sco_eco_5part_1, 
                          sum_rel_mod_sco_eco_5part_2 = sum_rel_mod_sco_eco_5part_2,
                          sum_rel_mod_sco_hyb_5part_1 = sum_rel_mod_sco_hyb_5part_1, 
                          sum_rel_mod_sco_hyb_5part_2 = sum_rel_mod_sco_hyb_5part_2,
                          sum_rel_mod_sco_eco_5part_cellspec_1 = sum_rel_mod_sco_eco_5part_cellspec_1,
                          sum_rel_mod_sco_eco_5part_cellspec_2 = sum_rel_mod_sco_eco_5part_cellspec_2,
                          sum_rel_mod_sco_hyb_5part_cellspec_1 = sum_rel_mod_sco_hyb_5part_cellspec_1,
                          sum_rel_mod_sco_hyb_5part_cellspec_2 = sum_rel_mod_sco_hyb_5part_cellspec_2)

tab_sco_mod_ad_5part  <- create_comp_tab(sco_mod_abs_5part, method = "ad")
tab_sco_mod_mae_5part  <- create_comp_tab(sco_mod_rel_5part, method = "mae")



# Wales
besip_wal_indi_list = besip_ipfp(besip_15_wal, aggr_data = list_wal_hyb_5part_1$aggr, 
                                 indi_data = list_wal_hyb_5part_1$indi, 
                                 country = "wal", election_names = c("10", "15"))
wal_indi_ipfp_rel <- besip_wal_indi_list$trans_matrix_ipfp_rel
wal_indi_ipfp_abs <- besip_wal_indi_list$trans_matrix_ipfp_abs
wal_indi_rel <- besip_wal_indi_list$trans_matrix_indi_rel
wal_indi_abs <- besip_wal_indi_list$trans_matrix_indi_abs

wal_indi_abs = wal_indi_abs[c(1, 2, 3, 5, 4), c(1, 2, 3, 5, 4)]
wal_indi_ipfp_abs = wal_indi_ipfp_abs[c(1, 2, 3, 5, 4), c(1, 2, 3, 5, 4)]
wal_indi_rel = wal_indi_rel[c(1, 2, 3, 5, 4), c(1, 2, 3, 5, 4)]
wal_indi_ipfp_rel = wal_indi_ipfp_rel[c(1, 2, 3, 5, 4), c(1, 2, 3, 5, 4)]

wal_mod_abs_5part <- list(wal_indi_abs = wal_indi_abs,
                          wal_indi_ipfp_abs = wal_indi_ipfp_abs,
                          sum_abs_mod_wal_eco_5part_1 = sum_abs_mod_wal_eco_5part_1, 
                          sum_abs_mod_wal_eco_5part_2 = sum_abs_mod_wal_eco_5part_2,
                          sum_abs_mod_wal_hyb_5part_1 = sum_abs_mod_wal_hyb_5part_1, 
                          sum_abs_mod_wal_hyb_5part_2 = sum_abs_mod_wal_hyb_5part_2,
                          sum_abs_mod_wal_eco_5part_cellspec_1 = sum_abs_mod_wal_eco_5part_cellspec_1,
                          sum_abs_mod_wal_eco_5part_cellspec_2 = sum_abs_mod_wal_eco_5part_cellspec_2,
                          sum_abs_mod_wal_hyb_5part_cellspec_1 = sum_abs_mod_wal_hyb_5part_cellspec_1,
                          sum_abs_mod_wal_hyb_5part_cellspec_2 = sum_abs_mod_wal_hyb_5part_cellspec_2)

wal_mod_rel_5part <- list(wal_indi_rel = wal_indi_rel,
                          wal_indi_ipfp_rel = wal_indi_ipfp_rel,
                          sum_rel_mod_wal_eco_5part_1 = sum_rel_mod_wal_eco_5part_1, 
                          sum_rel_mod_wal_eco_5part_2 = sum_rel_mod_wal_eco_5part_2,
                          sum_rel_mod_wal_hyb_5part_1 = sum_rel_mod_wal_hyb_5part_1, 
                          sum_rel_mod_wal_hyb_5part_2 = sum_rel_mod_wal_hyb_5part_2,
                          sum_rel_mod_wal_eco_5part_cellspec_1 = sum_rel_mod_wal_eco_5part_cellspec_1,
                          sum_rel_mod_wal_eco_5part_cellspec_2 = sum_rel_mod_wal_eco_5part_cellspec_2,
                          sum_rel_mod_wal_hyb_5part_cellspec_1 = sum_rel_mod_wal_hyb_5part_cellspec_1,
                          sum_rel_mod_wal_hyb_5part_cellspec_2 = sum_rel_mod_wal_hyb_5part_cellspec_2)

tab_wal_mod_ad_5part  <- create_comp_tab(wal_mod_abs_5part, method = "ad")
tab_wal_mod_mae_5part  <- create_comp_tab(wal_mod_rel_5part, method = "mae")


