################################################################################
#
# creating the date for the tables in the report
#
################################################################################

load("Data/allData.RData")

source("functions.R")


#########################################
###Constituencies and BESIP respondents in England, Scotland and Wales

## inital numbers (ignoring aggregate margins - see footnote 7))
stats_indi

## corrected numbers (aggregate margins) - only necessary in England
dim(besip_15_eng)                                                               # 20856 respondents

parties_eng_6 <- c("CON", "LAB", "LD", "UKIP", "GREEN") 
parties_engl_compl = c(parties_eng_6, "ABSTAIN")
aggr_besip <- aggr_data_besip(besip_15_eng, country = "eng", parties = parties_engl_compl)

indi_list          <- indi_data_besip(besip_15_eng, parties = parties_engl_compl, weighted = FALSE)
   indi_besip      <- indi_list$indi_besip                                      # still 20856 respondents, sum(indi_besip[,-1]) - do run after this line
   indi_like_aggr  <- indi_list$indi_like_aggr
   indi_list_check <- check_indi_data(aggr_besip, indi_like_aggr, indi_besip)
   indi_besip      <- indi_list_check$indi_besip                                # reduce to 20815 respondents, sum(indi_besip[,-1])

summary(rowSums(indi_besip[,-1]))


############################
#Vote shares in the 2010 and 2015 British general elections: Aggregate and individual data compared

#England 
eng_margins_aggr
eng_margins_indi

#Scotland
sco_margins_aggr
sco_margins_indi

#Wales
wal_margins_aggr
wal_margins_indi


##############################
#Estimation Results of the HHMD models without prior knowledge

#England
#Absolute voter transitions
sum_abs_mod_eng_hyb_6part_1

#Conditional transition probabilities
sum_rel_mod_eng_hyb_6part_1

#Scotland
#Absolute voter transitions
sum_abs_mod_sco_hyb_5part_1

#Conditional transition probabilities
sum_rel_mod_sco_hyb_5part_1

#Wales
#Absolute voter transitions
sum_abs_mod_wal_hyb_5part_1

#Conditional transition probabilities
sum_rel_mod_wal_hyb_5part_1


#####################
#Comparison of models and chains based on the AD (Absolute Distance) index

# England 

(tab_eng_mod_ad_6part/100)[c(3,4,7,8,5,6,9,10),c(3,4,7,8,5,6,9,10)]

# Scotland

(tab_sco_mod_ad_5part/100)[c(3,4,7,8,5,6,9,10),c(3,4,7,8,5,6,9,10)]

# Wales 
(tab_wal_mod_ad_5part/100)[c(3,4,7,8,5,6,9,10),c(3,4,7,8,5,6,9,10)]
