################################################################################
#
# calculation of ipf based projection [only England
#
################################################################################

################################################################################
source("functions.R")

load("Data/allData.RData")

################################################################################
### England 
################################################################################

# note: Green is only used in the code as pseude-placeholder, it is "others"
parties_eng_6 <- c("CON", "LAB", "LD", "UKIP", "GREEN") 
parties_engl_compl = c(parties_eng_6, "ABSTAIN")
aggr_besip <- aggr_data_besip(besip_15_eng, country = "eng", parties = parties_engl_compl)

indi_list          <- indi_data_besip(besip_15_eng, parties = parties_engl_compl, weighted = FALSE)
   indi_besip      <- indi_list$indi_besip
   indi_like_aggr  <- indi_list$indi_like_aggr
   indi_list_check <- check_indi_data(aggr_besip, indi_like_aggr, indi_besip)
   indi_besip      <- indi_list_check$indi_besip
   indi_like_aggr  <- indi_list_check$indi_like_aggr

   
################################################################################
### adding small number (tab, grid of values, added to each cell)
tabs.grid = 1/(10^(0:10))

# calculating ipf based projection for certain values
engl.tab       = ipf.calc.tab(agg.dat = aggr_besip, ind.dat = indi_besip, tab = 0)
engl.tab.1     = ipf.calc.tab(agg.dat = aggr_besip, ind.dat = indi_besip, tab = 1)
engl.tab.1_2   = ipf.calc.tab(agg.dat = aggr_besip, ind.dat = indi_besip, tab = .5)
engl.tab.1e10  = ipf.calc.tab(agg.dat = aggr_besip, ind.dat = indi_besip, tab = 1e-10)

engl.tab.sums = as.data.frame(colSums(engl.tab)[-1])
names(engl.tab.sums) = "keinTab"

for (i in 1:length(tabs.grid)){
   engl.tab.sums = cbind(engl.tab.sums, colSums(ipf.calc.tab(agg.dat = aggr_besip, ind.dat = indi_besip, tab = tabs.grid[i]))[-1])
   names(engl.tab.sums)[i+1] = paste("Tab", tabs.grid[i], sep = ".")
}

#### iterations
#engl.iter.tab             = ipf.calc.iter.tab(agg.dat = aggr_besip, ind.dat = indi_besip, tab = 0)
#engl.tab.iter.sums        = as.data.frame(sum(engl.iter.tab > 2000))
#names(engl.tab.iter.sums) = "keinTab"
#for (i in 1:length(tabs.grid)){
#   engl.tab.iter.sums = cbind(engl.tab.iter.sums, sum(ipf.calc.iter.tab(agg.dat = aggr_besip, ind.dat = indi_besip, tab = tabs.grid[i]) > 2000))
#   names(engl.tab.iter.sums)[i+1] = paste("Tab", tabs.grid[i], sep = ".")
#}
#
####  change of values depending on convergence (tab = 0) 
#par(mfrow = c(1,3))
#boxplot(rowSums(abs(engl.tab[,-1] - engl.tab.1[,-1])/rowSums(engl.tab.1[,-1])) ~ (engl.iter.tab > 2000), ylim = c(0,1), main = "Tabs = 1")
#boxplot(rowSums(abs(engl.tab[,-1] - engl.tab.1_2[,-1])/rowSums(engl.tab.1_2[,-1])) ~ (engl.iter.tab > 2000), ylim = c(0,1), main = "Tabs = 1/2")
#boxplot(rowSums(abs(engl.tab[,-1] - engl.tab.1e10[,-1])/rowSums(engl.tab.1e10[,-1])) ~ (engl.iter.tab > 2000), ylim = c(0,1), main = "Tabs = 1e-10")
#                                                                                                                       
#### further comparisons
#engl.tab.sums.rel = prop.table(as.matrix(engl.tab.sums),2)
#
#engl.tab.sums.rel.AD = engl.tab.sums.rel
#for (i in 2:(ncol(engl.tab.sums.rel)-1)){
#   engl.tab.sums.rel.AD[,i+1] = engl.tab.sums.rel[,i+1] - engl.tab.sums.rel[,i]
#}
#
#AD.tabs = colSums(abs(engl.tab.sums.rel.AD))
#AD.org  = colSums(abs(engl.tab.sums.rel - engl.tab.sums.rel[,1]))
#
#par(mfrow = c(1,1)))
#plot(1:10, AD.org[2:11], type = "l", ylim = c(0,1), xaxt = "n", ylab = "AD", col = "red", lwd = 2, main = "Comparison Tables England after IPF")
#lines(1:10, AD.tabs[2:11], col = "blue", lwd = 2)
#axis(1, at = 1:11, labels = tabs.grid)
#legend("topright", lty = c(1,1), lwd = c(2,2), col = c("red","blue"), legend = c("AD Org","AD Tabs Gain"))

################################################################################
### ipf estimate vs HHMD estimate
# note: Green is only used in the code as pseude-placeholder, it is "others"
ipf.res.engl.tab = matrix(engl.tab.sums[,11], nrow = 6, ncol = 6, byrow = TRUE , 
                          dimnames = list(c("CON10","LAB10","LD10","UKIP10","GRE10","ABST10"),c("CON15","LAB15","LD15","UKIP15","GRE15","ABST15"))) 

## tables 
round(addmargins(ipf.res.engl.tab))
round(addmargins(sum_abs_mod_eng_hyb_6part_1))
round(100*abs(prop.table(sum_abs_mod_eng_hyb_6part_1) - prop.table(ipf.res.engl.tab)),2)

##AD comparison
# AD (all cells)
sum(abs(prop.table(sum_abs_mod_eng_hyb_6part_1)       - prop.table(ipf.res.engl.tab))) 
# AD (inner cells, without abstain)
sum(abs(prop.table(sum_abs_mod_eng_hyb_6part_1[1:5,1:5]) - prop.table(ipf.res.engl.tab[1:5,1:5]))) 
