
********************************************************************************
***Operationalization ***
********************************************************************************

use "Data/Main/matched.dta", clear

***Number of missing answers***
*(Refusal /Dont know / verweigert)
gen nmissing_all = 0
order ctzcntr ctzshipc cntbrthc lnghom1 lnghom2 fbrncntb mbrncntb 
foreach VAR of varlist nwspol-impfun {
	replace nmissing_all = nmissing_all + 1 if inlist(`VAR', .b, .c, .d)
}
label var nmissing_all "Number of Missing Items"
fre nmissing_all
*misstable summarize nwspol-impfun
*describe nwspol-impfun


***Land numerisch vercoden***
encode cntry, gen(land)


drop if agea < 18		//Minderjaehrige raus
gen logage = log(agea)
label var logage "Log. Age of Respondent"

gen female = gndr - 1
fre female
label var female "Respondent is female"

gen intfemale = intgndr - 1
fre intfemale
label var intfemale "Interviewer is female"

gen diffsex = cond(female==intfemale,0,1)
label var diffsex "Gender of Interviewer different from Respondent"
fre diffsex
list gndr intgndr diffsex in 1/30



***agematch***
gen agematch = .
gen altersdiff = agea - intagea
label var altersdiff "Age difference Respondent - Interviewer"
drop if missing(altersdiff)
replace agematch = 0 if altersdiff > 5 	//Interviewer ist juenger
replace agematch = 2 if altersdiff < -5	//Interviewer ist aelter
replace agematch = 1 if missing(agematch)	//Etwa gleich alt
label define agematch 0 "Interviewer juenger" 1 "Gleiches Alter" 2 "Interviewer aelter", replace
label var agematch "Altersmatch"
label values agematch agematch
list agea intagea altersdiff agematch in 1/40
fre agematch


***Status***
gen status = .
replace status = 0 if diffsex == 0 & agematch == 1
replace status = 1 if diffsex == 0 & agematch == 0
replace status = 2 if diffsex == 0 & agematch == 2
replace status = 3 if diffsex == 1 & agematch == 1
replace status = 4 if diffsex == 1 & agematch == 0
replace status = 5 if diffsex == 1 & agematch == 2
label define status 0 "Same Sex & Age" 1 "Same Sex, Int. younger" 2 "Same Sex, Int. older" ///
	3 "Diff. Sex, same Age" 4 "Diff. Sex, Int. younger" 5 "Diff. Sex, Int. older"
label values status status
label var status "Difference level Respondent - Interviewer
fre status
list status gndr intgndr agea intagea in 1/40


***Bildung des Befragten***
replace eisced =. if eisced == 55


***Andere Person bei Interview dabei?***
gen ppresent = abs(preintf-2)
label var ppresent "Other person being present and interfering at interview"
tab preintf ppresent, missing
fre ppresent

***Andere Erwachsene Person interveniert***
gen apresent = 0
replace apresent = 1 if prewhp == 1 | preppil == 1 | preorel == 1 | prenrel == 1
label var apresent "Erwachsene Person interveniert"
fre apresent

***Person antwortet ungerne***
recode resrelq (1/3 = 0) (4/5 = 1) (else=.), gen(ungern)
label var ungern "Person antwortet nur ungerne"
tab resrelq ungern, miss

***Kinder im Haushalt***
recode chldhm (2=0 "Nein") (1=1 "Ja") (else=.), gen(child)
label var child "Kind im Haushalt"
tab chldhm child, miss

***Ehestatus***
recode maritalb (1 2=0 "Married") (3 4 = 1 "Separated / Divorced") (5 = 2 "Widowed") ///
	(6 = 3 "Never Married") (else=.), gen(marriage)
label var marriage "Ehestatus"
tab maritalb marriage, miss

***Regionales Einkommen im Schnitt***
bysort region: egen meanincome = mean(hinctnta)
label var meanincome "Average regional income, deciles"
fre meanincome

