
********************************************************************************
***Analyses***
********************************************************************************


*log using "logfilemain", text replace
global ip = 15			//Integration points
set scheme plotplain


*******************************************
*** Number of Item Nonresponse ***
*******************************************

preserve
egen fehlend = rowmiss(nmissing_all female intfemale agematch eisced logage hhmmb child marriage cntry intnum meanincome)
keep if fehlend == 0
menbreg nmissing_all ||cntry: ||intnum: ///
	,covar(unstructured) intpoints($ip) intmethod(gh)
est sto m1_1, title(Nonresponse Empty)
estat ic
*
menbreg nmissing_all i.female##i.intfemale##i.agematch ||cntry: ||intnum: ///
	,covar(unstructured) intpoints($ip) intmethod(gh)
est sto m1_2, title(Nonresponse Main)
estat ic
*
menbreg nmissing_all i.female##i.intfemale##i.agematch i.eisced c.logage c.hhmmb i.child i.marriage c.meanincome ||cntry: ||intnum: ///
	,covar(unstructured) intpoints($ip) intmethod(gh)
est sto m1_3, title(Nonresponse Full)
margins intfemale, at(female =(0 1) agematch=(0 1 2))
marginsplot, by(female) name(m_count, replace)
graph save m_count "m_count.gph", replace
margins ar.intfemale, at(female=(0 1) agematch = (0 1 2))
estat ic
*
esttab m1_1 m1_2 m1_3 using "menbreg_nested.rtf",nogaps ///
	nomtitles star(* 0.05 ** 0.01 *** 0.001) aic ///
	b(3) se label replace wide
restore



*******************************************
*** Reluctance Ologit                   ***
*******************************************

preserve
egen fehlend = rowmiss(resrelq female intfemale agematch eisced logage hhmmb child marriage cntry intnum meanincome)
keep if fehlend == 0
meologit resrelq  ||cntry: ||intnum: ///
	,covar(unstructured) intpoints($ip) intmethod(gh)
est sto m2_1, title(Resrelq Empty)
*
meologit resrelq i.female##i.intfemale##i.agematch ||cntry: ||intnum: ///
	,covar(unstructured) intpoints($ip) intmethod(gh)
est sto m2_2, title(Resrelq Main)
*
meologit resrelq i.female##i.intfemale##i.agematch i.eisced c.logage c.hhmmb i.child i.marriage c.meanincome ///
	||cntry: ||intnum: ,covar(unstructured) intpoints($ip) intmethod(gh)
est sto m2_3, title(Resrelq Full)
margins intfemale, at(female =(0 1) agematch=(0 1 2)) predict(outcome(5))
marginsplot, by(female) name(m_ologit, replace)
graph save m_ologit "m_ologit.gph", replace
margins ar.intfemale, at(female=(0 1) agematch = (0 1 2)) predict(outcome(5))
*
esttab m2_2 m2_3 using "meologit_resrelq.rtf",nogaps ///
	nomtitles star(* 0.05 ** 0.01 *** 0.001) aic ///
	b(3) se label replace wide
esttab m2_1 using "meologit_resrelq_m1.rtf",nogaps ///
	nomtitles star(* 0.05 ** 0.01 *** 0.001) aic ///
	b(3) se label replace wide
restore



*******************************************
*** Chance for other adult person being there ***
*******************************************

preserve
cap drop fehlend
egen fehlend = rowmiss(apresent female intfemale agematch eisced logage hhmmb child marriage cntry intnum meanincome)
keep if fehlend == 0
melogit apresent  ||cntry: ||intnum: ///
	,covar(unstructured) intpoints($ip)
est sto m3_1, title(Interfering Empty)
estat icc
*
melogit apresent i.female##i.intfemale##i.agematch ||cntry: ||intnum: ///
	,covar(unstructured) intpoints($ip)
est sto m3_2, title(Interfering Main)
estat icc
*
melogit apresent i.female##i.intfemale##i.agematch i.eisced c.logage c.hhmmb i.child i.marriage c.meanincome ///
	||cntry: ||intnum: ,covar(unstructured) intpoints($ip)
est sto m3_3, title(Interfering Full)
margins intfemale, at(female =(0 1) agematch=(0 1 2))
*marginsplot, by(female) name(m_logit, replace)
*graph save m_logit "m_logit.gph", replace
margins ar.intfemale, at(female=(0 1) agematch = (0 1 2))
estat icc
*
esttab m3_1 m3_2 m3_3 using "melogit_interfering.rtf",nogaps ///
	nomtitles star(* 0.05 ** 0.01 *** 0.001) aic ///
	b(3) se label replace wide
restore












************************************************************
*** Deskriptive Statistiken ***
************************************************************


***Deskriptive Statistiken nach Land***
preserve
bysort land: egen mittelmiss = mean(nmissing_all)
bysort land: egen sdmiss = sd(nmissing_all)
bysort land: egen medianmiss = median(nmissing_all)
bysort land: egen mittelapresent = mean(apresent)
bysort land: egen mittelungern = mean(ungern)
bysort land: egen mittelresrelq = mean(resrelq)
bysort land: egen sdresrelq = sd(resrelq)
bysort land: gen counter = _n
gen numberslot = 1
bysort land: egen landsumme = sum(numberslot)

keep if counter == 1
list land landsumme mittelmiss sdmiss medianmiss  ///
	 mittelresrelq sdresrelq mittelapresent, clean abb(15)
restore



***Interviewer pro Land***
matrix ints = J(23, 1, .)
matrix list ints
local row = 1
foreach NUM of numlist 1/23 {
preserve
	keep if land == `NUM'
	cap drop counter
	bysort intnum: gen counter = _n
	keep if counter == 1
	sum intagea intgndr
	quiet sum counter
	local test = r(N)
	matrix ints[`row', 1] = `test'
	local row = `row' + 1
	restore
}
matrix list ints
	





cap log close



***Correlations nach Land***
bysort land: spearman resrelq nmissing_all apresent, star(0.05)
spearman resrelq nmissing_all apresent, star(0.05)
