


quiet do "Dos/Operationalization.do"		//Load fresh dataset


***Item Nonresponse***
tempname a
postfile `a' co1 se1 co2 se2 co3 se3 ///
	using "Output/res_nmissing.dta", replace
foreach LAND of numlist 1/23 {
	preserve
	keep if land == `LAND'
	fre land
	quiet menbreg nmissing_all i.female##i.intfemale##i.agematch i.eisced c.logage c.hhmmb i.child i.marriage c.meanincome ||intnum: ///
		,intpoints(15) intmethod(gh)
		
	foreach FEMALE of numlist 0 1 {
		foreach INTFEMALE of numlist 0 1{
			foreach AGEMATCH of numlist 0 1 2 {
				margins, at(intfemale=(`INTFEMALE') female=(`FEMALE') agematch=(`AGEMATCH'))
				matrix res1 = r(b)
				matrix res2 = r(V)
				local pred`AGEMATCH' = res1[1,1]
				local sd`AGEMATCH' = sqrt(res2[1,1])
			}
			post `a' (`pred0') (`sd0') (`pred1') (`sd1') (`pred2') (`sd2')
		}
	}
	restore
}

postclose `a'



********************************************************************************

***Reluctance***
quiet do "Dos/Operationalization.do"		//Load fresh dataset
tempname b
postfile `b' co1 se1 co2 se2 co3 se3 ///
	using "Output/res_reluctance.dta", replace
foreach LAND of numlist 1/23 {
	preserve
	keep if land == `LAND'
	fre land
	quiet meologit resrelq i.female##i.intfemale##i.agematch i.eisced c.logage c.hhmmb i.child i.marriage c.meanincome ///
		||intnum: ,intpoints(15) intmethod(gh)
		
	foreach FEMALE of numlist 0 1 {
		foreach INTFEMALE of numlist 0 1{
			foreach AGEMATCH of numlist 0 1 2 {
				margins, at(intfemale=(`INTFEMALE') female=(`FEMALE') agematch=(`AGEMATCH')) predict(outcome(5))
				matrix res1 = r(b)
				matrix res2 = r(V)
				local pred`AGEMATCH' = res1[1,1]
				local sd`AGEMATCH' = sqrt(res2[1,1])
			}
			post `b' (`pred0') (`sd0') (`pred1') (`sd1') (`pred2') (`sd2')
		}
	}
	restore
}

postclose `b'



***Other person being present***
quiet do "Dos/Operationalization.do"		//Load fresh dataset
tempname c
postfile `c' co1 se1 co2 se2 co3 se3 ///
	using "Output/res_apresent2.dta", replace
foreach LAND of numlist 1/23 {
	preserve
	keep if land == `LAND'
	fre land
	quiet melogit apresent i.female##i.intfemale##i.agematch i.eisced c.logage c.hhmmb i.child i.marriage c.meanincome ///
		||intnum: ,intpoints(15) intmethod(gh)
		
	foreach FEMALE of numlist 0 1 {
		foreach INTFEMALE of numlist 0 1{
			foreach AGEMATCH of numlist 0 1 2 {
				margins, at(intfemale=(`INTFEMALE') female=(`FEMALE') agematch=(`AGEMATCH'))
				matrix res1 = r(b)
				matrix res2 = r(V)
				local pred`AGEMATCH' = res1[1,1]
				local sd`AGEMATCH' = sqrt(res2[1,1])
			}
			post `c' (`pred0') (`sd0') (`pred1') (`sd1') (`pred2') (`sd2')
		}
	}
	restore
}

postclose `c'





***Paarweise Vergleiche***
log using "Output/allcountries.log", text replace
quiet do "Dos/Operationalization.do"		//Load fresh dataset

***
foreach LAND of numlist 1/23 {
	preserve
	keep if land == `LAND'
	fre land
	menbreg nmissing_all i.female##i.intfemale##i.agematch i.eisced c.logage c.hhmmb i.child i.marriage c.meanincome ||intnum: ///
		,intpoints(15) intmethod(gh)
	margins ar.intfemale, at(female=(0 1) agematch = (0 1 2))
	restore
}
***
foreach LAND of numlist 1/23 {
	preserve
	keep if land == `LAND'
	quiet meologit resrelq i.female##i.intfemale##i.agematch i.eisced c.logage c.hhmmb i.child i.marriage c.meanincome ///
		||intnum: , intpoints(15) intmethod(gh)
	margins ar.intfemale, at(female=(0 1) agematch = (0 1 2)) predict(outcome(5))
	restore
}
***
foreach LAND of numlist 1/23 {
	preserve
	keep if land == `LAND'
	quiet melogit apresent i.female##i.intfemale##i.agematch i.eisced c.logage c.hhmmb i.child i.marriage c.meanincome ///
		||intnum: , intpoints(15)
	margins ar.intfemale, at(female=(0 1) agematch = (0 1 2))
	restore
}	

cap log close
