% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env-binding.R
\name{scoped_bindings}
\alias{scoped_bindings}
\alias{with_bindings}
\title{Temporarily change bindings of an environment}
\usage{
scoped_bindings(..., .env = .frame, .frame = caller_env())

with_bindings(.expr, ..., .env = caller_env())
}
\arguments{
\item{...}{Pairs of names and values. These dots support splicing
(with value semantics) and name unquoting.}

\item{.env}{An environment.}

\item{.frame}{The frame environment that determines the scope of
the temporary bindings. When that frame is popped from the call
stack, bindings are switched back to their original values.}

\item{.expr}{An expression to evaluate with temporary bindings.}
}
\value{
\code{scoped_bindings()} returns the values of old bindings
invisibly; \code{with_bindings()} returns the value of \code{expr}.
}
\description{
\itemize{
\item \code{scoped_bindings()} temporarily changes bindings in \code{.env} (which
is by default the caller environment). The bindings are reset to
their original values when the current frame (or an arbitrary one
if you specify \code{.frame}) goes out of scope.
\item \code{with_bindings()} evaluates \code{expr} with temporary bindings. When
\code{with_bindings()} returns, bindings are reset to their original
values. It is a simple wrapper around \code{scoped_bindings()}.
}
}
\examples{
foo <- "foo"
bar <- "bar"

# `foo` will be temporarily rebinded while executing `expr`
with_bindings(paste(foo, bar), foo = "rebinded")
paste(foo, bar)
}
