% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prototype.R
\name{vec_type}
\alias{vec_type}
\alias{vec_type_common}
\alias{vec_ptype}
\title{Find the prototype of a set of vectors}
\usage{
vec_type(x)

vec_type_common(..., .ptype = NULL)

vec_ptype(...)
}
\arguments{
\item{..., x}{Vectors inputs}

\item{.ptype}{If \code{NULL}, the default, the output type is determined by
computing the common type across all elements of \code{...}.

Alternatively, you can supply \code{.ptype} to give the output known type.
If \code{getOption("vctrs.no_guessing")} is \code{TRUE} you must supply this value:
this is a convenient way to make production code demand fixed types.}
}
\value{
\code{vec_type()} and \code{vec_type_common()} return a prototype
(a size-0 vector)
}
\description{
\code{vec_type()} finds the prototype of a single vector.
\code{vec_type_common()} finds the common type of multiple vectors.
\code{vec_ptype()} nicely prints the common type of any number of
inputs, and is designed for interative exploration.
}
\details{
\code{vec_type_common()} first finds the prototype of each input, then
finds the common type using \code{\link[=vec_type2]{vec_type2()}} and \code{\link[=Reduce]{Reduce()}}.
}
\section{Prototype}{

A prototype is \href{vec_size}{size} 0 vector containing attributes, but no
data. Generally, this is just \code{vec_slice(x, 0L)}, but some inputs
require special handling.

For example, the prototype of logical vectors that only contain missing
values is the special \link{unspecified} type, which can be coerced to any
other 1d type. This allows bare \code{NA}s to represent missing values for
any 1d vector type.
}

\examples{
# Unknown types ------------------------------------------
vec_ptype()
vec_ptype(NA)
vec_ptype(NULL)

# Vectors ------------------------------------------------
vec_ptype(1:10)
vec_ptype(letters)
vec_ptype(TRUE)

vec_ptype(Sys.Date())
vec_ptype(Sys.time())
vec_ptype(factor("a"))
vec_ptype(ordered("a"))

# Matrices -----------------------------------------------
# The prototype of a matrix includes the number of columns
vec_ptype(array(1, dim = c(1, 2)))
vec_ptype(array("x", dim = c(1, 2)))

# Data frames --------------------------------------------
# The prototype of a data frame includes the prototype of
# every column
vec_ptype(iris)

# The prototype of multiple data frames includes the prototype
# of every column that in any data frame
vec_ptype(
  data.frame(x = TRUE),
  data.frame(y = 2),
  data.frame(z = "a")
)
}
