% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind.R
\name{vec_bind}
\alias{vec_bind}
\alias{vec_rbind}
\alias{vec_cbind}
\title{Combine many data frames into one data frame}
\usage{
vec_rbind(..., .ptype = NULL)

vec_cbind(..., .ptype = NULL, .size = NULL)
}
\arguments{
\item{...}{Data frames or vectors.

\code{vec_rbind()} ignores names. \code{vec_cbind()} preserves outer names,
combining with inner names if also present.

\code{NULL} inputs are silently ignored. Empty (e.g. zero row) inputs
will not appear in the output, but will affect the derived \code{.ptype}.}

\item{.ptype}{If \code{NULL}, the default, the output type is determined by
computing the common type across all elements of \code{...}.

Alternatively, you can supply \code{.ptype} to give the output known type.
If \code{getOption("vctrs.no_guessing")} is \code{TRUE} you must supply this value:
this is a convenient way to make production code demand fixed types.}

\item{.size}{If, \code{NULL}, the default, will determing the number of
rows in \code{vec_cbind()} output by using the standard recycling rules.

Alternatively, specify the desired number of rows, and any inputs
of length 1 will be recycled appropriately.}
}
\value{
A data frame, or subclass of data frame.

If \code{...} is a mix of different data frame subclases, \code{vec_type2()}
will be used to determine the output type. For \code{vec_rbind()}, this
will determine the type of the container and the type of each column;
for \code{vec_cbind()} it only determines the type of the output container.
If there are no non-\code{NULL} inputs, the result will be \code{data.frame()}.
}
\description{
This pair of functions binds together data frames (and vectors), either
row-wise or column-wise. Row-binding creates a data frame with common type
across all arguments. Column-binding creates a data frame with common length
across all arguments.
}
\section{Invariants}{

\itemize{
\item \code{vec_size(vec_rbind(x, y)) == vec_size(x) + vec_size(y)}
\item \code{vec_type(vec_rbind(x, y)) = vec_type_common(x, y)}
\item \code{vec_size(vec_cbind(x, y)) == vec_size_common(x, y)}
\item \code{vec_type(vec_cbind(x, y)) == vec_cbind(vec_type(x), vec_type(x))}
}
}

\examples{
# row binding -----------------------------------------

# common columns are coerced to common class
vec_rbind(
  data.frame(x = 1),
  data.frame(x = FALSE)
)

# unique columns are filled with NAs
vec_rbind(
  data.frame(x = 1),
  data.frame(y = "x")
)

# null inputs are ignored
vec_rbind(
  data.frame(x = 1),
  NULL,
  data.frame(x = 2)
)

# bare vectors are treated as rows
vec_rbind(
  c(x = 1, y = 2),
  c(x = 3)
)

# default names will be supplied if arguments are not named
vec_rbind(
  1:2,
  1:3,
  1:4
)

# column binding --------------------------------------

# each input is recycled to have common length
vec_cbind(
  data.frame(x = 1),
  data.frame(y = 1:3)
)

# bare vectors are treated as columns
vec_cbind(
  data.frame(x = 1),
  y = letters[1:3]
)

# outer names are combined with inner names
vec_cbind(
  x = data.frame(a = 1, b = 2),
  y = 1
)

# duplicate names are flagged
vec_cbind(x = 1, x = 2)

}
\seealso{
\code{\link[=vec_c]{vec_c()}} for combining 1d vectors.
}
