% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionary.R
\name{vec_unique}
\alias{vec_unique}
\alias{vec_unique_loc}
\alias{vec_unique_count}
\title{Find and count unique values}
\usage{
vec_unique(x)

vec_unique_loc(x)

vec_unique_count(x)
}
\arguments{
\item{x}{A vector (including a data frame).}
}
\value{
\itemize{
\item \code{vec_unique()}: a vector the same type as \code{x} containining only unique
values.
\item \code{vec_unique_loc()}: an integer vector, giving locations of unique values.
\item \code{vec_unique_count()}: an integer vector of length 1, giving the
number of unique values.
}
}
\description{
\itemize{
\item \code{vec_unique()}: the unique values. Equivalent to \code{\link[=unique]{unique()}}.
\item \code{vec_unique_loc()}: the locations of the unique values.
\item \code{vec_unique_count()}: the number of unique values.
}
}
\section{Missing values}{

In most cases, missing values are not considered to be equal, i.e.
\code{NA == NA} is not \code{TRUE}. This behaviour would be unappealing here,
so these functions consider all \code{NAs} to be equal. (Similarly,
all \code{NaN} are also considered to be equal.)
}

\section{Performance}{

These functions are currently slightly slower than their base equivalents.
This is primarily because they do a little more checking and coercion
in R, which makes them both a litter safer and more generic. Additionally,
the C code underlying vctrs has not yet been implemented: we expect
some performance improvements when that happens.
}

\examples{
x <- rpois(100, 8)
vec_unique(x)
vec_unique_loc(x)
vec_unique_count(x)

# `vec_unique()` returns values in the order that encounters them
# use sort = "location" to match to the result of `vec_count()`
head(vec_unique(x))
head(vec_count(x, sort = "location"))

# Normally missing values are not considered to be equal
NA == NA

# But they are for the purposes of considering uniqueness
vec_unique(c(NA, NA, NA, NA, 1, 2, 1))
}
\seealso{
\link{vec_duplicate} for functions that work with the dual of
unique values: duplicated values.
}
