% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type-tibble.R, R/type2.R
\name{vec_type2.tbl_df}
\alias{vec_type2.tbl_df}
\alias{vec_type2}
\alias{vec_type2.logical}
\alias{vec_type2.integer}
\alias{vec_type2.double}
\alias{vec_type2.character}
\alias{vec_type2.list}
\title{Find the common type for a pair of vector types}
\usage{
\method{vec_type2}{tbl_df}(x, y)

vec_type2(x, y)

\method{vec_type2}{logical}(x, y)

\method{vec_type2}{integer}(x, y)

\method{vec_type2}{double}(x, y)

\method{vec_type2}{character}(x, y)

\method{vec_type2}{list}(x, y)
}
\arguments{
\item{x, y}{Either vector types; i.e.}
}
\description{
\code{vec_type2()} finds the common type for a pair of vectors, or dies trying.
It forms the foundation of the vctrs type system, along with \code{\link[=vec_cast]{vec_cast()}}.
This powers type coercion but should not usually be called directly;
instead call \code{\link[=vec_type_common]{vec_type_common()}}.
}
\section{Coercion rules}{

vctrs thinks of the vector types as forming a partially ordered set, or
poset. Then finding the common type from a set of types is a matter of
finding the least-upper-bound; if the least-upper-bound does not exist,
there is no common type. This is the case for many pairs of 1d vectors.

The poset of the most important base vectors is shown below:
(where datetime stands for \code{POSIXt}, and date for \code{Date})

\figure{coerce.png}
}

\section{S3 dispatch}{

\code{vec_type2()} dispatches on both arguments. This is implemented by having
methods of \code{vec_type2()}, e.g. \code{vec_type2.integer()} also be S3 generics,
which call e.g. \code{vec_type2.integer.double()}. \code{vec_type2.x.y()} must
return the same value as \code{vec_type2.y.x()}; this is currently not enforced,
but should be tested.

Whenever you implemenet a \code{vec_type2.new_class()} generic/method,
make sure to always provide \code{vec_type2.new_class.default()} (
which should call \code{\link[=stop_incompatible_cast]{stop_incompatible_cast()}}) and
\code{vec_type2.new_class.vctrs_unspecified()} (which should return \code{x}).

See \code{vignette("s3-vector")} for full details.
}

\keyword{internal}
