% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify.R
\name{at_depth}
\alias{at_depth}
\title{Map at depth}
\usage{
at_depth(.x, .depth, .f, ...)
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.depth}{Level of \code{.x} to map on. Use a negative value to count up
from the lowest level of the list.
\itemize{
\item \code{map_depth(x, 0, fun)} is equivalent to \code{fun(x)}.
\item \code{map_depth(x, 1, fun)} is equivalent to \code{x <- map(x, fun)}
\item \code{map_depth(x, 2, fun)} is equivalent to \code{x <- map(x, ~ map(., fun))}
}}

\item{.f}{A function, formula, or vector (not necessarily atomic).

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.

If \strong{character vector}, \strong{numeric vector}, or \strong{list}, it is
converted to an extractor function. Character vectors index by
name and numeric vectors index by position; use a list to index
by position and name at different levels. If a component is not
present, the value of \code{.default} will be returned.}

\item{...}{Additional arguments passed on to the mapped function.}
}
\description{
This function is defunct and has been replaced by \code{\link[=map_depth]{map_depth()}}.
See also \code{\link[=modify_depth]{modify_depth()}} for a version that preserves the types of
the elements of the tree.
}
\keyword{internal}
