% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size.R
\name{vec_size}
\alias{vec_size}
\alias{vec_size_common}
\title{Number of observations}
\usage{
vec_size(x)

vec_size_common(..., .size = NULL)
}
\arguments{
\item{x, ...}{Vector inputs}

\item{.size}{If \code{NULL}, the default, the output size is determined by
recycling the lengths of all elements of \code{...}. Alternatively, you can
supply \code{.size} to force a known size.}
}
\value{
An integer (or double for long vectors). Will throw an error
if \code{x} is not a vector.

\code{vec_size_common()} will return \code{NULL} if all inputs are \code{NULL} or absent.
}
\description{
\code{vec_size(x)} returns the size of a vector. This is distinct from the
\code{\link[=length]{length()}} of a vector because it generalises to the "number of observations"
for 2d structures, i.e. it's the number of rows in matrix or a data frame.
This definition has the important property that every column of a data frame
(even data frame and matrix columns) have the same size.
\code{vec_size_common(...)} returns the common size of multiple vectors.
}
\details{
There is no vctrs helper that retrieves the number of columns: as this
is a property of the \link[=vec_ptype]{type}.

\code{vec_size()} is equivalent to \code{NROW()} but has a name that is easier to
pronounce, and throws an error when passed non-vector inputs.
}
\section{Invariants}{

\itemize{
\item \code{vec_size(dataframe)} == \code{vec_size(dataframe[[i]])}
\item \code{vec_size(matrix)} == \code{vec_size(matrix[, i, drop = FALSE])}
\item \code{vec_size(vec_c(x, y))} == \code{vec_size(x)} + \code{vec_size(y)}
}
}

\examples{
vec_size(1:100)
vec_size(mtcars)
vec_size(array(dim = c(3, 5, 10)))

vec_size(NULL)
# Because vec_size(vec_c(NULL, x)) ==
#   vec_size(NULL) + vec_size(x) ==
#   vec_size(x)

vec_size_common(1:10, 1:10)
vec_size_common(1:10, 1)
vec_size_common(1:10, integer())
}
\seealso{
\code{\link[=vec_slice]{vec_slice()}} for a variation of \code{[} compatible with \code{vec_size()},
and \code{\link[=vec_recycle]{vec_recycle()}} to recycle vectors to common length.
}
