% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type-factor.R
\name{new_factor}
\alias{new_factor}
\alias{new_ordered}
\alias{vec_type2.factor}
\alias{vec_type2.ordered}
\alias{vec_cast.factor}
\title{Factor/ordered factor S3 class}
\usage{
new_factor(x = integer(), levels = character(), ...,
  class = character())

new_ordered(x = integer(), levels = character())

\method{vec_type2}{factor}(x, y)

\method{vec_type2}{ordered}(x, y)

\method{vec_cast}{factor}(x, to)
}
\arguments{
\item{x}{Integer values which index in to \code{levels}.}

\item{levels}{Character vector of labels.}

\item{..., class}{Used to for subclasses.}
}
\description{
A \link{factor} is an integer with attribute \code{levels}, a character vector. There
should be one level for each integer between 1 and \code{max(x)}.
An \link{ordered} factor has the same properties as a factor, but possesses
an extra class that marks levels as having a total ordering.
}
\details{
These functions help the base factor and ordered factor classes fit in to
the vctrs type system by providing constructors, coercion functions,
and casting functions. \code{new_factor()} and \code{new_ordered()} are low-level
constructors - they only check that types, but not values, are valid, so
are for expert use only.
}
\keyword{internal}
