% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate.R
\name{rate-helpers}
\alias{rate-helpers}
\alias{rate_delay}
\alias{rate_backoff}
\alias{is_rate}
\title{Create delaying rate settings}
\usage{
rate_delay(pause = 1, max_times = Inf)

rate_backoff(pause_base = 1, pause_cap = 60, pause_min = 1,
  max_times = 3, jitter = TRUE)

is_rate(x)
}
\arguments{
\item{pause}{Delay between attempts in seconds.}

\item{max_times}{Maximum number of requests to attempt.}

\item{pause_base, pause_cap}{\code{rate_backoff()} uses an exponential
back-off so that each request waits \code{pause_base * 2^i} seconds,
up to a maximum of \code{pause_cap} seconds.}

\item{pause_min}{Minimum time to wait in the backoff; generally
only necessary if you need pauses less than one second (which may
not be kind to the server, use with caution!).}

\item{jitter}{Whether to introduce a random jitter in the waiting time.}

\item{x}{An object to test.}
}
\description{
These helpers create rate settings that you can pass to
\code{\link[=insistently]{insistently()}}. You can also use them in your own functions with
\code{\link[=rate_sleep]{rate_sleep()}}.
}
\examples{
# A delay rate waits the same amount of time:
rate <- rate_delay(0.02)
for (i in 1:3) rate_sleep(rate, quiet = FALSE)

# A backoff rate waits exponentially longer each time, with random
# jitter by default:
rate <- rate_backoff(pause_base = 0.2, pause_min = 0.005)
for (i in 1:3) rate_sleep(rate, quiet = FALSE)
}
\seealso{
\code{\link[=rate_sleep]{rate_sleep()}}, \code{\link[=insistently]{insistently()}}
}
