################################################################
#  Health and Retirement Data Acqusition and Preparation for
#  "Measurement Equivalence of Subjective Well-Being Scales under
#  the Presence of Acquiescent Response Style for the Racially and 
#  Ethnically Diverse Older Population in the United States"
#  by Lee, Vsquez, Ryan and Smith
################################################################
   
   
   
################ Data Read-In ######################


loc_d<-"LOCATION FOR SAS DATA"


library(haven)
hrs<-read_sas(paste(loc_d,"hrs_swb.sas7bdat",sep=""))
names(hrs)
table(hrs$RACETHLANG_10)


#Labeling variable
hrs$RACE_10<-ifelse(is.na(hrs$RACETHLANG_10),NA,
                       ifelse(hrs$RACETHLANG_10==1, "H_EN",
                              ifelse(hrs$RACETHLANG_10==2,"H_SP","NHW")))


#################### FIGURE 1 #####################

library(survey)

dhrs<-svydesign(id=~1, weights=~weight_LB_10, data=subset(hrs, !is.na(weight_LB_10)))

svyby(~LIFESAT_10,~RACE_10, dhrs, svymean, na.rm=T) 
svyby(~SDL_LIFEWHOLE_10_R,~RACE_10, dhrs, svymean, na.rm=T) 
svyby(~LS_INDEX_10,~RACE_10, dhrs, svymean, na.rm=T) 
svyby(~PIL_INDEX_10,~RACE_10, dhrs, svymean, na.rm=T) 



################ Data Preparation for MGCFA ######################

#Recoding variables

hrs$PIL_PLANSFUTURE_10_N <- -1*hrs$PIL_PLANSFUTURE_10
hrs$PIL_ACTIVITIESTRIVIAL_10_N <- -1*hrs$PIL_ACTIVITIESTRIVIAL_10
hrs$PIL_OWNPLANS_10_N <- -1*hrs$PIL_OWNPLANS_10
hrs$PIL_NOSENSE_10_N <- -1*hrs$PIL_NOSENSE_10
hrs$PIL_DONEALL_10_N<- -1*hrs$PIL_DONEALL_10
hrs$PIL_ONEDAY_10_N <- -1*hrs$PIL_ONEDAY_10
hrs$PIL_DIRECTION_10_N<- -1*hrs$PIL_DIRECTION_10

library(car)

hrs$PAF_DETERMINED_10_R <-recode(hrs$PAF_DETERMINED_10,"NA=NA;1=5;2=4;3=3;4=2;5=1")
hrs$PAF_ENTHUSIAS_10_R <-recode(hrs$PAF_ENTHUSIAS_10,"NA=NA;1=5;2=4;3=3;4=2;5=1")
hrs$PAF_ACTIVE_10_R <-recode(hrs$PAF_ACTIVE_10,"NA=NA;1=5;2=4;3=3;4=2;5=1")
hrs$PAF_PROUD_10_R <-recode(hrs$PAF_PROUD_10,"NA=NA;1=5;2=4;3=3;4=2;5=1")
hrs$PAF_INTERESTED_10_R <-recode(hrs$PAF_INTERESTED_10,"NA=NA;1=5;2=4;3=3;4=2;5=1")
hrs$PAF_HAPPY_10_R <-recode(hrs$PAF_HAPPY_10,"NA=NA;1=5;2=4;3=3;4=2;5=1")
hrs$PAF_ATTENTIVE_10_R <-recode(hrs$PAF_ATTENTIVE_10,"NA=NA;1=5;2=4;3=3;4=2;5=1")
hrs$PAF_CONTENT_10_R <-recode(hrs$PAF_CONTENT_10,"NA=NA;1=5;2=4;3=3;4=2;5=1")
hrs$PAF_INSPIRED_10_R <-recode(hrs$PAF_INSPIRED_10,"NA=NA;1=5;2=4;3=3;4=2;5=1")
hrs$PAF_HOPEFUL_10_R <-recode(hrs$PAF_HOPEFUL_10,"NA=NA;1=5;2=4;3=3;4=2;5=1")
hrs$PAF_ALERT_10_R <-recode(hrs$PAF_ALERT_10,"NA=NA;1=5;2=4;3=3;4=2;5=1")
hrs$PAF_CALM_10_R <-recode(hrs$PAF_CALM_10,"NA=NA;1=5;2=4;3=3;4=2;5=1")
hrs$PAF_EXCITED_10_R <-recode(hrs$PAF_EXCITED_10,"NA=NA;1=5;2=4;3=3;4=2;5=1")


#Creating acquiescer variable 

hrs$PIL_PLANSFUTURE_10_A<-ifelse(is.na(hrs$PIL_PLANSFUTURE_10),NA,
                                    ifelse(hrs$PIL_PLANSFUTURE_10==5|hrs$PIL_PLANSFUTURE_10==6,1,0))
hrs$PIL_ACTIVITIESTRIVIAL_10_A<-ifelse(is.na(hrs$PIL_ACTIVITIESTRIVIAL_10),NA,
                                          ifelse(hrs$PIL_ACTIVITIESTRIVIAL_10==5|hrs$PIL_ACTIVITIESTRIVIAL_10==6,1,0))
hrs$PIL_OWNPLANS_10_A<-ifelse(is.na(hrs$PIL_OWNPLANS_10),NA,
                                 ifelse(hrs$PIL_OWNPLANS_10==5|hrs$PIL_OWNPLANS_10==6,1,0))
hrs$PIL_NOSENSE_10_A<-ifelse(is.na(hrs$PIL_NOSENSE_10),NA,
                                ifelse(hrs$PIL_NOSENSE_10==5|hrs$PIL_NOSENSE_10==6,1,0))
hrs$PIL_DONEALL_10_A<-ifelse(is.na(hrs$PIL_DONEALL_10),NA,
                                ifelse(hrs$PIL_DONEALL_10==5|hrs$PIL_DONEALL_10==6,1,0))
hrs$PIL_ONEDAY_10_A<-ifelse(is.na(hrs$PIL_ONEDAY_10),NA,
                               ifelse(hrs$PIL_ONEDAY_10==5|hrs$PIL_ONEDAY_10==6,1,0))
hrs$PIL_DIRECTION_10_A<-ifelse(is.na(hrs$PIL_DIRECTION_10),NA,
                                  ifelse(hrs$PIL_DIRECTION_10==5|hrs$PIL_DIRECTION_10==6,1,0))

hrs$PIL_POS_AR<-rowSums(hrs[, c("PIL_PLANSFUTURE_10_A","PIL_OWNPLANS_10_A", 
                                "PIL_DONEALL_10_A","PIL_DIRECTION_10_A")], na.rm = TRUE)
hrs$PIL_NEG_AR<-rowSums(hrs[, c("PIL_ACTIVITIESTRIVIAL_10_A","PIL_NOSENSE_10_A", 
                                "PIL_ONEDAY_10_A")], na.rm = TRUE)
table(hrs$PIL_POS_AR,hrs$PIL_NEG_AR)

hrs$PIL_ILLOGIC_AR56<-ifelse(is.na(hrs$PIL_POS_AR)|is.na(hrs$PIL_NEG_AR),NA,
                                ifelse(hrs$PIL_POS_AR>0 & hrs$PIL_NEG_AR>0,"AR","NonAR")) 


#Wealth logarithm

summary(hrs$WEALTH_ALL_10)
hrs$LOG_WEALTH_ALL_10 <-log(hrs$WEALTH_ALL_10+843501) 


# Subseting Dataset 

hrs_HE<-hrs[hrs$RACETHLANG_10==1,]
hrs_HS<-hrs[hrs$RACETHLANG_10==2,]
hrs_NHW<-hrs[hrs$RACETHLANG_10==3,]
hrs_NonAR<-hrs[hrs$PIL_ILLOGIC_AR56=="NonAR",]
hrs_AR<-hrs[hrs$PIL_ILLOGIC_AR56=="AR",]



################# Cronbach's alpha #################

library(psych)


options(digits=5)
alpha(hrs[,c("LS_CLOSETOIDEAL_10","LS_CONDEXCELL_10",
             "LS_SATISFLIFE_10","LS_IMPORTTHINGS_10","LS_CHANGENOTH_10")])
alpha(hrs_NHW[,c("LS_CLOSETOIDEAL_10","LS_CONDEXCELL_10",
                 "LS_SATISFLIFE_10","LS_IMPORTTHINGS_10","LS_CHANGENOTH_10")])
alpha(hrs_HE[,c("LS_CLOSETOIDEAL_10","LS_CONDEXCELL_10",
                "LS_SATISFLIFE_10","LS_IMPORTTHINGS_10","LS_CHANGENOTH_10")])
alpha(hrs_HS[,c("LS_CLOSETOIDEAL_10","LS_CONDEXCELL_10",
                "LS_SATISFLIFE_10","LS_IMPORTTHINGS_10","LS_CHANGENOTH_10")])
alpha(hrs_NonAR[,c("LS_CLOSETOIDEAL_10","LS_CONDEXCELL_10",
                   "LS_SATISFLIFE_10","LS_IMPORTTHINGS_10","LS_CHANGENOTH_10")])
alpha(hrs_AR[,c("LS_CLOSETOIDEAL_10","LS_CONDEXCELL_10",
                "LS_SATISFLIFE_10","LS_IMPORTTHINGS_10","LS_CHANGENOTH_10")])
       

alpha(hrs[,c("PIL_PLANSFUTURE_10", "PIL_ACTIVITIESTRIVIAL_10_N" , 
             "PIL_OWNPLANS_10", "PIL_NOSENSE_10_N", 
                "PIL_DONEALL_10_N", "PIL_ONEDAY_10_N", "PIL_DIRECTION_10")])
alpha(hrs_NHW[,c("PIL_PLANSFUTURE_10", "PIL_ACTIVITIESTRIVIAL_10_N" , 
                 "PIL_OWNPLANS_10", "PIL_NOSENSE_10_N", 
                    "PIL_DONEALL_10_N", "PIL_ONEDAY_10_N", "PIL_DIRECTION_10")])
alpha(hrs_HE[,c("PIL_PLANSFUTURE_10", "PIL_ACTIVITIESTRIVIAL_10_N" , 
                "PIL_OWNPLANS_10", "PIL_NOSENSE_10_N", 
                   "PIL_DONEALL_10_N", "PIL_ONEDAY_10_N", "PIL_DIRECTION_10")])
alpha(hrs_HS[,c("PIL_PLANSFUTURE_10", "PIL_ACTIVITIESTRIVIAL_10_N" , 
                "PIL_OWNPLANS_10", "PIL_NOSENSE_10_N", 
                   "PIL_DONEALL_10_N", "PIL_ONEDAY_10_N", "PIL_DIRECTION_10")])
alpha(hrs_NonAR[,c("PIL_PLANSFUTURE_10", "PIL_ACTIVITIESTRIVIAL_10_N" , 
                   "PIL_OWNPLANS_10", "PIL_NOSENSE_10_N", 
                      "PIL_DONEALL_10_N", "PIL_ONEDAY_10_N", "PIL_DIRECTION_10")])
alpha(hrs_AR[,c("PIL_PLANSFUTURE_10", "PIL_ACTIVITIESTRIVIAL_10_N" , 
                "PIL_OWNPLANS_10", "PIL_NOSENSE_10_N", 
                   "PIL_DONEALL_10_N", "PIL_ONEDAY_10_N", "PIL_DIRECTION_10")])


alpha(hrs[,c("PAF_DETERMINED_10_R","PAF_ENTHUSIAS_10_R","PAF_ACTIVE_10_R","PAF_PROUD_10_R",
                "PAF_INTERESTED_10_R","PAF_HAPPY_10_R","PAF_ATTENTIVE_10_R","PAF_CONTENT_10_R",
                "PAF_INSPIRED_10_R","PAF_HOPEFUL_10_R","PAF_ALERT_10_R","PAF_CALM_10_R","PAF_EXCITED_10_R")])
alpha(hrs_NHW[,c("PAF_DETERMINED_10_R","PAF_ENTHUSIAS_10_R","PAF_ACTIVE_10_R","PAF_PROUD_10_R",
                    "PAF_INTERESTED_10_R","PAF_HAPPY_10_R","PAF_ATTENTIVE_10_R","PAF_CONTENT_10_R",
                    "PAF_INSPIRED_10_R","PAF_HOPEFUL_10_R","PAF_ALERT_10_R","PAF_CALM_10_R","PAF_EXCITED_10_R")])
alpha(hrs_HE[,c("PAF_DETERMINED_10_R","PAF_ENTHUSIAS_10_R","PAF_ACTIVE_10_R","PAF_PROUD_10_R",
                   "PAF_INTERESTED_10_R","PAF_HAPPY_10_R","PAF_ATTENTIVE_10_R","PAF_CONTENT_10_R",
                   "PAF_INSPIRED_10_R","PAF_HOPEFUL_10_R","PAF_ALERT_10_R","PAF_CALM_10_R","PAF_EXCITED_10_R")])
alpha(hrs_HS[,c("PAF_DETERMINED_10_R","PAF_ENTHUSIAS_10_R","PAF_ACTIVE_10_R","PAF_PROUD_10_R",
                   "PAF_INTERESTED_10_R","PAF_HAPPY_10_R","PAF_ATTENTIVE_10_R","PAF_CONTENT_10_R",
                   "PAF_INSPIRED_10_R","PAF_HOPEFUL_10_R","PAF_ALERT_10_R","PAF_CALM_10_R","PAF_EXCITED_10_R")])
alpha(hrs_NonAR[,c("PAF_DETERMINED_10_R","PAF_ENTHUSIAS_10_R","PAF_ACTIVE_10_R","PAF_PROUD_10_R",
                      "PAF_INTERESTED_10_R","PAF_HAPPY_10_R","PAF_ATTENTIVE_10_R","PAF_CONTENT_10_R",
                      "PAF_INSPIRED_10_R","PAF_HOPEFUL_10_R","PAF_ALERT_10_R","PAF_CALM_10_R","PAF_EXCITED_10_R")])
alpha(hrs_AR[,c("PAF_DETERMINED_10_R","PAF_ENTHUSIAS_10_R","PAF_ACTIVE_10_R","PAF_PROUD_10_R",
                   "PAF_INTERESTED_10_R","PAF_HAPPY_10_R","PAF_ATTENTIVE_10_R","PAF_CONTENT_10_R",
                   "PAF_INSPIRED_10_R","PAF_HOPEFUL_10_R","PAF_ALERT_10_R","PAF_CALM_10_R","PAF_EXCITED_10_R")])







############## Multigroup CFA ################

library(semTools)
library(lavaan)


############## Table 2 ################

#SWL Base Model
SWL_p <-"SWL =  ~LS_CLOSETOIDEAL_10 + LS_CONDEXCELL_10 + LS_SATISFLIFE_10 + LS_IMPORTTHINGS_10 + LS_CHANGENOTH_10"  

fitmeasures(cfa(SWL_p, data=hrs, group = "RACE_10", std.lv=TRUE, missing='fiml'))


#SWL Modified Model
SWL <-"SWL =  ~LS_CLOSETOIDEAL_10 + LS_CONDEXCELL_10 + LS_SATISFLIFE_10 + LS_IMPORTTHINGS_10 + LS_CHANGENOTH_10

LS_CLOSETOIDEAL_10 ~~   LS_CONDEXCELL_10
LS_SATISFLIFE_10 ~~ LS_IMPORTTHINGS_10+LS_CHANGENOTH_10
LS_IMPORTTHINGS_10 ~~   LS_CHANGENOTH_10

LS_CLOSETOIDEAL_10~~1*LS_CLOSETOIDEAL_10
LS_CONDEXCELL_10~~1*LS_CONDEXCELL_10
LS_IMPORTTHINGS_10~~1*LS_IMPORTTHINGS_10"  

fitmeasures(cfa(SWL,data=hrs,  group = "RACE_10", std.lv=TRUE, missing='fiml'))



#PIL Base Model

PIL_p<-"PIL =  ~PIL_PLANSFUTURE_10_N + PIL_ACTIVITIESTRIVIAL_10_N + PIL_OWNPLANS_10_N + PIL_NOSENSE_10_N + 
PIL_DONEALL_10_N + PIL_ONEDAY_10_N + PIL_DIRECTION_10_N"
 
fitmeasures(cfa(PIL_p, data=hrs, group = "RACE_10", std.lv=TRUE, missing='fiml'))

#PIL Modified Model

PIL<-"PIL =  ~PIL_PLANSFUTURE_10_N + PIL_ACTIVITIESTRIVIAL_10_N + PIL_OWNPLANS_10_N + PIL_NOSENSE_10_N + 
               PIL_DONEALL_10_N + PIL_ONEDAY_10_N + PIL_DIRECTION_10_N
PIL_ACTIVITIESTRIVIAL_10_N~~PIL_NOSENSE_10_N+PIL_DONEALL_10_N+PIL_ONEDAY_10_N
PIL_NOSENSE_10_N~~PIL_DONEALL_10_N+PIL_ONEDAY_10_N
PIL_DONEALL_10_N~~PIL_ONEDAY_10_N
"

fitmeasures(cfa(PIL, data=hrs, group = "RACE_10", std.lv=TRUE, missing='fiml'))
 


#PAF Base Model

PAF_p<-"PAF =  ~PAF_DETERMINED_10_R+PAF_ENTHUSIAS_10_R+PAF_ACTIVE_10_R+PAF_PROUD_10_R+PAF_INTERESTED_10_R+PAF_HAPPY_10_R+
PAF_ATTENTIVE_10_R+PAF_CONTENT_10_R+PAF_INSPIRED_10_R+PAF_HOPEFUL_10_R+PAF_ALERT_10_R+PAF_CALM_10_R+PAF_EXCITED_10_R" 

fitmeasures(cfa(PAF_p, data=hrs, group = "RACE_10", std.lv=TRUE, missing='fiml'))

#PAF Modified Model

PAF<-"PAF =  ~PAF_DETERMINED_10_R+PAF_ENTHUSIAS_10_R+PAF_ACTIVE_10_R+PAF_PROUD_10_R+PAF_INTERESTED_10_R+PAF_HAPPY_10_R+
PAF_ATTENTIVE_10_R+PAF_CONTENT_10_R+PAF_INSPIRED_10_R+PAF_HOPEFUL_10_R+PAF_ALERT_10_R+PAF_CALM_10_R+PAF_EXCITED_10_R
PAF_ENTHUSIAS_10_R~~PAF_ACTIVE_10_R+PAF_EXCITED_10_R
PAF_DETERMINED_10_R ~~  PAF_ENTHUSIAS_10_R
PAF_INSPIRED_10_R ~~    PAF_HOPEFUL_10_R
PAF_HAPPY_10_R ~~    PAF_CONTENT_10_R
PAF_PROUD_10_R ~~ PAF_INTERESTED_10_R" 

fitmeasures(cfa(PAF, data=hrs, group = "RACE_10", std.lv=TRUE, missing='fiml'))



SWL_configural<-cfa(SWL, data=hrs, group = "RACE_10", std.lv=TRUE, missing='fiml')
SWL_metric<-cfa(SWL, data=hrs, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings"))
SWL_scalar<-cfa(SWL, data=hrs, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings","intercepts")) 
SWL_strict<-cfa(SWL, data=hrs, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings","intercepts","residuals"))

PAF_configural<-cfa(PAF, data=hrs, group = "RACE_10", std.lv=TRUE, missing='fiml')
PAF_metric<-cfa(PAF, data=hrs, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings"))
PAF_scalar<-cfa(PAF, data=hrs, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings","intercepts")) 
PAF_strict<-cfa(PAF, data=hrs, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings","intercepts","residuals")) 

PIL_configural<-cfa(PIL, data=hrs, group = "RACE_10", std.lv=TRUE, missing='fiml')
PIL_metric<-cfa(PIL, data=hrs, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings"))
PIL_scalar<-cfa(PIL, data=hrs, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings","intercepts")) 
PIL_strict<-cfa(PIL, data=hrs, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings","intercepts","residuals")) 

fitMeasures(SWL_configural,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
fitMeasures(SWL_metric,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
fitMeasures(SWL_scalar,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
fitMeasures(SWL_strict,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
anova(SWL_configural,SWL_metric,SWL_scalar,SWL_strict)

fitMeasures(PAF_configural,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
fitMeasures(PAF_metric,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
fitMeasures(PAF_scalar,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
fitMeasures(PAF_strict,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
anova(PAF_configural,PAF_metric,PAF_scalar,PAF_strict)

fitMeasures(PIL_configural,c("df", "chisq","aic","cfi", "rmsea","srmr"))
fitMeasures(PIL_metric,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
fitMeasures(PIL_scalar,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
fitMeasures(PIL_strict,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
anova(PIL_configural,PIL_metric,PIL_scalar,PIL_strict)


SWL_configural_AR<-cfa(SWL, data=hrs_AR, group = "RACE_10", std.lv=TRUE, missing='fiml')
SWL_metric_AR<-cfa(SWL, data=hrs_AR, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings"))
SWL_scalar_AR<-cfa(SWL, data=hrs_AR, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings","intercepts")) 
SWL_strict_AR<-cfa(SWL, data=hrs_AR, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings","intercepts","residuals"))

PIL_configural_AR<-cfa(PIL, data=hrs_AR, group = "RACE_10", std.lv=TRUE, missing='fiml')
PIL_metric_AR<-cfa(PIL, data=hrs_AR, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings"))
PIL_scalar_AR<-cfa(PIL, data=hrs_AR, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings","intercepts")) 
PIL_strict_AR<-cfa(PIL, data=hrs_AR, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings","intercepts","residuals")) 

PAF_configural_AR<-cfa(PAF, data=hrs_AR, group = "RACE_10", std.lv=TRUE, missing='fiml')
PAF_metric_AR<-cfa(PAF, data=hrs_AR, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings"))
PAF_scalar_AR<-cfa(PAF, data=hrs_AR, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings","intercepts")) 
PAF_strict_AR<-cfa(PAF, data=hrs_AR, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings","intercepts","residuals")) 

fitMeasures(SWL_configural_AR,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
fitMeasures(SWL_metric_AR,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
fitMeasures(SWL_scalar_AR,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
fitMeasures(SWL_strict_AR,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
anova(SWL_configural_AR,SWL_metric_AR,SWL_scalar_AR,SWL_strict_AR)

fitMeasures(PAF_configural_AR,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
fitMeasures(PAF_metric_AR,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
fitMeasures(PAF_scalar_AR,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
fitMeasures(PAF_strict_AR,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
anova(PAF_configural_AR,PAF_metric_AR,PAF_scalar_AR,PAF_strict_AR)

fitMeasures(PIL_configural_AR,c("df", "chisq","aic","cfi", "rmsea","srmr"))
fitMeasures(PIL_metric_AR,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
fitMeasures(PIL_scalar_AR,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
fitMeasures(PIL_strict_AR,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
anova(PIL_configural_AR,PIL_metric_AR,PIL_scalar_AR,PIL_strict_AR)


SWL_configural_NonAR<-cfa(SWL, data=hrs_NonAR, group = "RACE_10", std.lv=TRUE, missing='fiml')
SWL_metric_NonAR<-cfa(SWL, data=hrs_NonAR, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings"))
SWL_scalar_NonAR<-cfa(SWL, data=hrs_NonAR, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings","intercepts")) 
SWL_strict_NonAR<-cfa(SWL, data=hrs_NonAR, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings","intercepts","residuals"))

PIL_configural_NonAR<-cfa(PIL, data=hrs_NonAR, group = "RACE_10", std.lv=TRUE, missing='fiml')
PIL_metric_NonAR<-cfa(PIL, data=hrs_NonAR, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings"))
PIL_scalar_NonAR<-cfa(PIL, data=hrs_NonAR, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings","intercepts")) 
PIL_strict_NonAR<-cfa(PIL, data=hrs_NonAR, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings","intercepts","residuals")) 

PAF_configural_NonAR<-cfa(PAF, data=hrs_NonAR, group = "RACE_10", std.lv=TRUE, missing='fiml')
PAF_metric_NonAR<-cfa(PAF, data=hrs_NonAR, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings"))
PAF_scalar_NonAR<-cfa(PAF, data=hrs_NonAR, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings","intercepts")) 
PAF_strict_NonAR<-cfa(PAF, data=hrs_NonAR, group = "RACE_10", std.lv=TRUE, missing='fiml',group.equal=c("loadings","intercepts","residuals")) 


fitMeasures(SWL_configural_NonAR,c("df", "chisq", "pvalue", "aic","cfi", "rmsea","srmr"))
fitMeasures(SWL_metric_NonAR,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
fitMeasures(SWL_scalar_NonAR,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
fitMeasures(SWL_strict_NonAR,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
anova(SWL_configural_NonAR,SWL_metric_NonAR,SWL_scalar_NonAR,SWL_strict_NonAR)


fitMeasures(PAF_configural_NonAR, c("df", "chisq", "pvalue", "aic","cfi", "rmsea","srmr"))
fitMeasures(PAF_metric_NonAR, c("df", "chisq", "aic","cfi", "rmsea","srmr"))
fitMeasures(PAF_scalar_NonAR, c("df", "chisq", "aic","cfi", "rmsea","srmr"))
fitMeasures(PAF_strict_NonAR, c("df", "chisq", "aic","cfi", "rmsea","srmr"))
anova(PAF_configural_NonAR,PAF_metric_NonAR,PAF_scalar_NonAR,PAF_strict_NonAR)

fitMeasures(PIL_configural_NonAR,c("df", "chisq","pvalue","aic","cfi", "rmsea","srmr"))
fitMeasures(PIL_metric_NonAR,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
fitMeasures(PIL_scalar_NonAR,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
fitMeasures(PIL_strict_NonAR,c("df", "chisq", "aic","cfi", "rmsea","srmr"))
anova(PIL_configural_NonAR,PIL_metric_NonAR,PIL_scalar_NonAR,PIL_strict_NonAR)





############## Table 3 ################


SWL_LIFESAT <-"SWL =  ~LS_CLOSETOIDEAL_10 + LS_CONDEXCELL_10 + LS_SATISFLIFE_10 + LS_IMPORTTHINGS_10 + LS_CHANGENOTH_10

LS_CLOSETOIDEAL_10 ~~   LS_CONDEXCELL_10
LS_SATISFLIFE_10 ~~ LS_IMPORTTHINGS_10+LS_CHANGENOTH_10
LS_IMPORTTHINGS_10 ~~   LS_CHANGENOTH_10

LS_CLOSETOIDEAL_10~~1*LS_CLOSETOIDEAL_10
LS_CONDEXCELL_10~~1*LS_CONDEXCELL_10
LS_IMPORTTHINGS_10~~1*LS_IMPORTTHINGS_10

SWL~LIFESAT_10"  

SWL_SRH<-"SWL =  ~LS_CLOSETOIDEAL_10 + LS_CONDEXCELL_10 + LS_SATISFLIFE_10 + LS_IMPORTTHINGS_10 + LS_CHANGENOTH_10

LS_CLOSETOIDEAL_10 ~~   LS_CONDEXCELL_10
LS_SATISFLIFE_10 ~~ LS_IMPORTTHINGS_10+LS_CHANGENOTH_10
LS_IMPORTTHINGS_10 ~~   LS_CHANGENOTH_10

LS_CLOSETOIDEAL_10~~1*LS_CLOSETOIDEAL_10
LS_CONDEXCELL_10~~1*LS_CONDEXCELL_10
LS_IMPORTTHINGS_10~~1*LS_IMPORTTHINGS_10

SWL~srh_10"  

SWL_COND<-"SWL =  ~LS_CLOSETOIDEAL_10 + LS_CONDEXCELL_10 + LS_SATISFLIFE_10 + LS_IMPORTTHINGS_10 + LS_CHANGENOTH_10

LS_CLOSETOIDEAL_10 ~~   LS_CONDEXCELL_10
LS_SATISFLIFE_10 ~~ LS_IMPORTTHINGS_10+LS_CHANGENOTH_10
LS_IMPORTTHINGS_10 ~~   LS_CHANGENOTH_10

LS_CLOSETOIDEAL_10~~1*LS_CLOSETOIDEAL_10
LS_CONDEXCELL_10~~1*LS_CONDEXCELL_10
LS_IMPORTTHINGS_10~~1*LS_IMPORTTHINGS_10

SWL~numcond_10"  

SWL_COG<-"SWL =  ~LS_CLOSETOIDEAL_10 + LS_CONDEXCELL_10 + LS_SATISFLIFE_10 + LS_IMPORTTHINGS_10 + LS_CHANGENOTH_10

LS_CLOSETOIDEAL_10 ~~   LS_CONDEXCELL_10
LS_SATISFLIFE_10 ~~ LS_IMPORTTHINGS_10+LS_CHANGENOTH_10
LS_IMPORTTHINGS_10 ~~   LS_CHANGENOTH_10

LS_CLOSETOIDEAL_10~~1*LS_CLOSETOIDEAL_10
LS_CONDEXCELL_10~~1*LS_CONDEXCELL_10
LS_IMPORTTHINGS_10~~1*LS_IMPORTTHINGS_10

SWL~recall_10" 

SWL_ALIVE <-"SWL =  ~LS_CLOSETOIDEAL_10 + LS_CONDEXCELL_10 + LS_SATISFLIFE_10 + LS_IMPORTTHINGS_10 + LS_CHANGENOTH_10

LS_CLOSETOIDEAL_10 ~~   LS_CONDEXCELL_10
LS_SATISFLIFE_10 ~~ LS_IMPORTTHINGS_10+LS_CHANGENOTH_10
LS_IMPORTTHINGS_10 ~~   LS_CHANGENOTH_10

LS_CLOSETOIDEAL_10~~1*LS_CLOSETOIDEAL_10
LS_CONDEXCELL_10~~1*LS_CONDEXCELL_10
LS_IMPORTTHINGS_10~~1*LS_IMPORTTHINGS_10

SWL~ALIVE_14"  


SWL_WEALTH<-"SWL =  ~LS_CLOSETOIDEAL_10 + LS_CONDEXCELL_10 + LS_SATISFLIFE_10 + LS_IMPORTTHINGS_10 + LS_CHANGENOTH_10

LS_CLOSETOIDEAL_10 ~~   LS_CONDEXCELL_10
LS_SATISFLIFE_10 ~~ LS_IMPORTTHINGS_10+LS_CHANGENOTH_10
LS_IMPORTTHINGS_10 ~~   LS_CHANGENOTH_10

LS_CLOSETOIDEAL_10~~1*LS_CLOSETOIDEAL_10
LS_CONDEXCELL_10~~1*LS_CONDEXCELL_10
LS_IMPORTTHINGS_10~~1*LS_IMPORTTHINGS_10

SWL~LOG_WEALTH_ALL_10"  


SWL_LIFESAT_strict<-sem(SWL_LIFESAT, data=hrs, group = "RACE_10", 
                        group.equal=c("loadings","intercepts","residuals"),
                        missing='fiml')
SWL_LIFESAT_strict_sol<-standardizedsolution(SWL_LIFESAT_strict, type = "std.all")
SWL_LIFESAT_strict_sol[SWL_LIFESAT_strict_sol$lhs=="SWL"&
                         SWL_LIFESAT_strict_sol$op=="~"&
                         SWL_LIFESAT_strict_sol$rhs=="LIFESAT_10",]

SWL_SRH_strict<-sem(SWL_SRH, data=hrs, group = "RACE_10", 
                    group.equal=c("loadings","intercepts","residuals"),
                    missing='fiml')
SWL_SRH_strict_sol<-standardizedsolution(SWL_SRH_strict, type = "std.all")
SWL_SRH_strict_sol[SWL_SRH_strict_sol$lhs=="SWL"&
                     SWL_SRH_strict_sol$op=="~"&
                     SWL_SRH_strict_sol$rhs=="srh_10",]

SWL_COND_strict<-sem(SWL_COND, data=hrs, group = "RACE_10", 
                     group.equal=c("loadings","intercepts","residuals"),
                     missing='fiml')
SWL_COND_strict_sol<-standardizedsolution(SWL_COND_strict, type = "std.all")
SWL_COND_strict_sol[SWL_COND_strict_sol$lhs=="SWL"&
                      SWL_COND_strict_sol$op=="~"&
                      SWL_COND_strict_sol$rhs=="numcond_10",]

SWL_COG_strict<-sem(SWL_COG, data=hrs, group = "RACE_10", 
                    group.equal=c("loadings","intercepts","residuals"),
                    missing='fiml')
SWL_COG_strict_sol<-standardizedsolution(SWL_COG_strict, type = "std.all")
SWL_COG_strict_sol[SWL_COG_strict_sol$lhs=="SWL"&
                     SWL_COG_strict_sol$op=="~"&
                     SWL_COG_strict_sol$rhs=="recall_10",]

SWL_WEALTH_strict<-sem(SWL_WEALTH, data=hrs, group = "RACE_10", 
                       group.equal=c("loadings","intercepts","residuals"),
                       missing='fiml')
SWL_WEALTH_strict_sol<-standardizedsolution(SWL_WEALTH_strict, type = "std.all")
SWL_WEALTH_strict_sol[SWL_WEALTH_strict_sol$lhs=="SWL"&
                        SWL_WEALTH_strict_sol$op=="~"&
                        SWL_WEALTH_strict_sol$rhs=="LOG_WEALTH_ALL_10",]

SWL_ALIVE_strict<-sem(SWL_ALIVE, data=hrs, group = "RACE_10", 
                      group.equal=c("loadings","intercepts","residuals"),
                      missing='fiml')
SWL_ALIVE_strict_sol<-standardizedsolution(SWL_ALIVE_strict, type = "std.all")
SWL_ALIVE_strict_sol[SWL_ALIVE_strict_sol$lhs=="SWL"&
                       SWL_ALIVE_strict_sol$op=="~"&
                       SWL_ALIVE_strict_sol$rhs=="ALIVE_14",]


SWL_LIFESAT_strict_AR<-sem(SWL_LIFESAT, data=hrs, group = "PIL_ILLOGIC_AR56", 
                           group.equal=c("loadings","intercepts","residuals"),
                           missing='fiml')
summary(SWL_LIFESAT_strict_AR)
SWL_LIFESAT_strict_sol_AR<-standardizedsolution(SWL_LIFESAT_strict_AR, type = "std.all")
SWL_LIFESAT_strict_sol_AR[SWL_LIFESAT_strict_sol_AR$lhs=="SWL"&
                            SWL_LIFESAT_strict_sol_AR$op=="~"&
                            SWL_LIFESAT_strict_sol_AR$rhs=="LIFESAT_10",]

SWL_SRH_strict_AR<-sem(SWL_SRH, data=hrs, group = "PIL_ILLOGIC_AR56", 
                       group.equal=c("loadings","intercepts","residuals"),
                       missing='fiml')
SWL_SRH_strict_sol_AR<-standardizedsolution(SWL_SRH_strict_AR, type = "std.all")
SWL_SRH_strict_sol_AR[SWL_SRH_strict_sol_AR$lhs=="SWL"&
                        SWL_SRH_strict_sol_AR$op=="~"&
                        SWL_SRH_strict_sol_AR$rhs=="srh_10",]

SWL_COND_strict_AR<-sem(SWL_COND, data=hrs, group = "PIL_ILLOGIC_AR56", 
                        group.equal=c("loadings","intercepts","residuals"),
                        missing='fiml')
SWL_COND_strict_sol_AR<-standardizedsolution(SWL_COND_strict_AR, type = "std.all")
SWL_COND_strict_sol_AR[SWL_COND_strict_sol_AR$lhs=="SWL"&
                         SWL_COND_strict_sol_AR$op=="~"&
                         SWL_COND_strict_sol_AR$rhs=="numcond_10",]

SWL_COG_strict_AR<-sem(SWL_COG, data=hrs, group = "PIL_ILLOGIC_AR56", 
                       group.equal=c("loadings","intercepts","residuals"),
                       missing='fiml')
SWL_COG_strict_sol_AR<-standardizedsolution(SWL_COG_strict_AR, type = "std.all")
SWL_COG_strict_sol_AR[SWL_COG_strict_sol_AR$lhs=="SWL"&
                        SWL_COG_strict_sol_AR$op=="~"&
                        SWL_COG_strict_sol_AR$rhs=="recall_10",]

SWL_WEALTH_strict_AR<-sem(SWL_WEALTH, data=hrs, group = "PIL_ILLOGIC_AR56", 
                          group.equal=c("loadings","intercepts","residuals"),
                          missing='fiml')
SWL_WEALTH_strict_sol_AR<-standardizedsolution(SWL_WEALTH_strict_AR, type = "std.all")
SWL_WEALTH_strict_sol_AR[SWL_WEALTH_strict_sol_AR$lhs=="SWL"&
                           SWL_WEALTH_strict_sol_AR$op=="~"&
                           SWL_WEALTH_strict_sol_AR$rhs=="LOG_WEALTH_ALL_10",]

SWL_ALIVE_strict_AR<-sem(SWL_ALIVE, data=hrs, group = "PIL_ILLOGIC_AR56", 
                         group.equal=c("loadings","intercepts","residuals"),
                         missing='fiml')
SWL_ALIVE_strict_sol_AR<-standardizedsolution(SWL_ALIVE_strict_AR, type = "std.all")
SWL_ALIVE_strict_sol_AR[SWL_ALIVE_strict_sol_AR$lhs=="SWL"&
                          SWL_ALIVE_strict_sol_AR$op=="~"&
                          SWL_ALIVE_strict_sol_AR$rhs=="ALIVE_14",]


PIL_LIFESAT <-"PIL =  ~PIL_PLANSFUTURE_10_N + PIL_ACTIVITIESTRIVIAL_10_N + PIL_OWNPLANS_10_N + PIL_NOSENSE_10_N + 
               PIL_DONEALL_10_N + PIL_ONEDAY_10_N + PIL_DIRECTION_10_N
PIL_ACTIVITIESTRIVIAL_10_N~~PIL_NOSENSE_10_N+PIL_DONEALL_10_N+PIL_ONEDAY_10_N
PIL_NOSENSE_10_N~~PIL_DONEALL_10_N+PIL_ONEDAY_10_N
PIL_DONEALL_10_N~~PIL_ONEDAY_10_N

PIL~LIFESAT_10"  

PIL_SRH<-"PIL =  ~PIL_PLANSFUTURE_10_N + PIL_ACTIVITIESTRIVIAL_10_N + PIL_OWNPLANS_10_N + PIL_NOSENSE_10_N + 
               PIL_DONEALL_10_N + PIL_ONEDAY_10_N + PIL_DIRECTION_10_N
PIL_ACTIVITIESTRIVIAL_10_N~~PIL_NOSENSE_10_N+PIL_DONEALL_10_N+PIL_ONEDAY_10_N
PIL_NOSENSE_10_N~~PIL_DONEALL_10_N+PIL_ONEDAY_10_N
PIL_DONEALL_10_N~~PIL_ONEDAY_10_N

PIL~srh_10"  

PIL_COND<-"PIL =  ~PIL_PLANSFUTURE_10_N + PIL_ACTIVITIESTRIVIAL_10_N + PIL_OWNPLANS_10_N + PIL_NOSENSE_10_N + 
               PIL_DONEALL_10_N + PIL_ONEDAY_10_N + PIL_DIRECTION_10_N
PIL_ACTIVITIESTRIVIAL_10_N~~PIL_NOSENSE_10_N+PIL_DONEALL_10_N+PIL_ONEDAY_10_N
PIL_NOSENSE_10_N~~PIL_DONEALL_10_N+PIL_ONEDAY_10_N
PIL_DONEALL_10_N~~PIL_ONEDAY_10_N

PIL~numcond_10"  

PIL_COG<-"PIL =  ~PIL_PLANSFUTURE_10_N + PIL_ACTIVITIESTRIVIAL_10_N + PIL_OWNPLANS_10_N + PIL_NOSENSE_10_N + 
               PIL_DONEALL_10_N + PIL_ONEDAY_10_N + PIL_DIRECTION_10_N
PIL_ACTIVITIESTRIVIAL_10_N~~PIL_NOSENSE_10_N+PIL_DONEALL_10_N+PIL_ONEDAY_10_N
PIL_NOSENSE_10_N~~PIL_DONEALL_10_N+PIL_ONEDAY_10_N
PIL_DONEALL_10_N~~PIL_ONEDAY_10_N

PIL~recall_10" 

PIL_WEALTH<-"PIL =  ~PIL_PLANSFUTURE_10_N + PIL_ACTIVITIESTRIVIAL_10_N + PIL_OWNPLANS_10_N + PIL_NOSENSE_10_N + 
               PIL_DONEALL_10_N + PIL_ONEDAY_10_N + PIL_DIRECTION_10_N
PIL_ACTIVITIESTRIVIAL_10_N~~PIL_NOSENSE_10_N+PIL_DONEALL_10_N+PIL_ONEDAY_10_N
PIL_NOSENSE_10_N~~PIL_DONEALL_10_N+PIL_ONEDAY_10_N
PIL_DONEALL_10_N~~PIL_ONEDAY_10_N

PIL~LOG_WEALTH_ALL_10"  

PIL_ALIVE <-"PIL =  ~PIL_PLANSFUTURE_10_N + PIL_ACTIVITIESTRIVIAL_10_N + PIL_OWNPLANS_10_N + PIL_NOSENSE_10_N + 
               PIL_DONEALL_10_N + PIL_ONEDAY_10_N + PIL_DIRECTION_10_N
PIL_ACTIVITIESTRIVIAL_10_N~~PIL_NOSENSE_10_N+PIL_DONEALL_10_N+PIL_ONEDAY_10_N
PIL_NOSENSE_10_N~~PIL_DONEALL_10_N+PIL_ONEDAY_10_N
PIL_DONEALL_10_N~~PIL_ONEDAY_10_N

PIL~ALIVE_14"  


PIL_LIFESAT_metric<-sem(PIL_LIFESAT, data=hrs, group = "RACE_10", 
                        group.equal=c("loadings"),
                        missing='fiml')
PIL_LIFESAT_metric_sol<-standardizedsolution(PIL_LIFESAT_metric, type = "std.all")
PIL_LIFESAT_metric_sol[PIL_LIFESAT_metric_sol$lhs=="PIL"&
                         PIL_LIFESAT_metric_sol$op=="~"&
                         PIL_LIFESAT_metric_sol$rhs=="LIFESAT_10",]

PIL_SRH_metric<-sem(PIL_SRH, data=hrs, group = "RACE_10", 
                    group.equal=c("loadings"),
                    missing='fiml')
PIL_SRH_metric_sol<-standardizedsolution(PIL_SRH_metric, type = "std.all")
PIL_SRH_metric_sol[PIL_SRH_metric_sol$lhs=="PIL"&
                     PIL_SRH_metric_sol$op=="~"&
                     PIL_SRH_metric_sol$rhs=="srh_10",]

PIL_COND_metric<-sem(PIL_COND, data=hrs, group = "RACE_10", 
                     group.equal=c("loadings"),
                     missing='fiml')
PIL_COND_metric_sol<-standardizedsolution(PIL_COND_metric, type = "std.all")
PIL_COND_metric_sol[PIL_COND_metric_sol$lhs=="PIL"&
                      PIL_COND_metric_sol$op=="~"&
                      PIL_COND_metric_sol$rhs=="numcond_10",]

PIL_COG_metric<-sem(PIL_COG, data=hrs, group = "RACE_10", 
                    group.equal=c("loadings"),
                    missing='fiml')
PIL_COG_metric_sol<-standardizedsolution(PIL_COG_metric, type = "std.all")
PIL_COG_metric_sol[PIL_COG_metric_sol$lhs=="PIL"&
                     PIL_COG_metric_sol$op=="~"&
                     PIL_COG_metric_sol$rhs=="recall_10",]

PIL_WEALTH_metric<-sem(PIL_WEALTH, data=hrs, group = "RACE_10", 
                       group.equal=c("loadings"),
                       missing='fiml')
PIL_WEALTH_metric_sol<-standardizedsolution(PIL_WEALTH_metric, type = "std.all")
PIL_WEALTH_metric_sol[PIL_WEALTH_metric_sol$lhs=="PIL"&
                        PIL_WEALTH_metric_sol$op=="~"&
                        PIL_WEALTH_metric_sol$rhs=="LOG_WEALTH_ALL_10",]

PIL_ALIVE_metric<-sem(PIL_ALIVE, data=hrs, group = "RACE_10", 
                      group.equal=c("loadings"),
                      missing='fiml')
PIL_ALIVE_metric_sol<-standardizedsolution(PIL_ALIVE_metric, type = "std.all")
PIL_ALIVE_metric_sol[PIL_ALIVE_metric_sol$lhs=="PIL"&
                       PIL_ALIVE_metric_sol$op=="~"&
                       PIL_ALIVE_metric_sol$rhs=="ALIVE_14",]


PIL_LIFESAT_metric_AR<-sem(PIL_LIFESAT, data=hrs, group = "PIL_ILLOGIC_AR56", 
                           group.equal=c("loadings"),
                           missing='fiml')
PIL_LIFESAT_metric_sol_AR<-standardizedsolution(PIL_LIFESAT_metric_AR, type = "std.all")
PIL_LIFESAT_metric_sol_AR[PIL_LIFESAT_metric_sol_AR$lhs=="PIL"&
                            PIL_LIFESAT_metric_sol_AR$op=="~"&
                            PIL_LIFESAT_metric_sol_AR$rhs=="LIFESAT_10",]

PIL_SRH_metric_AR<-sem(PIL_SRH, data=hrs, group = "PIL_ILLOGIC_AR56", 
                       group.equal=c("loadings"),
                       missing='fiml')
PIL_SRH_metric_sol_AR<-standardizedsolution(PIL_SRH_metric_AR, type = "std.all")
PIL_SRH_metric_sol_AR[PIL_SRH_metric_sol_AR$lhs=="PIL"&
                        PIL_SRH_metric_sol_AR$op=="~"&
                        PIL_SRH_metric_sol_AR$rhs=="srh_10",]

PIL_COND_metric_AR<-sem(PIL_COND, data=hrs, group = "PIL_ILLOGIC_AR56", 
                        group.equal=c("loadings"),
                        missing='fiml')
PIL_COND_metric_sol_AR<-standardizedsolution(PIL_COND_metric_AR, type = "std.all")
PIL_COND_metric_sol_AR[PIL_COND_metric_sol_AR$lhs=="PIL"&
                         PIL_COND_metric_sol_AR$op=="~"&
                         PIL_COND_metric_sol_AR$rhs=="numcond_10",]

PIL_COG_metric_AR<-sem(PIL_COG, data=hrs, group = "PIL_ILLOGIC_AR56", 
                       group.equal=c("loadings"),
                       missing='fiml')
PIL_COG_metric_sol_AR<-standardizedsolution(PIL_COG_metric_AR, type = "std.all")
PIL_COG_metric_sol_AR[PIL_COG_metric_sol_AR$lhs=="PIL"&
                        PIL_COG_metric_sol_AR$op=="~"&
                        PIL_COG_metric_sol_AR$rhs=="recall_10",]

PIL_WEALTH_metric_AR<-sem(PIL_WEALTH, data=hrs, group = "PIL_ILLOGIC_AR56", 
                          group.equal=c("loadings"),
                          missing='fiml')
PIL_WEALTH_metric_sol_AR<-standardizedsolution(PIL_WEALTH_metric_AR, type = "std.all")
PIL_WEALTH_metric_sol_AR[PIL_WEALTH_metric_sol_AR$lhs=="PIL"&
                           PIL_WEALTH_metric_sol_AR$op=="~"&
                           PIL_WEALTH_metric_sol_AR$rhs=="LOG_WEALTH_ALL_10",]

PIL_ALIVE_metric_AR<-sem(PIL_ALIVE, data=hrs, group = "PIL_ILLOGIC_AR56", 
                         group.equal=c("loadings"),
                         missing='fiml')
PIL_ALIVE_metric_sol_AR<-standardizedsolution(PIL_ALIVE_metric_AR, type = "std.all")
PIL_ALIVE_metric_sol_AR[PIL_ALIVE_metric_sol_AR$lhs=="PIL"&
                          PIL_ALIVE_metric_sol_AR$op=="~"&
                          PIL_ALIVE_metric_sol_AR$rhs=="ALIVE_14",]



PAF_LIFESAT <-"PAF =  ~PAF_DETERMINED_10_R+PAF_ENTHUSIAS_10_R+PAF_ACTIVE_10_R+PAF_PROUD_10_R+PAF_INTERESTED_10_R+PAF_HAPPY_10_R+
PAF_ATTENTIVE_10_R+PAF_CONTENT_10_R+PAF_INSPIRED_10_R+PAF_HOPEFUL_10_R+PAF_ALERT_10_R+PAF_CALM_10_R+PAF_EXCITED_10_R

PAF_ENTHUSIAS_10_R~~PAF_ACTIVE_10_R+PAF_EXCITED_10_R
PAF_DETERMINED_10_R ~~  PAF_ENTHUSIAS_10_R
PAF_INSPIRED_10_R ~~    PAF_HOPEFUL_10_R
PAF_HAPPY_10_R ~~    PAF_CONTENT_10_R
PAF_PROUD_10_R ~~ PAF_INTERESTED_10_R

PAF~LIFESAT_10"  

PAF_SRH<-"PAF =  ~PAF_DETERMINED_10_R+PAF_ENTHUSIAS_10_R+PAF_ACTIVE_10_R+PAF_PROUD_10_R+PAF_INTERESTED_10_R+PAF_HAPPY_10_R+
PAF_ATTENTIVE_10_R+PAF_CONTENT_10_R+PAF_INSPIRED_10_R+PAF_HOPEFUL_10_R+PAF_ALERT_10_R+PAF_CALM_10_R+PAF_EXCITED_10_R
PAF_INTERESTED_10_R~~PAF_ATTENTIVE_10_R+PAF_ALERT_10_R

PAF_ENTHUSIAS_10_R~~PAF_ACTIVE_10_R+PAF_EXCITED_10_R
PAF_DETERMINED_10_R ~~  PAF_ENTHUSIAS_10_R
PAF_INSPIRED_10_R ~~    PAF_HOPEFUL_10_R
PAF_HAPPY_10_R ~~    PAF_CONTENT_10_R
PAF_PROUD_10_R ~~ PAF_INTERESTED_10_R

PAF~srh_10"  

PAF_COND<-"PAF =  ~PAF_DETERMINED_10_R+PAF_ENTHUSIAS_10_R+PAF_ACTIVE_10_R+PAF_PROUD_10_R+PAF_INTERESTED_10_R+PAF_HAPPY_10_R+
PAF_ATTENTIVE_10_R+PAF_CONTENT_10_R+PAF_INSPIRED_10_R+PAF_HOPEFUL_10_R+PAF_ALERT_10_R+PAF_CALM_10_R+PAF_EXCITED_10_R 

PAF_ENTHUSIAS_10_R~~PAF_ACTIVE_10_R+PAF_EXCITED_10_R
PAF_DETERMINED_10_R ~~  PAF_ENTHUSIAS_10_R
PAF_INSPIRED_10_R ~~    PAF_HOPEFUL_10_R
PAF_HAPPY_10_R ~~    PAF_CONTENT_10_R
PAF_PROUD_10_R ~~ PAF_INTERESTED_10_R

PAF~numcond_10"  

PAF_COG<-"PAF =  ~PAF_DETERMINED_10_R+PAF_ENTHUSIAS_10_R+PAF_ACTIVE_10_R+PAF_PROUD_10_R+PAF_INTERESTED_10_R+PAF_HAPPY_10_R+
PAF_ATTENTIVE_10_R+PAF_CONTENT_10_R+PAF_INSPIRED_10_R+PAF_HOPEFUL_10_R+PAF_ALERT_10_R+PAF_CALM_10_R+PAF_EXCITED_10_R 

PAF_ENTHUSIAS_10_R~~PAF_ACTIVE_10_R+PAF_EXCITED_10_R
PAF_DETERMINED_10_R ~~  PAF_ENTHUSIAS_10_R
PAF_INSPIRED_10_R ~~    PAF_HOPEFUL_10_R
PAF_HAPPY_10_R ~~    PAF_CONTENT_10_R
PAF_PROUD_10_R ~~ PAF_INTERESTED_10_R

PAF~recall_10" 

PAF_WEALTH<-"PAF =  ~PAF_DETERMINED_10_R+PAF_ENTHUSIAS_10_R+PAF_ACTIVE_10_R+PAF_PROUD_10_R+PAF_INTERESTED_10_R+PAF_HAPPY_10_R+
PAF_ATTENTIVE_10_R+PAF_CONTENT_10_R+PAF_INSPIRED_10_R+PAF_HOPEFUL_10_R+PAF_ALERT_10_R+PAF_CALM_10_R+PAF_EXCITED_10_R

PAF_ENTHUSIAS_10_R~~PAF_ACTIVE_10_R+PAF_EXCITED_10_R
PAF_DETERMINED_10_R ~~  PAF_ENTHUSIAS_10_R
PAF_INSPIRED_10_R ~~    PAF_HOPEFUL_10_R
PAF_HAPPY_10_R ~~    PAF_CONTENT_10_R
PAF_PROUD_10_R ~~ PAF_INTERESTED_10_R

PAF~LOG_WEALTH_ALL_10"  

PAF_ALIVE <-"PAF =  ~PAF_DETERMINED_10_R+PAF_ENTHUSIAS_10_R+PAF_ACTIVE_10_R+PAF_PROUD_10_R+PAF_INTERESTED_10_R+PAF_HAPPY_10_R+
PAF_ATTENTIVE_10_R+PAF_CONTENT_10_R+PAF_INSPIRED_10_R+PAF_HOPEFUL_10_R+PAF_ALERT_10_R+PAF_CALM_10_R+PAF_EXCITED_10_R

PAF_ENTHUSIAS_10_R~~PAF_ACTIVE_10_R+PAF_EXCITED_10_R
PAF_DETERMINED_10_R ~~  PAF_ENTHUSIAS_10_R
PAF_INSPIRED_10_R ~~    PAF_HOPEFUL_10_R
PAF_HAPPY_10_R ~~    PAF_CONTENT_10_R
PAF_PROUD_10_R ~~ PAF_INTERESTED_10_R

PAF~ALIVE_14"  


PAF_LIFESAT_scalar<-sem(PAF_LIFESAT, data=hrs, group = "RACE_10", 
                        group.equal=c("loadings","intercepts"),
                        missing='fiml')
PAF_LIFESAT_scalar_sol<-standardizedsolution(PAF_LIFESAT_scalar, type = "std.all")
PAF_LIFESAT_scalar_sol[PAF_LIFESAT_scalar_sol$lhs=="PAF"&
                         PAF_LIFESAT_scalar_sol$op=="~"&
                         PAF_LIFESAT_scalar_sol$rhs=="LIFESAT_10",]

PAF_SRH_scalar<-sem(PAF_SRH, data=hrs, group = "RACE_10", 
                    group.equal=c("loadings","intercepts"),
                    missing='fiml')
PAF_SRH_scalar_sol<-standardizedsolution(PAF_SRH_scalar, type = "std.all")
PAF_SRH_scalar_sol[PAF_SRH_scalar_sol$lhs=="PAF"&
                     PAF_SRH_scalar_sol$op=="~"&
                     PAF_SRH_scalar_sol$rhs=="srh_10",]

PAF_COND_scalar<-sem(PAF_COND, data=hrs, group = "RACE_10", 
                     group.equal=c("loadings","intercepts"),
                     missing='fiml')
PAF_COND_scalar_sol<-standardizedsolution(PAF_COND_scalar, type = "std.all")
PAF_COND_scalar_sol[PAF_COND_scalar_sol$lhs=="PAF"&
                      PAF_COND_scalar_sol$op=="~"&
                      PAF_COND_scalar_sol$rhs=="numcond_10",]

PAF_COG_scalar<-sem(PAF_COG, data=hrs, group = "RACE_10", 
                    group.equal=c("loadings","intercepts"),
                    missing='fiml')
PAF_COG_scalar_sol<-standardizedsolution(PAF_COG_scalar, type = "std.all")
PAF_COG_scalar_sol[PAF_COG_scalar_sol$lhs=="PAF"&
                     PAF_COG_scalar_sol$op=="~"&
                     PAF_COG_scalar_sol$rhs=="recall_10",]

PAF_WEALTH_scalar<-sem(PAF_WEALTH, data=hrs, group = "RACE_10", 
                       group.equal=c("loadings","intercepts"),
                       missing='fiml')
PAF_WEALTH_scalar_sol<-standardizedsolution(PAF_WEALTH_scalar, type = "std.all")
PAF_WEALTH_scalar_sol[PAF_WEALTH_scalar_sol$lhs=="PAF"&
                        PAF_WEALTH_scalar_sol$op=="~"&
                        PAF_WEALTH_scalar_sol$rhs=="LOG_WEALTH_ALL_10",]

PAF_ALIVE_scalar<-sem(PAF_ALIVE, data=hrs, group = "RACE_10", 
                      group.equal=c("loadings","intercepts"),
                      missing='fiml')
PAF_ALIVE_scalar_sol<-standardizedsolution(PAF_ALIVE_scalar, type = "std.all")
PAF_ALIVE_scalar_sol[PAF_ALIVE_scalar_sol$lhs=="PAF"&
                       PAF_ALIVE_scalar_sol$op=="~"&
                       PAF_ALIVE_scalar_sol$rhs=="ALIVE_14",]


PAF_LIFESAT_scalar_AR<-sem(PAF_LIFESAT, data=hrs, group = "PIL_ILLOGIC_AR56", 
                           group.equal=c("loadings","intercepts"),
                           missing='fiml')
PAF_LIFESAT_scalar_sol_AR<-standardizedsolution(PAF_LIFESAT_scalar_AR, type = "std.all")
PAF_LIFESAT_scalar_sol_AR[PAF_LIFESAT_scalar_sol_AR$lhs=="PAF"&
                            PAF_LIFESAT_scalar_sol_AR$op=="~"&
                            PAF_LIFESAT_scalar_sol_AR$rhs=="LIFESAT_10",]

PAF_SRH_scalar_AR<-sem(PAF_SRH, data=hrs, group = "PIL_ILLOGIC_AR56", 
                       group.equal=c("loadings","intercepts"),
                       missing='fiml')
PAF_SRH_scalar_sol_AR<-standardizedsolution(PAF_SRH_scalar_AR, type = "std.all")
PAF_SRH_scalar_sol_AR[PAF_SRH_scalar_sol_AR$lhs=="PAF"&
                        PAF_SRH_scalar_sol_AR$op=="~"&
                        PAF_SRH_scalar_sol_AR$rhs=="srh_10",]

PAF_COND_scalar_AR<-sem(PAF_COND, data=hrs, group = "PIL_ILLOGIC_AR56", 
                        group.equal=c("loadings","intercepts"),
                        missing='fiml')
PAF_COND_scalar_sol_AR<-standardizedsolution(PAF_COND_scalar_AR, type = "std.all")
PAF_COND_scalar_sol_AR[PAF_COND_scalar_sol_AR$lhs=="PAF"&
                         PAF_COND_scalar_sol_AR$op=="~"&
                         PAF_COND_scalar_sol_AR$rhs=="numcond_10",]

PAF_COG_scalar_AR<-sem(PAF_COG, data=hrs, group = "PIL_ILLOGIC_AR56", 
                       group.equal=c("loadings","intercepts"),
                       missing='fiml')
PAF_COG_scalar_sol_AR<-standardizedsolution(PAF_COG_scalar_AR, type = "std.all")
PAF_COG_scalar_sol_AR[PAF_COG_scalar_sol_AR$lhs=="PAF"&
                        PAF_COG_scalar_sol_AR$op=="~"&
                        PAF_COG_scalar_sol_AR$rhs=="recall_10",]

PAF_WEALTH_scalar_AR<-sem(PAF_WEALTH, data=hrs, group = "PIL_ILLOGIC_AR56", 
                          group.equal=c("loadings","intercepts"),
                          missing='fiml')
PAF_WEALTH_scalar_sol_AR<-standardizedsolution(PAF_WEALTH_scalar_AR, type = "std.all")
PAF_WEALTH_scalar_sol_AR[PAF_WEALTH_scalar_sol_AR$lhs=="PAF"&
                           PAF_WEALTH_scalar_sol_AR$op=="~"&
                           PAF_WEALTH_scalar_sol_AR$rhs=="LOG_WEALTH_ALL_10",]

PAF_ALIVE_scalar_AR<-sem(PAF_ALIVE, data=hrs, group = "PIL_ILLOGIC_AR56", 
                         group.equal=c("loadings","intercepts"),
                         missing='fiml')
PAF_ALIVE_scalar_sol_AR<-standardizedsolution(PAF_ALIVE_scalar_AR, type = "std.all")
PAF_ALIVE_scalar_sol_AR[PAF_ALIVE_scalar_sol_AR$lhs=="PAF"&
                          PAF_ALIVE_scalar_sol_AR$op=="~"&
                          PAF_ALIVE_scalar_sol_AR$rhs=="ALIVE_14",]



############## Supplemental Table 1 ################

SWL_p_configural_sol<-standardizedsolution(cfa(SWL_p, data=hrs, group = "RACE_10", std.lv=TRUE, missing='fiml'), type = "std.all")
PIL_p_configural_sol<-standardizedsolution(cfa(PIL_p, data=hrs, group = "RACE_10", std.lv=TRUE, missing='fiml'), type = "std.all")
PAF_p_configural_sol<-standardizedsolution(cfa(PAF_p, data=hrs, group = "RACE_10", std.lv=TRUE, missing='fiml'), type = "std.all")

SWL_configural_sol<-standardizedsolution(SWL_configural, type = "std.all")
PIL_configural_sol<-standardizedsolution(PIL_configural, type = "std.all")
PAF_configural_sol<-standardizedsolution(PAF_configural, type = "std.all")



rbind(cbind(SWL_p_configural_sol[SWL_p_configural_sol$group==1,],
                      SWL_p_configural_sol[SWL_p_configural_sol$group==2,],
                      SWL_p_configural_sol[SWL_p_configural_sol$group==3,]),
                cbind(SWL_configural_sol[SWL_configural_sol$group==1,],
                      SWL_configural_sol[SWL_configural_sol$group==2,],
                      SWL_configural_sol[SWL_configural_sol$group==3,]))
rbind(cbind(PIL_p_configural_sol[PIL_p_configural_sol$group==1,],
                      PIL_p_configural_sol[PIL_p_configural_sol$group==2,],
                      PIL_p_configural_sol[PIL_p_configural_sol$group==3,]),
                cbind(PIL_configural_sol[PIL_configural_sol$group==1,],
                      PIL_configural_sol[PIL_configural_sol$group==2,],
                      PIL_configural_sol[PIL_configural_sol$group==3,]))
rbind(cbind(PAF_p_configural_sol[PAF_p_configural_sol$group==1,],
            PAF_p_configural_sol[PAF_p_configural_sol$group==2,],
            PAF_p_configural_sol[PAF_p_configural_sol$group==3,]),
      cbind(PAF_configural_sol[PAF_configural_sol$group==1,],
            PAF_configural_sol[PAF_configural_sol$group==2,],
            PAF_configural_sol[PAF_configural_sol$group==3,]))



       
       
       