﻿* Encoding: UTF-8.
*Syntax for calculating the nonresponse bias.
* You need the datafiles from the syntax_SRM file.

*We distinct between 4 groups of participants.
1 = Said they did not want to participate.
2 = Said they wanted to participate, but never did.
3 = Only pre/post questionnaire. No smartphone parts.
4= Participated in all stages.

DATASET ACTIVATE "TUS_imputed.sav".
COMPUTE total_part=resp_preq + popup_part + resp_diary  + GPS_resp + resp_postq.
EXECUTE.

COMPUTE smartphone_part=popup_part + resp_diary  + GPS_resp .
EXECUTE.

IF (smartphone_part = 0) NRB_groups=3.
IF  (total_part = 0) NRB_groups=2.
IF (total_part = 5) NRB_groups=4.
EXECUTE.

DATASET ACTIVATE DataSet1.
MATCH FILES /FILE=*
  /FILE='DataSet4'
  /RENAME (aantalhh aantalki agreeable burgstat conscientious extraversion geslacht partner 
    income_new lftdhhh leeftijd neuroticism openness oplcat participation_history nettoink_f woning 
    sted surveyburden surveyenjoyment surveyvalue TBO_response trust woonvorm worries = d0 d1 d2 d3 d4 
    d5 d6 d7 d8 d9 d10 d11 d12 d13 d14 d15 d16 d17 d18 d19 d20 d21 d22 d23 d24) 
  /BY nomem_encr
  /DROP= d0 d1 d2 d3 d4 d5 d6 d7 d8 d9 d10 d11 d12 d13 d14 d15 d16 d17 d18 d19 d20 d21 d22 d23 d24.
EXECUTE.

DELETE VARIABLES ht13a6329 to smartphone_part.
EXECUTE.

IF (TBO_response = 0) NRB_groups=1.
EXECUTE.

SAVE OUTFILE=''
  /COMPRESSED.

#how many persons are in the four groups? .
FREQUENCIES VARIABLES=NRB_groups
  /ORDER=ANALYSIS.

GET FILE "cw12e_EN_1.0p.sav" .
EXECUTE.

#How many hours per week does the respondent work? . 
COMPUTE hours_work=cw12e127.
EXECUTE.

DATASET ACTIVATE DataSet1.
MATCH FILES /FILE=*
  /FILE='DataSet10'
  /BY nomem_encr.
EXECUTE.

DELETE VARIABLES cw12e000 to q201204.
EXECUTE.

#everyone without a value is supposed to work 0 hours a week. (students, retirement, etcetera). Perhaps I should make a distinction between these groups.
COMPUTE hours_work2=hours_work.
EXECUTE.

DO IF (cw12e_m > 1).
RECODE hours_work2 (MISSING=0).
END IF.
EXECUTE.

EXAMINE VARIABLES=hours_work2 BY NRB_groups
  /PLOT BOXPLOT HISTOGRAM
  /COMPARE GROUPS
  /STATISTICS DESCRIPTIVES
  /CINTERVAL 95
  /MISSING LISTWISE
  /NOTOTAL.

#do the groups differ significantly? . Only those who participate in all stages differ from the other groups, other groups are rather similar.
ONEWAY hours_work2 BY NRB_groups
 /STATISTICS DESCRIPTIVES 
  /MISSING ANALYSIS
  /POSTHOC=LSD BONFERRONI ALPHA(0.05).


DATASET ACTIVATE "cs12e_1.0p_EN.sav".
COMPUTE Sports=cs12e105.
EXECUTE.
COMPUTE Volunteerwork=cs12e079.
EXECUTE.
COMPUTE watch_tv=(cs12e379*cs12e124 / 60).
EXECUTE.

RECODE Sports Volunteerwork watch_tv (MISSING=0).
EXECUTE.

DATASET ACTIVATE DataSet1.

MATCH FILES /FILE=*
  /FILE='"cs12e_1.0p_EN.sav"'
  /BY nomem_encr.
EXECUTE.

DELETE VARIABLES nohouse_encr to q201202.
EXECUTE.

#ANOVA to see whether the groups differ. 
ONEWAY Sports Volunteerwork watch_tv hours_work2 BY NRB_groups
  /STATISTICS DESCRIPTIVES HOMOGENEITY 
  /MISSING ANALYSIS
  /POSTHOC=LSD BONFERRONI ALPHA(0.05).

DESCRIPTIVES VARIABLES=watch_tv Sports Volunteerwork hours_work2
   /STATISTICS=MEAN STDDEV MIN MAX.

#going out: to bars, theather, cinema, dinner, terrace.
COMPUTE goingout=cs12e180 * (cs12e401 / 60).
EXECUTE.

#making music or singing.
COMPUTE music=(cs12e160 * (cs12e381 / 60) ) + (cs12e161 * (cs12e382 / 60) ) .
EXECUTE.

#Going to ballet, plays, or musicals.
COMPUTE theater=(cs12e173 * (cs12e394 / 60)).
EXECUTE.

#creative things, like "handenarbeid, schildren, tekenen, boetseren, pottenbakken, etcetera".
COMPUTE creativity=(cs12e164 * (cs12e385 / 60)).
EXECUTE.

RECODE goingout music theater creativity (MISSING=0).
EXECUTE.


DATASET ACTIVATE DataSet3.
MATCH FILES /FILE=*
  /FILE='DataSet1'
  /RENAME (Sports Volunteerwork watch_tv = d0 d1 d2) 
  /BY nomem_encr
  /DROP= d0 d1 d2.
EXECUTE.

DELETE VARIABLES nohouse_encr to q201202.
EXECUTE.

ONEWAY goingout music theater creativity BY NRB_groups
  /STATISTICS DESCRIPTIVES 
  /MISSING ANALYSIS
  /POSTHOC=LSD BONFERRONI ALPHA(0.05).

SAVE OUTFILE='Nonresponse_Bias'
  /COMPRESSED.

*calculate effect size for significant results; so working, television, sports and going out.

UNIANOVA hours_work2 BY NRB_groups
  /METHOD=SSTYPE(3)
  /INTERCEPT=INCLUDE
  /PRINT=ETASQ DESCRIPTIVE HOMOGENEITY
  /CRITERIA=ALPHA(.05)
  /DESIGN=NRB_groups.

UNIANOVA watch_tv BY NRB_groups
  /METHOD=SSTYPE(3)
  /INTERCEPT=INCLUDE
  /PRINT=ETASQ DESCRIPTIVE HOMOGENEITY
  /CRITERIA=ALPHA(.05)
  /DESIGN=NRB_groups.

UNIANOVA Sports BY NRB_groups
  /METHOD=SSTYPE(3)
  /INTERCEPT=INCLUDE
  /PRINT=ETASQ DESCRIPTIVE HOMOGENEITY
  /CRITERIA=ALPHA(.05)
  /DESIGN=NRB_groups.


UNIANOVA goingout BY NRB_groups
  /METHOD=SSTYPE(3)
  /INTERCEPT=INCLUDE
  /PRINT=ETASQ DESCRIPTIVE HOMOGENEITY
  /CRITERIA=ALPHA(.05)
  /DESIGN=NRB_groups.

*perform the analysis for work, for the same group as the other "activities".
USE ALL.
COMPUTE filter_$=(goingout >= 0).
VARIABLE LABELS filter_$ 'goingout >= 0 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.

UNIANOVA hours_work2 BY NRB_groups
  /METHOD=SSTYPE(3)
  /INTERCEPT=INCLUDE
  /PRINT=ETASQ DESCRIPTIVE HOMOGENEITY
  /CRITERIA=ALPHA(.05)
  /DESIGN=NRB_groups.


*Only use complete cases, because we want the same participants for all activities . So if "Meenemen=2, they are selected.
IF  (hours_work2 >= 0) work_comp=1.
EXECUTE.

IF  (goingout >= 0) goingout_comp=1.
EXECUTE.

IF  (goingout >= 0) meenemen=goingout_comp + work_comp.
EXECUTE.


USE ALL.
COMPUTE filter_$=(meenemen = 2).
VARIABLE LABELS filter_$ 'meenemen = 2 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE.


#ANOVA to see whether the groups differ, and what the sample mean is.
ONEWAY Sports Volunteerwork watch_tv hours_work2 BY NRB_groups
    /STATISTICS DESCRIPTIVES HOMOGENEITY
    /MISSING ANALYSIS
    /POSTHOC=LSD BONFERRONI ALPHA(0.05).

ONEWAY goingout music theater creativity BY NRB_groups
    /STATISTICS DESCRIPTIVES
    /MISSING ANALYSIS
    /POSTHOC=LSD BONFERRONI ALPHA(0.05).

*calculate effect size for significant results; so working, watching television, sports and going out.
UNIANOVA hours_work2 BY NRB_groups
  /METHOD=SSTYPE(3)
  /INTERCEPT=INCLUDE
  /PRINT=ETASQ DESCRIPTIVE HOMOGENEITY
  /CRITERIA=ALPHA(.05)
  /DESIGN=NRB_groups.

UNIANOVA watch_tv BY NRB_groups
  /METHOD=SSTYPE(3)
  /INTERCEPT=INCLUDE
  /PRINT=ETASQ DESCRIPTIVE HOMOGENEITY
  /CRITERIA=ALPHA(.05)
  /DESIGN=NRB_groups.

UNIANOVA goingout BY NRB_groups
  /METHOD=SSTYPE(3)
  /INTERCEPT=INCLUDE
  /PRINT=ETASQ DESCRIPTIVE HOMOGENEITY
  /CRITERIA=ALPHA(.05)
  /DESIGN=NRB_groups.
