---
title: 'Nonresponse logistic regression models.'
author: "Anne Elevelt"
date: "`03-22-3019`"
---

rm(list=ls(all=TRUE))

setwd()
responseTUS = read.csv2("TUSdata.csv")
responseLISS = read.csv2("response_entireLISS.csv")

install.packages("mfx")
install.packages("betareg")
install.packages("zoo")

require(stats)
require(MASS)
require(betareg)
require(zoo)
require(sandwich)
require(lmtest)
require(mfx)


logisticPseudoR2s <- function(LogModel) {
  dev <- LogModel$deviance
  nullDev <- LogModel$null.deviance
  modelN <- length(LogModel$fitted.values)
  R.l <- 1 - dev / nullDev
  R.cs <- 1 - exp ( -(nullDev - dev) / modelN)
  R.n <- R.cs / ( 1 - (exp (-(nullDev / modelN))))
  cat("Psude R^2 for logisticregression\n")
  cat("Hosmer and Lemeshow R^2 ", round (R.l, 3), "\n")
  cat("Cox and Snell R^2       ", round(R.cs, 3), "\n")
  cat("Nagelkerke R^2          ", round(R.n, 3),"\n")
}

#Divide income by 100, to make the coefficients easier to interpret.
responseTUS$income_new <- responseTUS$nettoink_f / 100
responseLISS$income_new <- responseLISS$nettoink_f / 100


#Predicting willingness to participate in a smartphone study. ####
#We chose to report marginal effects, for more information see: (Fernihough, 2013) or ?mfx::logitmfx
TBO1 <- glm(TBO_response ~ geslacht + leeftijd + aantalki + income_new
            + participation_history + neuroticism + extraversion + agreeable
            + conscientious + openness + surveyvalue + surveyenjoyment + surveyburden
            + trust + worries + oplcat + smartphone_own, family = binomial, data=responseLISS)

logitmfx(TBO_response ~ geslacht + leeftijd + oplcat + aantalki + income_new
         + neuroticism + extraversion + agreeable + conscientious + openness + surveyvalue + surveyenjoyment + surveyburden
         + trust + worries + smartphone_own + participation_history, data=responseLISS)

summary(TBO1)
logisticPseudoR2s(TBO1)


#without including continuous participation. 
TBO2 <- glm(TBO_response ~ geslacht + leeftijd + aantalki + income_new
            + neuroticism + extraversion + agreeable
            + conscientious + openness + surveyvalue + surveyenjoyment + surveyburden
            + trust + worries + oplcat + smartphone_own, family = binomial, data=responseLISS)


logitmfx(TBO_response ~ geslacht + leeftijd + oplcat + aantalki + income_new
         + neuroticism + extraversion + agreeable
         + conscientious + openness + surveyvalue + surveyenjoyment + surveyburden
         + trust + worries + oplcat  + smartphone_own, data=responseLISS)

summary(TBO2)
logisticPseudoR2s(TBO2)


#Logistic regression models for predicting response in the different tasks of the Time Use Survey.####
#We chose to report marginal effects, for more information see: (Fernihough, 2013) or ?mfx::logitmfx

#model 1. predict response in the pre-questionnaire.
resp_preq_glm <- glm(resp_preq ~ geslacht + leeftijd + oplcat + aantalki + income_new
                     + participation_history + neuroticism + extraversion + agreeable
                     + conscientious + openness + surveyvalue + surveyenjoyment + surveyburden
                     + trust + worries + smartphone_use, 
                     family = binomial, data = responseTUS)
summary(resp_preq_glm)
logisticPseudoR2s(resp_preq_glm)


logitmfx(resp_preq ~ geslacht + leeftijd + oplcat + aantalki + income_new
         + participation_history + neuroticism + extraversion + agreeable
         + conscientious + openness + surveyvalue + surveyenjoyment + surveyburden
         + trust + worries + smartphone_use, data=responseTUS)


#without continuous participation. 
resp_preq2_glm <- glm(resp_preq ~ geslacht + leeftijd + aantalki + income_new
                      + neuroticism + extraversion + agreeable
                     + conscientious + openness + surveyvalue + surveyenjoyment + surveyburden
                     + trust + worries + smartphone_use + oplcat, 
                     family = binomial, data = responseTUS)
summary(resp_preq2_glm)
logisticPseudoR2s(resp_preq2_glm)

logitmfx(resp_preq ~ geslacht + leeftijd + oplcat + aantalki + income_new
         + neuroticism + extraversion + agreeable
         + conscientious + openness + surveyvalue + surveyenjoyment + surveyburden
         + trust + worries + smartphone_use, data=responseTUS)


#model 2. Predict response in the diary.
resp_diary_glm2 <- glm(resp_dairy ~ geslacht + leeftijd + aantalki + income_new
                      + participation_history + neuroticism + extraversion + agreeable
                      + conscientious + openness + surveyvalue + surveyenjoyment + surveyburden
                      + trust + worries + smartphone_use + oplcat + resp_preq, 
                      family = binomial, data = responseTUS)

summary(resp_diary_glm2)
logisticPseudoR2s(resp_diary_glm2)


logitmfx(resp_dairy ~ geslacht + leeftijd +  oplcat + aantalki + income_new
         + participation_history + neuroticism + extraversion + agreeable
         + conscientious + openness + surveyvalue + surveyenjoyment + surveyburden
         + trust + worries + smartphone_use + resp_preq, 
         data = responseTUS)

#without continuous participation.  
resp_diary2_glm <- glm(resp_dairy ~ geslacht + leeftijd + aantalki + income_new
                      + neuroticism + extraversion + agreeable
                       + conscientious + openness + surveyvalue + surveyenjoyment + surveyburden
                       + trust + worries + smartphone_use + oplcat, 
                       family = binomial, data = responseTUS)
summary(resp_diary2_glm)
logisticPseudoR2s(resp_diary2_glm)


logitmfx(resp_dairy ~ geslacht + leeftijd + oplcat + aantalki + income_new
          + neuroticism + extraversion + agreeable
         + conscientious + openness + surveyvalue + surveyenjoyment + surveyburden
         + trust + worries + smartphone_use , 
         data = responseTUS)


#model 3. Predict response for the pop-up questions.
resp_popup_glm2 <- glm(popup_part ~ geslacht + leeftijd + oplcat + aantalki + income_new
                       + participation_history + neuroticism + extraversion + agreeable
                       + conscientious + openness + surveyvalue + surveyenjoyment + surveyburden
                       + trust + worries + smartphone_use + oplcat + resp_preq + resp_dairy, 
                       family = binomial, data = responseTUS)

summary(resp_popup_glm2)
logisticPseudoR2s(resp_popup_glm2)

logitmfx(popup_part ~ geslacht + leeftijd + oplcat + aantalki + income_new
         + participation_history + neuroticism + extraversion + agreeable
         + conscientious + openness + surveyvalue + surveyenjoyment + surveyburden
         + trust + worries + smartphone_use + resp_preq + resp_dairy, 
         data = responseTUS)

#without continuous participation. 
resp_popup2_glm <-  glm(popup_part ~ geslacht + leeftijd + aantalki + income_new
                        + neuroticism + extraversion + agreeable
                        + conscientious + openness + surveyvalue + surveyenjoyment + surveyburden
                        + trust + worries + smartphone_use + oplcat, 
                        family = binomial, data = responseTUS)

summary(resp_popup2_glm)
logisticPseudoR2s(resp_popup2_glm)

logitmfx(popup_part ~ geslacht + leeftijd + oplcat + aantalki + income_new
         + neuroticism + extraversion + agreeable
         + conscientious + openness + surveyvalue + surveyenjoyment + surveyburden
         + trust + worries + smartphone_use, 
         data = responseTUS)



#model 4. Predict response for sharing GPS.
resp_GPS_glm2 <- glm(GPS_resp ~ geslacht + leeftijd + aantalki + income_new
                     + participation_history + neuroticism + extraversion + agreeable
                     + conscientious + openness + surveyvalue + surveyenjoyment + surveyburden
                     + trust + worries + smartphone_use + oplcat + resp_preq + resp_dairy, 
                     family = binomial, data = responseTUS)

summary(resp_GPS_glm2)
logisticPseudoR2s(resp_GPS_glm2)

logitmfx(GPS_resp ~ geslacht + leeftijd + oplcat + aantalki + income_new
         + participation_history + neuroticism + extraversion + agreeable
         + conscientious + openness + surveyvalue + surveyenjoyment + surveyburden
         + trust + worries + smartphone_use + resp_dairy + resp_preq, 
         data = responseTUS)

#without continuous participation.  
resp_GPS2_glm <- glm(GPS_resp ~ geslacht + leeftijd + aantalki + income_new
                     + neuroticism + extraversion + agreeable
                     + conscientious + openness + surveyvalue + surveyenjoyment + surveyburden
                     + trust + worries + smartphone_use + oplcat, 
                     family = binomial, data = responseTUS)

summary(resp_GPS2_glm)
logisticPseudoR2s(resp_GPS2_glm)

logitmfx(GPS_resp ~ geslacht + leeftijd + aantalki + income_new
         + neuroticism + extraversion + agreeable
         + conscientious + openness + surveyvalue + surveyenjoyment + surveyburden
         + trust + worries + smartphone_use + oplcat, 
         data = responseTUS)


#model 5. Predict response for the post-questionnaire.
resp_postq_glm2 <- glm(resp_postq ~ geslacht + leeftijd + aantalki + income_new
                       + participation_history + neuroticism + extraversion + agreeable
                       + conscientious + openness + surveyvalue + surveyenjoyment + surveyburden
                       + trust + worries + smartphone_use + oplcat + 
                         resp_preq + resp_dairy + GPS_resp + popup_part, 
                       family = binomial, data = responseTUS)

summary(resp_postq_glm2)
logisticPseudoR2s(resp_postq_glm2)

logitmfx(resp_postq ~ geslacht + leeftijd + oplcat + aantalki + income_new
         + participation_history + neuroticism + extraversion + agreeable
         + conscientious + openness + surveyvalue + surveyenjoyment + surveyburden
         + trust + worries + smartphone_use + resp_preq + resp_dairy + popup_part + GPS_resp, 
         data = responseTUS)


#without continuous participation. 
resp_postq2_glm <- glm(resp_postq ~ geslacht + leeftijd + aantalki + income_new
                      + neuroticism + extraversion + agreeable
                      + conscientious + openness + surveyvalue + surveyenjoyment + surveyburden
                      + trust + worries + smartphone_use + oplcat, 
                      family = binomial, data = responseTUS)

summary(resp_postq2_glm)
logisticPseudoR2s(resp_postq2_glm)

logitmfx(resp_postq ~ geslacht + leeftijd + oplcat + aantalki + income_new
         + neuroticism + extraversion + agreeable
         + conscientious + openness + surveyvalue + surveyenjoyment + surveyburden
         + trust + worries + smartphone_use, 
         data = responseTUS)



