﻿* Encoding: UTF-8.
*Complete Syntax for resubmission.
* last updated: 26-11-2018
* author: Anne Elevelt: a.elevelt@uu.nl 
*For privacy reasons, all references to the working directory are deleted.


*START WITH THE FACTOR ANALYSES TO MAKE ALL VARIABLES.*****************
*Survey attitude. We follow the structure of De Leeuw et al., 2010. 
*Datafile: cp11d_1.0p_EN.
* https://www.dataarchive.lissdata.nl/study_units/view/208.
 
 FACTOR
  /VARIABLES cp11d001 cp11d002 cp11d003 cp11d004 cp11d005 cp11d006 cp11d007 cp11d008 cp11d009
  /MISSING LISTWISE 
  /ANALYSIS cp11d001 cp11d002 cp11d003 cp11d004 cp11d005 cp11d006 cp11d007 cp11d008 cp11d009
  /PRINT INITIAL CORRELATION SIG KMO EXTRACTION ROTATION
  /CRITERIA FACTORS(3) ITERATE(25)
  /EXTRACTION PAF
  /CRITERIA ITERATE(25) DELTA(0)
  /ROTATION OBLIMIN
  /SAVE REG(ALL)
  /METHOD=CORRELATION.

*
FAC1_2 = Survey Value
FAC2_2 = Survey burden
FAC3_2= Survey Enjoyment
*

*Personality.
FACTOR
  /VARIABLES cp11d020 cp11d021 cp11d022 cp11d023 cp11d024 cp11d025 cp11d026 cp11d027 cp11d028 
    cp11d029 cp11d030 cp11d031 cp11d032 cp11d033 cp11d034 cp11d035 cp11d036 cp11d037 cp11d038 cp11d039 
    cp11d040 cp11d041 cp11d042 cp11d043 cp11d044 cp11d045 cp11d046 cp11d047 cp11d048 cp11d049 cp11d050 
    cp11d051 cp11d052 cp11d053 cp11d054 cp11d055 cp11d056 cp11d057 cp11d058 cp11d059 cp11d060 cp11d061 
    cp11d062 cp11d063 cp11d064 cp11d065 cp11d066 cp11d067 cp11d068 cp11d069
  /MISSING LISTWISE 
  /ANALYSIS cp11d020 cp11d021 cp11d022 cp11d023 cp11d024 cp11d025 cp11d026 cp11d027 cp11d028 
    cp11d029 cp11d030 cp11d031 cp11d032 cp11d033 cp11d034 cp11d035 cp11d036 cp11d037 cp11d038 cp11d039 
    cp11d040 cp11d041 cp11d042 cp11d043 cp11d044 cp11d045 cp11d046 cp11d047 cp11d048 cp11d049 cp11d050 
    cp11d051 cp11d052 cp11d053 cp11d054 cp11d055 cp11d056 cp11d057 cp11d058 cp11d059 cp11d060 cp11d061 
    cp11d062 cp11d063 cp11d064 cp11d065 cp11d066 cp11d067 cp11d068 cp11d069
  /PRINT INITIAL EXTRACTION ROTATION FSCORE
  /PLOT EIGEN
  /CRITERIA FACTORS(5) ITERATE(25)
  /EXTRACTION ML
  /CRITERIA ITERATE(25)
  /ROTATION PROMAX(4)
  /SAVE BART(ALL).


recode fac1_3 fac2_3 fac3_3 fac4_3 fac5_3 (ELSE=copy) into neuroticism extraversion agreeable conscientious openness .
execute . 
delete variables fac1_3 to fac5_3 .
execute .


*Smartphone usage.
*Transform variables to make the factor easier to interpret. 1 = not used, 2 = used.
RECODE hs13a021 hs13a022 hs13a023 hs13a024 hs13a025 hs13a026 hs13a027 hs13a028 hs13a029 hs13a030 
    hs13a031 hs13a032 hs13a033 hs13a034 hs13a035 hs13a036 hs13a037 hs13a038 hs13a039 hs13a040 hs13a041 
    hs13a042 (3=2) (MISSING=2).
EXECUTE.

RECODE hs13a021 hs13a022 hs13a023 hs13a024 hs13a025 hs13a026 hs13a027 hs13a028 hs13a029 hs13a030 
    hs13a031 hs13a032 hs13a033 hs13a034 hs13a035 hs13a036 hs13a037 hs13a038 hs13a039 hs13a040 hs13a041 
    hs13a042 (1=2) (2=1) INTO hs13a021om hs13a022om hs13a023om hs13a024om hs13a025om hs13a026om 
    hs13a027om hs13a028om hs13a029om hs13a030om hs13a031om hs13a032om hs13a033om hs13a034om hs13a035om 
    hs13a036om hs13a037om hs13a038om hs13a039om hs13a040om hs13a041om hs13a042om.
EXECUTE.

*Conduct a confirmatory factor analysis, extracting one factor. 
FACTOR
  /VARIABLES hs13a021om hs13a022om hs13a023om hs13a024om hs13a025om hs13a026om 
    hs13a027om hs13a028om hs13a029om hs13a030om hs13a031om hs13a032om hs13a033om hs13a034om hs13a035om 
    hs13a036om hs13a037om hs13a038om hs13a039om hs13a040om hs13a041om hs13a042om
  /MISSING LISTWISE 
  /ANALYSIS hs13a021om hs13a022om hs13a023om hs13a024om hs13a025om hs13a026om 
    hs13a027om hs13a028om hs13a029om hs13a030om hs13a031om hs13a032om hs13a033om hs13a034om hs13a035om 
    hs13a036om hs13a037om hs13a038om hs13a039om hs13a040om hs13a041om hs13a042om
  /PRINT INITIAL CORRELATION KMO EXTRACTION ROTATION
  /PLOT EIGEN
  /CRITERIA FACTORS(1) ITERATE(25)
  /EXTRACTION ML
  /CRITERIA ITERATE(25) 
  /ROTATION PROMAX(4)
  /SAVE BART(ALL)
  /METHOD=CORRELATION.

recode FAC1_1 (else=copy) into smartphone_use.
EXECUTE .

*Privacy.*Half of the participants got the questions scaled positive-negative, the other half negative - positive.
*We recoded them to ensure that higher values present a higher level of worries/privacy concerns.
RECODE ae08a011 ae08a003 (1=4) (2=3) (3=2) (4=1) INTO worried2 privacy2.
EXECUTE.

COMPUTE privacy=MEAN(privacy2, ae08a010).
EXECUTE.

COMPUTE worried=MEAN(worried2, ae08a002).
EXECUTE.

*Exploratory factor analyses, yields 2 factors.
FACTOR
  /VARIABLES ae08a012 ae08a013 ae08a014 privacy worried
  /MISSING LISTWISE 
  /ANALYSIS ae08a012 ae08a013 ae08a014 privacy worried
  /PRINT INITIAL KMO EXTRACTION ROTATION
  /CRITERIA MINEIGEN(1) ITERATE(25)
  /EXTRACTION ML
  /CRITERIA ITERATE(25)
  /ROTATION PROMAX(4)
  /SAVE BART(ALL).

recode variables FAC1_1 FAC2_1 into trust worries .
execute .


*WHO IS WILLING TO PARTICIPATE IN A SMARTPHONE STUDY AND WHO IS NOT?.*****************
cd '' .
EXECUTE.

#This file is not online, but available upon request.
get file 'L_TBO_SelectieOverzicht_06p.sav' .
EXECUTE.

*did people answer the question whether they wanted to participate or not?.
COUNT TBO_missing=respons_tbo_08_2012 respons_tbo_03_2013 respons_tbo_0708_2013(MISSING).
EXECUTE.

RECODE TBO_missing (3=1) (ELSE=0).
EXECUTE.

*who were willing to respond? (0= not willing, 1 = willing, -99 = uncontacted).
COUNT TBO_response=respons_tbo_08_2012 respons_tbo_03_2013 respons_tbo_0708_2013(1).
EXECUTE.

RECODE TBO_response (1 thru 3=1).
EXECUTE.

DO IF (TBO_missing = 1).
RECODE TBO_response (0=-99).
END IF.
EXECUTE.

delete variables uitnodiging_08_2012 to oplcat.
EXECUTE.

*Code response/nonresponse for all TUS participants *****************
*make binary variables. 0 = nonresponse. 1= response.

*data-set prequestionnaire.* 
*Only respondents who filled out the pre-questionnaire are included in this file.

COMPUTE resp_preq=1.
EXECUTE.

*data-set post-questionnaire.*
*Only respondents who filled out the post-questionnaire are included in this file.

COMPUTE resp_postq=1.
EXECUTE.

*dataset TUS diary.
*Did the respondent fill out the diary on a specific day?

IF  (ht13a0007 > 1) resp_day1=1.
EXECUTE.

IF  (ht13a2116 > 1) resp_day2=1.
EXECUTE.

IF  (ht13a4225 > 1) resp_day3=1.
EXECUTE.

*total number of filled out days.*

COMPUTE resp_days=resp_day1 + resp_day2 + resp_day3.
EXECUTE.

IF  (resp_days > 0) resp_diary=1.
EXECUTE.

RECODE resp_diary  (MISSING=0).
EXECUTE.

DELETE VARIABLES ht13a6328 to ht12a6327. 
EXECUTE.

SAVE OUTFILE='response_nonresponse.sav'
  /COMPRESSED

*See R-file: Response_nonresponse_popup.R for response/nonresponse coding for the pop-up questions.

*Merge the resp_preq variable from the pre-questionnaire dataset to the response_nonresponse dataset.

STAR JOIN
  /SELECT t1.resp_preq, t0.resp_diary
  /FROM 'response_nonresponse' AS t0
  /JOIN * AS t1
    ON t0.nomem_encr=t1.nomem_encr
  /OUTFILE FILE=*.

*Merge the resp_postq variable from the post-questionnaire dataset to the response_nonresponse dataset.
STAR JOIN
  /SELECT t0.resp_preq, t0.resp_diary, t1.resp_postq
  /FROM 'response_nonresponse' AS t0
  /JOIN * AS t1
    ON t0.nomem_encr=t1.nomem_encr
  /OUTFILE FILE=*.

*Merge the pop-up variable from the pop_up dataset (that we just made in R) to the response_nonresponse dataset.
STAR JOIN
  /SELECT t0.resp_preq, t0.resp_diary, t0.resp_postq, t1.popup_part
  /FROM 'response_nonresponse' AS t0
  /JOIN * AS t1
    ON t0.nomem_encr=t1.nomem_encr
  /OUTFILE FILE=*.

RECODE resp_preq  (MISSING=0).
EXECUTE.

RECODE resp_postq  (MISSING=0).
EXECUTE.

SAVE OUTFILE='response_nonresponse.sav'
  /COMPRESSED


*MERGE THE FILES WITH THE COVARIATES.*****************
*merge file with personality.
*Here we use the file of the entire LISS panel.

get file 'personality.sav' .
EXECUTE.

*The file of the entire LISS panel. This one is available upon request with the authors.
DATASET ACTIVATE 'L_TBO_SelectieOverzicht_06p.sav' .
MATCH FILES /FILE=*
  /FILE='personality'
  /BY nomem_encr.
EXECUTE.

delete variables cp11d020 to cp11d069.
EXECUTE.

SAVE OUTFILE='Entire LISS panel.sav'
  /COMPRESSED.

*match with particiption history.
STAR JOIN
  /SELECT t0.TBO_missing, t0.TBO_response, t0.neuroticism, t0.extraversion, t0.agreeable, 
    t0.openness, t0.conscientious, t1.nohouse_encr, t1.leeftijd, t1.doetmee, t1.startlid, t1.stoplid, 
    t1.q200711, t1.q200712, t1.q200801, t1.q200802, t1.q200803, t1.q200804, t1.q200805, t1.q200806, 
    t1.q200807, t1.q200808, t1.q200809, t1.q200810, t1.q200811, t1.q200812, t1.q200901, t1.q200902, 
    t1.q200903, t1.q200904, t1.q200905, t1.q200906, t1.q200907, t1.q200908, t1.q200909, t1.q200910, 
    t1.q200911, t1.q200912, t1.q201001, t1.q201002, t1.q201003, t1.q201004, t1.q201005, t1.q201006, 
    t1.q201007, t1.q201008, t1.q201009, t1.q201010, t1.q201011, t1.q201012, t1.q201101, t1.q201102, 
    t1.q200103, t1.q201104, t1.q201105, t1.q201106, t1.q201107, t1.q201108, t1.q201109, t1.q201110, 
    t1.q201111, t1.q201112, t1.q201201, t1.q201202, t1.q201203, t1.q201204, t1.q201205, t1.q201206, 
    t1.q201207, t1.q201208, t1.q201209, t1.positie, t1.lftdcat, t1.lftdhhh, t1.aantalhh, t1.aantalki, 
    t1.partner, t1.burgstat, t1.woonvorm, t1.woning, t1.belbezig, t1.brutoink, t1.nettoink, 
    t1.brutocat, t1.nettocat, t1.oplzon, t1.oplmet, t1.oplcat, t1.participation_history, t1.startwave
  /FROM * AS t0
  /JOIN 'Participation_history' AS t1
    ON t0.nomem_encr=t1.nomem_encr
  /OUTFILE FILE=*.

delete variables nohouse_encr to oplcat .
EXECUTE .

delete variables startwave.
EXECUTE.

*Merge with privacy-dataset.
STAR JOIN
  /SELECT t0.TBO_missing, t0.TBO_response, t0.neuroticism, t0.extraversion, t0.agreeable, 
    t0.openness, t0.conscientious, t0.participation_history, t1.nohouse_encr, t1.ae08a_m, t1.ae08a001, 
    t1.ae08a002, t1.ae08a003, t1.ae08a004, t1.ae08a005, t1.ae08a006, t1.ae08a007, t1.ae08a008, 
    t1.ae08a009, t1.ae08a010, t1.ae08a011, t1.ae08a012, t1.ae08a013, t1.ae08a014, t1.ae08a015, 
    t1.ae08a016, t1.ae08a017, t1.ae08a018, t1.ae08a019, t1.ae08a020, t1.ae08a021, t1.ae08a022, 
    t1.ae08a023, t1.ae08a024, t1.privacy2, t1.privacy, t1.worried2, t1.worried, t1.trust, t1.worries
  /FROM * AS t0
  /JOIN '\ae08a_1p_EN.sav' AS t1
    ON t0.nomem_encr=t1.nomem_encr
  /OUTFILE FILE=*.

delete variables nohouse_encr to worried.
EXECUTE.

*Match with survey attitude.
STAR JOIN
  /SELECT t0.TBO_missing, t0.TBO_response, t0.neuroticism, t0.extraversion, t0.agreeable, 
    t0.openness, t0.conscientious, t0.participation_history, t0.trust, t0.worries, t1.nohouse_encr, 
    t1.cp11d_m, t1.cp11d196, t1.cp11d001, t1.cp11d002, t1.cp11d003, t1.cp11d004, t1.cp11d005, 
    t1.cp11d006, t1.cp11d007, t1.cp11d008, t1.cp11d009, t1.cp11d010, t1.cp11d011, t1.cp11d012, 
    t1.cp11d013, t1.cp11d014, t1.cp11d015, t1.cp11d016, t1.cp11d017, t1.cp11d018, t1.cp11d019, 
    t1.cp11d020, t1.cp11d021, t1.cp11d022, t1.cp11d023, t1.cp11d024, t1.cp11d025, t1.cp11d026, 
    t1.cp11d027, t1.cp11d028, t1.cp11d029, t1.cp11d030, t1.cp11d031, t1.cp11d032, t1.cp11d033, 
    t1.cp11d034, t1.cp11d035, t1.cp11d036, t1.cp11d037, t1.cp11d038, t1.cp11d039, t1.cp11d040, 
    t1.cp11d041, t1.cp11d042, t1.cp11d043, t1.cp11d044, t1.cp11d045, t1.cp11d046, t1.cp11d047, 
    t1.cp11d048, t1.cp11d049, t1.cp11d050, t1.cp11d051, t1.cp11d052, t1.cp11d053, t1.cp11d054, 
    t1.cp11d055, t1.cp11d056, t1.cp11d057, t1.cp11d058, t1.cp11d059, t1.cp11d060, t1.cp11d061, 
    t1.cp11d062, t1.cp11d063, t1.cp11d064, t1.cp11d065, t1.cp11d066, t1.cp11d067, t1.cp11d068, 
    t1.cp11d069, t1.cp11d070, t1.cp11d071, t1.cp11d072, t1.cp11d073, t1.cp11d074, t1.cp11d075, 
    t1.cp11d076, t1.cp11d077, t1.cp11d078, t1.cp11d079, t1.cp11d080, t1.cp11d081, t1.cp11d082, 
    t1.cp11d083, t1.cp11d084, t1.cp11d085, t1.cp11d086, t1.cp11d087, t1.cp11d088, t1.cp11d089, 
    t1.cp11d090, t1.cp11d091, t1.cp11d092, t1.cp11d093, t1.cp11d094, t1.cp11d095, t1.cp11d096, 
    t1.cp11d097, t1.cp11d098, t1.cp11d099, t1.cp11d100, t1.cp11d101, t1.cp11d102, t1.cp11d103, 
    t1.cp11d104, t1.cp11d105, t1.cp11d106, t1.cp11d107, t1.cp11d108, t1.cp11d109, t1.cp11d110, 
    t1.cp11d111, t1.cp11d112, t1.cp11d113, t1.cp11d114, t1.cp11d115, t1.cp11d116, t1.cp11d117, 
    t1.cp11d118, t1.cp11d119, t1.cp11d120, t1.cp11d121, t1.cp11d122, t1.cp11d123, t1.cp11d124, 
    t1.cp11d125, t1.cp11d126, t1.cp11d127, t1.cp11d128, t1.cp11d129, t1.cp11d130, t1.cp11d131, 
    t1.cp11d132, t1.cp11d133, t1.cp11d134, t1.cp11d135, t1.cp11d194, t1.cp11d136, t1.cp11d137, 
    t1.cp11d138, t1.cp11d139, t1.cp11d140, t1.cp11d141, t1.cp11d142, t1.cp11d143, t1.cp11d144, 
    t1.cp11d145, t1.cp11d146, t1.cp11d147, t1.cp11d148, t1.cp11d149, t1.cp11d150, t1.cp11d151, 
    t1.cp11d152, t1.cp11d153, t1.cp11d154, t1.cp11d155, t1.cp11d156, t1.cp11d157, t1.cp11d158, 
    t1.cp11d159, t1.cp11d160, t1.cp11d161, t1.cp11d162, t1.cp11d163, t1.cp11d164, t1.cp11d165, 
    t1.cp11d166, t1.cp11d167, t1.cp11d168, t1.cp11d169, t1.cp11d170, t1.cp11d171, t1.cp11d172, 
    t1.cp11d173, t1.cp11d174, t1.cp11d175, t1.cp11d176, t1.cp11d177, t1.cp11d178, t1.cp11d179, 
    t1.cp11d180, t1.cp11d181, t1.cp11d182, t1.cp11d183, t1.cp11d184, t1.cp11d185, t1.cp11d186, 
    t1.cp11d187, t1.cp11d188, t1.cp11d189, t1.cp11d190, t1.cp11d191, t1.cp11d192, t1.cp11d193, 
    t1.surveyvalue, t1.surveyburden, t1.surveyenjoyment
  /FROM * AS t0
  /JOIN 'cp11d_1.0p_EN.sav' AS t1
    ON t0.nomem_encr=t1.nomem_encr
  /OUTFILE FILE=*.

delete variables nohouse_encr to cp11d193.
EXECUTE.

*Match with information about smartphone ownership.
STAR JOIN
  /SELECT t0.TBO_missing, t0.TBO_response, t0.neuroticism, t0.extraversion, t0.agreeable, 
    t0.openness, t0.conscientious, t0.participation_history, t0.trust, t0.worries, t0.surveyvalue, 
    t0.surveyburden, t0.surveyenjoyment, t1.nohouse_encr, t1.cs12e_m, t1.cs12e001, t1.cs12e002, 
    t1.cs12e003, t1.cs12e004, t1.cs12e005, t1.cs12e006, t1.cs12e007, t1.cs12e008, t1.cs12e009, 
    t1.cs12e010, t1.cs12e011, t1.cs12e012, t1.cs12e013, t1.cs12e014, t1.cs12e015, t1.cs12e016, 
    t1.cs12e017, t1.cs12e018, t1.cs12e019, t1.cs12e020, t1.cs12e021, t1.cs12e022, t1.cs12e023, 
    t1.cs12e024, t1.cs12e025, t1.cs12e026, t1.cs12e027, t1.cs12e028, t1.cs12e029, t1.cs12e030, 
    t1.cs12e031, t1.cs12e032, t1.cs12e033, t1.cs12e034, t1.cs12e035, t1.cs12e036, t1.cs12e037, 
    t1.cs12e038, t1.cs12e039, t1.cs12e040, t1.cs12e041, t1.cs12e042, t1.cs12e043, t1.cs12e044, 
    t1.cs12e045, t1.cs12e046, t1.cs12e047, t1.cs12e048, t1.cs12e049, t1.cs12e050, t1.cs12e051, 
    t1.cs12e052, t1.cs12e053, t1.cs12e054, t1.cs12e055, t1.cs12e056, t1.cs12e057, t1.cs12e058, 
    t1.cs12e059, t1.cs12e060, t1.cs12e061, t1.cs12e062, t1.cs12e063, t1.cs12e064, t1.cs12e065, 
    t1.cs12e066, t1.cs12e067, t1.cs12e068, t1.cs12e069, t1.cs12e070, t1.cs12e071, t1.cs12e072, 
    t1.cs12e073, t1.cs12e074, t1.cs12e075, t1.cs12e076, t1.cs12e077, t1.cs12e078, t1.cs12e408, 
    t1.cs12e079, t1.cs12e080, t1.cs12e081, t1.cs12e082, t1.cs12e083, t1.cs12e084, t1.cs12e085, 
    t1.cs12e086, t1.cs12e087, t1.cs12e088, t1.cs12e089, t1.cs12e090, t1.cs12e091, t1.cs12e092, 
    t1.cs12e093, t1.cs12e094, t1.cs12e095, t1.cs12e096, t1.cs12e097, t1.cs12e098, t1.cs12e099, 
    t1.cs12e100, t1.cs12e101, t1.cs12e102, t1.cs12e103, t1.cs12e104, t1.cs12e105, t1.cs12e106, 
    t1.cs12e107, t1.cs12e108, t1.cs12e109, t1.cs12e110, t1.cs12e111, t1.cs12e112, t1.cs12e113, 
    t1.cs12e114, t1.cs12e115, t1.cs12e116, t1.cs12e117, t1.cs12e118, t1.cs12e119, t1.cs12e120, 
    t1.cs12e121, t1.cs12e409, t1.cs12e122, t1.cs12e123, t1.cs12e124, t1.cs12e125, t1.cs12e126, 
    t1.cs12e379, t1.cs12e127, t1.cs12e128, t1.cs12e129, t1.cs12e380, t1.cs12e130, t1.cs12e131, 
    t1.cs12e132, t1.cs12e133, t1.cs12e134, t1.cs12e135, t1.cs12e136, t1.cs12e137, t1.cs12e138, 
    t1.cs12e139, t1.cs12e140, t1.cs12e141, t1.cs12e142, t1.cs12e143, t1.cs12e144, t1.cs12e145, 
    t1.cs12e146, t1.cs12e147, t1.cs12e148, t1.cs12e149, t1.cs12e150, t1.cs12e151, t1.cs12e152, 
    t1.cs12e153, t1.cs12e154, t1.cs12e155, t1.cs12e156, t1.cs12e157, t1.cs12e158, t1.cs12e159, 
    t1.cs12e160, t1.cs12e161, t1.cs12e162, t1.cs12e163, t1.cs12e164, t1.cs12e165, t1.cs12e166, 
    t1.cs12e167, t1.cs12e168, t1.cs12e169, t1.cs12e170, t1.cs12e171, t1.cs12e172, t1.cs12e173, 
    t1.cs12e174, t1.cs12e175, t1.cs12e176, t1.cs12e177, t1.cs12e178, t1.cs12e179, t1.cs12e180, 
    t1.cs12e181, t1.cs12e182, t1.cs12e183, t1.cs12e184, t1.cs12e185, t1.cs12e186, t1.cs12e187, 
    t1.cs12e188, t1.cs12e381, t1.cs12e189, t1.cs12e190, t1.cs12e382, t1.cs12e191, t1.cs12e192, 
    t1.cs12e383, t1.cs12e193, t1.cs12e194, t1.cs12e384, t1.cs12e195, t1.cs12e196, t1.cs12e385, 
    t1.cs12e197, t1.cs12e198, t1.cs12e386, t1.cs12e199, t1.cs12e200, t1.cs12e387, t1.cs12e201, 
    t1.cs12e202, t1.cs12e388, t1.cs12e203, t1.cs12e204, t1.cs12e389, t1.cs12e205, t1.cs12e206, 
    t1.cs12e390, t1.cs12e207, t1.cs12e208, t1.cs12e391, t1.cs12e209, t1.cs12e210, t1.cs12e392, 
    t1.cs12e211, t1.cs12e212, t1.cs12e393, t1.cs12e213, t1.cs12e214, t1.cs12e394, t1.cs12e215, 
    t1.cs12e216, t1.cs12e395, t1.cs12e217, t1.cs12e218, t1.cs12e396, t1.cs12e219, t1.cs12e220, 
    t1.cs12e397, t1.cs12e221, t1.cs12e222, t1.cs12e398, t1.cs12e223, t1.cs12e224, t1.cs12e399, 
    t1.cs12e225, t1.cs12e226, t1.cs12e400, t1.cs12e227, t1.cs12e228, t1.cs12e401, t1.cs12e229, 
    t1.cs12e230, t1.cs12e402, t1.cs12e231, t1.cs12e232, t1.cs12e403, t1.cs12e233, t1.cs12e234, 
    t1.cs12e404, t1.cs12e235, t1.cs12e236, t1.cs12e405, t1.cs12e237, t1.cs12e238, t1.cs12e406, 
    t1.cs12e239, t1.cs12e240, t1.cs12e407, t1.cs12e241, t1.cs12e416, t1.cs12e417, t1.cs12e242, 
    t1.cs12e243, t1.cs12e244, t1.cs12e245, t1.cs12e418, t1.cs12e419, t1.cs12e420, t1.cs12e421, 
    t1.cs12e422, t1.cs12e423, t1.cs12e424, t1.cs12e425, t1.cs12e426, t1.cs12e427, t1.cs12e428, 
    t1.cs12e251, t1.cs12e252, t1.cs12e253, t1.cs12e254, t1.cs12e429, t1.cs12e430, t1.cs12e260, 
    t1.cs12e261, t1.cs12e262, t1.cs12e263, t1.cs12e431, t1.cs12e432, t1.cs12e433, t1.cs12e264, 
    t1.cs12e434, t1.cs12e435, t1.cs12e265, t1.cs12e266, t1.cs12e436, t1.cs12e267, t1.cs12e268, 
    t1.cs12e269, t1.cs12e270, t1.cs12e437, t1.cs12e438, t1.cs12e276, t1.cs12e277, t1.cs12e278, 
    t1.cs12e279, t1.cs12e439, t1.cs12e440, t1.cs12e441, t1.cs12e280, t1.cs12e442, t1.cs12e443, 
    t1.cs12e281, t1.cs12e282, t1.cs12e283, t1.cs12e284, t1.cs12e285, t1.cs12e286, t1.cs12e287, 
    t1.cs12e288, t1.cs12e289, t1.cs12e290, t1.cs12e291, t1.cs12e292, t1.cs12e293, t1.cs12e294, 
    t1.cs12e295, t1.cs12e296, t1.cs12e297, t1.cs12e298, t1.cs12e299, t1.cs12e300, t1.cs12e301, 
    t1.cs12e302, t1.cs12e303, t1.cs12e304, t1.cs12e305, t1.cs12e306, t1.cs12e307, t1.cs12e308, 
    t1.cs12e309, t1.cs12e310, t1.cs12e311, t1.cs12e312, t1.cs12e313, t1.cs12e314, t1.cs12e315, 
    t1.cs12e316, t1.cs12e317, t1.cs12e318, t1.cs12e319, t1.cs12e320, t1.cs12e321, t1.cs12e322, 
    t1.cs12e323, t1.cs12e324, t1.cs12e325, t1.cs12e326, t1.cs12e327, t1.cs12e328, t1.cs12e329, 
    t1.cs12e330, t1.cs12e331, t1.cs12e332, t1.cs12e333, t1.cs12e334, t1.cs12e335, t1.cs12e336, 
    t1.cs12e337, t1.cs12e338, t1.cs12e339, t1.cs12e340, t1.cs12e341, t1.cs12e342, t1.cs12e343, 
    t1.cs12e344, t1.cs12e345, t1.cs12e346, t1.cs12e347, t1.cs12e348, t1.cs12e349, t1.cs12e350, 
    t1.cs12e351, t1.cs12e352, t1.cs12e353, t1.cs12e354, t1.cs12e355, t1.cs12e356, t1.cs12e357, 
    t1.cs12e358, t1.cs12e359, t1.cs12e360, t1.cs12e361, t1.cs12e362, t1.cs12e363, t1.cs12e364, 
    t1.cs12e365, t1.cs12e366, t1.cs12e367, t1.cs12e368, t1.cs12e369, t1.cs12e370, t1.cs12e371, 
    t1.cs12e372, t1.cs12e373, t1.cs12e374, t1.cs12e410, t1.cs12e411, t1.cs12e412, t1.cs12e413, 
    t1.cs12e414, t1.cs12e375, t1.cs12e376, t1.cs12e377, t1.cs12e378, t1.cs12e415, t1.q201202, 
    t1.Sports, t1.Volunteerwork, t1.watch_tv, t1.goingout, t1.music, t1.theater, t1.creativity
  /FROM * AS t0
  /JOIN 'cs12e_1.0p_EN.sav' AS t1
    ON t0.nomem_encr=t1.nomem_encr
  /OUTFILE FILE=*.

DELETE VARIABLES nohouse_encr to cs12e416.
DELETE VARIABLES cs12e242 to cs12e425.
DELETE VARIABLES cs12e427 to creativity.
EXECUTE.

*recode smartphone usage. 1=use smartphone, 0 = no smartphone.
RECODE cs12e417 (1=1) (2=0) INTO smartphone_own.
EXECUTE.

DELETE VARIABLES cs12e417 to cs12e426.
EXECUTE.


* Match file with demographic information.
STAR JOIN
  /SELECT t0.TBO_missing, t0.TBO_response, t0.neuroticism, t0.extraversion, t0.agreeable, 
    t0.openness, t0.conscientious, t0.participation_history, t0.trust, t0.worries, t0.surveyvalue, 
    t0.surveyburden, t0.surveyenjoyment, t0.smartphone_own, t1.nohouse_encr, t1.woonvorm, t1.wave, 
    t1.geslacht, t1.positie, t1.gebjaar, t1.leeftijd, t1.lftdcat, t1.lftdhhh, t1.aantalhh, t1.aantalki, 
    t1.partner, t1.burgstat, t1.woning, t1.sted, t1.belbezig, t1.brutoink, t1.brutoink_f, t1.nettoink, 
    t1.netinc, t1.nettoink_f, t1.brutocat, t1.nettocat, t1.brutohh_f, t1.nettohh_f, t1.oplzon, 
    t1.oplmet, t1.oplcat, t1.doetmee, t1.werving, t1.herkomstgroep, t1.simpc, t1.filter_$
  /FROM * AS t0
  /JOIN 'avars_201209_EN_1.0p.sav' AS t1
    ON t0.nomem_encr=t1.nomem_encr
  /OUTFILE FILE=*.

SAVE OUTFILE='Entire LISS panel.sav'
  /COMPRESSED.

*Only select the ones who actually got the question (no matter whether they answered or not). Rest is deleted.
DATASET ACTIVATE DataSet1.
DATASET COPY  entireLISSpanel.
DATASET ACTIVATE  entireLISSpanel.
FILTER OFF.
USE ALL.
SELECT IF (TBO_missing >= 0).
EXECUTE.
DATASET ACTIVATE  DataSet1.

SAVE OUTFILE='Entire LISS panel_ALLCOVARIATES.sav'
  /COMPRESSED.

STAR JOIN
  /SELECT t0.TBO_missing, t0.TBO_response, t0.neuroticism, t0.extraversion, t0.agreeable, 
    t0.openness, t0.conscientious, t0.participation_history, t0.trust, t0.worries, t0.surveyvalue, 
    t0.surveyburden, t0.surveyenjoyment, t0.smartphone_own, t0.nohouse_encr, t0.woonvorm, t0.wave, 
    t0.geslacht, t0.positie, t0.gebjaar, t0.leeftijd, t0.lftdcat, t0.lftdhhh, t0.aantalhh, t0.aantalki, 
    t0.partner, t0.burgstat, t0.woning, t0.sted, t0.belbezig, t0.brutoink, t0.brutoink_f, t0.nettoink, 
    t0.netinc, t0.nettoink_f, t0.brutocat, t0.nettocat, t0.brutohh_f, t0.nettohh_f, t0.oplzon, 
    t0.oplmet, t0.oplcat, t0.doetmee, t0.werving, t0.herkomstgroep, t0.simpc, t1.smartphone_use
  /FROM * AS t0
  /JOIN 'DataSet3' AS t1
    ON t0.nomem_encr=t1.nomem_encr
  /OUTFILE FILE=*.

*only select the ones who answered whether they wanted to participate. Rest is deleted.
DATASET COPY  expressedwillingness.
DATASET ACTIVATE  expressedwillingness.
FILTER OFF.
USE ALL.
SELECT IF (TBO_response >= 0).
EXECUTE.
DATASET ACTIVATE  DataSet1.

SAVE OUTFILE='ExpressedWillingness_ALLCOVARIATESsav'
  /COMPRESSED.

*Analyze Patterns of Missing Values.
MULTIPLE IMPUTATION  nomem_encr neuroticism extraversion agreeable openness conscientious 
    participation_history trust worries surveyvalue surveyburden surveyenjoyment smartphone_own 
    woonvorm geslacht leeftijd aantalhh aantalki partner burgstat woning sted nettoink_f oplcat 
    TBO_missing TBO_response smartphone_use
   /IMPUTE METHOD=NONE
   /MISSINGSUMMARIES  OVERALL VARIABLES (MAXVARS=25 MINPCTMISSING=1) PATTERNS.

*impute missing values..
DATASET DECLARE  imputed_covariates2.
MVA VARIABLES=nomem_encr geslacht leeftijd aantalhh lftdhhh aantalki partner burgstat woonvorm woning sted 
    nettoink_f oplcat TBO_response participation_history neuroticism extraversion agreeable conscientious openness 
    surveyvalue surveyburden surveyenjoyment worries trust smartphone_own smartphone_use
  /EM(TOLERANCE=0.001 CONVERGENCE=0.0001 ITERATIONS=25 OUTFILE=imputed_covariates2).

SAVE OUTFILE='ExpressedWillingness_imputed.sav'
  /COMPRESSED.

*merge with the response_nonresponse.sav dataset.
*Only keep the TUS respondents. The rest can be deleted.
STAR JOIN
  /SELECT t1.TBO_response, t1.neuroticism, t1.extraversion, t1.agreeable, t1.openness, 
    t1.conscientious, t1.participation_history, t1.trust, t1.worries, t1.surveyvalue, t1.surveyburden, 
    t1.surveyenjoyment, t1.smartphone_own, t1.woonvorm, t1.geslacht, t1.leeftijd, t1.lftdhhh, 
    t1.aantalhh, t1.aantalki, t1.partner, t1.burgstat, t1.woning, t1.sted, t1.nettoink_f, t1.oplcat, 
    t0.resp_preq, t0.resp_postq, t0.resp_diary, t0.popup_part
  /FROM 'DataSet28' AS t0
  /JOIN * AS t1
    ON t0.nomem_encr=t1.nomem_encr
  /OUTFILE FILE=*.

SAVE OUTFILE='TUS_imputed.sav'
  /COMPRESSED.


STAR JOIN
  /SELECT t0.TBO_response, t0.neuroticism, t0.extraversion, t0.agreeable, t0.openness, 
    t0.conscientious, t0.participation_history, t0.trust, t0.worries, t0.surveyvalue, t0.surveyburden, 
    t0.surveyenjoyment, t0.smartphone_own, t0.woonvorm, t0.geslacht, t0.leeftijd, t0.lftdhhh, 
    t0.aantalhh, t0.aantalki, t0.partner, t0.burgstat, t0.woning, t0.sted, t0.nettoink_f, t0.oplcat, 
    t0.resp_preq, t0.resp_postq, t0.popup_part, t0.resp_diary, t1.numbOfGPSObs
  /FROM * AS t0
  /JOIN 'TBO_SelectieOverzicht_06p.sav' AS t1
    ON t0.nomem_encr=t1.nomem_encr
  /OUTFILE FILE=*.

*When you look at the histogram, you see a clear "top" around 576 - 602. So you also say that everyone below that has not always shared his GPS observations.We decide to use this one. So therefore it is called GPS_resp.
IF  (numbOfGPSObs  >=  576) GPS_resp=1.
EXECUTE.
RECODE GPS_resp (MISSING=0).
EXECUTE.

SAVE OUTFILE='TUS_imputed.sav'
  /COMPRESSED.

*We performed all logistic regression models in R, because we wanted to calculate Average Marginal Effects.
