﻿* Encoding: UTF-8.

* This syntax works with the dataset ESS1-8_merge.sav created by the first syntax file.

*(Part 1) % of females

* Create gender (technical variable)

RECODE gndr (1=0) (2=1) INTO gender.
VARIABLE LABELS  gender 'gender'.
VALUE LABELS gender
0 Male
1 Female.
EXECUTE.

SORT CASES  BY essround.
SPLIT FILE LAYERED BY essround.
EXECUTE.

* Calculate % of female

WEIGHT BY dweight.
EXECUTE.

MEANS TABLES=gender BY cntry
  /CELLS=MEAN.
EXECUTE.

* Calculate sample size

WEIGHT OFF.
EXECUTE.

MEANS TABLES=gender BY cntry
  /CELLS=COUNT.
EXECUTE.

*Split file off & delete gender (technical_variable)

SPLIT FILE OFF.
DELETE VARIABLES gender.
EXECUTE.

*END (Part 1)

*(Part 2) % of respondents age 15-24

* Create age15_24 (technical variable)

RECODE agea (MISSING=SYSMIS) (14=SYSMIS) (15 thru 24=1) (ELSE=0) INTO age15_24.
VARIABLE LABELS  age15_24 'age (15-24)'.
VALUE LABELS age15_24
0 'not 15_24'
1 '15-24'.
EXECUTE.

SORT CASES  BY essround.
SPLIT FILE LAYERED BY essround.
EXECUTE.

* Calculate % of respondents age 15-24

WEIGHT BY dweight.
EXECUTE.

MEANS TABLES=age15_24 BY cntry
  /CELLS=MEAN.
EXECUTE.

* Calculate sample size

WEIGHT OFF.
EXECUTE.

MEANS TABLES=age15_24 BY cntry
  /CELLS=COUNT.
EXECUTE.

*Split file off & delete age15_24 (technical_variable)

SPLIT FILE OFF.
DELETE VARIABLES age15_24.
EXECUTE.

*END (Part 2)

*(Part 3) % of respondents age 75+

* Create age75plus (technical variable)

RECODE agea (MISSING=SYSMIS) (14=SYSMIS) (75 thru Highest=1) (ELSE=0) INTO age75plus.
VARIABLE LABELS  age75plus 'age (75+)'.
VALUE LABELS age75plus
0 'not 75+'
1 '75+'.
EXECUTE.

SORT CASES  BY essround.
SPLIT FILE LAYERED BY essround.
EXECUTE.

* Calculate % of respondents age 75+

WEIGHT BY dweight.
EXECUTE.

MEANS TABLES=age75plus BY cntry
  /CELLS=MEAN.
EXECUTE.

* Calculate sample size

WEIGHT OFF.
EXECUTE.

MEANS TABLES=age75plus BY cntry
  /CELLS=COUNT.
EXECUTE.

*Split file off & delete age15_24 (technical_variable)

SPLIT FILE OFF.
DELETE VARIABLES age75plus.
EXECUTE.

*END (Part 3)
*END
