﻿ * Encoding: UTF-8.

* This syntax works with the dataset ESS1-8_merge.sav created in the previous step

*NOTE: in order for the subsample data file to save substitue the actual path for "path_here" in the command SAVE OUTFILE='path_here/ESS1-8_internal.sav' at the end of this syntax file

*Reasons for excluding respondents from ESS1-ESS7 cumulative dataset: 
*One-person households or households with unknown number of members

FILTER OFF.
USE ALL.
SELECT IF (hhmmb ~= 1 & hhmmb ~= 77 & hhmmb ~= 88 & hhmmb ~= 99 & hhmmb <= 15).
EXECUTE.

 *DISTRIBUTION OF THE NUMBER OF HOUSEHOLD MEMBERS IN THE SUBSAMPLE Step1
  
FREQUENCIES VARIABLES=hhmmb
  /ORDER=ANALYSIS.
EXECUTE.

*Reasons for excluding respondents from ESS1-ESS7 cumulative dataset: 
*Respondent does not live with husband/wife/partner or there is no information about it

FILTER OFF.
USE ALL.
SELECT IF (partner = 1).
EXECUTE.

 *DISTRIBUTION OF THE NUMBER OF HOUSEHOLD MEMBERS IN THE SUBSAMPLE Step2
  
FREQUENCIES VARIABLES=hhmmb
  /ORDER=ANALYSIS.
EXECUTE.

*Reasons for excluding respondents from ESS1-ESS7 cumulative dataset: 
*Respondent lives with: a) parents/parents-in-law, b) other relative, c) other non-relative

RECODE rship2 rship3 rship4 rship5 rship6 rship7 rship8 rship9 rship10 rship11 rship12 rship13
    rship14 rship15 (MISSING=0).
EXECUTE.

FILTER OFF.
USE ALL.
SELECT IF (rship2 <= 2).
EXECUTE.

FILTER OFF.
USE ALL.
SELECT IF (rship3 <= 2).
EXECUTE.

FILTER OFF.
USE ALL.
SELECT IF (rship4 <= 2).
EXECUTE.

FILTER OFF.
USE ALL.
SELECT IF (rship5 <= 2).
EXECUTE.

FILTER OFF.
USE ALL.
SELECT IF (rship6 <= 2).
EXECUTE.

FILTER OFF.
USE ALL.
SELECT IF (rship7 <= 2).
EXECUTE.

FILTER OFF.
USE ALL.
SELECT IF (rship8 <= 2).
EXECUTE.

FILTER OFF.
USE ALL.
SELECT IF (rship9 <= 2).
EXECUTE.

FILTER OFF.
USE ALL.
SELECT IF (rship10 <= 2).
EXECUTE.

FILTER OFF.
USE ALL.
SELECT IF (rship11 <= 2).
EXECUTE.

FILTER OFF.
USE ALL.
SELECT IF (rship12 <= 2).
EXECUTE.

FILTER OFF.
USE ALL.
SELECT IF (rship13 <= 2).
EXECUTE.

FILTER OFF.
USE ALL.
SELECT IF (rship14 <= 2).
EXECUTE.

FILTER OFF.
USE ALL.
SELECT IF (rship15 <= 2).
EXECUTE.

RECODE rship2 rship3 rship4 rship5 rship6 rship7 rship8 rship9 rship10 rship11 rship12 rship13
    rship14 rship15 (0=SYSMIS).
EXECUTE.

 *DISTRIBUTION OF THE NUMBER OF HOUSEHOLD MEMBERS IN THE SUBSAMPLE Step3
  
FREQUENCIES VARIABLES=hhmmb
  /ORDER=ANALYSIS.
EXECUTE.

*Reasons for excluding respondents from ESS1-ESS7 cumulative dataset: 
*Respondent lives with a homosexual partner

USE ALL.
COMPUTE filter_$=(rship2=1 & (gndr = gndr2)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship2=1 & (gndr = gndr2) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship3=1 & (gndr = gndr3)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship3=1 & (gndr = gndr3) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship4=1 & (gndr = gndr4)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship4=1 & (gndr = gndr4) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship5=1 & (gndr = gndr5)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship5=1 & (gndr = gndr5) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship6=1 & (gndr = gndr6)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship6=1 & (gndr = gndr6) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship7=1 & (gndr = gndr7)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship7=1 & (gndr = gndr7) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship8=1 & (gndr = gndr8)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship8=1 & (gndr = gndr8) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship9=1 & (gndr = gndr9)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship9=1 & (gndr = gndr9) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship10=1 & (gndr = gndr10)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship10=1 & (gndr = gndr10) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship11=1 & (gndr = gndr11)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship11=1 & (gndr = gndr11) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship12=1 & (gndr = gndr12)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship12=1 & (gndr = gndr12) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship13=1 & (gndr = gndr13)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship13=1 & (gndr = gndr13) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship14=1 & (gndr = gndr14)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship14=1 & (gndr = gndr14) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship15=1 & (gndr = gndr15)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship15=1 & (gndr = gndr15) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

 *DISTRIBUTION OF THE NUMBER OF HOUSEHOLD MEMBERS IN THE SUBSAMPLE Step 4
  
FREQUENCIES VARIABLES=hhmmb
  /ORDER=ANALYSIS.
EXECUTE.

*Reasons for excluding respondents from ESS1-ESS7 cumulative dataset: 
*Respondent declared cohabitation in one household with two or more husbands/wives

USE ALL.
COMPUTE filter_$=(rship2=1 & ( rship3=1  | rship4=1 | rship5=1 | rship6=1 | rship7=1 | rship8=1 |
    rship9=1 | rship10=1 | rship11=1 | rship12=1 | rship13=1 | rship14=1 | rship15=1)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship2=1 & ( rship3=1  | rship4=1 | rship5=1 | rship6=1 | rship7=1 | '+
    'rship8=1 | rship9=1 | rship10=1 | rship11=1 | rship12=1 | rship13=1 | rship14=1 | rship15=1)) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship3=1 & ( rship2=1  | rship4=1 | rship5=1 | rship6=1 | rship7=1 | rship8=1 |
    rship9=1 | rship10=1 | rship11=1 | rship12=1 | rship13=1 | rship14=1 | rship15=1)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship3=1 & ( rship2=1  | rship4=1 | rship5=1 | rship6=1 | rship7=1 | '+
    'rship8=1 | rship9=1 | rship10=1 | rship11=1 | rship12=1 | rship13=1 | rship14=1 | rship15=1) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship4=1 & ( rship2=1  | rship3=1 | rship5=1 | rship6=1 | rship7=1 | rship8=1 |
    rship9=1 | rship10=1 | rship11=1 | rship12=1 | rship13=1 | rship14=1 | rship15=1)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship4=1 & ( rship2=1  | rship3=1 | rship5=1 | rship6=1 | rship7=1 | '+
    'rship8=1 | rship9=1 | rship10=1 | rship11=1 | rship12=1 | rship13=1 | rship14=1 | rship15=1) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship5=1 & ( rship2=1  | rship3=1 | rship4=1 | rship6=1 | rship7=1 | rship8=1 |
    rship9=1 | rship10=1 | rship11=1 | rship12=1 | rship13=1 | rship14=1 | rship15=1)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship5=1 & ( rship2=1  | rship3=1 | rship4=1 | rship6=1 | rship7=1 | '+
    'rship8=1 | rship9=1 | rship10=1 | rship11=1 | rship12=1 | rship13=1 | rship14=1 | rship15=1) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship6=1 & ( rship2=1  | rship3=1 | rship4=1 | rship5=1 | rship7=1 | rship8=1 |
    rship9=1 | rship10=1 | rship11=1 | rship12=1 | rship13=1 | rship14=1 | rship15=1)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship6=1 & ( rship2=1  | rship3=1 | rship4=1 | rship5=1 | rship7=1 | '+
    'rship8=1 | rship9=1 | rship10=1 | rship11=1 | rship12=1 | rship13=1 | rship14=1 | rship15=1) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship7=1 & ( rship2=1  | rship3=1 | rship4=1 | rship5=1 | rship6=1 | rship8=1 |
    rship9=1 | rship10=1 | rship11=1 | rship12=1 | rship13=1 | rship14=1 | rship15=1)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship7=1 & ( rship2=1  | rship3=1 | rship4=1 | rship5=1 | rship6=1 | '+
    'rship8=1 | rship9=1 | rship10=1 | rship11=1 | rship12=1 | rship13=1 | rship14=1 | rship15=1) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship8=1 & ( rship2=1  | rship3=1 | rship4=1 | rship5=1 | rship6=1 | rship7=1 |
    rship9=1 | rship10=1 | rship11=1 | rship12=1 | rship13=1 | rship14=1 | rship15=1)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship8=1 & ( rship2=1  | rship3=1 | rship4=1 | rship5=1 | rship6=1 | '+
    'rship7=1 | rship9=1 | rship10=1 | rship11=1 | rship12=1 | rship13=1 | rship14=1 | rship15=1) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship9=1 & ( rship2=1  | rship3=1 | rship4=1 | rship5=1 | rship6=1 | rship7=1 |
    rship8=1 | rship10=1 | rship11=1 | rship12=1 | rship13=1 | rship14=1 | rship15=1)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship9=1 & ( rship2=1  | rship3=1 | rship4=1 | rship5=1 | rship6=1 | '+
    'rship7=1 | rship8=1 | rship10=1 | rship11=1 | rship12=1 | rship13=1 | rship14=1 | rship15=1) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship10=1 & ( rship2=1  | rship3=1 | rship4=1 | rship5=1 | rship6=1 | rship7=1 |
    rship8=1 | rship9=1 | rship11=1 | rship12=1 | rship13=1 | rship14=1 | rship15=1)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship10=1 & ( rship2=1  | rship3=1 | rship4=1 | rship5=1 | rship6=1 | '+
    'rship7=1 | rship8=1 | rship9=1 | rship11=1 | rship12=1 | rship13=1 | rship14=1 | rship15=1) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship11=1 & ( rship2=1  | rship3=1 | rship4=1 | rship5=1 | rship6=1 | rship7=1 |
    rship8=1 | rship9=1 | rship10=1 | rship12=1 | rship13=1 | rship14=1 | rship15=1)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship11=1 & ( rship2=1  | rship3=1 | rship4=1 | rship5=1 | rship6=1 | '+
    'rship7=1 | rship8=1 | rship9=1 | rship10=1 | rship12=1 | rship13=1 | rship14=1 | rship15=1) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship12=1 & ( rship2=1  | rship3=1 | rship4=1 | rship5=1 | rship6=1 | rship7=1 |
    rship8=1 | rship9=1 | rship10=1 | rship11=1 | rship13=1 | rship14=1 | rship15=1)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship12=1 & ( rship2=1  | rship3=1 | rship4=1 | rship5=1 | rship6=1 | '+
    'rship7=1 | rship8=1 | rship9=1 | rship10=1 | rship11=1 | rship13=1 | rship14=1 | rship15=1) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship13=1 & ( rship2=1  | rship3=1 | rship4=1 | rship5=1 | rship6=1 | rship7=1 |
    rship8=1 | rship9=1 | rship10=1 | rship11=1 | rship12=1 | rship14=1 | rship15=1)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship13=1 & ( rship2=1  | rship3=1 | rship4=1 | rship5=1 | rship6=1 | '+
    'rship7=1 | rship8=1 | rship9=1 | rship10=1 | rship11=1 | rship12=1 | rship14=1 | rship15=1) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship14=1 & ( rship2=1  | rship3=1 | rship4=1 | rship5=1 | rship6=1 | rship7=1 |
    rship8=1 | rship9=1 | rship10=1 | rship11=1 | rship12=1 | rship13=1 | rship15=1)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship14=1 & ( rship2=1  | rship3=1 | rship4=1 | rship5=1 | rship6=1 | '+
    'rship7=1 | rship8=1 | rship9=1 | rship10=1 | rship11=1 | rship12=1 | rship13=1 | rship15=1) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship15=1 & ( rship2=1  | rship3=1 | rship4=1 | rship5=1 | rship6=1 | rship7=1 |
    rship8=1 | rship9=1 | rship10=1 | rship11=1 | rship12=1 | rship13=1 | rship14=1)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship15=1 & ( rship2=1  | rship3=1 | rship4=1 | rship5=1 | rship6=1 | '+
    'rship7=1 | rship8=1 | rship9=1 | rship10=1 | rship11=1 | rship12=1 | rship13=1 | rship14=1) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

 *DISTRIBUTION OF THE NUMBER OF HOUSEHOLD MEMBERS IN THE SUBSAMPLE Step5
  
FREQUENCIES VARIABLES=hhmmb
  /ORDER=ANALYSIS.
EXECUTE.


*Reasons for excluding respondents from ESS1-ESS7 cumulative dataset: 
*No data about: a) gender of respondent/partner, b) relationship with other residents

USE ALL.
COMPUTE filter_$=(gndr = 9).
VARIABLE LABELS filter_$ '(gndr = 9) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship2=1 & gndr2 >= 6).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship2=1 & gndr2 >= 6 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship3=1 & gndr3 >= 6).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship3=1 & gndr3 >= 6 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship4=1 & gndr4 >= 6).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship4=1 & gndr4 >= 6 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship5=1 & gndr5 >= 6).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship5=1 & gndr5 >= 6 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship6=1 & gndr6 >= 6).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship6=1 & gndr6 >= 6 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship7=1 & gndr7 >= 6).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship7=1 & gndr7 >= 6 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship8=1 & gndr8 >= 6).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship8=1 & gndr8 >= 6 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship9=1 & gndr9 >= 6).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship9=1 & gndr9 >= 6 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship10=1 & gndr10 >= 6).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship10=1 & gndr10 >= 6 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship11=1 & gndr11 >= 6).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship11=1 & gndr11 >= 6 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship12=1 & gndr12 >= 6).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship12=1 & gndr12 >= 6 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship13=1 & gndr13 >= 6).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship13=1 & gndr13 >= 6 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship14=1 & gndr14 >= 6).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship14=1 & gndr14 >= 6 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship15=1 & gndr15 >= 6).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship15=1 & gndr15 >= 6 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(hhmmb=2 & rship2 = 99).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'hhmmb=2 & rship2 = 99 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(hhmmb=3 & (rship2 = 99 | rship3 = 99)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'hhmmb=3 & (rship2 = 99 | rship3 = 99) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(hhmmb=4 & (rship2 = 99 | rship3 = 99| rship4 = 99)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'hhmmb=4 & (rship2 = 99 | rship3 = 99| rship4 = 99) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(hhmmb=5 & (rship2 = 99 | rship3 = 99| rship4 = 99| rship5 = 99)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'hhmmb=5 & (rship2 = 99 | rship3 = 99| rship4 = 99| rship5 = 99) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(hhmmb=6 & (rship2 = 99 | rship3 = 99| rship4 = 99| rship5 = 99| rship6 = 99)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'hhmmb=6 & (rship2 = 99 | rship3 = 99| rship4 = 99| rship5 = 99| rship6 = 99) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(hhmmb=7 & (rship2 = 99 | rship3 = 99| rship4 = 99| rship5 = 99| rship6 = 99|
    rship7 = 99)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'hhmmb=7 & (rship2 = 99 | rship3 = 99| rship4 = 99| rship5 = 99| rship6 = 99| rship7 = 99) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(hhmmb=8 & (rship2 = 99 | rship3 = 99| rship4 = 99| rship5 = 99| rship6 = 99|
    rship7 = 99| rship8 = 99)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'hhmmb=8 & (rship2 = 99 | rship3 = 99| rship4 = 99| rship5 = 99| rship6 = 99| rship7 = 99| rship8 = 99) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(hhmmb=9 & (rship2 = 99 | rship3 = 99| rship4 = 99| rship5 = 99| rship6 = 99|
    rship7 = 99| rship8 = 99| rship9 = 99)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'hhmmb=9 & (rship2 = 99 | rship3 = 99| rship4 = 99| rship5 = 99| rship6 = 99| rship7 = 99| rship8 = 99| rship9 = 99) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(hhmmb=10 & (rship2 = 99 | rship3 = 99| rship4 = 99| rship5 = 99| rship6 = 99|
    rship7 = 99| rship8 = 99| rship9 = 99| rship10 = 99)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'hhmmb=10 & (rship2 = 99 | rship3 = 99| rship4 = 99| rship5 = 99| rship6 = 99| rship7 = 99| rship8 = 99| rship9 = 99| rship10 = 99) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(hhmmb=11 & (rship2 = 99 | rship3 = 99| rship4 = 99| rship5 = 99| rship6 = 99|
    rship7 = 99| rship8 = 99| rship9 = 99| rship10 = 99| rship11 = 99)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'hhmmb=11 & (rship2 = 99 | rship3 = 99| rship4 = 99| rship5 = 99| rship6 = 99| rship7 = 99| rship8 = 99| rship9 = 99| rship10 = 99| rship11 = 99) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(hhmmb=12 & (rship2 = 99 | rship3 = 99| rship4 = 99| rship5 = 99| rship6 = 99|
    rship7 = 99| rship8 = 99| rship9 = 99| rship10 = 99| rship11 = 99| rship12 = 99)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'hhmmb=12 & (rship2 = 99 | rship3 = 99| rship4 = 99| rship5 = 99| rship6 = 99| rship7 = 99| rship8 = 99| rship9 = 99| rship10 = 99| rship11 = 99| rship12 = 99) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(hhmmb=13 & (rship2 = 99 | rship3 = 99| rship4 = 99| rship5 = 99| rship6 = 99|
    rship7 = 99| rship8 = 99| rship9 = 99| rship10 = 99| rship11 = 99| rship12 = 99| rship13 = 99)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'hhmmb=13 & (rship2 = 99 | rship3 = 99| rship4 = 99| rship5 = 99| '+
    'rship6 = 99| rship7 = 99| rship8 = 99| rship9 = 99| rship10 = 99| rship11 = 99| rship12 = 99| '+
    'rship13 = 99) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(hhmmb=14 & (rship2 = 99 | rship3 = 99| rship4 = 99| rship5 = 99| rship6 = 99|
    rship7 = 99| rship8 = 99| rship9 = 99| rship10 = 99| rship11 = 99| rship12 = 99| rship13 = 99|
    rship14 = 99)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'hhmmb=14 & (rship2 = 99 | rship3 = 99| rship4 = 99| rship5 = 99| '+
    'rship6 = 99| rship7 = 99| rship8 = 99| rship9 = 99| rship10 = 99| rship11 = 99| rship12 = 99| '+
    'rship13 = 99| rship14 = 99) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(hhmmb=15 & (rship2 = 99 | rship3 = 99| rship4 = 99| rship5 = 99| rship6 = 99|
    rship7 = 99| rship8 = 99| rship9 = 99| rship10 = 99| rship11 = 99| rship12 = 99| rship13 = 99|
    rship14 = 99| rship15 = 99)).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'hhmmb=15 & (rship2 = 99 | rship3 = 99| rship4 = 99| rship5 = 99| '+
    'rship6 = 99| rship7 = 99| rship8 = 99| rship9 = 99| rship10 = 99| rship11 = 99| rship12 = 99| '+
    'rship13 = 99| rship14 = 99| rship15 = 99) (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

 *DISTRIBUTION OF THE NUMBER OF HOUSEHOLD MEMBERS IN THE SUBSAMPLE Step 6
  
FREQUENCIES VARIABLES=hhmmb
  /ORDER=ANALYSIS.
EXECUTE.

*Reasons for excluding respondents from ESS1-ESS7 cumulative dataset: 
*Respondent lives in a household with children aged 15 years and older

COMPUTE inwyr=SUM(inwyr,inwyys).
EXECUTE.

* In Estonia (round 5) data is missing for the inwyr and inwyys variables, in line with the published documentaion this value has to be set at 2010

USE ALL.
IF  (essround = 5 & cntry = "EE") inwyr=2010.
EXECUTE.

COMPUTE agea2=inwyr-yrbrn2.
EXECUTE.
COMPUTE agea3=inwyr-yrbrn3.
EXECUTE.
COMPUTE agea4=inwyr-yrbrn4.
EXECUTE.
COMPUTE agea5=inwyr-yrbrn5.
EXECUTE.
COMPUTE agea6=inwyr-yrbrn6.
EXECUTE.
COMPUTE agea7=inwyr-yrbrn7.
EXECUTE.
COMPUTE agea8=inwyr-yrbrn8.
EXECUTE.
COMPUTE agea9=inwyr-yrbrn9.
EXECUTE.
COMPUTE agea10=inwyr-yrbrn10.
EXECUTE.
COMPUTE agea11=inwyr-yrbrn11.
EXECUTE.
COMPUTE agea12=inwyr-yrbrn12.
EXECUTE.
COMPUTE agea13=inwyr-yrbrn13.
EXECUTE.
COMPUTE agea14=inwyr-yrbrn14.
EXECUTE.
COMPUTE agea15=inwyr-yrbrn15.
EXECUTE.

RECODE agea2 agea3 agea4 agea5 agea6 agea7 agea8 agea9 agea10 agea11 agea12 agea13 agea14 agea15
    (MISSING=9999).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship2=2 & agea2 >= 15).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship2=2 & agea2 >= 15 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship3=2 & agea3 >= 15).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship3=2 & agea3 >= 15 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship4=2 & agea4 >= 15).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship4=2 & agea4 >= 15 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship5=2 & agea5 >= 15).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship5=2 & agea5 >= 15 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship6=2 & agea6 >= 15).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship6=2 & agea6 >= 15 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship7=2 & agea7 >= 15).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship7=2 & agea7 >= 15 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship8=2 & agea8 >= 15).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship8=2 & agea8 >= 15 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship9=2 & agea9 >= 15).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship9=2 & agea9 >= 15 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship10=2 & agea10 >= 15).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship10=2 & agea10 >= 15 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship11=2 & agea11 >= 15).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship11=2 & agea11 >= 15 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship12=2 & agea12 >= 15).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship12=2 & agea12 >= 15 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship13=2 & agea13 >= 15).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship13=2 & agea13 >= 15 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship14=2 & agea14 >= 15).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship14=2 & agea14 >= 15 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

USE ALL.
COMPUTE filter_$=(rship15=2 & agea15 >= 15).
RECODE filter_$ (SYSMIS=0).
VARIABLE LABELS filter_$ 'rship14=2 & agea14 >= 15 (FILTER)'.
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
SELECT IF (filter_$ = 0).
EXECUTE.

 *DISTRIBUTION OF THE NUMBER OF HOUSEHOLD MEMBERS IN THE SUBSAMPLE FOR INTERNAL CRITERIA OF REPRESENTATIVENESS
  
FREQUENCIES VARIABLES=hhmmb
  /ORDER=ANALYSIS.
EXECUTE.

* Note: set up the path of the new file ESS1-8_internal.sav

SAVE OUTFILE='/path_here/ESS1-8_internal.sav'
  /COMPRESSED.
EXECUTE.


*END
