﻿* Encoding: UTF-8.

* This syntax works with the attached meta-data file ESS1-7_metadata.sav

* Part 1: Compute variables: Abs_bias of demographic representation & Unit_nonresponse_bias

* (Syntax 1.1) Absolute bias of female misrepresentation

COMPUTE Abs_bias_female=ABS(eurostat_female-sample_female)/SQRT(eurostat_female*(1-eurostat_female)
    /n_sample_total_gender).
VARIABLE LABELS Abs_bias_female 'External criteria: Absolute bias of female misrepresentation'.
EXECUTE.

* (Syntax1.2) Absolute bias of youth misrepresentation

COMPUTE Abs_bias_age15_24=ABS(eurostat_age15_24-sample_age15_24)/SQRT(eurostat_age15_24*
    (1-eurostat_age15_24)/n_sample_total_age).
VARIABLE LABELS Abs_bias_age15_24 'External criteria: Absolute bias of youth misrepresentation'.
EXECUTE.

* (Syntax 1.3) Absolute bias of elderly misrepresentation.

COMPUTE Abs_bias_age75plus=ABS(eurostat_age75plus-sample_age75plus)/SQRT(eurostat_age75plus*
    (1-eurostat_age75plus)/n_sample_total_age).
VARIABLE LABELS Abs_bias_age75plus 'External criteria: Absolute bias of elderly misrepresentation'.
EXECUTE.

* (Syntax 1.4) Internal criteria - syntax for calculating Unit nonresponse bias

COMPUTE Unit_nonresponse=ABS(0.5-females_hh_subsample)/SQRT(0.25/n_hh_subsample).
VARIABLE LABELS Unit_nonresponse 'Internal criteria: Unit nonresponse bias'.
EXECUTE.

* Part 2: Differences between non-PRS and PRS surveys with respect to rates of response, refusal, contact, cooperation, the ratio of respondents selected for or confirmed through back-checkingand the fraction of surveys utilising respondent-incentives

* (Syntax 1.1) Differences between non-PRS and PRS surveys with respect to rates of response, refusal, contact or cooperation.

MEANS TABLES=rr2 con1 coop2 ref1 BY sample
  /CELLS=MEAN COUNT.
EXECUTE.

* (Syntax 1.2) Differences between non-PRS and PRS surveys with respect to the ratio of respondents selected for or confirmed through back-checking..

MEANS TABLES=back_rs back_rc BY sample
  /CELLS=MEAN COUNT.
EXECUTE.

* (Syntax 1.3) Differences between non-PRS and PRS surveys with respect to the fraction of surveys utilising respondent-incentives

MEANS TABLES=incentives BY sample
  /CELLS=MEAN COUNT.
EXECUTE.

*Part 3: Syntax for external criteria assessment

* (Syntax 1.1) Distribution of sample types over ESS rounds

CROSSTABS
  /TABLES=sample BY round
  /FORMAT=AVALUE TABLES
  /STATISTICS=CHISQ 
  /CELLS=COUNT 
  /COUNT ROUND CELL.
EXECUTE.

* (Syntax 2.1) Mean values of Abs_bias_dem with corresponding standard errors within categories selected according to sample type and ESS round

MEANS TABLES=Abs_bias_female Abs_bias_age15_24 Abs_bias_age75plus BY sample round
  /CELLS=MEAN SEMEAN COUNT.
EXECUTE.

* (Syntax 2.2) GLM Univariate analysis of between-subject effects on gender and age imbalance

UNIANOVA Abs_bias_female BY sample round
  /METHOD=SSTYPE(2)
  /INTERCEPT=INCLUDE
  /CRITERIA=ALPHA(.05)
  /DESIGN=sample round round*sample.

UNIANOVA Abs_bias_age15_24 BY sample round
  /METHOD=SSTYPE(2)
  /INTERCEPT=INCLUDE
  /CRITERIA=ALPHA(.05)
  /DESIGN=sample round round*sample.

UNIANOVA Abs_bias_age75plus BY sample round
  /METHOD=SSTYPE(2)
  /INTERCEPT=INCLUDE
  /CRITERIA=ALPHA(.05)
  /DESIGN=sample round round*sample.

* Part 4: Syntax for internal criteria assessment

* (Syntax 1) Correlation between refusal rate (REF1) and Unit_nonresponse_bias  in PRS and non-PRS surveys

SORT CASES  BY sample.
SPLIT FILE LAYERED BY sample.
EXECUTE.

CORRELATIONS
  /VARIABLES=Unit_nonresponse ref1
  /PRINT=TWOTAIL NOSIG
  /MISSING=PAIRWISE.
EXECUTE.

SPLIT FILE OFF.
SORT CASES  BY ID.
EXECUTE.

* (Syntax 2) Testing heteroscedasticy: correlation between refusal rate (REF1) and Unit_nonresponse_bias 

SORT CASES  BY sample.
SPLIT FILE SEPARATE BY sample.
EXECUTE.

* (Syntax 2.1) Compute residuals (technical variable)

REGRESSION
  /MISSING LISTWISE
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT ref1
  /METHOD=ENTER Unit_nonresponse
  /SAVE RESID.
EXECUTE.

COMPUTE RES_2=RES_1 * RES_1.
EXECUTE.

* (Syntax 2.2) Test for heteroscedasticy

REGRESSION
  /MISSING LISTWISE
  /STATISTICS ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT Unit_nonresponse
  /METHOD=ENTER RES_2.
EXECUTE.

* Delete technical variables and finish syntax

DELETE VARIABLES RES_1 RES_2.
EXECUTE.

SPLIT FILE OFF.
SORT CASES  BY ID.
EXECUTE.

* End syntax 2.2.

* End