﻿* Encoding: UTF-8.

* Step 1: Dowload the data files:
* (1.1) Use ESS Cumulative Data Wizard (ESS Cumulative Data Wizard) to download ESS cumulative data set:
            - Select Rounds/Countries: 
                    * Austria (1-3, 7); 
                    * Belgium (1-7); 
                    * Czechia (1,2,4-7); 
                    * Denmark (1-7); 
                    * Estionia (2-7); 
                    * Finland (1-7); 
                    * France (1-7); 
                    * Genrmany (1-7);
                    * Hungary (1-7); 
                    * Ireland (1-7); 
                    * Netherlands (1-7); 
                    * Norway (1-7), 
                    * Poland (1-7), 
                    * Portugal (1-7); 
                    * Slovenia (1-7), 
                    * Spain (1-7),
                    * Sweden (1-7); 
                    * Switzerland (1-7); 
                    * United Kingdom (1-7).
*            - Select Variables:
                    * select all variables from section "Gender, age and household composition" 
                    * select PARTNER variable from section "Socio-demographic profile, including: type of area, education and occupation, union membership,.." and subsection  "ESS standard variables, Socio-demographic profile"
                    * select INWYR & INWYYS variables from section "Administrative variables; interview time, administration of split bal..."
*            - Download SPSS datafile and unzip it.
* [Due to the absence of Austrian data (from ESS4 and ESS5 rounds) in the current ESS cummulative data wizzard additional steps are neccesary]
* (1.2) Dowload ESS round 4 datafile for Austria (https://www.europeansocialsurvey.org/download.html?file=ESS4AT&c=AT&y=2008) and unzip it
* (1.3) Dowload ESS round 5 datafile for Austria (https://www.europeansocialsurvey.org/download.html?file=ESS5AT&c=AT&y=2010) and unzip it

* Step 2: Merge data files

* (1) Open file ESS1-8e01.sav

* Note: Set up the path of the file ESS1-8e01.sav in the FILE command, i.e., substitute the actual path for "path_here" in all subsequent comands: FILE='path_here/ESS1-8e01.sav'.

GET
  FILE='/path_here/ESS1-8e01.sav'.
DATASET NAME DataSet1 WINDOW=FRONT.

* (2) Open file ESS4AT.sav

* Note: Set up the path of the file ESS4AT.sav in the FILE command 
i.e., FILE='path_here/ESS4AT.sav'.

GET 
  FILE='/path_here/ESS4AT.sav'. 
DATASET NAME DataSet2 WINDOW=FRONT.

DATASET ACTIVATE DataSet2.
RECODE rshipa2 rshipa3 rshipa4 rshipa5 rshipa6 rshipa7 rshipa8 rshipa9 rshipa10 rshipa11 rshipa12 
    rshipa13 rshipa14 rshipa15 rshipa16 (1=1) (2=2) (3=3) (4=4) (5=4) (6=5) (66=6) (77=7) (88=8) (99=9) 
    INTO rship2 rship3 rship4 rship5 rship6 rship7 rship8 rship9 rship10 rship11 rship12 rship13 
    rship14 rship15 rship16.
EXECUTE.

* (3) Open file ESS5ATe1_1.sav

* Note: Set up the path of the file ESS5ATe1_1.sav in the FILE command 
i.e., FILE='path_here/ESS5ATe1_1.sav'.

GET 
  FILE='/path_here/ESS5ATe1_1.sav'. 
DATASET NAME DataSet3 WINDOW=FRONT.

DATASET ACTIVATE DataSet3.
RECODE rshipa2 rshipa3 rshipa4 rshipa5 rshipa6 rshipa7 rshipa8 rshipa9 rshipa10 rshipa11 rshipa12 
    rshipa13 rshipa14 (1=1) (2=2) (3=3) (4=4) (5=4) (6=5) (66=6) (77=7) (88=8) (99=9) 
    INTO rship2 rship3 rship4 rship5 rship6 rship7 rship8 rship9 rship10 rship11 rship12 rship13 
    rship14.
EXECUTE.

ALTER TYPE cntry(A2) edition(A3).
EXECUTE.

* (4) Merge ESS4AT.sav with ESS1-8e01.sav

DATASET ACTIVATE DataSet1.
ADD FILES /FILE=*
  /RENAME (cedition cname cproddat cseqno name rshipa2 rshipa3=d0 d1 d2 d3 d4 d5 d6)
  /FILE='DataSet2'
  /RENAME (acq30bs acq70bs aesfdrk agdcold agdcyng agegrbl ageyo30 agrpblg atncrse badge bctprd 
    bennent blgetmg brghmef brghmwr brncntr brnocnt brwmny buproag chg1530 chldhhe chldhm cldcrsv 
    clsprty cmsrv cmsrvp cntbrthb contplt crmvct crpdwk crpdwkp crvctef crvctwr ctzcntr ctzshipb 
    dcndleq dfincac ditxssp dngdk dngdkp dngna dngnap dngnapp dngoth dngothp dngref dngrefp domicil 
    dprschg dprsf70 dprso70 dprsy30 dsbld dsbldp dscrage dscrdk dscrdsb dscretn dscrgnd dscrgrp dscrlng 
    dscrna dscrnap dscrntn dscroth dscrrce dscrref dscrrlg dscrsex dvrcdev earnpen earnueb edctn edctnp 
    edlvabe edlvacy edlvadk edlvaes edlvagr edlvail edlvano edlvase edlvasi edlvask edlvat edlvaua 
    edlvbee edlvbfr edlvbhu edlvbie edlvbpl edlvbpt edlvcch edlvcz edlvfat edlvfbe edlvfch edlvfcy 
    edlvfcz edlvfdk edlvfee edlvfes edlvffr edlvfgb edlvfgr edlvfhr edlvfhu edlvfie edlvfil edlvflt 
    edlvflv edlvfnl edlvfno edlvfpl edlvfpt edlvfro edlvfru edlvfse edlvfsi edlvfsk edlvftr edlvfua 
    edlvgb edlvhr edlvlt edlvlv edlvmat edlvmbe edlvmch edlvmcy edlvmcz edlvmdk edlvmee edlvmes edlvmfr 
    edlvmgb edlvmgr edlvmhr edlvmhu edlvmie edlvmil edlvmlt edlvmlv edlvmnl edlvmno edlvmpl edlvmpt 
    edlvmro edlvmru edlvmse edlvmsi edlvmsk edlvmtr edlvmua edlvnl edlvpat edlvpbe edlvpch edlvpcy 
    edlvpcz edlvpdk edlvpee edlvpes edlvpfr edlvpgb edlvpgr edlvphr edlvphu edlvpie edlvpil edlvplt 
    edlvplv edlvpnl edlvpno edlvppl edlvppt edlvpro edlvpru edlvpse edlvpsi edlvpsk edlvptr edlvpua 
    edlvro edlvru edlvtr edufld edulvla edulvlfa edulvlma edulvlpa eduyrs eisced eiscedf eiscedm 
    eiscedp emplno emplnof emplnom emplnop emplrel emprelp emprf14 emprm14 estsz euftf facntr fbrncnta 
    freehms frndo70 frndy30 fxltph gincdif gvcldcr gvhlthc gvjbevn gvpdlwk gvslvol gvslvue happy health 
    hincfel hincsrca hinctnta hlthcef hlthhmp hrshsnt hswrk hswrkp imbgeco imdfetn impcntr impdiff 
    impenv impfree impfun imprich impsafe imptrad imrccon imsclbn imsmetn imueclt imwbcnt inmdisc 
    insfben intewde inttph inwdde inwdds inwehh inwemm inwmme inwmms inwshh inwsmm inwtm inwyye ioactp 
    iorgact ipadvnt ipbhprp ipcrtiv ipeqopt ipfrule ipgdtim iphlppl iplylfr ipmodst iprspot ipshabt 
    ipstrgv ipsuces ipudrst iscoco iscocop jbspv jbspvf jbspvm jbspvp lbenent livecntr lklpwcf lknemny 
    lknhlcn lkrspag lkuemp lnghoma lnghomb lrscale lvghwa lvgptna lvgptne lvoapen lvpbhlt mainact 
    maritala mbfmo70 mbltph mbrncnta mbtru mmbprty mnactic mnactp mnrgtjb mocntr nacer11 name netuse 
    njbspv njbspvp nmnybsc nwsppol nwsptot oafl20 oafl70 occf14b occm14b p20cnec p20cust p70cnec 
    p70cust p70hltb pbldmn pdjobev pdjobyr pdwrk pdwrkp polcmpl poldcs polintr pplfair pplhlp ppltrst 
    pray predage predetn predsex proddate prtclaat prtclabg prtclacz prtclafi prtclail prtclaro 
    prtclaru prtclask prtclatr prtclbbe prtclbch prtclbde prtclbdk prtclbee prtclbes prtclbfr prtclbgr 
    prtclbhu prtclbie prtclbnl prtclbpt prtclbua prtclcpl prtclcsi prtclcy prtclgb prtclhr prtcllt 
    prtcllv prtclno prtclse prtdgcl prtmbaat prtmbabg prtmbacz prtmbafi prtmbaie prtmbail prtmbapt 
    prtmbaro prtmbaru prtmbask prtmbatr prtmbbbe prtmbbch prtmbbde prtmbbdk prtmbbee prtmbbes prtmbbfr 
    prtmbbgr prtmbbhu prtmbbnl prtmbbua prtmbcpl prtmbcsi prtmbcy prtmbgb prtmbhr prtmblt prtmblv 
    prtmbno prtmbse prtsick prtvbde1 prtvbde2 prtvlt1 prtvlt2 prtvlt3 prtvtaat prtvtabg prtvtacz 
    prtvtafi prtvtail prtvtapt prtvtaro prtvtaru prtvtask prtvtatr prtvtbbe prtvtbch prtvtbdk prtvtbee 
    prtvtbes prtvtbfr prtvtbgr prtvtbhu prtvtbpl prtvtbua prtvtcnl prtvtcsi prtvtcy prtvtgb prtvthr 
    prtvtie prtvtlv prtvtno prtvtse prtyban pvolwrk rdpol rdtot regioach regioacz regioadk regioaes 
    regioafi regioagr regioapt regiobie regionat regionbe regionbg regioncy regionde regionee regionfr 
    regiongb regionhr regionhu regionil regionlt regionlv regionnl regionno regionpl regionro regionru 
    regionse regionsi regionsk regiontr regionua rlgatnd rlgblg rlgblge rlgdeat rlgdech rlgdecy rlgdefi 
    rlgdegb rlgdegr rlgdehu rlgdeie rlgdeil rlgdelt rlgdelv rlgdenl rlgdeno rlgdepl rlgdept rlgdero 
    rlgderu rlgdese rlgdesk rlgdeua rlgdgr rlgdnat rlgdnch rlgdncy rlgdnfi rlgdngb rlgdngr rlgdnhu 
    rlgdnie rlgdnil rlgdnlt rlgdnlv rlgdnm rlgdnme rlgdnnl rlgdnno rlgdnpl rlgdnpt rlgdnro rlgdnru 
    rlgdnse rlgdnsk rlgdnua rshipa10 rshipa11 rshipa12 rshipa13 rshipa14 rshipa15 rshipa16 rshipa2 
    rshipa3 rshipa4 rshipa5 rshipa6 rshipa7 rshipa8 rshipa9 rtrd rtrdp sbbsntx sbcwkfm sbenccm sbeqsoc 
    sblazy sblwcoa sblwlka sbprvpv sbstrec schtaut sclact sclmeet scnsenv sgnptit sgr2070 sickdsb 
    slvpens slvuemp smdfslv spltadmc srdscag stfdem stfeco stfedu stfgov stfhlth stflife stsp20 stsp40 
    stsp70 supqad1 supqad2 supqdd supqmm supqyr suproag tporgwk trrcnyr trrenyr trrprsn trrtort trstep 
    trstlgl trstplc trstplt trstprl trstprt trstun trtbdag tvpol tvtot twcol20 twcol70 txadleq txautef 
    txearn uemp12m uemp3m uemp5yr uempla uemplap uempli uemplip uemplwk uentrjb v20adm v20cntm v20comp 
    v20envy v20frnd v20mrst v20pity v20resp v70adm v70cntm v70comp v70envy v70frnd v70mrst v70pity 
    v70resp vote wkdcorga wkdcorp wkhct wkhtot wkhtotp wmcpwrk wr20crm wr20emp wrkac6m wrkctra wrkorg 
    wrkprty yngfnjb=d7 d8 d9 d10 d11 d12 d13 d14 d15 d16 d17 d18 d19 d20 d21 d22 d23 d24 d25 d26 d27 
    d28 d29 d30 d31 d32 d33 d34 d35 d36 d37 d38 d39 d40 d41 d42 d43 d44 d45 d46 d47 d48 d49 d50 d51 d52 
    d53 d54 d55 d56 d57 d58 d59 d60 d61 d62 d63 d64 d65 d66 d67 d68 d69 d70 d71 d72 d73 d74 d75 d76 d77 
    d78 d79 d80 d81 d82 d83 d84 d85 d86 d87 d88 d89 d90 d91 d92 d93 d94 d95 d96 d97 d98 d99 d100 d101 
    d102 d103 d104 d105 d106 d107 d108 d109 d110 d111 d112 d113 d114 d115 d116 d117 d118 d119 d120 d121 
    d122 d123 d124 d125 d126 d127 d128 d129 d130 d131 d132 d133 d134 d135 d136 d137 d138 d139 d140 d141 
    d142 d143 d144 d145 d146 d147 d148 d149 d150 d151 d152 d153 d154 d155 d156 d157 d158 d159 d160 d161 
    d162 d163 d164 d165 d166 d167 d168 d169 d170 d171 d172 d173 d174 d175 d176 d177 d178 d179 d180 d181 
    d182 d183 d184 d185 d186 d187 d188 d189 d190 d191 d192 d193 d194 d195 d196 d197 d198 d199 d200 d201 
    d202 d203 d204 d205 d206 d207 d208 d209 d210 d211 d212 d213 d214 d215 d216 d217 d218 d219 d220 d221 
    d222 d223 d224 d225 d226 d227 d228 d229 d230 d231 d232 d233 d234 d235 d236 d237 d238 d239 d240 d241 
    d242 d243 d244 d245 d246 d247 d248 d249 d250 d251 d252 d253 d254 d255 d256 d257 d258 d259 d260 d261 
    d262 d263 d264 d265 d266 d267 d268 d269 d270 d271 d272 d273 d274 d275 d276 d277 d278 d279 d280 d281 
    d282 d283 d284 d285 d286 d287 d288 d289 d290 d291 d292 d293 d294 d295 d296 d297 d298 d299 d300 d301 
    d302 d303 d304 d305 d306 d307 d308 d309 d310 d311 d312 d313 d314 d315 d316 d317 d318 d319 d320 d321 
    d322 d323 d324 d325 d326 d327 d328 d329 d330 d331 d332 d333 d334 d335 d336 d337 d338 d339 d340 d341 
    d342 d343 d344 d345 d346 d347 d348 d349 d350 d351 d352 d353 d354 d355 d356 d357 d358 d359 d360 d361 
    d362 d363 d364 d365 d366 d367 d368 d369 d370 d371 d372 d373 d374 d375 d376 d377 d378 d379 d380 d381 
    d382 d383 d384 d385 d386 d387 d388 d389 d390 d391 d392 d393 d394 d395 d396 d397 d398 d399 d400 d401 
    d402 d403 d404 d405 d406 d407 d408 d409 d410 d411 d412 d413 d414 d415 d416 d417 d418 d419 d420 d421 
    d422 d423 d424 d425 d426 d427 d428 d429 d430 d431 d432 d433 d434 d435 d436 d437 d438 d439 d440 d441 
    d442 d443 d444 d445 d446 d447 d448 d449 d450 d451 d452 d453 d454 d455 d456 d457 d458 d459 d460 d461 
    d462 d463 d464 d465 d466 d467 d468 d469 d470 d471 d472 d473 d474 d475 d476 d477 d478 d479 d480 d481 
    d482 d483 d484 d485 d486 d487 d488 d489 d490 d491 d492 d493 d494 d495 d496 d497 d498 d499 d500 d501 
    d502 d503 d504 d505 d506 d507 d508 d509 d510 d511 d512 d513 d514 d515 d516 d517 d518 d519 d520 d521 
    d522 d523 d524 d525 d526 d527 d528 d529 d530 d531 d532 d533 d534 d535 d536 d537 d538 d539 d540 d541 
    d542 d543 d544 d545 d546 d547 d548 d549 d550 d551 d552 d553 d554 d555 d556 d557 d558 d559 d560 d561 
    d562 d563 d564 d565 d566 d567 d568 d569 d570 d571 d572 d573 d574 d575 d576 d577 d578 d579 d580 d581 
    d582 d583 d584 d585 d586 d587 d588 d589 d590 d591 d592 d593 d594 d595 d596 d597 d598 d599 d600 d601 
    d602 d603 d604 d605 d606 d607 d608 d609 d610 d611 d612 d613 d614 d615 d616 d617 d618 d619 d620 d621 
    d622 d623 d624 d625 d626 d627 d628 d629 d630 d631 d632 d633 d634 d635 d636)
  /DROP=d0 d1 d2 d3 d4 d5 d6 d7 d8 d9 d10 d11 d12 d13 d14 d15 d16 d17 d18 d19 d20 d21 d22 d23 d24 
    d25 d26 d27 d28 d29 d30 d31 d32 d33 d34 d35 d36 d37 d38 d39 d40 d41 d42 d43 d44 d45 d46 d47 d48 d49 
    d50 d51 d52 d53 d54 d55 d56 d57 d58 d59 d60 d61 d62 d63 d64 d65 d66 d67 d68 d69 d70 d71 d72 d73 d74 
    d75 d76 d77 d78 d79 d80 d81 d82 d83 d84 d85 d86 d87 d88 d89 d90 d91 d92 d93 d94 d95 d96 d97 d98 d99 
    d100 d101 d102 d103 d104 d105 d106 d107 d108 d109 d110 d111 d112 d113 d114 d115 d116 d117 d118 d119 
    d120 d121 d122 d123 d124 d125 d126 d127 d128 d129 d130 d131 d132 d133 d134 d135 d136 d137 d138 d139 
    d140 d141 d142 d143 d144 d145 d146 d147 d148 d149 d150 d151 d152 d153 d154 d155 d156 d157 d158 d159 
    d160 d161 d162 d163 d164 d165 d166 d167 d168 d169 d170 d171 d172 d173 d174 d175 d176 d177 d178 d179 
    d180 d181 d182 d183 d184 d185 d186 d187 d188 d189 d190 d191 d192 d193 d194 d195 d196 d197 d198 d199 
    d200 d201 d202 d203 d204 d205 d206 d207 d208 d209 d210 d211 d212 d213 d214 d215 d216 d217 d218 d219 
    d220 d221 d222 d223 d224 d225 d226 d227 d228 d229 d230 d231 d232 d233 d234 d235 d236 d237 d238 d239 
    d240 d241 d242 d243 d244 d245 d246 d247 d248 d249 d250 d251 d252 d253 d254 d255 d256 d257 d258 d259 
    d260 d261 d262 d263 d264 d265 d266 d267 d268 d269 d270 d271 d272 d273 d274 d275 d276 d277 d278 d279 
    d280 d281 d282 d283 d284 d285 d286 d287 d288 d289 d290 d291 d292 d293 d294 d295 d296 d297 d298 d299 
    d300 d301 d302 d303 d304 d305 d306 d307 d308 d309 d310 d311 d312 d313 d314 d315 d316 d317 d318 d319 
    d320 d321 d322 d323 d324 d325 d326 d327 d328 d329 d330 d331 d332 d333 d334 d335 d336 d337 d338 d339 
    d340 d341 d342 d343 d344 d345 d346 d347 d348 d349 d350 d351 d352 d353 d354 d355 d356 d357 d358 d359 
    d360 d361 d362 d363 d364 d365 d366 d367 d368 d369 d370 d371 d372 d373 d374 d375 d376 d377 d378 d379 
    d380 d381 d382 d383 d384 d385 d386 d387 d388 d389 d390 d391 d392 d393 d394 d395 d396 d397 d398 d399 
    d400 d401 d402 d403 d404 d405 d406 d407 d408 d409 d410 d411 d412 d413 d414 d415 d416 d417 d418 d419 
    d420 d421 d422 d423 d424 d425 d426 d427 d428 d429 d430 d431 d432 d433 d434 d435 d436 d437 d438 d439 
    d440 d441 d442 d443 d444 d445 d446 d447 d448 d449 d450 d451 d452 d453 d454 d455 d456 d457 d458 d459 
    d460 d461 d462 d463 d464 d465 d466 d467 d468 d469 d470 d471 d472 d473 d474 d475 d476 d477 d478 d479 
    d480 d481 d482 d483 d484 d485 d486 d487 d488 d489 d490 d491 d492 d493 d494 d495 d496 d497 d498 d499 
    d500 d501 d502 d503 d504 d505 d506 d507 d508 d509 d510 d511 d512 d513 d514 d515 d516 d517 d518 d519 
    d520 d521 d522 d523 d524 d525 d526 d527 d528 d529 d530 d531 d532 d533 d534 d535 d536 d537 d538 d539 
    d540 d541 d542 d543 d544 d545 d546 d547 d548 d549 d550 d551 d552 d553 d554 d555 d556 d557 d558 d559 
    d560 d561 d562 d563 d564 d565 d566 d567 d568 d569 d570 d571 d572 d573 d574 d575 d576 d577 d578 d579 
    d580 d581 d582 d583 d584 d585 d586 d587 d588 d589 d590 d591 d592 d593 d594 d595 d596 d597 d598 d599 
    d600 d601 d602 d603 d604 d605 d606 d607 d608 d609 d610 d611 d612 d613 d614 d615 d616 d617 d618 d619 
    d620 d621 d622 d623 d624 d625 d626 d627 d628 d629 d630 d631 d632 d633 d634 d635 d636.
EXECUTE.

* Note: set up the path of the new file ESS1-8_merge.sav

SAVE OUTFILE='/path_here/ESS1-8_merge.sav'
  /COMPRESSED.
EXECUTE.

DATASET CLOSE DataSet2.
EXECUTE.

* (5) Merge files ESS5ATe1_1.sav with ESS4AT.sav and ESS1-8e01.sav

DATASET ACTIVATE DataSet1.
ADD FILES /FILE=*
  /FILE='DataSet3'
  /RENAME (actvgrs aesfdrk agertr atncrse badge bctprd blgetmg bplcdc brghmef brghmwr brncntr 
    brwmny bseftwk bsmw bstln5y bystlct bystlwr caplcst chldhhe chldhm clmrlx clsprty cmsrv cmsrvp 
    cntbrthb contplt crmvct crpdwk crpdwkp crvctef crvctwr ctfrdc ctinplt ctjbcnt ctmtgfr ctprpwr 
    ctzcntr ctzshipb cutheqat cuthheq dbctvrd dcsfwrk dfcnswka dngdk dngdkp dngna dngnap dngnapp dngoth 
    dngothp dngref dngrefp domicil doplcsy dpcstrb dsbld dsbldp dscrage dscrdk dscrdsb dscretn dscrgnd 
    dscrgrp dscrlng dscrna dscrnap dscrntn dscroth dscrrce dscrref dscrrlg dscrsex dsdclvat dsdclve 
    dsgrmnya dvrcdeva edagefgb edagegb edagemgb edagepgb edctn edctnp edlvdat edlvdbe edlvdbg edlvdch 
    edlvdcy edlvdcz edlvddk edlvdee edlvdes edlvdfi edlvdfr edlvdgr edlvdhr edlvdhu edlvdie edlvdlt 
    edlvdnl edlvdno edlvdpl edlvdpt edlvdru edlvdse edlvdsi edlvdsk edlvdua edlvfdat edlvfdbe edlvfdbg 
    edlvfdch edlvfdcy edlvfdcz edlvfddk edlvfdee edlvfdes edlvfdfi edlvfdfr edlvfdgr edlvfdhr edlvfdhu 
    edlvfdie edlvfdlt edlvfdnl edlvfdno edlvfdpl edlvfdpt edlvfdru edlvfdse edlvfdsi edlvfdsk edlvfdua 
    edlvmdat edlvmdbe edlvmdbg edlvmdch edlvmdcy edlvmdcz edlvmddk edlvmdee edlvmdes edlvmdfi edlvmdfr 
    edlvmdgr edlvmdhr edlvmdhu edlvmdie edlvmdlt edlvmdnl edlvmdno edlvmdpl edlvmdpt edlvmdru edlvmdse 
    edlvmdsi edlvmdsk edlvmdua edlvpdat edlvpdbe edlvpdbg edlvpdch edlvpdcy edlvpdcz edlvpddk edlvpdee 
    edlvpdes edlvpdfi edlvpdfr edlvpdgr edlvpdhr edlvpdhu edlvpdie edlvpdlt edlvpdnl edlvpdno edlvpdpl 
    edlvpdpt edlvpdru edlvpdse edlvpdsi edlvpdsk edlvpdua edude1 edude2 edude3 edufde1 edufde2 edufde3 
    edufgb1 edufgb2 edufil1 edufil2 edugb1 edugb2 eduil1 eduil2 edul12m edulvlb edulvlfb edulvlmb 
    edulvlpb edumde1 edumde2 edumde3 edumgb1 edumgb2 edumil1 edumil2 edupde1 edupde2 edupde3 edupdem 
    edupgb1 edupgb2 edupil1 edupil2 edupl2 eduppl2 eduyrpl eduyrppl eduyrs eisced eiscedf eiscedm 
    eiscedp emplno emplnof emplnom emplnop emplrel emplrjb emprelp emprf14 emprm14 estsz facntr 
    fbrncnta flsin5y fltlnla freehms frsptjb fxltph gdsprt gincdif grspaya gsupplc gvprppv happy health 
    hincfel hincsrca hinctnta hlpcowk hlthhmp hlthrwk hrshsnta hswrk hswrkp hwwkhs icago45 icagu70a 
    iccohbt icmnact icmnart icnopfma icpart1 icpart2 icptn icptnwka imbgeco imdfetn impcntr impdiff 
    impenv impfree impfun imprich impsafe imptrad imsmetn imueclt imwbcnt indisdc inmdisc insclct 
    insclwr intewde inwdde inwdds inwehh inwemm inwmme inwmms inwshh inwsmm inwtm inwyye iorgact 
    ipadvnt ipbhprp ipcrtiv ipeqopt ipfrule ipgdtim iphlppl ipjbhin ipjbini ipjbscr ipjbtro ipjbwfm 
    iplylfr ipmodst iprspot ipshabt ipstrgv ipsuces ipudrst iscoco iscocop jbcoedu jbedyrs jblrn 
    jbprtfp jbrqlrn jbscr jbspv jbspvf jbspvm jbspvp jbtmppm jbtsktm jdgcbrb linwk3y livecnta lnghom1 
    lnghom2 lrscale lscjb3y lsintjb lvgptnea lwstrob mainact maritalb marstie marsts mbrncnta mbtru 
    mlohinc mloincat mmbprty mnactic mnactp mnrgtjb mnrsefw mocntr nacer2 name netuse nevdnjb njbspv 
    njbspvp npemp3y nwsppol nwsptot occf14b occm14b oprtad orgfd3y payprda pbldmn pdaprpa pdjbndm 
    pdjobev pdjobyr pdwrk pdwrkp pfmfdjba phwwkhs plcarcr plccbrb plccbrg plccont plcexdc plcfrdc 
    plciplt plcipvl plcjbcn plcpvcr plcrgwr plcrspc plcstf plcvcrc plcvcrp plnchld polintr pphincr 
    pplfair pplhlp ppltrst ppwwkp pray proddate prtclaie prtclano prtclase prtclbat prtclbbg prtclbcz 
    prtclbdk prtclbes prtclbfi prtclbil prtclbru prtclbsk prtclcbe prtclcch prtclcde prtclcee prtclcfr 
    prtclcgr prtclchu prtclcnl prtclcpt prtclcsi prtclcua prtclcy prtcldpl prtclgb prtclhr prtcllt 
    prtdgcl prtmbaie prtmbano prtmbase prtmbbat prtmbbbg prtmbbcz prtmbbdk prtmbbes prtmbbfi prtmbbil 
    prtmbbpt prtmbbru prtmbbsk prtmbcbe prtmbcch prtmbcde prtmbcee prtmbcfr prtmbcgr prtmbchu prtmbcnl 
    prtmbcsi prtmbcua prtmbcy prtmbdpl prtmbgb prtmbhr prtmblt prtvcde1 prtvcde2 prtvlt1 prtvlt2 
    prtvlt3 prtvtaat prtvtaie prtvtano prtvtase prtvtbbg prtvtbcz prtvtbdk prtvtbes prtvtbfi prtvtbfr 
    prtvtbil prtvtbpl prtvtbpt prtvtbru prtvtbsk prtvtbua prtvtcbe prtvtcch prtvtcee prtvtcgr prtvtchu 
    prtvtcsi prtvtcy prtvtdnl prtvtgb prtvthr prtyban ptnwkwe puemp3y pwkhsch rdpay3y rdpol rdtot 
    region regunit rgbrklw rlgatnd rlgblg rlgblge rlgdeaat rlgdeach rlgdeafi rlgdeagr rlgdeapl rlgdearu 
    rlgdease rlgdebe rlgdecy rlgdede rlgdedk rlgdegb rlgdehu rlgdeie rlgdeil rlgdelt rlgdenl rlgdeno 
    rlgdept rlgdesi rlgdesk rlgdeua rlgdgr rlgdnaat rlgdnach rlgdnafi rlgdnagr rlgdnapl rlgdnaru 
    rlgdnase rlgdnbe rlgdncy rlgdnde rlgdndk rlgdngb rlgdnhu rlgdnie rlgdnil rlgdnlt rlgdnm rlgdnme 
    rlgdnnl rlgdnno rlgdnpt rlgdnsi rlgdnsk rlgdnua rpljbde rshipa10 rshipa11 rshipa12 rshipa13 
    rshipa14 rshipa2 rshipa3 rshipa4 rshipa5 rshipa6 rshipa7 rshipa8 rshipa9 rshpsts rsnlvem rtrd rtrdp 
    rtryr sclact sclmeet scnsenv scrsefw sgnptit smblvjb spltadmd stcbg2t stfdem stfeco stfedu stfgov 
    stfhlth stfjbot stflife stfmjob supqad1 supqad2 supqdd supqmm supqyr tmprs tporgwk trdawrk trfoct 
    trfowr troff5y trstep trstlgl trstplc trstplt trstprl trstprt trstun truinwk tvpol tvtot uemp12m 
    uemp3m uemp3y uemp5yr uempla uemplap uempli uemplip useknwl vote vrtywrk wevdct wgdpeft widprsn 
    wkdcorga wkdcpce wkengtp wkhct wkhsch wkhtot wkhtotp wkjbndm wkovrtm wkovtmp wkshr3y wmcpwrk wntrtr 
    wpmwkcp wraccrc wraccrp wrkac6m wrkctra wrkengt wrkhrd wrkorg wrkprty wrkwe wrywprb yrcremp yrskdwk 
    yrspdwka=d0 d1 d2 d3 d4 d5 d6 d7 d8 d9 d10 d11 d12 d13 d14 d15 d16 d17 d18 d19 d20 d21 d22 d23 d24 
    d25 d26 d27 d28 d29 d30 d31 d32 d33 d34 d35 d36 d37 d38 d39 d40 d41 d42 d43 d44 d45 d46 d47 d48 d49 
    d50 d51 d52 d53 d54 d55 d56 d57 d58 d59 d60 d61 d62 d63 d64 d65 d66 d67 d68 d69 d70 d71 d72 d73 d74 
    d75 d76 d77 d78 d79 d80 d81 d82 d83 d84 d85 d86 d87 d88 d89 d90 d91 d92 d93 d94 d95 d96 d97 d98 d99 
    d100 d101 d102 d103 d104 d105 d106 d107 d108 d109 d110 d111 d112 d113 d114 d115 d116 d117 d118 d119 
    d120 d121 d122 d123 d124 d125 d126 d127 d128 d129 d130 d131 d132 d133 d134 d135 d136 d137 d138 d139 
    d140 d141 d142 d143 d144 d145 d146 d147 d148 d149 d150 d151 d152 d153 d154 d155 d156 d157 d158 d159 
    d160 d161 d162 d163 d164 d165 d166 d167 d168 d169 d170 d171 d172 d173 d174 d175 d176 d177 d178 d179 
    d180 d181 d182 d183 d184 d185 d186 d187 d188 d189 d190 d191 d192 d193 d194 d195 d196 d197 d198 d199 
    d200 d201 d202 d203 d204 d205 d206 d207 d208 d209 d210 d211 d212 d213 d214 d215 d216 d217 d218 d219 
    d220 d221 d222 d223 d224 d225 d226 d227 d228 d229 d230 d231 d232 d233 d234 d235 d236 d237 d238 d239 
    d240 d241 d242 d243 d244 d245 d246 d247 d248 d249 d250 d251 d252 d253 d254 d255 d256 d257 d258 d259 
    d260 d261 d262 d263 d264 d265 d266 d267 d268 d269 d270 d271 d272 d273 d274 d275 d276 d277 d278 d279 
    d280 d281 d282 d283 d284 d285 d286 d287 d288 d289 d290 d291 d292 d293 d294 d295 d296 d297 d298 d299 
    d300 d301 d302 d303 d304 d305 d306 d307 d308 d309 d310 d311 d312 d313 d314 d315 d316 d317 d318 d319 
    d320 d321 d322 d323 d324 d325 d326 d327 d328 d329 d330 d331 d332 d333 d334 d335 d336 d337 d338 d339 
    d340 d341 d342 d343 d344 d345 d346 d347 d348 d349 d350 d351 d352 d353 d354 d355 d356 d357 d358 d359 
    d360 d361 d362 d363 d364 d365 d366 d367 d368 d369 d370 d371 d372 d373 d374 d375 d376 d377 d378 d379 
    d380 d381 d382 d383 d384 d385 d386 d387 d388 d389 d390 d391 d392 d393 d394 d395 d396 d397 d398 d399 
    d400 d401 d402 d403 d404 d405 d406 d407 d408 d409 d410 d411 d412 d413 d414 d415 d416 d417 d418 d419 
    d420 d421 d422 d423 d424 d425 d426 d427 d428 d429 d430 d431 d432 d433 d434 d435 d436 d437 d438 d439 
    d440 d441 d442 d443 d444 d445 d446 d447 d448 d449 d450 d451 d452 d453 d454 d455 d456 d457 d458 d459 
    d460 d461 d462 d463 d464 d465 d466 d467 d468 d469 d470 d471 d472 d473 d474 d475 d476 d477 d478 d479 
    d480 d481 d482 d483 d484 d485 d486 d487 d488 d489 d490 d491 d492 d493 d494 d495 d496 d497 d498 d499 
    d500 d501 d502 d503 d504 d505 d506 d507 d508 d509 d510 d511 d512 d513 d514 d515 d516 d517 d518 d519 
    d520 d521 d522 d523 d524 d525 d526 d527 d528 d529 d530 d531 d532 d533 d534 d535 d536 d537 d538 d539 
    d540 d541 d542 d543 d544 d545 d546 d547 d548 d549 d550 d551 d552 d553 d554 d555 d556 d557 d558 d559 
    d560 d561 d562 d563 d564 d565 d566 d567 d568 d569 d570 d571 d572 d573 d574 d575 d576 d577 d578 d579 
    d580 d581 d582 d583 d584 d585 d586 d587 d588 d589 d590 d591 d592 d593 d594 d595 d596 d597 d598 d599 
    d600 d601 d602 d603 d604 d605 d606 d607 d608 d609 d610 d611 d612 d613 d614 d615 d616 d617 d618 d619 
    d620 d621 d622 d623 d624 d625 d626 d627 d628 d629 d630 d631 d632 d633 d634 d635 d636 d637 d638 d639 
    d640 d641 d642 d643 d644 d645 d646) icpart3=partner
  /DROP=d0 d1 d2 d3 d4 d5 d6 d7 d8 d9 d10 d11 d12 d13 d14 d15 d16 d17 d18 d19 d20 d21 d22 d23 d24 
    d25 d26 d27 d28 d29 d30 d31 d32 d33 d34 d35 d36 d37 d38 d39 d40 d41 d42 d43 d44 d45 d46 d47 d48 d49 
    d50 d51 d52 d53 d54 d55 d56 d57 d58 d59 d60 d61 d62 d63 d64 d65 d66 d67 d68 d69 d70 d71 d72 d73 d74 
    d75 d76 d77 d78 d79 d80 d81 d82 d83 d84 d85 d86 d87 d88 d89 d90 d91 d92 d93 d94 d95 d96 d97 d98 d99 
    d100 d101 d102 d103 d104 d105 d106 d107 d108 d109 d110 d111 d112 d113 d114 d115 d116 d117 d118 d119 
    d120 d121 d122 d123 d124 d125 d126 d127 d128 d129 d130 d131 d132 d133 d134 d135 d136 d137 d138 d139 
    d140 d141 d142 d143 d144 d145 d146 d147 d148 d149 d150 d151 d152 d153 d154 d155 d156 d157 d158 d159 
    d160 d161 d162 d163 d164 d165 d166 d167 d168 d169 d170 d171 d172 d173 d174 d175 d176 d177 d178 d179 
    d180 d181 d182 d183 d184 d185 d186 d187 d188 d189 d190 d191 d192 d193 d194 d195 d196 d197 d198 d199 
    d200 d201 d202 d203 d204 d205 d206 d207 d208 d209 d210 d211 d212 d213 d214 d215 d216 d217 d218 d219 
    d220 d221 d222 d223 d224 d225 d226 d227 d228 d229 d230 d231 d232 d233 d234 d235 d236 d237 d238 d239 
    d240 d241 d242 d243 d244 d245 d246 d247 d248 d249 d250 d251 d252 d253 d254 d255 d256 d257 d258 d259 
    d260 d261 d262 d263 d264 d265 d266 d267 d268 d269 d270 d271 d272 d273 d274 d275 d276 d277 d278 d279 
    d280 d281 d282 d283 d284 d285 d286 d287 d288 d289 d290 d291 d292 d293 d294 d295 d296 d297 d298 d299 
    d300 d301 d302 d303 d304 d305 d306 d307 d308 d309 d310 d311 d312 d313 d314 d315 d316 d317 d318 d319 
    d320 d321 d322 d323 d324 d325 d326 d327 d328 d329 d330 d331 d332 d333 d334 d335 d336 d337 d338 d339 
    d340 d341 d342 d343 d344 d345 d346 d347 d348 d349 d350 d351 d352 d353 d354 d355 d356 d357 d358 d359 
    d360 d361 d362 d363 d364 d365 d366 d367 d368 d369 d370 d371 d372 d373 d374 d375 d376 d377 d378 d379 
    d380 d381 d382 d383 d384 d385 d386 d387 d388 d389 d390 d391 d392 d393 d394 d395 d396 d397 d398 d399 
    d400 d401 d402 d403 d404 d405 d406 d407 d408 d409 d410 d411 d412 d413 d414 d415 d416 d417 d418 d419 
    d420 d421 d422 d423 d424 d425 d426 d427 d428 d429 d430 d431 d432 d433 d434 d435 d436 d437 d438 d439 
    d440 d441 d442 d443 d444 d445 d446 d447 d448 d449 d450 d451 d452 d453 d454 d455 d456 d457 d458 d459 
    d460 d461 d462 d463 d464 d465 d466 d467 d468 d469 d470 d471 d472 d473 d474 d475 d476 d477 d478 d479 
    d480 d481 d482 d483 d484 d485 d486 d487 d488 d489 d490 d491 d492 d493 d494 d495 d496 d497 d498 d499 
    d500 d501 d502 d503 d504 d505 d506 d507 d508 d509 d510 d511 d512 d513 d514 d515 d516 d517 d518 d519 
    d520 d521 d522 d523 d524 d525 d526 d527 d528 d529 d530 d531 d532 d533 d534 d535 d536 d537 d538 d539 
    d540 d541 d542 d543 d544 d545 d546 d547 d548 d549 d550 d551 d552 d553 d554 d555 d556 d557 d558 d559 
    d560 d561 d562 d563 d564 d565 d566 d567 d568 d569 d570 d571 d572 d573 d574 d575 d576 d577 d578 d579 
    d580 d581 d582 d583 d584 d585 d586 d587 d588 d589 d590 d591 d592 d593 d594 d595 d596 d597 d598 d599 
    d600 d601 d602 d603 d604 d605 d606 d607 d608 d609 d610 d611 d612 d613 d614 d615 d616 d617 d618 d619 
    d620 d621 d622 d623 d624 d625 d626 d627 d628 d629 d630 d631 d632 d633 d634 d635 d636 d637 d638 d639 
    d640 d641 d642 d643 d644 d645 d646.
EXECUTE.

* Note: set up the path of the new file ESS1-8_merge.sav

SAVE OUTFILE='/path_here/ESS1-8_merge.sav'
  /COMPRESSED.
EXECUTE.

