****This file computes the estimates in the tables and produces disclosure statistics
cap log using logs/03_estimators.txt, text replace
local f_year=2008
local l_year=2012
local cluster vce(cluster cmid)
set matsize 10000
local gmm yes
local export_results yes
local disclosure_tabs yes

*get matrix of administrative total recipients by county for GMM estimator
use cty year tot_rec_all_ad using data/est_all.dta, clear
sort cty year
bys cty: gen ad_rec=tot_rec_all_ad[_n-1]
gen ad_rec_acs=(ad_rec+tot_rec_all_ad)/2
drop if year<`f_year' | year>`l_year'
sort cty year
mkmat ad_rec_acs, matrix(totrecmat)

*pool data from all years
clear
gen year=.
foreach year of numlist `f_year'/`l_year' {
	append using data/acs_analysis`year'.dta, keep(cmid pnum pik cty piked adjpwgt F_ad_rec elderly female agecat* race* hisp female)
	replace year=`year' if year==.
	mat def years=(nullmat(years)\(`year'))
}

gen F_ad_rec_female=(F_ad_rec==1 & female==1)
gen F_ad_rec_eld=(F_ad_rec==1 & elderly==1)
gen F_ad_rec_all=F_ad_rec

	foreach pop in all female eld {
		***1. estimation using county and time fixed effects
		reg F_ad_rec_`pop' i.cty i.year [pw=adjpwgt], `cluster'
		est store fe_`pop'
	
		preserve
		duplicates drop cty year, force
		predict f_rec
		predict se_f_rec, stdp
		*multiply estimate and SE by county population to get total recipients
		merge 1:1 cty year using data/est_all.dta, keepusing(tot_pop_all) keep(1 3)
		gen tot_rec_`pop'_fe=f_rec*tot_pop_all
		label var tot_rec_`pop'_fe "Fixed Effects, `pop'"
		gen se_tot_rec_`pop'_fe=se_f_rec*tot_pop_all
		label var se_tot_rec_`pop'_fe "SE Fixed Effects, `pop'"
		keep cty year tot_rec_`pop'_fe se_tot_rec_`pop'_fe
		sort year cty
		capture noisily merge 1:1 year cty using data/est_`pop'.dta, update
		capture drop _merge
		save data/est_`pop'.dta, replace
		export excel cty year tot_rec_`pop'_fe se_tot_rec_`pop'_fe using results/small_area.xlsx, sh("fe_est_`pop'") sheetreplace firstrow(var) nol
		restore
	}
	*export coefficients
	outreg2 [fe*] using "results/parameters_fe.xlsx", excel replace se title(Parameters of FE Estimator) bdec(4) sdec(4)


***2. GMM estimator
if "`gmm'"=="yes" {
	drop agecat* race* hisp
	gen fvar=1
	ren elderly eld
	local nyears=`l_year'-`f_year'+1
	qui: tab cty if pik!=., matrow(ctynames)
	local ncty=`r(r)'
	egen cty_seq=group(cty)
	local over year
	local fvar fvar
	local xsvy F_ad_rec
	local wgt adjpwgt

	egen year_seq=group(`over')
	local over year_seq
	**usually need to create sequence for fvar here as well
	sum `over' if pik!=., meanonly
	local nparam=3*`r(max)'
	sum `fvar' if pik!=., meanonly
	local nparam=`nparam'+`r(max)'

	***run loop over female, eld and export
	foreach ysvy in female eld {
		cap mat drop year
		cap mat drop county
		cap mat tot_rec_`ysvy'_gmm
		cap mat se_tot_rec_`ysvy'_gmm
		*loop over counties
		foreach c of numlist 1/`ncty' {
			di `c'
			preserve
			keep if cty_seq==`c' & pik!=.
			*get starting values (the starting values are the point estimates of the estimator, so the gmm part only needs to be run to get SEs
			qui total `ysvy' if `xsvy'==1 & `ysvy'==1 & pik!=. & cty_seq==`c' [pw=`wgt'], over(`over')
			mat def ytot=e(b)
			qui total `xsvy' if pik!=. & cty_seq==`c' [pw=`wgt'], over(`over')	
			mat def xtot=e(b)
			qui total `wgt' if `xsvy'==1 & pik!=. & `ysvy'==1 & cty_seq==`c', over(`fvar')
			mat def frac=e(b)
			qui total `wgt' if `xsvy'==1 & pik!=. & cty_seq==`c', over(`fvar')
			mata: st_matrix("frac",st_matrix("frac"):/st_matrix("e(b)"))
			mata: st_matrix("ytotc",st_matrix("ytot")+J(1,`nyears',st_matrix("frac")):*(st_matrix("totrecmat")[(`c'-1)*`nyears'+1..`c'*`nyears',1]'-st_matrix("xtot")))
			mat def init=(ytotc,ytot,xtot,frac)
			mat def xtotmat=totrecmat[(`c'-1)*`nyears'+1..`c'*`nyears',1]
			mat list xtotmat
			mat list init
			*run gmm estimator for the county
			gmm small_areagmm if pik!=. & cty_seq==`c', nequations(`nparam') nparameters(`nparam') onestep winitial(identity) nocommonesample from(init) xsvy(`xsvy') ysvy(`ysvy') xtotmat(xtotmat) over(`over') fvar(`fvar') weight(`wgt') conv_maxiter(3) hasderivatives
			est store gmm_`ysvy'
			mat def objf=e(Q)
			if objf[1,1]>0.00001 n: di "Warning, gmm may not have converged for county `c'"
			mat def tmp=e(b)'
			mat def tot_rec_`ysvy'_gmm=(nullmat(tot_rec_`ysvy'_gmm)\tmp[1..`nyears',1])
			mata: st_matrix("tmp", sqrt(diagonal(st_matrix("e(V)"))[1..`nyears',1]))
			mat def se_tot_rec_`ysvy'_gmm=(nullmat(se_tot_rec_`ysvy'_gmm)\tmp)
			mat def year=(nullmat(year)\years)
			mat def county=(nullmat(county)\J(`nyears',1,ctynames[`c',1]))
			restore
		}
		*export GMM results
		preserve
		drop _all
		svmat tot_rec_`ysvy'_gmm
		ren tot_rec_`ysvy'_gmm1 tot_rec_`ysvy'_gmm
		svmat se_tot_rec_`ysvy'_gmm
		ren se_tot_rec_`ysvy'_gmm1 se_tot_rec_`ysvy'_gmm
		svmat year
		ren year1 year
		svmat county
		ren county1 cty
		label var tot_rec_`ysvy'_gmm "GMM by County, `ysvy'"
		label var se_tot_rec_`ysvy'_gmm "SE GMM by County, `ysvy'"
		keep cty year tot_rec_`ysvy'_gmm se_tot_rec_`ysvy'_gmm
		sort year cty
		export excel cty year tot_rec_`ysvy'_gmm se_tot_rec_`ysvy'_gmm using results/small_area.xlsx, sh("gmm_`ysvy'") sheetreplace firstrow(varl) nol
		capture noisily merge 1:1 year cty using data/est_`ysvy'.dta, update
		capture drop _merge
		sort year cty
		capture noisily order year cty county_name tot_pop tot_rec_`ysvy'_ad
		save data/est_`ysvy'.dta, replace
		restore
	}
	*export full GMM results
*	outreg2 [gmm_*] using "results/parameters_gmm.xlsx", excel replace se title(Parameters of GMM Estimator) bdec(4) sdec(4)
}

*disclosure tabulations
if "`disclosure_tabs'"=="yes" {
	gen all=1
	gen notpiked=(piked==0)
	foreach samp in all piked notpiked {
		foreach pop in all female eld {
			foreach year of numlist `f_year'/`l_year' {
				tab cty if `samp'==1 & `pop'==1 & year==`year', matcell(tmp)
				mat def `samp'_`pop'=(nullmat(`samp'_`pop')\tmp)
			}
			mat def cells_`samp'=(nullmat(cells_`samp'),`samp'_`pop')
		}
		matrix colnames cells_`samp'=all female elderly
		preserve
		drop _all
		svmat year
		ren year1 year
		svmat county
		ren county1 cty
		sort year cty
		svmat cells_`samp', names(col)
		export excel year cty all female elderly using results/disclosure_tabs.xlsx, sh(`samp') sheetreplace firstrow(var) nol
		restore
	}
}

*export tables
if "`export_results'"=="yes" {
	foreach pop in all female eld {
		use data/est_`pop'.dta, clear
		sort cty year
		bys cty: gen tot_rec_`pop'_adacs=tot_rec_`pop'_ad[_n-1]
		replace tot_rec_`pop'_adacs=(tot_rec_`pop'_adacs+tot_rec_`pop'_ad)/2
		label var tot_rec_`pop'_adacs "Admin ACS Period, `pop'"
		order year cty county_name tot_pop_`pop' tot_rec_`pop'_ad tot_rec_`pop'_adacs tot_rec_`pop'_ld se_tot_rec_`pop'_ld tot_rec_`pop'_svy se_tot_rec_`pop'_svy tot_rec_`pop'_fe se_tot_rec_`pop'_fe tot_rec_`pop'_year se_tot_rec_`pop'_year tot_rec_`pop'_cty se_tot_rec_`pop'_cty 
		sort year cty
		export excel year cty county_name tot_pop_`pop' tot_rec_`pop'* using results/small_area_tables.xlsx, sh(`pop') sheetreplace firstrow(varl) nol
		export excel year cty county_name se_tot_rec_`pop'* using results/small_area_tables.xlsx, sh(se_`pop') sheetreplace firstrow(varl) nol
	}
}
cap log close
