****This file prepares the linked data and computes the simple survey estimates. Unfortunately, the data are confidential and can only be accessed by writing a proposal to the U.S. Census Bureau.
local create_data no
local cluster vce(cluster cmid)
local hh_level no
local f_year=2008
local l_year=2012
cap log using logs/02_linked_data.txt, text replace

*create table with reported and recorded numbers and SEs
foreach year of numlist `f_year'/`l_year' {
	if "`create_data'"=="yes" {
		*get full NY ACS sample
		use cmid pnum pik st pwgt cty fsp age sex totrace hsgp groupq dby if st==36 using ../data/merged_pfile_us`year', clear
		*get HH level variables (reported fs receipt, hh weight)
		merge m:1 cmid using ../data/merged_hfile_us`year'.dta, keepusing(cmid fs wgt) keep(1 3)
		*construct HH level variables for people in group quarters
		replace fs=fsp if fsp!=.
		recode fs (2=0)
		replace wgt=pwgt if groupq==1
		drop _merge fsp st groupq
		*get IPW weights
		merge 1:1 cmid pnum using ../data/ipw_weights_indiv`year'.dta, keepusing(cmid pnum piked adjpwgt_gq_ny) keep(1 3)
		ren adjpwgt_gq_ny adjpwgt
		replace adjpwgt=. if piked==0
		drop _merge
		merge m:1 cmid using ../data/ipw_weights_hh`year'.dta, keepusing(cmid pnum adjwgt_gq_ny) keep(1 3)
		ren adjwgt_gq_ny adjwgt
		replace adjwgt=. if piked==0
		drop _merge

		*merge with admin data and create yearly receipt dummies
		merge 1:1 cmid pnum using ../data/admin_edited`year', keepusing(cmid pnum F_ad_rec) keep(1 3)
		*replace missing values for non-recipients
		replace F_ad_rec=0 if _merge==1
		drop _merge
		*code receipt up to household level
		*number of recipients in HH to derive HH level weights
		bys cmid: egen nrec=total(F_ad_rec)
		bys cmid: gen unique_hh=(_n==1)
		bys cmid: egen F_ad_rec_hh=max(F_ad_rec)
		gen hhwgt=wgt*nrec
		replace hhwgt=. if unique_hh!=1
		gen hhadjwgt=adjwgt*nrec
		replace hhadjwgt=. if unique_hh!=1

		*pool Hamilton and Herkimer County
		recode cty (41=43)

		***generate required variables
		**variables for totals
		gen byte elderly=`year'-dby>60
		gen byte female=(sex==2)
		gen byte male=(sex==1)

		*save extract
		compress
		save data/acs_analysis`year'.dta, replace
	}
	else use data/acs_analysis`year'.dta, clear

	**analysis of county totals accoding to survey (reported and admin)
	*total population (once only)
	total pwgt, over(cty)
	mat def tot_pop_all=(nullmat(tot_pop_all)\e(b)')
	total pwgt if female==1, over(cty)
	mat def tot_pop_female=(nullmat(tot_pop_female)\e(b)')
	total pwgt if elderly==1, over(cty)
	mat def tot_pop_eld=(nullmat(tot_pop_eld)\e(b)')

	*recipients
	if "`hh_level'"=="yes" {
		replace F_ad_rec F_ad_rec_hh
		local svywgt hhwgt
		local adwgt hhadjwgt
	}
	else {
		local svywgt pwgt
		local adwgt adjpwgt
	}

	local wgt `svywgt'
	foreach var in fs F_ad_rec {
		gen `var'_eld=(`var'==1 & elderly==1)
		gen `var'_fem=(`var'==1 & female==1)
		*total recipients
		total `var' [pw=`wgt'], over(cty) `cluster'
		mat def tot_rec_all_`var'=(nullmat(tot_rec_all_`var')\e(b)')
		mata: st_matrix("se", sqrt(diagonal(st_matrix("e(V)"))))
		mat def se_tot_rec_all_`var'=(nullmat(se_tot_rec_all_`var')\se)
		*total female recipients
		total `var'_fem [pw=`wgt'], over(cty) `cluster'
		mat def tot_rec_female_`var'=(nullmat(tot_rec_female_`var')\e(b)')
		mata: st_matrix("se", sqrt(diagonal(st_matrix("e(V)"))))
		mat def se_tot_rec_female_`var'=(nullmat(se_tot_rec_female_`var')\se) 
		*total elderly recipients
		total `var'_eld [pw=`wgt'], over(cty) `cluster'
		mat def tot_rec_eld_`var'=(nullmat(tot_rec_eld_`var')\e(b)')
		mata: st_matrix("se", sqrt(diagonal(st_matrix("e(V)"))))
		mat def se_tot_rec_eld_`var'=(nullmat(se_tot_rec_eld_`var')\se)
		local wgt `adwgt'
	}
}

qui: tab cty, matrow(countyid)	
drop _all
*county names and ids
label define cty 1 "Albany" 3 "Allegany" 5 "Bronx" 7 "Broome" 9 "Cataraugus" 11 "Cayuga" 13 "Chautauqa" 15 "Chemung" 17 "Chenango" 19 "Clinton" 21 "Columbia" 23 "Cortland" 25 "Delaware" 27 "Dutchess" 29 "Erie" 31 "Essex" 33 "Franklin" 35 "Fulton" 37 "Genesee" 39 "Greene" 43 "Herkimer and Hamilton" 45 "Jefferson" 47 "Kings" 49 "Lewis" 51 "Livingston" 53 "Madison" 55 "Monroe" 57 "Montgomery" 59 "Nassau" 61 "NewYork" 63 "Niagara" 65 "Oneida" 67 "Onondaga" 69 "Ontario" 71 "Orange" 73 "Orleans" 75 "Oswego" 77 "Otsego" 79 "Putnam" 81 "Queens" 83 "Rensselaer" 85 "Richmond" 87 "Rockland" 89 "StLawrence" 91 "Saratoga" 93 "Schenectady" 95 "Schoharie" 97 "Schuyler" 99 "Seneca" 101 "Steuben" 103 "Suffolk" 105 "Sullivan" 107 "Tioga" 109 "Tompkins" 111 "Ulster" 113 "Warren" 115 "Washington" 117 "Wayne" 119 "Westchester" 121 "Wyoming" 123 "Yates", replace

*generate year and cty variable
capture mat drop repcountyid
capture mat drop years
foreach year of numlist `f_year'/`l_year' {
	mat def repcountyid=(nullmat(repcountyid)\countyid)
	mat def years=(nullmat(years)\J(rowsof(countyid),1,`year'))
}

svmat int repcountyid
label val repcountyid1 cty
ren repcountyid1 cty
decode cty, generate(county_name)
svmat int years
ren years1 year
sort year cty
numlist "`f_year'/`l_year'"
local yr_list="`r(numlist)'"
foreach pop in all female eld {
	preserve
	svmat tot_pop_`pop'
	ren tot_pop_`pop'1 tot_pop_`pop'
	label var tot_pop_`pop' "Total Population, `pop'"
	svmat tot_rec_`pop'_fs, names(tot_rec_`pop'_svy)
	ren tot_rec_`pop'_svy1 tot_rec_`pop'_svy
	label var tot_rec_`pop'_svy "ACS Reports, `pop'"
	svmat se_tot_rec_`pop'_fs, names(se_tot_rec_`pop'_svy)
	ren se_tot_rec_`pop'_svy1 se_tot_rec_`pop'_svy
	label var se_tot_rec_`pop'_svy "SE ACS Reports, `pop'"
	svmat tot_rec_`pop'_F_ad_rec, names(tot_rec_`pop'_ld)
	ren tot_rec_`pop'_ld1 tot_rec_`pop'_ld
	label var tot_rec_`pop'_ld "Linked Data, `pop'"
	svmat se_tot_rec_`pop'_F_ad_rec, names(se_tot_rec_`pop'_ld)
	ren se_tot_rec_`pop'_ld1 se_tot_rec_`pop'_ld
	label var se_tot_rec_`pop'_ld "SE Linked Data, `pop'"
	export excel year cty county_name tot_pop_`pop' *tot_rec_`pop'_* using results/small_area.xlsx, sh("`pop'_svyld") sheetreplace firstrow(var) nol
	capture noisily merge 1:1 year cty using data/est_`pop'.dta, update
	capture drop _merge
	save data/est_`pop'.dta, replace
	restore
}
clear all
cap log close
