clear all
set more off

cd "C:\_Work\Studies\Halton sequence\Data"

* make graph
set obs 490
mata
	_rnd = halton(490,2,1)
end
getmata (_rnd*)=_rnd

set seed 123
gen rnd1=uniform()
gen rnd2=uniform()

scatter _rnd1 _rnd2,msize(small) title("Halton Sequence") xtitle("") ytitle("") name(halton) aspectratio(1) scheme(s1mono) ms(Oh)
scatter rnd1 rnd2,msize(small) title("Random Number") xtitle("") ytitle("") name(random) aspectratio(1) scheme(s1mono) ms(Oh)

graph combine halton random
graph export figure2.pdf, replace


* analysis

use Halton1,clear


local randVar candgender_rnd candname1 canedu_rnd canexp_rnd canrel_rnd
local randBlaise candgender_blaise candname_blaise canedu_blaise canexp_blaise canrel_blaise


* 1 variable tabulation

forvalue i=1(1)5 {
	local x1: word `i' of `randVar'
	local x2: word `i' of `randBlaise'

	disp "----------------------------------------------------------------"
	tab `x1'
	tab `x2'
}



* 2 variable tabulation

local title Gender Name Education Experience Religious_Advocacy

forvalue i =1(1)4 {
	local x1: word `i' of `randVar'
	local y1: word `i' of `randBlaise'
	
	local i1=`i'+1
	
	forvalue j=`i1'(1)5 {
		local x2: word `j' of `randVar'
		local y2: word `j' of `randBlaise'
		
		disp "----------------------------------------------------------------"
		tab `x1' `x2',chi cell nofreq
		tab `y1' `y2',chi cell nofreq
		
		* local xtitle: word `j' of `title' 
		* local ytitle: word `i' of `title' 
		* scatter rnd`i' rnd`j'  ,name(h`i'`j')  xtitle("`xtitle'") ytitle("`ytitle'") 
	}
}




* Check randomness: 1 Var 

local demoVar gender young highedu marital 

forvalue i=1(1)5 {
	local x: word `i' of `randVar'
	local y: word `i' of `randBlaise'

	foreach z of varlist `demoVar' {
		disp "----------------------------------------------------------------"
		disp "`x'   `y'   `z'"
		oneway `z' `x' //,tab 
		oneway `z' `y' //,tab
	}
}


* Check randomness: 2 Var 

forvalue i =1(1)4 {
	local x1: word `i' of `randVar'
	local y1: word `i' of `randBlaise'
	
	local i1=`i'+1
	
	forvalue j=`i1'(1)5 {
		local x2: word `j' of `randVar'
		local y2: word `j' of `randBlaise'
		
		capture drop hh bb
		egen hh=group(`x1' `x2')
		egen bb=group(`y1' `y2')
		
		foreach z of varlist `demoVar' {
			disp "----------------------------------------------------------------"
			disp "`x1'   `x2'   `z'"
			oneway `z' hh //,tab 
			oneway `z' bb //,tab
		}

	}
}



