capture log close
log using srm-zack-DCR, replace text
version 15.1
clear all
macro drop _all
set linesize 80
set scheme s1manual
local pgm srm-zack-DCR

//  Discrete Changes at Representative Values
//      : These analysis can take an hour or more to complete depending
//        on the speed of your computer

//  Replication script for:
//
//      Can Nonprobability Samples Be Used for Social Science Research?
//      Elizabeth S. Zack, John M. Kennedy, and J. Scott Long
//
//  For questions, contact: Elizabeth Zack elizabeth.sarah.zack@gmail.com

//  Analysis use SPost13 commands. From the Stata command line, run:
//  -search spost13- and and install the package/

//  srm-zack-DCR.do / Scott Long / 2019-06-26

//  ===============================================================
//  #1 dataset and specifications

local dsn srm-zack1
use `dsn', clear
keep if sampivnomiss==1

local lhsvars happy2 life2 helpful2 nextgen2 toofast2 advfront2 fechild2 ///
    sexeduc1 pillok2 abany1 helppoor2 helpnot2 getahead1 cappun1 courts1 ///
    wrkwayup2 kcore2 kradioact2 klasers2 kelectron2 kodds1 bible1

local rhsvarsfs c.age2##c.age2 i.female i.white c.polviews1 c.incmid ///
    i.educ2 i.partyid1 i.marital1 i.region3 i.relig3

local rhsvars ibn.dataset ibn.dataset#(`rhsvarsfs')

//  ===============================================================
//  #2 Compute representative values at GSS means

local xage2 = 35
local xpolviews1 = 4 // moderate
local xincmid = 42500

sum female if data==1
local xfem1 = r(mean)
local xfem0 = 1 - `xfem1'

sum white if data==1
local xwhi1 = r(mean)
local xwhi0 = 1 - `xwhi1'

local xpar = 1 // democrat

local xmar = 1 // married

sum region3 if data==1
local xreg1 = r(mean)
local xreg0 = 1 - `xreg1'

local xrel = 1 // protestant

local atspec ///
age2=`xage2' 1.female=`xfem1' 0.female=`xfem0' 1.white=`xwhi1' ///
0.white=`xwhi0' polviews1=`xpolviews1' incmid=`xincmid' partyid1=`xpar' ///
marital1=`xmar' 1.region3=`xreg1' 0.region3=`xreg0' relig3=`xrel'

di "at() specification: `atspec'" // verified 2019-06-24

//  ===============================================================
//  #3 compare DCRs of continuous vars

//  loop through outcomes and regressors to compute effects

foreach lhs in `lhsvars' { // loop through outcomes

    qui logit `lhs' `rhsvars' if M`lhs'==1, nocon nolog
    qui estimates store model

    mlincom, clear
    foreach rhs in age2 polviews1 incmid { // loop through regressors

        //  compute DCR and second differences

        qui {
        sum `rhs' if M`lhs'==1
        local sd = r(sd)
        local ST = `x`rhs'' // start value defined above
        local EN = `ST' + `sd'
        mtable, ///
            at(data=(1 2 3) `rhs'=`ST' `atspec') ///
            at(data=(1 2 3) `rhs'=`EN' `atspec') ///
            atmean post dec(7) commands
        mlincom (4-5), rowname(`lhs' DCR[`rhs'+sd]:GSS) ///
            stats(est pv se) add
        mlincom (6-7), rowname(`lhs' DCR[`rhs'+sd]:MT) ///
            stats(est pv se) add
        mlincom (8-9), rowname(`lhs' DCR[`rhs'+sd]:Qual) ///
            stats(est pv se) add
        mlincom (4-5)-(6-7), rowname(`lhs' DCR[`rhs'+sd]:GSS-MT) ///
            stats(est pv se) add
        mlincom (4-5)-(8-9), rowname(`lhs' DCR[`rhs'+sd]:GSS-Qual) ///
            stats(est pv se) add
        mlincom (5-2)-(6-7), rowname(`lhs' DCR[`rhs'+sd]:MT-Qual) ///
            stats(est pv se) add
        }

        qui est restore model
    }

    // summary of results

    mlincom, stats(est pv se) twidth(30) add dec(3)
    di

} // loop through outcomes

//  ===============================================================
//  #4 compare DCRs of indicator vars

foreach lhs in `lhsvars' {

    qui logit `lhs' `rhsvars' if M`lhs'==1, nocon nolog
    qui estimates store model

    mlincom, clear
    foreach rhs in female white educ2 {

        qui {
        mtable, dydx(`rhs') at(`atspec' data=(1 2 3)) atmean post
        mlincom   1, rowname(`lhs' DCR[`rhs']: GSS) stats(est pv se) add
        mlincom   2, rowname(`lhs' DCR[`rhs']: MTurk) stats(est pv se) add
        mlincom   3, rowname(`lhs' DCR[`rhs']: Qualt) stats(est pv se) add
        mlincom 1-2, rowname(`lhs' DCR[`rhs']: GSS-MT) stats(est pv se) add
        mlincom 1-3, rowname(`lhs' DCR[`rhs']: GSS-Qual) stats(est pv se) add
        mlincom 2-3, rowname(`lhs' DCR[`rhs']: MT-Qual)  stats(est pv se) add
        }

        qui est restore model
    } // rhsvars

    mlincom, stats(est pv se) twidth(30) add dec(3)
    di

} // outcomes

//  ===============================================================
//  #5 age restricted sample

sum age2
drop if age2<18
drop if age2>45
sum age2

local xage2 = 35
local xpolviews1 = 4 // moderate
local xincmid = 42500

sum female if data==1
local xfem1 = r(mean)
local xfem0 = 1 - `xfem1'

sum white if data==1
local xwhi1 = r(mean)
local xwhi0 = 1 - `xwhi1'

local xpar = 1 // democrat

local xmar = 1 // married

sum region3 if data==1

local xreg1 = r(mean)
local xreg0 = 1 - `xreg1'

local xrel = 1 // protestant

local atspec ///
age2=`xage2' 1.female=`xfem1' 0.female=`xfem0' 1.white=`xwhi1' ///
0.white=`xwhi0' polviews1=`xpolviews1' incmid=`xincmid' partyid1=`xpar' ///
marital1=`xmar' 1.region3=`xreg1' 0.region3=`xreg0' relig3=`xrel'

di "at() specification: `atspec'"

//  ===============================================================
//  #6 compare DCRs of continuous vars on age restricted sample

foreach lhs in `lhsvars' {

    qui logit `lhs' `rhsvars' if M`lhs'==1, nocon nolog
    qui estimates store model

    mlincom, clear
    foreach rhs in age2 polviews1 incmid {

        qui {
        sum `rhs' if M`lhs'==1
        local sd = r(sd)
        local ST = `x`rhs''
        local EN = `ST' + `sd'
        mtable, ///
            at(data=(1 2 3) `rhs'=`ST' `atspec') ///
            at(data=(1 2 3) `rhs'=`EN' `atspec') ///
            atmean post dec(7) commands
        mlincom (4-5), rowname(`lhs' DCR[`rhs'+sd]:GSS) ///
            stats(est pv se) add
        mlincom (6-7), rowname(`lhs' DCR[`rhs'+sd]:MT) ///
            stats(est pv se) add
        mlincom (8-9), rowname(`lhs' DCR[`rhs'+sd]:Qual) ///
            stats(est pv se) add
        mlincom (4-5)-(6-7), rowname(`lhs' DCR[`rhs'+sd]:GSS-MT) ///
            stats(est pv se) add
        mlincom (4-5)-(8-9), rowname(`lhs' DCR[`rhs'+sd]:GSS-Qual) ///
            stats(est pv se) add
        mlincom (5-2)-(6-7), rowname(`lhs' DCR[`rhs'+sd]:MT-Qual) ///
            stats(est pv se) add
        }

        qui est restore model
    }

    mlincom, stats(est pv se) twidth(30) add dec(3)
    di

} // outcomes

//  ===============================================================
//  #7 compare DCRs of indicator vars on age restricted sample

foreach lhs in `lhsvars' {

    qui logit `lhs' `rhsvars' if M`lhs'==1, nocon nolog
    qui estimates store model

    mlincom, clear
    foreach rhs in female white educ2 { // loop through regressors

        qui {
        mtable, dydx(`rhs') at(`atspec' data=(1 2 3)) atmean post
        mlincom   1, rowname(`lhs' DCR[`rhs']: GSS) stats(est pv se) add
        mlincom   2, rowname(`lhs' DCR[`rhs']: MTurk) stats(est pv se) add
        mlincom   3, rowname(`lhs' DCR[`rhs']: Qualt) stats(est pv se) add
        mlincom 1-2, rowname(`lhs' DCR[`rhs']: GSS-MT) stats(est pv se) add
        mlincom 1-3, rowname(`lhs' DCR[`rhs']: GSS-Qual) stats(est pv se) add
        mlincom 2-3, rowname(`lhs' DCR[`rhs']: MT-Qual)  stats(est pv se) add
        }

        qui est restore model
    } // rhsvars

    mlincom, stats(est pv se) twidth(30) add dec(3)
    di

} // outcomes

log close
exit

NOTES
