capture log close
log using srm-zack-ADC, replace text
version 15.1
clear all
macro drop _all
set linesize 80
set scheme s1manual
local pgm srm-zack-ADC

//  Average Discrete Changes
//      : These analysis can take an hour or more to complete depending
//        on the speed of your computer

//  Replication script for:
//
//      Can Nonprobability Samples Be Used for Social Science Research?
//      Elizabeth S. Zack, John M. Kennedy, and J. Scott Long
//
//  For questions, contact: Elizabeth Zack elizabeth.sarah.zack@gmail.com

//  Analysis use SPost13 commands. From the Stata command line, run:
//  -search spost13- and and install the package/

//  srm-zack-ADC.do / Scott Long / 2019-06-26

//  ===============================================================
//  #1 dataset and specifications

local dsn srm-zack1
use `dsn', clear
keep if sampivnomiss==1

local lhsvars happy2 life2 helpful2 nextgen2 toofast2 advfront2 fechild2 ///
    sexeduc1 pillok2 abany1 helppoor2 helpnot2 getahead1 cappun1 courts1 ///
    wrkwayup2 kcore2 kradioact2 klasers2 kelectron2 kodds1 bible1

local rhsvarsfs c.age2##c.age2 i.female i.white c.polviews1 c.incmid ///
    i.educ2 i.partyid1 i.marital1 i.region3 i.relig3

local rhsvars ibn.dataset ibn.dataset#(`rhsvarsfs')

//  ===============================================================
//  #2 compare ADCs of continuous vars

//  loop through outcomes and regressors to compute effects

foreach lhs in `lhsvars' { // loop through outcomes

    qui logit `lhs' `rhsvars' if M`lhs'==1, nocon nolog
    qui estimates store model

    mlincom, clear
    foreach rhs in age2 polviews1 incmid { // loop through regressors

        //  compute ADC and second differences

        qui {
        sum `rhs' if M`lhs'==1
        local sd = r(sd)
        mtable, ///
            at(`rhs'=gen(`rhs')) at(`rhs'=gen(`rhs'+`sd')) over(dataset) ///
            post brief dec(4)
        mlincom (4-1), rowname(`lhs' ADC[`rhs'+sd]:GSS) ///
            stats(est pv se) add
        mlincom (5-2), rowname(`lhs' ADC[`rhs'+sd]:MT) ///
            stats(est pv se) add
        mlincom (6-3), rowname(`lhs' ADC[`rhs'+sd]:Qual) ///
            stats(est pv se) add
        mlincom (4-1)-(5-2), rowname(`lhs' ADC[`rhs'+sd]:GSS-MT) ///
            stats(est pv se) add
        mlincom (4-1)-(6-3), rowname(`lhs' ADC[`rhs'+sd]:GSS-Qual) ///
            stats(est pv se) add
        mlincom (5-2)-(6-3), rowname(`lhs' ADC[`rhs'+sd]:MT-Qual) ///
            stats(est pv se) add
        }
        qui est restore model
    }

    // summary of results

    mlincom, stats(est pv se) twidth(30) add dec(3)

} // end loop through outcomes

//  ===============================================================
//  #3 compare ADCs of indicator vars

foreach lhs in `lhsvars' { // loop through outcomes

    qui logit `lhs' `rhsvars' if M`lhs'==1, nocon nolog
    qui estimates store model

    mlincom, clear
    foreach rhs in female white educ2 { // loop through regressors

        qui {
        mtable, dydx(`rhs') over(data) post brief dec(4)
        mlincom 1, rowname(`lhs' ADC[`rhs']: GSS) ///
            stats(est pv se) add
        mlincom 2, rowname(`lhs' ADC[`rhs']: MTurk) ///
            stats(est pv se) add
        mlincom 3, rowname(`lhs' ADC[`rhs']: Qualt) ///
            stats(est pv se) add
        mlincom 1-2, rowname(`lhs' ADC[`rhs']: GSS-MT) ///
            stats(est pv se) add
        mlincom 1-3, rowname(`lhs' ADC[`rhs']: GSS-Qual) ///
            stats(est pv se) add
        mlincom 2-3, rowname(`lhs' ADC[`rhs']: MT-Qual) ///
            stats(est pv se) add
        }

        qui est restore model
    }

    mlincom, stats(est pv se) twidth(30) add dec(3)

} // outcomes

//  ===============================================================
//  #4 compare ADCs of continuous vars - restriced age

//  restrict age of sample
sum age2
drop if age2<18
drop if age2>45
sum age2

foreach lhs in `lhsvars' {

    qui logit `lhs' `rhsvars' if M`lhs'==1, nocon nolog
    qui estimates store model

    mlincom, clear
    foreach rhs in age2 polviews1 incmid { // loop through regressors

        qui {
        sum `rhs' if M`lhs'==1
        local sd = r(sd)
        mtable, ///
            at(`rhs'=gen(`rhs')) at(`rhs'=gen(`rhs'+`sd')) over(dataset) ///
            post brief dec(4)
        mlincom (4-1), rowname(`lhs' ADC[`rhs'+sd:GSS) ///
            stats(est pv se) add
        mlincom (5-2), rowname(`lhs' ADC[`rhs'+sd:MT) ///
            stats(est pv se) add
        mlincom (6-3), rowname(`lhs' ADC[`rhs'+sd:QU) ///
            stats(est pv se) add
        mlincom (4-1)-(5-2), rowname(`lhs' ADC[`rhs'+sd]:GSS-MT) ///
            stats(est pv se) add
        mlincom (4-1)-(6-3), rowname(`lhs' ADC[`rhs'+sd]:GSS-Qual) ///
            stats(est pv se) add
        mlincom (5-2)-(6-3), rowname(`lhs' ADC[`rhs'+sd]:MT-Qual) ///
            stats(est pv se) add
        }

        qui est restore model
    }

    mlincom, stats(est pv se) twidth(30) add dec(3)

} // outcomes

//  ===============================================================
//  #5 compare ADCs of indicator vars - restricted age

foreach lhs in `lhsvars' {

    qui logit `lhs' `rhsvars' if M`lhs'==1, nocon nolog
    qui estimates store model

    mlincom, clear
    foreach rhs in female white educ2 { // loop through regressors

        qui {
        mtable, dydx(`rhs') over(data) post brief dec(4)
        mlincom 1, rowname(`lhs' ADC[`rhs']: GSS) ///
            stats(est pv se) add
        mlincom 2, rowname(`lhs' ADC[`rhs']: MTurk) ///
            stats(est pv se) add
        mlincom 3, rowname(`lhs' ADC[`rhs']: Qualt) ///
            stats(est pv se) add
        mlincom 1-2, rowname(`lhs' ADC[`rhs']: GSS-MT) ///
            stats(est pv se) add
        mlincom 1-3, rowname(`lhs' ADC[`rhs']: GSS-Qual) ///
            stats(est pv se) add
        mlincom 2-3, rowname(`lhs' ADC[`rhs']: MT-Qual) ///
            stats(est pv se) add
        }

        qui est restore model
    }

    mlincom, stats(est pv se) twidth(30) add dec(3)

} // outcomes

log close
exit

NOTES
