/*
Paper: 		Memory Gabs in the American Time Use Survey. Are Respondents Forgetful or is There More to it?
Authors: 	Antje Kirchner ab, Robert F Belli b, Ana Lucía Córdova-Cazar c, Caitlin E Deal d
			a RTI International, b University of Nebraska-Lincoln, c Universidad San Francisco de Quito, d AIR
Date: 		26 August 2018
File: 		Analyses
*/

capture log close

version 15.1
clear all
set more off

*Set path
	global pathdta "SET YOUR DIRECTORY\dta"
	global pathlog "SET YOUR DIRECTORY\log"
	global pathplot "SET YOUR DIRECTORY\plot"

	local today=string(date("`c(current_date)'","DMY"),"%tdCCYYNNDD")
		
log using "$pathlog/1_atus_analyses_`today'_logitATUS.smcl", replace 

***********************************************
*Read in data from 1_cleaning_20180826
use "$pathdta/ATUS_RespondentLevelData_`today'.dta", clear		

****************************************
*Set globals
		global dv  			d_tempmemgap	//paradata
		global dv2 			d_forget		//ATUS
				
		global whowhere 	whowhereavg
		
		global effort  		attempts everref i.famincref2 ATUSrespondentNOTCPS
		global controls    	female age i.edu race ethn i.empl i.faminc2 own marstat child_presrec i.metro completes_cent centiverCRpr tuactivity_n					
		
		global tab 			everref attempts female age edu race ethn empl faminc famincref own marstat child_presrec metro diaryday holiday tuactivity_n

****************************************
*Descriptives
	//dvs
		tab1 *memgap *forget , m		
		tab d_forget d_tempmemgap 
	
	//ivs
		tab1 who* where*, m	
		sum who* where*
		corr  who* where*
		hist whowhereavg, freq discrete scheme(s1mono)
		
		sum d_tempmemgap whowhereavg everref attempts famincref, d
		tab d_tempmemgap

	//effort & controls
		tab1 $tab who* where*
		sum intdur_cens completes attempts age  

		
****************************************	
//Final Analyses: 
	//1) Logistic mixed effects models d_memgap_any for null models (dichotomous)
		//Null Model: Enduring Memory gaps
			melogit $dv2 		|| intid:, or
			est store forget
			estat icc
		
		//Null Model: Temporary Memory Gaps
			melogit $dv 		|| intid:, or
			est store dany
			estat icc


	//2) Footnote 9: Combined Model with all available cases n=13,193
		gsem 	($dv2  <- $dv  whowhereavg $effort $controls 	M1[intid]@1, logit) ///
				($dv  <- 	   whowhereavg $effort $controls   M2[intid]@1, logit),  ///  
																latent(M1 M2) nocapslatent cov(M1[intid]*M2[intid]) 
				estat eform $dv2 $dv
				est store path_allwhowhereavg_all		

	****************************************		
	//subsample cases with (no temp and no enduring memgap) to address with rarity of event
		set seed 1001
		sample 10 if d_tempmemgap==0 & forget==0
		count
	

	//3) Logistic mixed effects path models
		//Null Model
			gsem 	($dv2 <- $dv 									M1[intid]@1, logit) ///
					($dv  <- 	  									M2[intid]@1, logit),  ///
																	latent(M1 M2) nocapslatent cov(M1[intid]*M2[intid])  
					estat eform $dv2 $dv
					est store path_null
		
		//Combined Model
			gsem 	($dv2  <- $dv  $whowhere $effort $controls 	M1[intid]@1, logit) ///
					($dv  <- 	   $whowhere $effort $controls   	M2[intid]@1, logit),  ///  
																	latent(M1 M2) nocapslatent cov(M1[intid]*M2[intid])  
					estat eform $dv2 $dv
					est store path_allwhowhereavg
				
		//Sensitvity analyses 
		
			//a) excluding whowhereavg
				gsem 	($dv2  <- $dv   			$effort $controls 	M1[intid]@1, logit) ///
						($dv  <- 	   				$effort $controls  M2[intid]@1, logit),  ///  
																		latent(M1 M2) nocapslatent cov(M1[intid]*M2[intid])  
						estat eform $dv2 $dv
						est store path_allwhowhereavgOUT
				
		esttab path* 	using "$pathplot/1_path_ATUS_v2_OR.rtf", ci(%9.2f) b(%9.2f) stats(N aic bic)  ///
						starlevels(+ 0.10 * 0.05 ** 0.01 *** .001) eform replace label nogaps  ///
						title({\b Table 4.} {\b Estimated Odds Ratios, Confidence Intervals, and Variance Components  ///
						for Hierarchical Models Predicting Memory Gap in Final and Any Response (gsem)}) nonumbers
			
			//b) rare events logistic regression (based on Firth 1993)
				logistic $dv  			$whowhere $effort $controls i.intid  
				firthlogit $dv  		$whowhere $effort $controls i.intid, or 
				est store firth2
				constraint define 1 $whowhere 
				firthlogit $dv  		$whowhere $effort $controls i.intid, constraint(1) or
				lrtest firth2 .
				
				logistic $dv2 $dv  		$whowhere $effort $controls tuactivity_n i.intid
				firthlogit $dv2 $dv  	$whowhere $effort $controls tuactivity_n i.intid, or
				est store firth
				constraint define 1 $whowhere 
				constraint define 2 $dv
				firthlogit $dv2 $dv		whowhereavg $effort $controls tuactivity_n i.intid, constraint(1 2) or
				lrtest firth .

log close
exit
