about
version 14.2
clear all
set type double

// Estimation methods
do isdl-programs.do

// Data
// questionnaire data
use kv14a_EN_1.0p.dta, clear
// background variables (May 2014)
merge 1:1 nomem_encr using avars_201405_EN_1.0p.dta, keep(match master)
drop if _merge==1
drop _merge
quietly compress
describe
// Experimental groups
fre kv14a001
rename kv14a001 group
// ISDL question on lifetime sexual partners
// - long list 1 (group A)
fre kv14a003, t(5)
assert kv14a003>=. if group!=1
generate sex1 = kv14a003 if kv14a003>=0 & kv14a003<.
// - short list 1 (group B)
fre kv14a009, t(5)
assert kv14a009>=. if group!=2
replace sex1 = kv14a009 if kv14a009>=0 & kv14a009<.
// - short list 1 (DQ)
fre kv14a011, t(5)
assert kv14a011>=. if group!=3
// - long list 2 (group B)
fre kv14a007, t(5)
assert kv14a007>=. if group!=2
generate sex2 = kv14a007 if kv14a007>=0 & kv14a007<.
// - short list 2 (group A)
fre kv14a005, t(5)
assert kv14a005>=. if group!=1
replace sex2 = kv14a005 if kv14a005>=0 & kv14a005<.
// - short list 2 (DQ)
fre kv14a010, t(5)
assert kv14a010>=. if group!=3
// - sensitive question (DQ)
fre kv14a012, t(5)
assert kv14a012>=. if group!=3
replace sex1 = kv14a012 if kv14a012>=0 & kv14a012<.
replace sex2 = kv14a012 if kv14a012>=0 & kv14a012<.
fre sex1 sex2, t(5)
// ISDL question on pornography consumption
// - long list 1 (group A)
fre kv14a002, t(5)
assert kv14a002>=. if group!=1
generate porn1 = kv14a002 if kv14a002>=0 & kv14a002<1000
// - short list 1 (group B)
fre kv14a008, t(5)
assert kv14a008>=. if group!=2
replace porn1 = kv14a008 if kv14a008>=0 & kv14a008<1000
// - short list 1 (DQ)
fre kv14a014, t(5)
assert kv14a014>=. if group!=3
// - long list 2 (group B)
fre kv14a006, t(5)
assert kv14a006>=. if group!=2
generate porn2 = kv14a006 if kv14a006>=0 & kv14a006<1000
// - short list 2 (group A)
fre kv14a004, t(5)
assert kv14a004>=. if group!=1
replace porn2 = kv14a004 if kv14a004>=0 & kv14a004<1000
// - short list 2 (DQ)
fre kv14a013, t(5)
assert kv14a013>=. if group!=3
// - sensitive question (DQ)
fre kv14a015, t(5)
assert kv14a015>=. if group!=3
replace porn1 = kv14a015 if kv14a015>=0 & kv14a015<1000
replace porn2 = kv14a015 if kv14a015>=0 & kv14a015<1000
fre porn1 porn2, t(5)
// Definition of predictors
fre kv14a016
gen byte relation = (kv14a016==1) if kv14a016<.
fre relation
fre kv14a019
gen byte pornwrong = inlist(kv14a019,4,5) if kv14a019<.
fre pornwrong
fre kv14a018, t(5)
rename kv14a018 pornpct
fre geslacht
gen byte female = (geslacht==2) if geslacht<.
fre female
fre leeftijd, t(5)
rename leeftijd age
fre oplcat
rename oplcat educ

// Results: Lifetime sexual partners (Table 2)
// - have a look at ouliers
fre sex1 sex2 if group==1, t(5) // sex1: S+restaurants, sex2: events
fre sex1 sex2 if group==2, t(5) // sex1: restaurants, sex2: S+events
fre sex1 sex2 if group==3, t(5) // S
fre kv14a011 kv14a010 if group==3, t(5) // kv14a014: restaurants, kv14a013: events
// - set outlier rules (observed maximum in SL or DQ, excluding obvious errors)
local smax  = 200 // number of different sexual partners
local c1max = 300 // number of restaurant visits last year
local c2max = 123 // number of cultural events last year
// - overall
isdl sex1 sex2 group, quietly smax(`smax') c1max(`c1max') c2max(`c2max') ml 
// - by sex
isdl sex1 sex2 group if female==0, quietly smax(`smax') c1max(`c1max') c2max(`c2max') ml
isdl sex1 sex2 group if female==1, quietly smax(`smax') c1max(`c1max') c2max(`c2max') ml
// - alternative estimates: mean
isdl sex1 sex2 group, quietly smax(`smax') c1max(`c1max') c2max(`c2max') mean
isdl sex1 sex2 group if female==0, quietly smax(`smax') c1max(`c1max') c2max(`c2max') mean
isdl sex1 sex2 group if female==1, quietly smax(`smax') c1max(`c1max') c2max(`c2max') mean
// - alternative estimates: suest (almost identical to mean)
isdl sex1 sex2 group, quietly smax(`smax') c1max(`c1max') c2max(`c2max') suest
// - alternative estimates: sureg (almost identical to ml)
isdl sex1 sex2 group, quietly smax(`smax') c1max(`c1max') c2max(`c2max') sureg vce(robust)
isdl sex1 sex2 group if female==0, quietly smax(`smax') c1max(`c1max') c2max(`c2max') sureg vce(robust)
isdl sex1 sex2 group if female==1, quietly smax(`smax') c1max(`c1max') c2max(`c2max') sureg vce(robust)

// Results: Pornography consumption (Table 3)
// - have a look at ouliers
fre porn1 porn2 if group==1, t(5) // porn1: S+holidays, porn2: workhours
fre porn1 porn2 if group==2, t(5) // porn1: holidays, porn2: S+workhours
fre porn1 porn2 if group==3, t(5) // S
fre kv14a014 kv14a013 if group==3, t(5) // kv14a014: holidays, kv14a013: workhours
// - outlier rules (observed maximum in SL or DQ, excluding obvious errors)
local smax  = 15   // days with pornography consumption (within last 14 days)
local c1max = 365  // length of last holiday trip
local c2max = 123  // number of hours worked last week
// - overall
isdl porn1 porn2 group, quietly smax(`smax') c1max(`c1max') c2max(`c2max') ml
// - by sex
isdl porn1 porn2 group if female==0, quietly smax(`smax') c1max(`c1max') c2max(`c2max') ml
isdl porn1 porn2 group if female==1, quietly smax(`smax') c1max(`c1max') c2max(`c2max') ml
// - alternative estimates: mean
isdl porn1 porn2 group, quietly smax(`smax') c1max(`c1max') c2max(`c2max') mean
isdl porn1 porn2 group if female==0, quietly smax(`smax') c1max(`c1max') c2max(`c2max') mean
isdl porn1 porn2 group if female==1, quietly smax(`smax') c1max(`c1max') c2max(`c2max') mean
// - alternative estimates: suest (almost identical to mean)
isdl porn1 porn2 group, quietly smax(`smax') c1max(`c1max') c2max(`c2max') suest
// - alternative estimates: sureg (almost identical to ml)
isdl porn1 porn2 group, quietly smax(`smax') c1max(`c1max') c2max(`c2max') sureg vce(robust)
isdl porn1 porn2 group if female==0, quietly smax(`smax') c1max(`c1max') c2max(`c2max') sureg vce(robust)
isdl porn1 porn2 group if female==1, quietly smax(`smax') c1max(`c1max') c2max(`c2max') sureg vce(robust)

// Results: Means and variances of items in direct questioning group (Table 4)
describe kv14a011 kv14a010
summarize sex1 kv14a011 kv14a010 if group==3 & sex1<=200
corr sex1 kv14a011 kv14a010 if group==3 & sex1<=200
describe kv14a014 kv14a013
summarize porn1 kv14a014 kv14a013 if group==3
corr porn1 kv14a014 kv14a013 if group==3

// Results: Proportion of zeros (Table 5)
local smax  = 200 // number of different sexual partners
local c1max = 300 // number of restaurant visits last year
local c2max = 123 // number of cultural events last year
generate byte sex1zero = (sex1==0) if group==1 & sex1<=(`smax'+`c1max')
replace       sex1zero = (sex1==0) if group==2 & sex1<=(`c1max')
generate byte sex2zero = (sex2==0) if group==1 & sex1<=(`c2max')
replace       sex2zero = (sex2==0) if group==2 & sex1<=(`smax'+`c2max')
mean sex1zero, over(group)
lincom _subpop_1-_subpop_2
mean sex2zero, over(group)
lincom _subpop_2-_subpop_1
local smax  = 15   // days with pornography consumption (within last 14 days)
local c1max = 365  // length of last holiday trip
local c2max = 123  // number of hours worked last week
generate byte porn1zero = (porn1==0) if group==1 & porn1<=(`smax'+`c1max')
replace       porn1zero = (porn1==0) if group==2 & porn1<=(`c1max')
generate byte porn2zero = (porn2==0) if group==1 & porn1<=(`c2max')
replace       porn2zero = (porn2==0) if group==2 & porn1<=(`smax'+`c2max')
mean porn1zero, over(group)
lincom _subpop_1-_subpop_2
mean porn2zero, over(group)
lincom _subpop_2-_subpop_1

// Results: Regression models (Table 6)
local smax  = 200 // number of different sexual partners
local c1max = 300 // number of restaurant visits last year
local c2max = 123 // number of cultural events last year
regress sex1 female age relation educ pornwrong pornpct ///
    if group==3 & sex1<=`smax'
est sto sex_DQ
isdlreg sex1 sex2 group female age relation educ pornwrong pornpct ///
    if inlist(group,1,2), smax(`smax') c1max(`c1max') c2max(`c2max')
est sto sex_ISDL
local smax  = 15   // days with pornography consumption (within last 14 days)
local c1max = 365  // length of last holiday trip
local c2max = 123  // number of hours worked last week
regress porn1 female age relation educ pornwrong pornpct ///
    if group==3 & porn1<=`smax'
est sto porn_DQ
isdlreg porn1 porn2 group female age relation educ pornwrong pornpct ///
    if inlist(group,1,2), smax(`smax') c1max(`c1max') c2max(`c2max')
est sto porn_ISDL
esttab sex_DQ sex_ISDL porn_DQ porn_ISDL, keep(main:) b(3) se ///
    star(+ 0.10 * 0.05 ** 0.01 *** 0.001) mti nonum
