**Syntaxt: Article SRM: Meitinger, Braun & Behr "SEQUENCE MATTERS IN ONLINE PROBING: THE 
*IMPACT OF THE ORDER OF PROBES ON RESPONSE QUALITY, MOTIVATION OF RESPONDENTS, AND ANSWER CONTENT"


**Table 4: Mismatching Probe Responses by Probe Type, Experimental Group, and Country 
** in Percent and Results for Two-sided Fisher’s Exact Test 

**Table A5: Mismatching Probe Responses for the Category-Selection Probe by Experimental
** Group and Country in Percent and detailed results for the two-sided Fisher’s exact Test
**Table A6: Mismatching Probe Responses for the Specific Probe by Experimental Group and 
** Country in Percent and detailed results for the two-sided Fisher’s exact Test
**Table A7: Mismatching Probe Responses for the Comprehension Probe by Experimental 
** Group and Country in Percent and detailed results for the two-sided Fisher’s exact Test

clear      
use MeitingeretalSRM.dta

************************************************************************************
**Percentage of Mismatches:
****************************************************************************
***Crd6_cop: Comprehension Probe
* Mismatch as CSP:
*By experimental condition - total:
bysort trigger: tab crd_6cop_6
*CSP probe first: By country
bysort country: tab crd_6cop_6 if trigger==1
*COP probe first: By country
bysort country: tab crd_6cop_6 if trigger==2

* Mismatch as SP:
*By experimental condition - total:
bysort trigger: tab crd_6cop_7
*CSP probe first: By country
bysort country: tab crd_6cop_7 if trigger==1
*COP probe first: By country
bysort country: tab crd_6cop_7 if trigger==2

****************************************************************************
***Crd6_sp: Specific Probe
* Mismatch as CSP:
*By experimental condition - total:
bysort trigger: tab crd6_sp_6
*CSP probe first: By country
bysort country: tab crd6_sp_6 if trigger==1
*COP probe first: By country
bysort country: tab crd6_sp_6 if trigger==2

* Mismatch as COP:
*By experimental condition - total:
bysort trigger: tab crd6_sp_8
*CSP probe first: By country
bysort country: tab crd6_sp_8 if trigger==1
*COP probe first: By country
bysort country: tab crd6_sp_8 if trigger==2

****************************************************************************
***Crd6_cp: Category selection probe
* Mismatch as SP:
*By experimental condition - total:
bysort trigger: tab crd_6cp_7
*CSP probe first: By country
bysort country: tab crd_6cp_7 if trigger==1
*COP probe first: By country
bysort country: tab crd_6cp_7 if trigger==2

* Mismatch as COP:
*By experimental condition - total:
bysort trigger: tab crd_6cp_8
*CSP probe first: By country
bysort country: tab crd_6cp_8 if trigger==1
*COP probe first: By country
bysort country: tab crd_6cp_8 if trigger==2

************************************************************************************
**Mismatches: Fisher's exact test
***************************************************************************
**Statistical test for Difference in Mismatching response behavior across experimental groups
*Comprehension Probe:
*Mismatch as CSP:
tab trigger crd_6cop_6, exact
tab trigger crd_6cop_6 if country==1, exact
tab trigger crd_6cop_6 if country==2, exact
tab trigger crd_6cop_6 if country==3, exact
tab trigger crd_6cop_6 if country==4, exact
tab trigger crd_6cop_6 if country==5, exact

* Mismatch as SP:
tab trigger crd_6cop_7, exact
tab trigger crd_6cop_7 if country==1, exact
tab trigger crd_6cop_7 if country==2, exact
tab trigger crd_6cop_7 if country==3, exact
tab trigger crd_6cop_7 if country==4, exact
tab trigger crd_6cop_7 if country==5, exact

**************************************************************
*SP Probe:
*Mismatch as CSP:
tab trigger crd6_sp_6, exact
tab trigger crd6_sp_6 if country==1, exact
tab trigger crd6_sp_6 if country==2, exact
tab trigger crd6_sp_6 if country==3, exact
tab trigger crd6_sp_6 if country==4, exact
tab trigger crd6_sp_6 if country==5, exact

*Mismatch as COP:
tab trigger crd6_sp_8, exact
tab trigger crd6_sp_8 if country==1, exact
tab trigger crd6_sp_8 if country==2, exact
tab trigger crd6_sp_8 if country==3, exact
tab trigger crd6_sp_8 if country==4, exact
tab trigger crd6_sp_8 if country==5, exact

**************************************************************
*Category Selection Probe:
* Mismatch as SP:
tab trigger crd_6cp_7, exact
tab trigger crd_6cp_7 if country==1, exact
tab trigger crd_6cp_7 if country==2, exact
tab trigger crd_6cp_7 if country==3, exact
tab trigger crd_6cp_7 if country==4, exact
tab trigger crd_6cp_7 if country==5, exact

*Mismatch as CoP:
tab trigger crd_6cp_8, exact
tab trigger crd_6cp_8 if country==1, exact
tab trigger crd_6cp_8 if country==2, exact
tab trigger crd_6cp_8 if country==3, exact
tab trigger crd_6cp_8 if country==4, exact
tab trigger crd_6cp_8 if country==5, exact



